"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QSpacerItem(PySide6.QtWidgets.QLayoutItem):
    """
    https://doc.qt.io/qt-6/qspaceritem.html

    **Detailed Description**

    Normally, you don't need to use this class directly. Qt's built-in layout
    managers provide the following functions for manipulating empty space in
    layouts:

    ClassFunctions
    **QHBoxLayout** **addSpacing** (), **addStretch** (),
    **insertSpacing** (), **insertStretch** ()
    **QGridLayout**
    **setRowMinimumHeight** (), **setRowStretch** (), **setColumnMinimumWidth**
    (), **setColumnStretch** ()

    **See also** **QLayout** , **QWidgetItem** , and **QLayoutItem::spacerItem**
    ().
    """

    def __init__(
        self,
        w: int,
        h: int,
        hData: PySide6.QtWidgets.QSizePolicy.Policy = ...,
        vData: PySide6.QtWidgets.QSizePolicy.Policy = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qspaceritem.html#QSpacerItem

        **QSpacerItem::QSpacerItem(int w , int h , QSizePolicy::Policy hPolicy =
        QSizePolicy::Minimum, QSizePolicy::Policy vPolicy =
        QSizePolicy::Minimum)**

        Constructs a spacer item with preferred width **w** , preferred height
        **h** , horizontal size policy **hPolicy** and vertical size policy
        **vPolicy**.

        The default values provide a gap that is able to stretch if nothing else
        wants the space.
        """
        ...

    def changeSize(
        self,
        w: int,
        h: int,
        hData: PySide6.QtWidgets.QSizePolicy.Policy = ...,
        vData: PySide6.QtWidgets.QSizePolicy.Policy = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qspaceritem.html#changeSize

        **void QSpacerItem::changeSize(int w , int h , QSizePolicy::Policy
        hPolicy = QSizePolicy::Minimum, QSizePolicy::Policy vPolicy =
        QSizePolicy::Minimum)**

        Changes this spacer item to have preferred width **w** , preferred
        height **h** , horizontal size policy **hPolicy** and vertical size
        policy **vPolicy**.

        The default values provide a gap that is able to stretch if nothing else
        wants the space.

        Note that if changeSize() is called after the spacer item has been added
        to a layout, it is necessary to invalidate the layout in order for the
        spacer item's new size to take effect.

        **See also** **QSpacerItem::invalidate** ().
        """
        ...

    def expandingDirections(self) -> PySide6.QtCore.Qt.Orientations:
        """
        https://doc.qt.io/qt-6/qspaceritem.html#expandingDirections

        **[override virtual] Qt::Orientations QSpacerItem::expandingDirections()
        const**

        Reimplements: **QLayoutItem::expandingDirections() const** .
        """
        ...

    def geometry(self) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qspaceritem.html#geometry

        **[override virtual] QRect QSpacerItem::geometry() const**

        Reimplements: **QLayoutItem::geometry() const** .

        **See also** **setGeometry** ().
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qspaceritem.html#isEmpty

        **[override virtual] bool QSpacerItem::isEmpty() const**

        Reimplements: **QLayoutItem::isEmpty() const** .

        Returns `true`.
        """
        ...

    def maximumSize(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qspaceritem.html#maximumSize

        **[override virtual] QSize QSpacerItem::maximumSize() const**

        Reimplements: **QLayoutItem::maximumSize() const** .
        """
        ...

    def minimumSize(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qspaceritem.html#minimumSize

        **[override virtual] QSize QSpacerItem::minimumSize() const**

        Reimplements: **QLayoutItem::minimumSize() const** .
        """
        ...

    def setGeometry(self, arg__1: PySide6.QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-6/qspaceritem.html#setGeometry

        **[override virtual] void QSpacerItem::setGeometry(const QRect & r )**

        Reimplements: **QLayoutItem::setGeometry** (const QRect &r).

        **See also** **geometry** ().
        """
        ...

    def sizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qspaceritem.html#sizeHint

        **[override virtual] QSize QSpacerItem::sizeHint() const**

        Reimplements: **QLayoutItem::sizeHint() const** .
        """
        ...

    def sizePolicy(self) -> PySide6.QtWidgets.QSizePolicy:
        """
        https://doc.qt.io/qt-6/qspaceritem.html#sizePolicy

        **[since 5.5] QSizePolicy QSpacerItem::sizePolicy() const**

        Returns the size policy of this item.

        This function was introduced in Qt 5.5.
        """
        ...

    def spacerItem(self) -> PySide6.QtWidgets.QSpacerItem:
        """
        https://doc.qt.io/qt-6/qspaceritem.html#spacerItem

        **[override virtual] QSpacerItem *QSpacerItem::spacerItem()**

        Reimplements: **QLayoutItem::spacerItem** ().

        Returns a pointer to this object.
        """
        ...
