"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QScrollerProperties(object):
    """
    https://doc.qt.io/qt-6/qscrollerproperties.html

    **Detailed Description**

    The QScrollerProperties class stores the parameters used by **QScroller** .

    The default settings are platform dependent so that Qt emulates the platform
    behaviour for kinetic scrolling.

    As a convention the QScrollerProperties are in physical units (meter,
    seconds) and are converted by **QScroller**  using the current DPI.

    **See also** **QScroller** .
    """

    Standard: QScrollerProperties.FrameRates = ...
    Fps60: QScrollerProperties.FrameRates = ...
    Fps30: QScrollerProperties.FrameRates = ...
    Fps20: QScrollerProperties.FrameRates = ...
    OvershootWhenScrollable: QScrollerProperties.OvershootPolicy = ...
    OvershootAlwaysOff: QScrollerProperties.OvershootPolicy = ...
    OvershootAlwaysOn: QScrollerProperties.OvershootPolicy = ...
    MousePressEventDelay: QScrollerProperties.ScrollMetric = ...
    DragStartDistance: QScrollerProperties.ScrollMetric = ...
    DragVelocitySmoothingFactor: QScrollerProperties.ScrollMetric = ...
    AxisLockThreshold: QScrollerProperties.ScrollMetric = ...
    ScrollingCurve: QScrollerProperties.ScrollMetric = ...
    DecelerationFactor: QScrollerProperties.ScrollMetric = ...
    MinimumVelocity: QScrollerProperties.ScrollMetric = ...
    MaximumVelocity: QScrollerProperties.ScrollMetric = ...
    MaximumClickThroughVelocity: QScrollerProperties.ScrollMetric = ...
    AcceleratingFlickMaximumTime: QScrollerProperties.ScrollMetric = ...
    AcceleratingFlickSpeedupFactor: QScrollerProperties.ScrollMetric = ...
    SnapPositionRatio: QScrollerProperties.ScrollMetric = ...
    SnapTime: QScrollerProperties.ScrollMetric = ...
    OvershootDragResistanceFactor: QScrollerProperties.ScrollMetric = ...
    OvershootDragDistanceFactor: QScrollerProperties.ScrollMetric = ...
    OvershootScrollDistanceFactor: QScrollerProperties.ScrollMetric = ...
    OvershootScrollTime: QScrollerProperties.ScrollMetric = ...
    HorizontalOvershootPolicy: QScrollerProperties.ScrollMetric = ...
    VerticalOvershootPolicy: QScrollerProperties.ScrollMetric = ...
    FrameRate: QScrollerProperties.ScrollMetric = ...
    ScrollMetricCount: QScrollerProperties.ScrollMetric = ...

    class FrameRates(Enum):
        Standard: QScrollerProperties.FrameRates = ...
        Fps60: QScrollerProperties.FrameRates = ...
        Fps30: QScrollerProperties.FrameRates = ...
        Fps20: QScrollerProperties.FrameRates = ...

    class OvershootPolicy(Enum):
        OvershootWhenScrollable: QScrollerProperties.OvershootPolicy = ...
        OvershootAlwaysOff: QScrollerProperties.OvershootPolicy = ...
        OvershootAlwaysOn: QScrollerProperties.OvershootPolicy = ...

    class ScrollMetric(Enum):
        MousePressEventDelay: QScrollerProperties.ScrollMetric = ...
        DragStartDistance: QScrollerProperties.ScrollMetric = ...
        DragVelocitySmoothingFactor: QScrollerProperties.ScrollMetric = ...
        AxisLockThreshold: QScrollerProperties.ScrollMetric = ...
        ScrollingCurve: QScrollerProperties.ScrollMetric = ...
        DecelerationFactor: QScrollerProperties.ScrollMetric = ...
        MinimumVelocity: QScrollerProperties.ScrollMetric = ...
        MaximumVelocity: QScrollerProperties.ScrollMetric = ...
        MaximumClickThroughVelocity: QScrollerProperties.ScrollMetric = ...
        AcceleratingFlickMaximumTime: QScrollerProperties.ScrollMetric = ...
        AcceleratingFlickSpeedupFactor: QScrollerProperties.ScrollMetric = ...
        SnapPositionRatio: QScrollerProperties.ScrollMetric = ...
        SnapTime: QScrollerProperties.ScrollMetric = ...
        OvershootDragResistanceFactor: QScrollerProperties.ScrollMetric = ...
        OvershootDragDistanceFactor: QScrollerProperties.ScrollMetric = ...
        OvershootScrollDistanceFactor: QScrollerProperties.ScrollMetric = ...
        OvershootScrollTime: QScrollerProperties.ScrollMetric = ...
        HorizontalOvershootPolicy: QScrollerProperties.ScrollMetric = ...
        VerticalOvershootPolicy: QScrollerProperties.ScrollMetric = ...
        FrameRate: QScrollerProperties.ScrollMetric = ...
        ScrollMetricCount: QScrollerProperties.ScrollMetric = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qscrollerproperties.html#QScrollerProperties

        **QScrollerProperties::QScrollerProperties()**

        Constructs new scroller properties.
        """
        ...

    @overload
    def __init__(self, sp: PySide6.QtWidgets.QScrollerProperties) -> None:
        """
        https://doc.qt.io/qt-6/qscrollerproperties.html#QScrollerProperties-1

        **QScrollerProperties::QScrollerProperties(const QScrollerProperties &
        sp )**

        Constructs a copy of **sp**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def scrollMetric(
        self, metric: PySide6.QtWidgets.QScrollerProperties.ScrollMetric
    ) -> Any:
        """
        https://doc.qt.io/qt-6/qscrollerproperties.html#scrollMetric

        **QVariant
        QScrollerProperties::scrollMetric(QScrollerProperties::ScrollMetric
        metric ) const**

        Query the **metric** value of the scroller properties.

        **See also** **setScrollMetric** () and **ScrollMetric** .
        """
        ...

    @staticmethod
    def setDefaultScrollerProperties(sp: PySide6.QtWidgets.QScrollerProperties) -> None:
        """
        https://doc.qt.io/qt-6/qscrollerproperties.html#setDefaultScrollerProper
        ties

        **[static] void QScrollerProperties::setDefaultScrollerProperties(const
        QScrollerProperties & sp )**

        Sets the scroller properties for all new **QScrollerProperties**
        objects to **sp**.

        Use this function to override the platform default properties returned
        by the default constructor. If you only want to change the scroller
        properties of a single scroller, use
        **QScroller::setScrollerProperties** ()

        **Note:** Calling this function will not change the content of already
        existing **QScrollerProperties**  objects.

        **See also** **unsetDefaultScrollerProperties** ().
        """
        ...

    def setScrollMetric(
        self, metric: PySide6.QtWidgets.QScrollerProperties.ScrollMetric, value: Any
    ) -> None:
        """
        https://doc.qt.io/qt-6/qscrollerproperties.html#setScrollMetric

        **void
        QScrollerProperties::setScrollMetric(QScrollerProperties::ScrollMetric
        metric , const QVariant & value )**

        Set a specific value of the **metric** ScrollerMetric to **value**.

        **See also** **scrollMetric** () and **ScrollMetric** .
        """
        ...

    @staticmethod
    def unsetDefaultScrollerProperties() -> None:
        """
        https://doc.qt.io/qt-6/qscrollerproperties.html#unsetDefaultScrollerProp
        erties

        **[static] void QScrollerProperties::unsetDefaultScrollerProperties()**

        Sets the scroller properties returned by the default constructor back to
        the platform default properties.

        **See also** **setDefaultScrollerProperties** ().
        """
        ...
