"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import Optional, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QRadioButton(PySide6.QtWidgets.QAbstractButton):
    """
    https://doc.qt.io/qt-6/qradiobutton.html

    **Detailed Description**

    ![](images/windows-radiobutton.png)

    A QRadioButton is an option button that can be switched on (checked) or off
    (unchecked). Radio buttons typically present the user with a "one of many"
    choice. In a group of radio buttons, only one radio button at a time can be
    checked; if the user selects another button, the previously selected button
    is switched off.

    Radio buttons are autoExclusive by default. If auto-exclusive is enabled,
    radio buttons that belong to the same parent widget behave as if they were
    part of the same exclusive button group. If you need multiple exclusive
    button groups for radio buttons that belong to the same parent widget, put
    them into a **QButtonGroup** .

    Whenever a button is switched on or off, it emits the **toggled** () signal.
    Connect to this signal if you want to trigger an action each time the button
    changes state. Use **isChecked** () to see if a particular button is
    selected.

    Just like **QPushButton** , a radio button displays text, and optionally a
    small icon. The icon is set with **setIcon** (). The text can be set in the
    constructor or with **setText** (). A shortcut key can be specified by
    preceding the preferred character with an ampersand in the text. For
    example:

    **QRadioButton**  *button = new **QRadioButton** ("Search from the &cursor",
    this);

    In this example the shortcut is **Alt+c**. See the **QShortcut**
    documentation for details. To display an actual ampersand, use '&&'.

    Important inherited members: **text** (), **setText** (), **text** (),
    **setDown** (), **isDown** (), **autoRepeat** (), **group** (),
    **setAutoRepeat** (), **toggle** (), **pressed** (), **released** (),
    **clicked** (), and **toggled** ().

    **See also** **QPushButton** , **QToolButton** , **QCheckBox** , **GUI
    Design Handbook: Radio Button** , and **Group Box Example** .
    """

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qradiobutton.html#QRadioButton

        **QRadioButton::QRadioButton(QWidget * parent = nullptr)**

        Constructs a radio button with the given **parent** , but with no text
        or pixmap.

        The **parent** argument is passed on to the **QAbstractButton**
        constructor.
        """
        ...

    @overload
    def __init__(
        self, text: str, parent: Optional[PySide6.QtWidgets.QWidget] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qradiobutton.html#QRadioButton-1

        **QRadioButton::QRadioButton(const QString & text , QWidget * parent =
        nullptr)**

        Constructs a radio button with the given **parent** and **text** string.

        The **parent** argument is passed on to the **QAbstractButton**
        constructor.
        """
        ...

    def event(self, e: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qradiobutton.html#event

        **[override virtual protected] bool QRadioButton::event(QEvent * e )**

        Reimplements: **QAbstractButton::event** (QEvent *e).
        """
        ...

    def hitButton(self, arg__1: PySide6.QtCore.QPoint) -> bool:
        """
        https://doc.qt.io/qt-6/qradiobutton.html#hitButton

        **[override virtual protected] bool QRadioButton::hitButton(const QPoint
        & pos ) const**

        Reimplements: **QAbstractButton::hitButton(const QPoint &pos) const** .
        """
        ...

    def initStyleOption(self, button: PySide6.QtWidgets.QStyleOptionButton) -> None:
        """
        https://doc.qt.io/qt-6/qradiobutton.html#initStyleOption

        **[virtual protected] void
        QRadioButton::initStyleOption(QStyleOptionButton * option ) const**

        Initialize **option** with the values from this **QRadioButton** . This
        method is useful for subclasses when they need a **QStyleOptionButton**
        , but don't want to fill in all the information themselves.

        **See also** **QStyleOption::initFrom** ().
        """
        ...

    def minimumSizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qradiobutton.html#minimumSizeHint

        **[override virtual] QSize QRadioButton::minimumSizeHint() const**

        Reimplements an access function for property:
        **QWidget::minimumSizeHint** .
        """
        ...

    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qradiobutton.html#mouseMoveEvent

        **[override virtual protected] void
        QRadioButton::mouseMoveEvent(QMouseEvent * e )**

        Reimplements: **QAbstractButton::mouseMoveEvent** (QMouseEvent *e).
        """
        ...

    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-6/qradiobutton.html#paintEvent

        **[override virtual protected] void QRadioButton::paintEvent(QPaintEvent
        *)**

        Reimplements: **QAbstractButton::paintEvent** (QPaintEvent *e).
        """
        ...

    def sizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qradiobutton.html#sizeHint

        **[override virtual] QSize QRadioButton::sizeHint() const**

        Reimplements an access function for property: **QWidget::sizeHint** .
        """
        ...
