"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QPlainTextDocumentLayout(PySide6.QtGui.QAbstractTextDocumentLayout):
    """
    https://doc.qt.io/qt-6/qplaintextdocumentlayout.html

    **Detailed Description**

    A QPlainTextDocumentLayout is required for text documents that can be
    display or edited in a **QPlainTextEdit** . See
    **QTextDocument::setDocumentLayout** ().

    QPlainTextDocumentLayout uses the **QAbstractTextDocumentLayout**  API that
    **QTextDocument**  requires, but redefines it partially in order to support
    plain text better. For instances, it does not operate on vertical pixels,
    but on paragraphs (called blocks) instead. The height of a document is
    identical to the number of paragraphs it contains. The layout also doesn't
    support tables or nested frames, or any sort of advanced text layout that
    goes beyond a list of paragraphs with syntax highlighting.
    """

    def __init__(self, document: PySide6.QtGui.QTextDocument) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextdocumentlayout.html#QPlainTextDocumentL
        ayout

        **QPlainTextDocumentLayout::QPlainTextDocumentLayout(QTextDocument *
        document )**

        Constructs a plain text document layout for the text **document**.
        """
        ...

    def blockBoundingRect(
        self, block: PySide6.QtGui.QTextBlock
    ) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qplaintextdocumentlayout.html#blockBoundingRect

        **[override virtual] QRectF
        QPlainTextDocumentLayout::blockBoundingRect(const QTextBlock & block )
        const**

        Reimplements: **QAbstractTextDocumentLayout::blockBoundingRect(const
        QTextBlock &block) const** .
        """
        ...

    def cursorWidth(self) -> int:
        """
        https://doc.qt.io/qt-6/qplaintextdocumentlayout.html#cursorWidth-prop

        **cursorWidth : int**

        This property specifies the width of the cursor in pixels. The default
        value is 1.

        **Access functions:**

        int **cursorWidth** () const
        void **setCursorWidth** (int **width** )

        **Member Function Documentation**
        """
        ...

    def documentChanged(self, from_: int, arg__2: int, charsAdded: int) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextdocumentlayout.html#documentChanged

        **[override virtual protected] void
        QPlainTextDocumentLayout::documentChanged(int from , int charsRemoved ,
        int charsAdded )**

        Reimplements: **QAbstractTextDocumentLayout::documentChanged** (int
        position, int charsRemoved, int charsAdded).
        """
        ...

    def documentSize(self) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qplaintextdocumentlayout.html#documentSize

        **[override virtual] QSizeF QPlainTextDocumentLayout::documentSize()
        const**

        Reimplements: **QAbstractTextDocumentLayout::documentSize() const** .
        """
        ...

    def draw(
        self,
        arg__1: PySide6.QtGui.QPainter,
        arg__2: PySide6.QtGui.QAbstractTextDocumentLayout.PaintContext,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextdocumentlayout.html#draw

        **[override virtual] void QPlainTextDocumentLayout::draw(QPainter *,
        const QAbstractTextDocumentLayout::PaintContext &)**

        Reimplements: **QAbstractTextDocumentLayout::draw** (QPainter *painter,
        const QAbstractTextDocumentLayout::PaintContext &context).
        """
        ...

    def ensureBlockLayout(self, block: PySide6.QtGui.QTextBlock) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextdocumentlayout.html#ensureBlockLayout

        **void QPlainTextDocumentLayout::ensureBlockLayout(const QTextBlock &
        block ) const**

        Ensures that **block** has a valid layout
        """
        ...

    def frameBoundingRect(
        self, arg__1: PySide6.QtGui.QTextFrame
    ) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qplaintextdocumentlayout.html#frameBoundingRect

        **[override virtual] QRectF
        QPlainTextDocumentLayout::frameBoundingRect(QTextFrame *) const**

        Reimplements:
        **QAbstractTextDocumentLayout::frameBoundingRect(QTextFrame *frame)
        const** .
        """
        ...

    def hitTest(
        self,
        arg__1: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
        arg__2: PySide6.QtCore.Qt.HitTestAccuracy,
    ) -> int:
        """
        https://doc.qt.io/qt-6/qplaintextdocumentlayout.html#hitTest

        **[override virtual] int QPlainTextDocumentLayout::hitTest(const QPointF
        &, Qt::HitTestAccuracy) const**

        Reimplements: **QAbstractTextDocumentLayout::hitTest(const QPointF
        &point, Qt::HitTestAccuracy accuracy) const** .
        """
        ...

    def pageCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qplaintextdocumentlayout.html#pageCount

        **[override virtual] int QPlainTextDocumentLayout::pageCount() const**

        Reimplements: **QAbstractTextDocumentLayout::pageCount() const** .
        """
        ...

    def requestUpdate(self) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextdocumentlayout.html#requestUpdate

        **void QPlainTextDocumentLayout::requestUpdate()**

        Requests a complete update on all views.
        """
        ...

    def setCursorWidth(self, width: int) -> None:
        """
        https://doc.qt.io/qt-6/qplaintextdocumentlayout.html#cursorWidth-prop

        **cursorWidth : int**

        This property specifies the width of the cursor in pixels. The default
        value is 1.

        **Access functions:**

        int **cursorWidth** () const
        void **setCursorWidth** (int **width** )

        **Member Function Documentation**
        """
        ...
