"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QGraphicsSceneResizeEvent(PySide6.QtWidgets.QGraphicsSceneEvent):
    """
    https://doc.qt.io/qt-6/qgraphicssceneresizeevent.html

    **Detailed Description**

    A **QGraphicsWidget**  sends itself a QGraphicsSceneResizeEvent immediately
    when its geometry changes.

    It's similar to **QResizeEvent** , but its sizes, **oldSize** () and
    **newSize** (), use **QSizeF**  instead of **QSize** .

    **See also** **QGraphicsWidget::setGeometry** () and
    **QGraphicsWidget::resize** ().
    """

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicssceneresizeevent.html#QGraphicsSceneResi
        zeEvent-1

        **QGraphicsSceneResizeEvent::QGraphicsSceneResizeEvent()**

        Constructs a QGraphicsSceneResizeEvent.
        """
        ...

    def newSize(self) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qgraphicssceneresizeevent.html#newSize

        **QSizeF QGraphicsSceneResizeEvent::newSize() const**

        Returns the new size (i.e., the current size).

        **See also** **oldSize** () and **QGraphicsWidget::resize** ().
        """
        ...

    def oldSize(self) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qgraphicssceneresizeevent.html#oldSize

        **QSizeF QGraphicsSceneResizeEvent::oldSize() const**

        Returns the old size (i.e., the size immediately before the widget was
        resized).

        **See also** **newSize** () and **QGraphicsWidget::resize** ().
        """
        ...

    def setNewSize(
        self, size: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicssceneresizeevent.html#newSize

        **QSizeF QGraphicsSceneResizeEvent::newSize() const**

        Returns the new size (i.e., the current size).

        **See also** **oldSize** () and **QGraphicsWidget::resize** ().
        """
        ...

    def setOldSize(
        self, size: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicssceneresizeevent.html#oldSize

        **QSizeF QGraphicsSceneResizeEvent::oldSize() const**

        Returns the old size (i.e., the size immediately before the widget was
        resized).

        **See also** **newSize** () and **QGraphicsWidget::resize** ().
        """
        ...
