"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import Optional, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QGraphicsSceneMouseEvent(PySide6.QtWidgets.QGraphicsSceneEvent):
    """
    https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html

    **Detailed Description**

    When a **QGraphicsView**  receives a **QMouseEvent** , it translates it to a
    QGraphicsSceneMouseEvent. The event is then forwarded to the
    **QGraphicsScene**  associated with the view. If the event is not handled by
    the scene, the view may use it, e.g., for the **DragMode** .

    In addition to containing the item, scene, and screen coordinates of the
    event (as **pos** (), **scenePos** (), and **screenPos** ()), mouse events
    also contain the coordinates of the previous mouse event received by the
    view. These can be retrieved with **lastPos** (), **lastScreenPos** (), and
    **lastScenePos** ().

    **See also** **QGraphicsSceneContextMenuEvent** ,
    **QGraphicsSceneHoverEvent** , **QGraphicsSceneWheelEvent** , and
    **QMouseEvent** .
    """

    def __init__(self, type: Optional[PySide6.QtCore.QEvent.Type] = ...) -> None:
        ...

    def button(self) -> PySide6.QtCore.Qt.MouseButton:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#button

        **Qt::MouseButton QGraphicsSceneMouseEvent::button() const**

        Returns the mouse button (if any) that caused the event.

        **See also** **buttons** () and **modifiers** ().
        """
        ...

    def buttonDownPos(
        self, button: PySide6.QtCore.Qt.MouseButton
    ) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#buttonDownPos

        **QPointF QGraphicsSceneMouseEvent::buttonDownPos(Qt::MouseButton button
        ) const**

        Returns the mouse cursor position in item coordinates where the
        specified **button** was clicked.

        **See also** **buttonDownScenePos** (), **buttonDownScreenPos** (), and
        **pos** ().
        """
        ...

    def buttonDownScenePos(
        self, button: PySide6.QtCore.Qt.MouseButton
    ) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#buttonDownScenePos

        **QPointF QGraphicsSceneMouseEvent::buttonDownScenePos(Qt::MouseButton
        button ) const**

        Returns the mouse cursor position in scene coordinates where the
        specified **button** was clicked.

        **See also** **buttonDownPos** (), **buttonDownScreenPos** (), and
        **scenePos** ().
        """
        ...

    def buttonDownScreenPos(
        self, button: PySide6.QtCore.Qt.MouseButton
    ) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#buttonDownScreenPos

        **QPoint QGraphicsSceneMouseEvent::buttonDownScreenPos(Qt::MouseButton
        button ) const**

        Returns the mouse cursor position in screen coordinates where the
        specified **button** was clicked.

        **See also** **screenPos** (), **buttonDownPos** (), and
        **buttonDownScenePos** ().
        """
        ...

    def buttons(self) -> PySide6.QtCore.Qt.MouseButtons:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#buttons

        **Qt::MouseButtons QGraphicsSceneMouseEvent::buttons() const**

        Returns the combination of mouse buttons that were pressed at the time
        the event was sent.

        **See also** **button** () and **modifiers** ().
        """
        ...

    def flags(self) -> PySide6.QtCore.Qt.MouseEventFlags:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#flags

        **[since 5.4] Qt::MouseEventFlags QGraphicsSceneMouseEvent::flags()
        const**

        Returns the mouse event flags.

        The mouse event flags provide additional information about a mouse
        event.

        This function was introduced in Qt 5.4.

        **See also** **Qt::MouseEventFlag**  and **QMouseEvent::flags** ().
        """
        ...

    def lastPos(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#lastPos

        **QPointF QGraphicsSceneMouseEvent::lastPos() const**

        Returns the last recorded mouse cursor position in item coordinates.

        **See also** **lastScenePos** (), **lastScreenPos** (), and **pos** ().
        """
        ...

    def lastScenePos(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#lastScenePos

        **QPointF QGraphicsSceneMouseEvent::lastScenePos() const**

        Returns the last recorded mouse cursor position in scene coordinates.
        The last recorded position is the position of the previous mouse event
        received by the view that created the event.

        **See also** **lastPos** (), **lastScreenPos** (), and **scenePos** ().
        """
        ...

    def lastScreenPos(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#lastScreenPos

        **QPoint QGraphicsSceneMouseEvent::lastScreenPos() const**

        Returns the last recorded mouse cursor position in screen coordinates.
        The last recorded position is the position of the previous mouse event
        received by the view that created the event.

        **See also** **lastPos** (), **lastScenePos** (), and **screenPos** ().
        """
        ...

    def modifiers(self) -> PySide6.QtCore.Qt.KeyboardModifiers:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#modifiers

        **Qt::KeyboardModifiers QGraphicsSceneMouseEvent::modifiers() const**

        Returns the keyboard modifiers in use at the time the event was sent.

        **See also** **buttons** () and **button** ().
        """
        ...

    def pos(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#pos

        **QPointF QGraphicsSceneMouseEvent::pos() const**

        Returns the mouse cursor position in item coordinates.

        **See also** **scenePos** (), **screenPos** (), and **lastPos** ().
        """
        ...

    def scenePos(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#scenePos

        **QPointF QGraphicsSceneMouseEvent::scenePos() const**

        Returns the mouse cursor position in scene coordinates.

        **See also** **pos** (), **screenPos** (), and **lastScenePos** ().
        """
        ...

    def screenPos(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#screenPos

        **QPoint QGraphicsSceneMouseEvent::screenPos() const**

        Returns the mouse cursor position in screen coordinates.

        **See also** **pos** (), **scenePos** (), and **lastScreenPos** ().
        """
        ...

    def setButton(self, button: PySide6.QtCore.Qt.MouseButton) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#button

        **Qt::MouseButton QGraphicsSceneMouseEvent::button() const**

        Returns the mouse button (if any) that caused the event.

        **See also** **buttons** () and **modifiers** ().
        """
        ...

    def setButtonDownPos(
        self,
        button: PySide6.QtCore.Qt.MouseButton,
        pos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#buttonDownPos

        **QPointF QGraphicsSceneMouseEvent::buttonDownPos(Qt::MouseButton button
        ) const**

        Returns the mouse cursor position in item coordinates where the
        specified **button** was clicked.

        **See also** **buttonDownScenePos** (), **buttonDownScreenPos** (), and
        **pos** ().
        """
        ...

    def setButtonDownScenePos(
        self,
        button: PySide6.QtCore.Qt.MouseButton,
        pos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#buttonDownScenePos

        **QPointF QGraphicsSceneMouseEvent::buttonDownScenePos(Qt::MouseButton
        button ) const**

        Returns the mouse cursor position in scene coordinates where the
        specified **button** was clicked.

        **See also** **buttonDownPos** (), **buttonDownScreenPos** (), and
        **scenePos** ().
        """
        ...

    def setButtonDownScreenPos(
        self, button: PySide6.QtCore.Qt.MouseButton, pos: PySide6.QtCore.QPoint
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#buttonDownScreenPos

        **QPoint QGraphicsSceneMouseEvent::buttonDownScreenPos(Qt::MouseButton
        button ) const**

        Returns the mouse cursor position in screen coordinates where the
        specified **button** was clicked.

        **See also** **screenPos** (), **buttonDownPos** (), and
        **buttonDownScenePos** ().
        """
        ...

    def setButtons(self, buttons: PySide6.QtCore.Qt.MouseButtons) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#buttons

        **Qt::MouseButtons QGraphicsSceneMouseEvent::buttons() const**

        Returns the combination of mouse buttons that were pressed at the time
        the event was sent.

        **See also** **button** () and **modifiers** ().
        """
        ...

    def setFlags(self, arg__1: PySide6.QtCore.Qt.MouseEventFlags) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#flags

        **[since 5.4] Qt::MouseEventFlags QGraphicsSceneMouseEvent::flags()
        const**

        Returns the mouse event flags.

        The mouse event flags provide additional information about a mouse
        event.

        This function was introduced in Qt 5.4.

        **See also** **Qt::MouseEventFlag**  and **QMouseEvent::flags** ().
        """
        ...

    def setLastPos(
        self,
        pos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#lastPos

        **QPointF QGraphicsSceneMouseEvent::lastPos() const**

        Returns the last recorded mouse cursor position in item coordinates.

        **See also** **lastScenePos** (), **lastScreenPos** (), and **pos** ().
        """
        ...

    def setLastScenePos(
        self,
        pos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#lastScenePos

        **QPointF QGraphicsSceneMouseEvent::lastScenePos() const**

        Returns the last recorded mouse cursor position in scene coordinates.
        The last recorded position is the position of the previous mouse event
        received by the view that created the event.

        **See also** **lastPos** (), **lastScreenPos** (), and **scenePos** ().
        """
        ...

    def setLastScreenPos(self, pos: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#lastScreenPos

        **QPoint QGraphicsSceneMouseEvent::lastScreenPos() const**

        Returns the last recorded mouse cursor position in screen coordinates.
        The last recorded position is the position of the previous mouse event
        received by the view that created the event.

        **See also** **lastPos** (), **lastScenePos** (), and **screenPos** ().
        """
        ...

    def setModifiers(self, modifiers: PySide6.QtCore.Qt.KeyboardModifiers) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#modifiers

        **Qt::KeyboardModifiers QGraphicsSceneMouseEvent::modifiers() const**

        Returns the keyboard modifiers in use at the time the event was sent.

        **See also** **buttons** () and **button** ().
        """
        ...

    def setPos(
        self,
        pos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#pos

        **QPointF QGraphicsSceneMouseEvent::pos() const**

        Returns the mouse cursor position in item coordinates.

        **See also** **scenePos** (), **screenPos** (), and **lastPos** ().
        """
        ...

    def setScenePos(
        self,
        pos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#scenePos

        **QPointF QGraphicsSceneMouseEvent::scenePos() const**

        Returns the mouse cursor position in scene coordinates.

        **See also** **pos** (), **screenPos** (), and **lastScenePos** ().
        """
        ...

    def setScreenPos(self, pos: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#screenPos

        **QPoint QGraphicsSceneMouseEvent::screenPos() const**

        Returns the mouse cursor position in screen coordinates.

        **See also** **pos** (), **scenePos** (), and **lastScreenPos** ().
        """
        ...

    def setSource(self, source: PySide6.QtCore.Qt.MouseEventSource) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#source

        **[since 5.4] Qt::MouseEventSource QGraphicsSceneMouseEvent::source()
        const**

        Returns information about the mouse event source.

        The mouse event source can be used to distinguish between genuine and
        artificial mouse events. The latter are events that are synthesized from
        touch events by the operating system or Qt itself.

        This function was introduced in Qt 5.4.

        **See also** **Qt::MouseEventSource**  and **QMouseEvent::source** ().
        """
        ...

    def source(self) -> PySide6.QtCore.Qt.MouseEventSource:
        """
        https://doc.qt.io/qt-6/qgraphicsscenemouseevent.html#source

        **[since 5.4] Qt::MouseEventSource QGraphicsSceneMouseEvent::source()
        const**

        Returns information about the mouse event source.

        The mouse event source can be used to distinguish between genuine and
        artificial mouse events. The latter are events that are synthesized from
        touch events by the operating system or Qt itself.

        This function was introduced in Qt 5.4.

        **See also** **Qt::MouseEventSource**  and **QMouseEvent::source** ().
        """
        ...
