"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import Optional, Union
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QGraphicsSceneDragDropEvent(PySide6.QtWidgets.QGraphicsSceneEvent):
    """
    https://doc.qt.io/qt-6/qgraphicsscenedragdropevent.html

    **Detailed Description**

    **QGraphicsView**  inherits the drag and drop functionality provided by
    **QWidget** . When it receives a drag and drop event, it translates it to a
    QGraphicsSceneDragDropEvent.

    QGraphicsSceneDragDropEvent stores events of type GraphicsSceneDragEnter,
    GraphicsSceneDragLeave, GraphicsSceneDragMove, or GraphicsSceneDrop.

    QGraphicsSceneDragDropEvent contains the position of the mouse cursor in
    both item, scene, and screen coordinates; this can be retrieved with **pos**
    (), **scenePos** (), and **screenPos** ().

    The scene sends the event to the first **QGraphicsItem**  under the mouse
    cursor that accepts drops; a graphics item is set to accept drops with
    **setAcceptDrops** ().
    """

    def __init__(self, type: Optional[PySide6.QtCore.QEvent.Type] = ...) -> None:
        ...

    def acceptProposedAction(self) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenedragdropevent.html#acceptProposedAc
        tion

        **void QGraphicsSceneDragDropEvent::acceptProposedAction()**

        Sets the proposed action as accepted, i.e, the drop action is set to the
        proposed action. This is equal to:

        setDropAction(proposedAction());

        When using this function, one should not call `accept()`.

        **See also** **dropAction** (), **setDropAction** (), and
        **proposedAction** ().
        """
        ...

    def buttons(self) -> PySide6.QtCore.Qt.MouseButtons:
        """
        https://doc.qt.io/qt-6/qgraphicsscenedragdropevent.html#buttons

        **Qt::MouseButtons QGraphicsSceneDragDropEvent::buttons() const**

        Returns a **Qt::MouseButtons**  value indicating which buttons were
        pressed on the mouse when this mouse event was generated.

        **See also** **Qt::MouseButtons** .
        """
        ...

    def dropAction(self) -> PySide6.QtCore.Qt.DropAction:
        """
        https://doc.qt.io/qt-6/qgraphicsscenedragdropevent.html#dropAction

        **Qt::DropAction QGraphicsSceneDragDropEvent::dropAction() const**

        Returns the action that was performed in this drag and drop. This should
        be set by the receiver of the drop and is returned by **QDrag::exec**
        ().

        **See also** **setDropAction** () and **acceptProposedAction** ().
        """
        ...

    def mimeData(self) -> PySide6.QtCore.QMimeData:
        """
        https://doc.qt.io/qt-6/qgraphicsscenedragdropevent.html#mimeData

        **const QMimeData *QGraphicsSceneDragDropEvent::mimeData() const**

        This function returns the MIME data of the event.
        """
        ...

    def modifiers(self) -> PySide6.QtCore.Qt.KeyboardModifiers:
        """
        https://doc.qt.io/qt-6/qgraphicsscenedragdropevent.html#modifiers

        **Qt::KeyboardModifiers QGraphicsSceneDragDropEvent::modifiers() const**

        Returns the keyboard modifiers that were pressed when the drag and drop
        event was created.

        **See also** **Qt::KeyboardModifiers** .
        """
        ...

    def pos(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qgraphicsscenedragdropevent.html#pos

        **QPointF QGraphicsSceneDragDropEvent::pos() const**

        Returns the mouse position of the event relative to the view that sent
        the event.

        **See also** **QGraphicsView** , **screenPos** (), and **scenePos** ().
        """
        ...

    def possibleActions(self) -> PySide6.QtCore.Qt.DropActions:
        """
        https://doc.qt.io/qt-6/qgraphicsscenedragdropevent.html#possibleActions

        **Qt::DropActions QGraphicsSceneDragDropEvent::possibleActions() const**

        Returns the possible drop actions that the drag and drop can result in.

        **See also** **Qt::DropActions** .
        """
        ...

    def proposedAction(self) -> PySide6.QtCore.Qt.DropAction:
        """
        https://doc.qt.io/qt-6/qgraphicsscenedragdropevent.html#proposedAction

        **Qt::DropAction QGraphicsSceneDragDropEvent::proposedAction() const**

        Returns the drop action that is proposed, i.e., preferred. The action
        must be one of the possible actions as defined by `possibleActions()`.

        **See also** **Qt::DropAction**  and **possibleActions** ().
        """
        ...

    def scenePos(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qgraphicsscenedragdropevent.html#scenePos

        **QPointF QGraphicsSceneDragDropEvent::scenePos() const**

        Returns the position of the mouse in scene coordinates.

        **See also** **pos** () and **screenPos** ().
        """
        ...

    def screenPos(self) -> PySide6.QtCore.QPoint:
        """
        https://doc.qt.io/qt-6/qgraphicsscenedragdropevent.html#screenPos

        **QPoint QGraphicsSceneDragDropEvent::screenPos() const**

        Returns the position of the mouse relative to the screen.

        **See also** **pos** () and **scenePos** ().
        """
        ...

    def setButtons(self, buttons: PySide6.QtCore.Qt.MouseButtons) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenedragdropevent.html#buttons

        **Qt::MouseButtons QGraphicsSceneDragDropEvent::buttons() const**

        Returns a **Qt::MouseButtons**  value indicating which buttons were
        pressed on the mouse when this mouse event was generated.

        **See also** **Qt::MouseButtons** .
        """
        ...

    def setDropAction(self, action: PySide6.QtCore.Qt.DropAction) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenedragdropevent.html#setDropAction

        **void QGraphicsSceneDragDropEvent::setDropAction(Qt::DropAction action
        )**

        This function lets the receiver of the drop set the drop action that was
        performed to **action** , which should be one of the **possible
        actions** . Call `accept()` in stead of `acceptProposedAction()` if you
        use this function.

        **See also** **dropAction** (), **accept** (), and **possibleActions**
        ().
        """
        ...

    def setModifiers(self, modifiers: PySide6.QtCore.Qt.KeyboardModifiers) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenedragdropevent.html#modifiers

        **Qt::KeyboardModifiers QGraphicsSceneDragDropEvent::modifiers() const**

        Returns the keyboard modifiers that were pressed when the drag and drop
        event was created.

        **See also** **Qt::KeyboardModifiers** .
        """
        ...

    def setPos(
        self,
        pos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenedragdropevent.html#pos

        **QPointF QGraphicsSceneDragDropEvent::pos() const**

        Returns the mouse position of the event relative to the view that sent
        the event.

        **See also** **QGraphicsView** , **screenPos** (), and **scenePos** ().
        """
        ...

    def setPossibleActions(self, actions: PySide6.QtCore.Qt.DropActions) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenedragdropevent.html#possibleActions

        **Qt::DropActions QGraphicsSceneDragDropEvent::possibleActions() const**

        Returns the possible drop actions that the drag and drop can result in.

        **See also** **Qt::DropActions** .
        """
        ...

    def setProposedAction(self, action: PySide6.QtCore.Qt.DropAction) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenedragdropevent.html#proposedAction

        **Qt::DropAction QGraphicsSceneDragDropEvent::proposedAction() const**

        Returns the drop action that is proposed, i.e., preferred. The action
        must be one of the possible actions as defined by `possibleActions()`.

        **See also** **Qt::DropAction**  and **possibleActions** ().
        """
        ...

    def setScenePos(
        self,
        pos: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenedragdropevent.html#scenePos

        **QPointF QGraphicsSceneDragDropEvent::scenePos() const**

        Returns the position of the mouse in scene coordinates.

        **See also** **pos** () and **screenPos** ().
        """
        ...

    def setScreenPos(self, pos: PySide6.QtCore.QPoint) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsscenedragdropevent.html#screenPos

        **QPoint QGraphicsSceneDragDropEvent::screenPos() const**

        Returns the position of the mouse relative to the screen.

        **See also** **pos** () and **scenePos** ().
        """
        ...

    def source(self) -> PySide6.QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-6/qgraphicsscenedragdropevent.html#source

        **QWidget *QGraphicsSceneDragDropEvent::source() const**

        This function returns the **QGraphicsView**  that created the
        **QGraphicsSceneDragDropEvent** .
        """
        ...
