"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import Any, Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QGraphicsProxyWidget(PySide6.QtWidgets.QGraphicsWidget):
    """
    https://doc.qt.io/qt-6/qgraphicsproxywidget.html

    **Detailed Description**

    QGraphicsProxyWidget embeds **QWidget** -based widgets, for example, a
    **QPushButton** , **QFontComboBox** , or even **QFileDialog** , into
    **QGraphicsScene** . It forwards events between the two objects and
    translates between **QWidget** 's integer-based geometry and
    **QGraphicsWidget** 's qreal-based geometry. QGraphicsProxyWidget supports
    all core features of **QWidget** , including tab focus, keyboard input, Drag
    & Drop, and popups. You can also embed complex widgets, e.g., widgets with
    subwidgets.

    Example:

    int main(int argc, char **argv)
        {
            **QApplication**  app(argc,
    argv);

            **QTabWidget**  *tabWidget = new **QTabWidget** ;
    **QGraphicsScene**  scene;
            **QGraphicsProxyWidget**  *proxy =
    scene.addWidget(tabWidget);

            **QGraphicsView**  view(&scene);
    view.show();

            return app.exec();
        }

    QGraphicsProxyWidget takes care of automatically embedding popup children of
    embedded widgets through creating a child proxy for each popup. This means
    that when an embedded **QComboBox**  shows its popup list, a new
    QGraphicsProxyWidget is created automatically, embedding the popup, and
    positioning it correctly. This only works if the popup is child of the
    embedded widget (for example **QToolButton::setMenu** () requires the
    **QMenu**  instance to be child of the **QToolButton** ).

    **Embedding a Widget with QGraphicsProxyWidget**

    There are two ways to embed a widget using QGraphicsProxyWidget. The most
    common way is to pass a widget pointer to **QGraphicsScene::addWidget** ()
    together with any relevant **Qt::WindowFlags** . This function returns a
    pointer to a QGraphicsProxyWidget. You can then choose to reparent or
    position either the proxy, or the embedded widget itself.

    For example, in the code snippet below, we embed a group box into the proxy:

    **QGroupBox**  *groupBox = new **QGroupBox** ("Contact Details");
    **QLabel**  *numberLabel = new **QLabel** ("Telephone number");
    **QLineEdit**  *numberEdit = new **QLineEdit** ;

        **QFormLayout**
    *layout = new **QFormLayout** ;
        layout->addRow(numberLabel, numberEdit);
    groupBox->setLayout(layout);

        **QGraphicsScene**  scene;
    **QGraphicsProxyWidget**  *proxy = scene.addWidget(groupBox);
    **QGraphicsView**  view(&scene);
        view.show();

    The image below is the output obtained with its contents margin and contents
    rect labeled.

    ![](images/qgraphicsproxywidget-embed.png)

    Alternatively, you can start by creating a new QGraphicsProxyWidget item,
    and then call **setWidget** () to embed a **QWidget**  later. The **widget**
    () function returns a pointer to the embedded widget. QGraphicsProxyWidget
    shares ownership with **QWidget** , so if either of the two widgets are
    destroyed, the other widget will be automatically destroyed as well.

    **Synchronizing Widget States**

    QGraphicsProxyWidget keeps its state in sync with the embedded widget. For
    example, if the proxy is hidden or disabled, the embedded widget will be
    hidden or disabled as well, and vice versa. When the widget is embedded by
    calling addWidget(), QGraphicsProxyWidget copies the state from the widget
    into the proxy, and after that, the two will stay synchronized where
    possible. By default, when you embed a widget into a proxy, both the widget
    and the proxy will be visible because a **QGraphicsWidget**  is visible when
    created (you do not have to call **show** ()). If you explicitly hide the
    embedded widget, the proxy will also become invisible.

    Example:

    **QGraphicsScene**  scene;

        **QLineEdit**  *edit = new **QLineEdit**
    ;
        **QGraphicsProxyWidget**  *proxy = scene.addWidget(edit);
    edit->isVisible();  // returns true
        proxy->isVisible(); // also returns
    true

        edit->hide();

        edit->isVisible();  // returns false
    proxy->isVisible(); // also returns false

    QGraphicsProxyWidget maintains symmetry for the following states:

    **QWidget**  stateQGraphicsProxyWidget stateNotes
    **QWidget::enabled**
    QGraphicsProxyWidget::enabled
    **QWidget::visible**
    QGraphicsProxyWidget::visibleThe explicit state is also symmetric.
    **QWidget::geometry** QGraphicsProxyWidget::geometryGeometry is only
    guaranteed to be symmetric while the embedded widget is visible.
    **QWidget::layoutDirection** QGraphicsProxyWidget::layoutDirection
    **QWidget::style** QGraphicsProxyWidget::style
    **QWidget::palette**
    QGraphicsProxyWidget::palette
    **QWidget::font** QGraphicsProxyWidget::font
    **QWidget::cursor** QGraphicsProxyWidget::cursorThe embedded widget
    overrides the proxy widget cursor. The proxy cursor changes depending on
    which embedded subwidget is currently under the mouse.
    **QWidget::sizeHint** ()**QGraphicsProxyWidget::sizeHint** ()All size hint
    functionality from the embedded widget is forwarded by the proxy.
    QWidget::getContentsMargins()**QGraphicsProxyWidget::getContentsMargins**
    ()Updated once by **setWidget** ().
    **QWidget::windowTitle**
    QGraphicsProxyWidget::windowTitleUpdated once by **setWidget** ().

    **Note:****QGraphicsScene**  keeps the embedded widget in a special state
    that prevents it from disturbing other widgets (both embedded and not
    embedded) while the widget is embedded. In this state, the widget may differ
    slightly in behavior from when it is not embedded.

    **Warning:** This class is provided for convenience when bridging QWidgets
    and QGraphicsItems, it should not be used for high-performance scenarios. In
    particular, embedding widgets into a scene that is then displayed through a
    **QGraphicsView**  that uses an OpenGL viewport will not work for all
    combinations.

    **See also** **QGraphicsScene::addWidget** () and **QGraphicsWidget** .
    """

    def __init__(
        self,
        parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...,
        wFlags: PySide6.QtCore.Qt.WindowFlags = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#QGraphicsProxyWidget

        **QGraphicsProxyWidget::QGraphicsProxyWidget(QGraphicsItem * parent =
        nullptr, Qt::WindowFlags wFlags = Qt::WindowFlags())**

        Constructs a new QGraphicsProxy widget. **parent** and **wFlags** are
        passed to **QGraphicsItem** 's constructor.
        """
        ...

    def contextMenuEvent(
        self, event: PySide6.QtWidgets.QGraphicsSceneContextMenuEvent
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#contextMenuEvent

        **[override virtual protected] void
        QGraphicsProxyWidget::contextMenuEvent(QGraphicsSceneContextMenuEvent *
        event )**

        Reimplements: **QGraphicsItem::contextMenuEvent**
        (QGraphicsSceneContextMenuEvent *event).
        """
        ...

    def createProxyForChildWidget(
        self, child: PySide6.QtWidgets.QWidget
    ) -> PySide6.QtWidgets.QGraphicsProxyWidget:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#createProxyForChildWidg
        et

        **QGraphicsProxyWidget
        *QGraphicsProxyWidget::createProxyForChildWidget(QWidget * child )**

        Creates a proxy widget for the given **child** of the widget contained
        in this proxy.

        This function makes it possible to acquire proxies for non top-level
        widgets. For instance, you can embed a dialog, and then transform only
        one of its widgets.

        If the widget is already embedded, return the existing proxy widget.

        **See also** **newProxyWidget** () and **QGraphicsScene::addWidget** ().
        """
        ...

    def dragEnterEvent(
        self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#dragEnterEvent

        **[override virtual protected] void
        QGraphicsProxyWidget::dragEnterEvent(QGraphicsSceneDragDropEvent * event
        )**

        Reimplements: **QGraphicsItem::dragEnterEvent**
        (QGraphicsSceneDragDropEvent *event).
        """
        ...

    def dragLeaveEvent(
        self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#dragLeaveEvent

        **[override virtual protected] void
        QGraphicsProxyWidget::dragLeaveEvent(QGraphicsSceneDragDropEvent * event
        )**

        Reimplements: **QGraphicsItem::dragLeaveEvent**
        (QGraphicsSceneDragDropEvent *event).
        """
        ...

    def dragMoveEvent(
        self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#dragMoveEvent

        **[override virtual protected] void
        QGraphicsProxyWidget::dragMoveEvent(QGraphicsSceneDragDropEvent * event
        )**

        Reimplements: **QGraphicsItem::dragMoveEvent**
        (QGraphicsSceneDragDropEvent *event).
        """
        ...

    def dropEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#dropEvent

        **[override virtual protected] void
        QGraphicsProxyWidget::dropEvent(QGraphicsSceneDragDropEvent * event )**

        Reimplements: **QGraphicsItem::dropEvent** (QGraphicsSceneDragDropEvent
        *event).
        """
        ...

    def event(self, event: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#event

        **[override virtual protected] bool QGraphicsProxyWidget::event(QEvent *
        event )**

        Reimplements: **QGraphicsWidget::event** (QEvent *event).
        """
        ...

    def eventFilter(
        self, object: PySide6.QtCore.QObject, event: PySide6.QtCore.QEvent
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#eventFilter

        **[override virtual protected] bool
        QGraphicsProxyWidget::eventFilter(QObject * object , QEvent * event )**

        Reimplements: **QObject::eventFilter** (QObject *watched, QEvent
        *event).
        """
        ...

    def focusInEvent(self, event: PySide6.QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#focusInEvent

        **[override virtual protected] void
        QGraphicsProxyWidget::focusInEvent(QFocusEvent * event )**

        Reimplements: **QGraphicsWidget::focusInEvent** (QFocusEvent *event).
        """
        ...

    def focusNextPrevChild(self, next: bool) -> bool:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#focusNextPrevChild

        **[override virtual protected] bool
        QGraphicsProxyWidget::focusNextPrevChild(bool next )**

        Reimplements: **QGraphicsWidget::focusNextPrevChild** (bool next).
        """
        ...

    def focusOutEvent(self, event: PySide6.QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#focusOutEvent

        **[override virtual protected] void
        QGraphicsProxyWidget::focusOutEvent(QFocusEvent * event )**

        Reimplements: **QGraphicsWidget::focusOutEvent** (QFocusEvent *event).
        """
        ...

    def grabMouseEvent(self, event: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#grabMouseEvent

        **[override virtual protected] void
        QGraphicsProxyWidget::grabMouseEvent(QEvent * event )**

        Reimplements: **QGraphicsWidget::grabMouseEvent** (QEvent *event).
        """
        ...

    def hideEvent(self, event: PySide6.QtGui.QHideEvent) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#hideEvent

        **[override virtual protected] void
        QGraphicsProxyWidget::hideEvent(QHideEvent * event )**

        Reimplements: **QGraphicsWidget::hideEvent** (QHideEvent *event).
        """
        ...

    def hoverEnterEvent(
        self, event: PySide6.QtWidgets.QGraphicsSceneHoverEvent
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#hoverEnterEvent

        **[override virtual protected] void
        QGraphicsProxyWidget::hoverEnterEvent(QGraphicsSceneHoverEvent * event
        )**

        Reimplements: **QGraphicsItem::hoverEnterEvent**
        (QGraphicsSceneHoverEvent *event).
        """
        ...

    def hoverLeaveEvent(
        self, event: PySide6.QtWidgets.QGraphicsSceneHoverEvent
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#hoverLeaveEvent

        **[override virtual protected] void
        QGraphicsProxyWidget::hoverLeaveEvent(QGraphicsSceneHoverEvent * event
        )**

        Reimplements: **QGraphicsWidget::hoverLeaveEvent**
        (QGraphicsSceneHoverEvent *event).
        """
        ...

    def hoverMoveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneHoverEvent) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#hoverMoveEvent

        **[override virtual protected] void
        QGraphicsProxyWidget::hoverMoveEvent(QGraphicsSceneHoverEvent * event
        )**

        Reimplements: **QGraphicsWidget::hoverMoveEvent**
        (QGraphicsSceneHoverEvent *event).
        """
        ...

    def inputMethodEvent(self, event: PySide6.QtGui.QInputMethodEvent) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#inputMethodEvent

        **[override virtual protected] void
        QGraphicsProxyWidget::inputMethodEvent(QInputMethodEvent * event )**

        Reimplements: **QGraphicsItem::inputMethodEvent** (QInputMethodEvent
        *event).
        """
        ...

    def inputMethodQuery(self, query: PySide6.QtCore.Qt.InputMethodQuery) -> Any:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#inputMethodQuery

        **[override virtual protected] QVariant
        QGraphicsProxyWidget::inputMethodQuery(Qt::InputMethodQuery query )
        const**

        Reimplements: **QGraphicsItem::inputMethodQuery(Qt::InputMethodQuery
        query) const** .
        """
        ...

    def itemChange(
        self, change: PySide6.QtWidgets.QGraphicsItem.GraphicsItemChange, value: Any
    ) -> Any:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#itemChange

        **[override virtual protected] QVariant
        QGraphicsProxyWidget::itemChange(QGraphicsItem::GraphicsItemChange
        change , const QVariant & value )**

        Reimplements: **QGraphicsWidget::itemChange**
        (QGraphicsItem::GraphicsItemChange change, const QVariant &value).
        """
        ...

    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#keyPressEvent

        **[override virtual protected] void
        QGraphicsProxyWidget::keyPressEvent(QKeyEvent * event )**

        Reimplements: **QGraphicsItem::keyPressEvent** (QKeyEvent *event).
        """
        ...

    def keyReleaseEvent(self, event: PySide6.QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#keyReleaseEvent

        **[override virtual protected] void
        QGraphicsProxyWidget::keyReleaseEvent(QKeyEvent * event )**

        Reimplements: **QGraphicsItem::keyReleaseEvent** (QKeyEvent *event).
        """
        ...

    def mouseDoubleClickEvent(
        self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#mouseDoubleClickEvent

        **[override virtual protected] void
        QGraphicsProxyWidget::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *
        event )**

        Reimplements: **QGraphicsItem::mouseDoubleClickEvent**
        (QGraphicsSceneMouseEvent *event).
        """
        ...

    def mouseMoveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#mouseMoveEvent

        **[override virtual protected] void
        QGraphicsProxyWidget::mouseMoveEvent(QGraphicsSceneMouseEvent * event
        )**

        Reimplements: **QGraphicsItem::mouseMoveEvent**
        (QGraphicsSceneMouseEvent *event).
        """
        ...

    def mousePressEvent(
        self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#mousePressEvent

        **[override virtual protected] void
        QGraphicsProxyWidget::mousePressEvent(QGraphicsSceneMouseEvent * event
        )**

        Reimplements: **QGraphicsItem::mousePressEvent**
        (QGraphicsSceneMouseEvent *event).
        """
        ...

    def mouseReleaseEvent(
        self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#mouseReleaseEvent

        **[override virtual protected] void
        QGraphicsProxyWidget::mouseReleaseEvent(QGraphicsSceneMouseEvent * event
        )**

        Reimplements: **QGraphicsItem::mouseReleaseEvent**
        (QGraphicsSceneMouseEvent *event).
        """
        ...

    def newProxyWidget(
        self, arg__1: PySide6.QtWidgets.QWidget
    ) -> PySide6.QtWidgets.QGraphicsProxyWidget:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#newProxyWidget

        **[protected slot] QGraphicsProxyWidget
        *QGraphicsProxyWidget::newProxyWidget(const QWidget * child )**

        Creates a proxy widget for the given **child** of the widget contained
        in this proxy.

        You should not call this function directly; use
        **QGraphicsProxyWidget::createProxyForChildWidget** () instead.

        This function is a fake virtual slot that you can reimplement in your
        subclass in order to control how new proxy widgets are created. The
        default implementation returns a proxy created with the
        **QGraphicsProxyWidget** () constructor with this proxy widget as the
        parent.

        **See also** **createProxyForChildWidget** ().
        """
        ...

    def paint(
        self,
        painter: PySide6.QtGui.QPainter,
        option: PySide6.QtWidgets.QStyleOptionGraphicsItem,
        widget: PySide6.QtWidgets.QWidget,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#paint

        **[override virtual] void QGraphicsProxyWidget::paint(QPainter * painter
        , const QStyleOptionGraphicsItem * option , QWidget * widget )**

        Reimplements: **QGraphicsWidget::paint** (QPainter *painter, const
        QStyleOptionGraphicsItem *option, QWidget *widget).
        """
        ...

    def resizeEvent(self, event: PySide6.QtWidgets.QGraphicsSceneResizeEvent) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#resizeEvent

        **[override virtual protected] void
        QGraphicsProxyWidget::resizeEvent(QGraphicsSceneResizeEvent * event )**

        Reimplements: **QGraphicsWidget::resizeEvent**
        (QGraphicsSceneResizeEvent *event).
        """
        ...

    @overload
    def setGeometry(
        self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#setGeometry

        **[override virtual] void QGraphicsProxyWidget::setGeometry(const QRectF
        & rect )**

        Reimplements: **QGraphicsLayoutItem::setGeometry** (const QRectF &rect).
        """
        ...

    @overload
    def setGeometry(self, x: float, y: float, w: float, h: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#setGeometry

        **[override virtual] void QGraphicsProxyWidget::setGeometry(const QRectF
        & rect )**

        Reimplements: **QGraphicsLayoutItem::setGeometry** (const QRectF &rect).
        """
        ...

    def setWidget(self, widget: PySide6.QtWidgets.QWidget) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#setWidget

        **void QGraphicsProxyWidget::setWidget(QWidget * widget )**

        Embeds **widget** into this proxy widget. The embedded widget must
        reside exclusively either inside or outside of Graphics View. You cannot
        embed a widget as long as it is is visible elsewhere in the UI, at the
        same time.

        **widget** must be a top-level widget whose parent is `nullptr`.

        When the widget is embedded, its state (e.g., visible, enabled,
        geometry, size hints) is copied into the proxy widget. If the embedded
        widget is explicitly hidden or disabled, the proxy widget will become
        explicitly hidden or disabled after embedding is complete. The class
        documentation has a full overview over the shared state.

        **QGraphicsProxyWidget** 's window flags determine whether the widget,
        after embedding, will be given window decorations or not.

        After this function returns, **QGraphicsProxyWidget**  will keep its
        state synchronized with that of **widget** whenever possible.

        If a widget is already embedded by this proxy when this function is
        called, that widget will first be automatically unembedded. Passing
        `nullptr` for the **widget** argument will only unembed the widget, and
        the ownership of the currently embedded widget will be passed on to the
        caller. Every child widget that are embedded will also be embedded and
        their proxy widget destroyed.

        Note that widgets with the **Qt::WA_PaintOnScreen**  widget attribute
        set and widgets that wrap an external application or controller cannot
        be embedded. Examples are QOpenGLWidget and QAxWidget.

        **See also** **widget** ().
        """
        ...

    def showEvent(self, event: PySide6.QtGui.QShowEvent) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#showEvent

        **[override virtual protected] void
        QGraphicsProxyWidget::showEvent(QShowEvent * event )**

        Reimplements: **QGraphicsWidget::showEvent** (QShowEvent *event).
        """
        ...

    def sizeHint(
        self,
        which: PySide6.QtCore.Qt.SizeHint,
        constraint: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize] = ...,
    ) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#sizeHint

        **[override virtual protected] QSizeF
        QGraphicsProxyWidget::sizeHint(Qt::SizeHint which , const QSizeF &
        constraint = QSizeF()) const**

        Reimplements: **QGraphicsWidget::sizeHint(Qt::SizeHint which, const
        QSizeF &constraint) const** .
        """
        ...

    def subWidgetRect(self, widget: PySide6.QtWidgets.QWidget) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#subWidgetRect

        **QRectF QGraphicsProxyWidget::subWidgetRect(const QWidget * widget )
        const**

        Returns the rectangle for **widget** , which must be a descendant of
        **widget** (), or **widget** () itself, in this proxy item's local
        coordinates.

        If no widget is embedded, **widget** is `nullptr`, or **widget** is not
        a descendant of the embedded widget, this function returns an empty
        **QRectF** .

        **See also** **widget** ().
        """
        ...

    def type(self) -> int:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#type

        **[override virtual] int QGraphicsProxyWidget::type() const**

        Reimplements: **QGraphicsWidget::type() const** .
        """
        ...

    def ungrabMouseEvent(self, event: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#ungrabMouseEvent

        **[override virtual protected] void
        QGraphicsProxyWidget::ungrabMouseEvent(QEvent * event )**

        Reimplements: **QGraphicsWidget::ungrabMouseEvent** (QEvent *event).
        """
        ...

    def wheelEvent(self, event: PySide6.QtWidgets.QGraphicsSceneWheelEvent) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#wheelEvent

        **[override virtual protected] void
        QGraphicsProxyWidget::wheelEvent(QGraphicsSceneWheelEvent * event )**

        Reimplements: **QGraphicsItem::wheelEvent** (QGraphicsSceneWheelEvent
        *event).
        """
        ...

    def widget(self) -> PySide6.QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-6/qgraphicsproxywidget.html#widget

        **QWidget *QGraphicsProxyWidget::widget() const**

        Returns a pointer to the embedded widget.

        **See also** **setWidget** ().
        """
        ...
