"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import Any, Optional, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QGraphicsPolygonItem(PySide6.QtWidgets.QAbstractGraphicsShapeItem):
    """
    https://doc.qt.io/qt-6/qgraphicspolygonitem.html

    **Detailed Description**

    To set the item's polygon, pass a **QPolygonF**  to QGraphicsPolygonItem's
    constructor, or call the **setPolygon** () function. The **polygon** ()
    function returns the current polygon.

    ![](images/graphicsview-polygonitem.png)

    QGraphicsPolygonItem uses the polygon and the pen width to provide a
    reasonable implementation of **boundingRect** (), **shape** (), and
    **contains** (). The **paint** () function draws the polygon using the
    item's associated pen and brush, which you can set by calling the **setPen**
    () and **setBrush** () functions.

    **See also** **QGraphicsPathItem** , **QGraphicsRectItem** ,
    **QGraphicsEllipseItem** , **QGraphicsTextItem** , **QGraphicsLineItem** ,
    **QGraphicsPixmapItem** , and **Graphics View Framework** .
    """

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicspolygonitem.html#QGraphicsPolygonItem

        **QGraphicsPolygonItem::QGraphicsPolygonItem(QGraphicsItem * parent =
        nullptr)**

        Constructs a QGraphicsPolygonItem. **parent** is passed to
        **QAbstractGraphicsShapeItem** 's constructor.

        **See also** **QGraphicsScene::addItem** ().
        """
        ...

    @overload
    def __init__(
        self,
        polygon: Union[
            PySide6.QtGui.QPolygonF,
            Sequence[PySide6.QtCore.QPointF],
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRectF,
        ],
        parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicspolygonitem.html#QGraphicsPolygonItem-1

        **QGraphicsPolygonItem::QGraphicsPolygonItem(const QPolygonF & polygon ,
        QGraphicsItem * parent = nullptr)**

        Constructs a QGraphicsPolygonItem with **polygon** as the default
        polygon. **parent** is passed to **QAbstractGraphicsShapeItem** 's
        constructor.

        **See also** **QGraphicsScene::addItem** ().
        """
        ...

    def boundingRect(self) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qgraphicspolygonitem.html#boundingRect

        **[override virtual] QRectF QGraphicsPolygonItem::boundingRect() const**

        Reimplements: **QGraphicsItem::boundingRect() const** .
        """
        ...

    def contains(
        self,
        point: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qgraphicspolygonitem.html#contains

        **[override virtual] bool QGraphicsPolygonItem::contains(const QPointF &
        point ) const**

        Reimplements: **QGraphicsItem::contains(const QPointF &point) const** .
        """
        ...

    def extension(self, variant: Any) -> Any:
        ...

    def fillRule(self) -> PySide6.QtCore.Qt.FillRule:
        """
        https://doc.qt.io/qt-6/qgraphicspolygonitem.html#fillRule

        **Qt::FillRule QGraphicsPolygonItem::fillRule() const**

        Returns the fill rule of the polygon. The default fill rule is
        **Qt::OddEvenFill** .

        **See also** **setFillRule** (), **QPainterPath::fillRule** (), and
        **QPainter::drawPolygon** ().
        """
        ...

    def isObscuredBy(self, item: PySide6.QtWidgets.QGraphicsItem) -> bool:
        """
        https://doc.qt.io/qt-6/qgraphicspolygonitem.html#isObscuredBy

        **[override virtual] bool QGraphicsPolygonItem::isObscuredBy(const
        QGraphicsItem * item ) const**

        Reimplements: **QAbstractGraphicsShapeItem::isObscuredBy(const
        QGraphicsItem *item) const** .
        """
        ...

    def opaqueArea(self) -> PySide6.QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-6/qgraphicspolygonitem.html#opaqueArea

        **[override virtual] QPainterPath QGraphicsPolygonItem::opaqueArea()
        const**

        Reimplements: **QAbstractGraphicsShapeItem::opaqueArea() const** .
        """
        ...

    def paint(
        self,
        painter: PySide6.QtGui.QPainter,
        option: PySide6.QtWidgets.QStyleOptionGraphicsItem,
        widget: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicspolygonitem.html#paint

        **[override virtual] void QGraphicsPolygonItem::paint(QPainter * painter
        , const QStyleOptionGraphicsItem * option , QWidget * widget =
        nullptr)**

        Reimplements: **QGraphicsItem::paint** (QPainter *painter, const
        QStyleOptionGraphicsItem *option, QWidget *widget).
        """
        ...

    def polygon(self) -> PySide6.QtGui.QPolygonF:
        """
        https://doc.qt.io/qt-6/qgraphicspolygonitem.html#polygon

        **QPolygonF QGraphicsPolygonItem::polygon() const**

        Returns the item's polygon, or an empty polygon if no polygon has been
        set.

        **See also** **setPolygon** ().
        """
        ...

    def setFillRule(self, rule: PySide6.QtCore.Qt.FillRule) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicspolygonitem.html#setFillRule

        **void QGraphicsPolygonItem::setFillRule(Qt::FillRule rule )**

        Sets the fill rule of the polygon to **rule**. The default fill rule is
        **Qt::OddEvenFill** .

        **See also** **fillRule** (), **QPainterPath::fillRule** (), and
        **QPainter::drawPolygon** ().
        """
        ...

    def setPolygon(
        self,
        polygon: Union[
            PySide6.QtGui.QPolygonF,
            Sequence[PySide6.QtCore.QPointF],
            PySide6.QtGui.QPolygon,
            PySide6.QtCore.QRectF,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicspolygonitem.html#setPolygon

        **void QGraphicsPolygonItem::setPolygon(const QPolygonF & polygon )**

        Sets the item's polygon to be the given **polygon**.

        **See also** **polygon** ().
        """
        ...

    def shape(self) -> PySide6.QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-6/qgraphicspolygonitem.html#shape

        **[override virtual] QPainterPath QGraphicsPolygonItem::shape() const**

        Reimplements: **QGraphicsItem::shape() const** .
        """
        ...

    def type(self) -> int:
        """
        https://doc.qt.io/qt-6/qgraphicspolygonitem.html#type

        **[override virtual] int QGraphicsPolygonItem::type() const**

        Reimplements: **QGraphicsItem::type() const** .
        """
        ...
