"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import Any, Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QGraphicsEllipseItem(PySide6.QtWidgets.QAbstractGraphicsShapeItem):
    """
    https://doc.qt.io/qt-6/qgraphicsellipseitem.html

    **Detailed Description**

    QGraphicsEllipseItem respresents an ellipse with a fill and an outline, and
    you can also use it for ellipse segments (see **startAngle** (),
    **spanAngle** ()).

    ![](images/graphicsview-ellipseitem.png)![](images/graphicsview-ellipseitem-
    pie.png)

    To set the item's ellipse, pass a **QRectF**  to QGraphicsEllipseItem's
    constructor, or call **setRect** (). The **rect** () function returns the
    current ellipse geometry.

    QGraphicsEllipseItem uses the rect and the pen width to provide a reasonable
    implementation of **boundingRect** (), **shape** (), and **contains** ().
    The **paint** () function draws the ellipse using the item's associated pen
    and brush, which you can set by calling **setPen** () and **setBrush** ().

    **See also** **QGraphicsPathItem** , **QGraphicsRectItem** ,
    **QGraphicsPolygonItem** , **QGraphicsTextItem** , **QGraphicsLineItem** ,
    **QGraphicsPixmapItem** , and **Graphics View Framework** .
    """

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsellipseitem.html#QGraphicsEllipseItem

        **QGraphicsEllipseItem::QGraphicsEllipseItem(QGraphicsItem * parent =
        nullptr)**

        Constructs a QGraphicsEllipseItem. **parent** is passed to
        **QAbstractGraphicsShapeItem** 's constructor.

        **See also** **QGraphicsScene::addItem** ().
        """
        ...

    @overload
    def __init__(
        self,
        rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect],
        parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsellipseitem.html#QGraphicsEllipseItem-1

        **QGraphicsEllipseItem::QGraphicsEllipseItem(const QRectF & rect ,
        QGraphicsItem * parent = nullptr)**

        Constructs a QGraphicsEllipseItem using **rect** as the default
        rectangle. **parent** is passed to **QAbstractGraphicsShapeItem** 's
        constructor.

        **See also** **QGraphicsScene::addItem** ().
        """
        ...

    @overload
    def __init__(
        self,
        x: float,
        y: float,
        w: float,
        h: float,
        parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsellipseitem.html#QGraphicsEllipseItem-2

        **QGraphicsEllipseItem::QGraphicsEllipseItem(qreal x , qreal y , qreal
        width , qreal height , QGraphicsItem * parent = nullptr)**

        Constructs a QGraphicsEllipseItem using the rectangle defined by ( **x**
        , **y** ) and the given **width** and **height** , as the default
        rectangle. **parent** is passed to **QAbstractGraphicsShapeItem** 's
        constructor.

        **See also** **QGraphicsScene::addItem** ().
        """
        ...

    def boundingRect(self) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qgraphicsellipseitem.html#boundingRect

        **[override virtual] QRectF QGraphicsEllipseItem::boundingRect() const**

        Reimplements: **QGraphicsItem::boundingRect() const** .
        """
        ...

    def contains(
        self,
        point: Union[
            PySide6.QtCore.QPointF,
            PySide6.QtCore.QPoint,
            PySide6.QtGui.QPainterPath.Element,
        ],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qgraphicsellipseitem.html#contains

        **[override virtual] bool QGraphicsEllipseItem::contains(const QPointF &
        point ) const**

        Reimplements: **QGraphicsItem::contains(const QPointF &point) const** .
        """
        ...

    def extension(self, variant: Any) -> Any:
        ...

    def isObscuredBy(self, item: PySide6.QtWidgets.QGraphicsItem) -> bool:
        """
        https://doc.qt.io/qt-6/qgraphicsellipseitem.html#isObscuredBy

        **[override virtual] bool QGraphicsEllipseItem::isObscuredBy(const
        QGraphicsItem * item ) const**

        Reimplements: **QAbstractGraphicsShapeItem::isObscuredBy(const
        QGraphicsItem *item) const** .
        """
        ...

    def opaqueArea(self) -> PySide6.QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-6/qgraphicsellipseitem.html#opaqueArea

        **[override virtual] QPainterPath QGraphicsEllipseItem::opaqueArea()
        const**

        Reimplements: **QAbstractGraphicsShapeItem::opaqueArea() const** .
        """
        ...

    def paint(
        self,
        painter: PySide6.QtGui.QPainter,
        option: PySide6.QtWidgets.QStyleOptionGraphicsItem,
        widget: Optional[PySide6.QtWidgets.QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsellipseitem.html#paint

        **[override virtual] void QGraphicsEllipseItem::paint(QPainter * painter
        , const QStyleOptionGraphicsItem * option , QWidget * widget =
        nullptr)**

        Reimplements: **QGraphicsItem::paint** (QPainter *painter, const
        QStyleOptionGraphicsItem *option, QWidget *widget).
        """
        ...

    def rect(self) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qgraphicsellipseitem.html#rect

        **QRectF QGraphicsEllipseItem::rect() const**

        Returns the item's ellipse geometry as a **QRectF** .

        **See also** **setRect** () and **QPainter::drawEllipse** ().
        """
        ...

    @overload
    def setRect(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsellipseitem.html#setRect

        **void QGraphicsEllipseItem::setRect(const QRectF & rect )**

        Sets the item's ellipse geometry to **rect**. The rectangle's left edge
        defines the left edge of the ellipse, and the rectangle's top edge
        describes the top of the ellipse. The height and width of the rectangle
        describe the height and width of the ellipse.

        **See also** **rect** () and **QPainter::drawEllipse** ().
        """
        ...

    @overload
    def setRect(self, x: float, y: float, w: float, h: float) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsellipseitem.html#setRect-1

        **void QGraphicsEllipseItem::setRect(qreal x , qreal y , qreal width ,
        qreal height )**

        Sets the item's rectangle to the rectangle defined by ( **x** , **y** )
        and the given **width** and **height**.

        This convenience function is equivalent to calling `setRect(QRectF(x, y,
        width, height))`

        **See also** **rect** ().
        """
        ...

    def setSpanAngle(self, angle: int) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsellipseitem.html#setSpanAngle

        **void QGraphicsEllipseItem::setSpanAngle(int angle )**

        Sets the span angle for an ellipse segment to **angle** , which is in
        16ths of a degree. This angle is used together with **startAngle** () to
        represent an ellipse segment (a pie). By default, the span angle is 5760
        (360 * 16, a full ellipse).

        **See also** **spanAngle** (), **setStartAngle** (), and
        **QPainter::drawPie** ().
        """
        ...

    def setStartAngle(self, angle: int) -> None:
        """
        https://doc.qt.io/qt-6/qgraphicsellipseitem.html#setStartAngle

        **void QGraphicsEllipseItem::setStartAngle(int angle )**

        Sets the start angle for an ellipse segment to **angle** , which is in
        16ths of a degree. This angle is used together with **spanAngle** () for
        representing an ellipse segment (a pie). By default, the start angle is
        0.

        **See also** **startAngle** (), **setSpanAngle** (), and
        **QPainter::drawPie** ().
        """
        ...

    def shape(self) -> PySide6.QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-6/qgraphicsellipseitem.html#shape

        **[override virtual] QPainterPath QGraphicsEllipseItem::shape() const**

        Reimplements: **QGraphicsItem::shape() const** .
        """
        ...

    def spanAngle(self) -> int:
        """
        https://doc.qt.io/qt-6/qgraphicsellipseitem.html#spanAngle

        **int QGraphicsEllipseItem::spanAngle() const**

        Returns the span angle of an ellipse segment in 16ths of a degree. This
        angle is used together with **startAngle** () for representing an
        ellipse segment (a pie). By default, this function returns 5760 (360 *
        16, a full ellipse).

        **See also** **setSpanAngle** () and **startAngle** ().
        """
        ...

    def startAngle(self) -> int:
        """
        https://doc.qt.io/qt-6/qgraphicsellipseitem.html#startAngle

        **int QGraphicsEllipseItem::startAngle() const**

        Returns the start angle for an ellipse segment in 16ths of a degree.
        This angle is used together with **spanAngle** () for representing an
        ellipse segment (a pie). By default, the start angle is 0.

        **See also** **setStartAngle** () and **spanAngle** ().
        """
        ...

    def type(self) -> int:
        """
        https://doc.qt.io/qt-6/qgraphicsellipseitem.html#type

        **[override virtual] int QGraphicsEllipseItem::type() const**

        Reimplements: **QGraphicsItem::type() const** .
        """
        ...
