"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QFrame(PySide6.QtWidgets.QWidget):
    """
    https://doc.qt.io/qt-6/qframe.html

    **Detailed Description**

    **QMenu**  uses this to "raise" the menu above the surrounding screen.
    **QProgressBar**  has a "sunken" look. **QLabel**  has a flat look. The
    frames of widgets like these can be changed.

    **QLabel**  label(...);
        label.setFrameStyle(**QFrame** ::Panel |
    **QFrame** ::Raised);
        label.setLineWidth(2);

        **QProgressBar**
    pbar(...);
        label.setFrameStyle(**QFrame** ::NoFrame);

    The QFrame class can also be used directly for creating simple placeholder
    frames without any contents.

    The frame style is specified by a **frame shape**  and a **shadow style**
    that is used to visually separate the frame from surrounding widgets. These
    properties can be set together using the **setFrameStyle** () function and
    read with **frameStyle** ().

    The frame shapes are **NoFrame** , **Box** , **Panel** , **StyledPanel** ,
    **HLine**  and **VLine** ; the shadow styles are **Plain** , **Raised**  and
    **Sunken** .

    A frame widget has three attributes that describe the thickness of the
    border: **lineWidth** , **midLineWidth** , and **frameWidth** .

    * The line width is the width of the frame border. It can be modified to
    customize the frame's appearance.
      * The mid-line width specifies the width
    of an extra line in the middle of the frame, which uses a third color to
    obtain a special 3D effect. Notice that a mid-line is only drawn for **Box**
    , **HLine**  and **VLine**  frames that are raised or sunken.
      * The frame
    width is determined by the frame style, and the **frameWidth** () function
    is used to obtain the value defined for the style used.

    The margin between the frame and the contents of the frame can be customized
    with the **QWidget::setContentsMargins** () function.

    This table shows some of the combinations of styles and line widths:

    ![Table of frame styles](images/frames.png)
    """

    Plain: QFrame.Shadow = ...
    Raised: QFrame.Shadow = ...
    Sunken: QFrame.Shadow = ...
    NoFrame: QFrame.Shape = ...
    Box: QFrame.Shape = ...
    Panel: QFrame.Shape = ...
    WinPanel: QFrame.Shape = ...
    HLine: QFrame.Shape = ...
    VLine: QFrame.Shape = ...
    StyledPanel: QFrame.Shape = ...
    Shape_Mask: QFrame.StyleMask = ...
    Shadow_Mask: QFrame.StyleMask = ...

    class Shadow(Enum):
        Plain: QFrame.Shadow = ...
        Raised: QFrame.Shadow = ...
        Sunken: QFrame.Shadow = ...

    class Shape(Enum):
        NoFrame: QFrame.Shape = ...
        Box: QFrame.Shape = ...
        Panel: QFrame.Shape = ...
        WinPanel: QFrame.Shape = ...
        HLine: QFrame.Shape = ...
        VLine: QFrame.Shape = ...
        StyledPanel: QFrame.Shape = ...

    class StyleMask(Enum):
        Shape_Mask: QFrame.StyleMask = ...
        Shadow_Mask: QFrame.StyleMask = ...

    def __init__(
        self,
        parent: Optional[PySide6.QtWidgets.QWidget] = ...,
        f: PySide6.QtCore.Qt.WindowFlags = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qframe.html#QFrame

        **QFrame::QFrame(QWidget * parent = nullptr, Qt::WindowFlags f =
        Qt::WindowFlags())**

        Constructs a frame widget with frame style **NoFrame**  and a 1-pixel
        frame width.

        The **parent** and **f** arguments are passed to the **QWidget**
        constructor.
        """
        ...

    def changeEvent(self, arg__1: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qframe.html#changeEvent

        **[override virtual protected] void QFrame::changeEvent(QEvent * ev )**

        Reimplements: **QWidget::changeEvent** (QEvent *event).
        """
        ...

    def drawFrame(self, arg__1: PySide6.QtGui.QPainter) -> None:
        ...

    def event(self, e: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qframe.html#event

        **[override virtual protected] bool QFrame::event(QEvent * e )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    def frameRect(self) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qframe.html#frameRect-prop

        **frameRect : QRect**

        This property holds the frame's rectangle

        The frame's rectangle is the rectangle the frame is drawn in. By
        default, this is the entire widget. Setting the rectangle does does
        **not** cause a widget update. The frame rectangle is automatically
        adjusted when the widget changes size.

        If you set the rectangle to a null rectangle (for example, **QRect** (0,
        0, 0, 0)), then the resulting frame rectangle is equivalent to the
        **widget rectangle** .

        **Access functions:**

        QRect **frameRect** () const
        void **setFrameRect** (const QRect &)
        """
        ...

    def frameShadow(self) -> PySide6.QtWidgets.QFrame.Shadow:
        """
        https://doc.qt.io/qt-6/qframe.html#frameShadow-prop

        **frameShadow : Shadow**

        This property holds the frame shadow value from the frame style

        **Access functions:**

        QFrame::Shadow **frameShadow** () const
        void **setFrameShadow**
        (QFrame::Shadow)

        **See also** **frameStyle** () and **frameShape** ().
        """
        ...

    def frameShape(self) -> PySide6.QtWidgets.QFrame.Shape:
        """
        https://doc.qt.io/qt-6/qframe.html#frameShape-prop

        **frameShape : Shape**

        This property holds the frame shape value from the frame style

        **Access functions:**

        QFrame::Shape **frameShape** () const
        void **setFrameShape**
        (QFrame::Shape)

        **See also** **frameStyle** () and **frameShadow** ().
        """
        ...

    def frameStyle(self) -> int:
        """
        https://doc.qt.io/qt-6/qframe.html#frameStyle

        **int QFrame::frameStyle() const**

        Returns the frame style.

        The default value is **QFrame::Plain** .

        **See also** **setFrameStyle** (), **frameShape** (), and
        **frameShadow** ().
        """
        ...

    def frameWidth(self) -> int:
        """
        https://doc.qt.io/qt-6/qframe.html#frameWidth-prop

        **[read-only] frameWidth : const int**

        This property holds the width of the frame that is drawn.

        Note that the frame width depends on the **frame style** , not only the
        line width and the mid-line width. For example, the style specified by
        **NoFrame**  always has a frame width of 0, whereas the style **Panel**
        has a frame width equivalent to the line width.

        **Access functions:**

        int **frameWidth** () const

        **See also** **lineWidth** (), **midLineWidth** (), and **frameStyle**
        ().
        """
        ...

    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionFrame) -> None:
        """
        https://doc.qt.io/qt-6/qframe.html#initStyleOption

        **[virtual protected, since 5.5] void
        QFrame::initStyleOption(QStyleOptionFrame * option ) const**

        Initializes **option** with the values from this **QFrame** . This
        method is useful for subclasses when they need a **QStyleOptionFrame**
        but don't want to fill in all the information themselves.

        This function was introduced in Qt 5.5.

        **See also** **QStyleOption::initFrom** ().
        """
        ...

    def lineWidth(self) -> int:
        """
        https://doc.qt.io/qt-6/qframe.html#lineWidth-prop

        **lineWidth : int**

        This property holds the line width

        Note that the **total** line width for frames used as separators
        (**HLine**  and **VLine** ) is specified by **frameWidth** .

        The default value is 1.

        **Access functions:**

        int **lineWidth** () const
        void **setLineWidth** (int)

        **See also** **midLineWidth**  and **frameWidth** .
        """
        ...

    def midLineWidth(self) -> int:
        """
        https://doc.qt.io/qt-6/qframe.html#midLineWidth-prop

        **midLineWidth : int**

        This property holds the width of the mid-line

        The default value is 0.

        **Access functions:**

        int **midLineWidth** () const
        void **setMidLineWidth** (int)

        **See also** **lineWidth**  and **frameWidth** .

        **Member Function Documentation**
        """
        ...

    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-6/qframe.html#paintEvent

        **[override virtual protected] void QFrame::paintEvent(QPaintEvent *)**

        Reimplements: **QWidget::paintEvent** (QPaintEvent *event).
        """
        ...

    def setFrameRect(self, arg__1: PySide6.QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-6/qframe.html#frameRect-prop

        **frameRect : QRect**

        This property holds the frame's rectangle

        The frame's rectangle is the rectangle the frame is drawn in. By
        default, this is the entire widget. Setting the rectangle does does
        **not** cause a widget update. The frame rectangle is automatically
        adjusted when the widget changes size.

        If you set the rectangle to a null rectangle (for example, **QRect** (0,
        0, 0, 0)), then the resulting frame rectangle is equivalent to the
        **widget rectangle** .

        **Access functions:**

        QRect **frameRect** () const
        void **setFrameRect** (const QRect &)
        """
        ...

    def setFrameShadow(self, arg__1: PySide6.QtWidgets.QFrame.Shadow) -> None:
        """
        https://doc.qt.io/qt-6/qframe.html#frameShadow-prop

        **frameShadow : Shadow**

        This property holds the frame shadow value from the frame style

        **Access functions:**

        QFrame::Shadow **frameShadow** () const
        void **setFrameShadow**
        (QFrame::Shadow)

        **See also** **frameStyle** () and **frameShape** ().
        """
        ...

    def setFrameShape(self, arg__1: PySide6.QtWidgets.QFrame.Shape) -> None:
        """
        https://doc.qt.io/qt-6/qframe.html#frameShape-prop

        **frameShape : Shape**

        This property holds the frame shape value from the frame style

        **Access functions:**

        QFrame::Shape **frameShape** () const
        void **setFrameShape**
        (QFrame::Shape)

        **See also** **frameStyle** () and **frameShadow** ().
        """
        ...

    def setFrameStyle(self, arg__1: int) -> None:
        """
        https://doc.qt.io/qt-6/qframe.html#setFrameStyle

        **void QFrame::setFrameStyle(int style )**

        Sets the frame style to **style**.

        The **style** is the bitwise OR between a frame shape and a frame shadow
        style. See the picture of the frames in the main class documentation.

        The frame shapes are given in **QFrame::Shape**  and the shadow styles
        in **QFrame::Shadow** .

        If a mid-line width greater than 0 is specified, an additional line is
        drawn for **Raised**  or **Sunken**  **Box** , **HLine** , and **VLine**
        frames. The mid-color of the current color group is used for drawing
        middle lines.

        **See also** **frameStyle** ().
        """
        ...

    def setLineWidth(self, arg__1: int) -> None:
        """
        https://doc.qt.io/qt-6/qframe.html#lineWidth-prop

        **lineWidth : int**

        This property holds the line width

        Note that the **total** line width for frames used as separators
        (**HLine**  and **VLine** ) is specified by **frameWidth** .

        The default value is 1.

        **Access functions:**

        int **lineWidth** () const
        void **setLineWidth** (int)

        **See also** **midLineWidth**  and **frameWidth** .
        """
        ...

    def setMidLineWidth(self, arg__1: int) -> None:
        """
        https://doc.qt.io/qt-6/qframe.html#midLineWidth-prop

        **midLineWidth : int**

        This property holds the width of the mid-line

        The default value is 0.

        **Access functions:**

        int **midLineWidth** () const
        void **setMidLineWidth** (int)

        **See also** **lineWidth**  and **frameWidth** .

        **Member Function Documentation**
        """
        ...

    def sizeHint(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qframe.html#sizeHint

        **[override virtual] QSize QFrame::sizeHint() const**

        Reimplements an access function for property: **QWidget::sizeHint** .
        """
        ...
