"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, Dict, List, Optional, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QFileSystemModel(PySide6.QtCore.QAbstractItemModel):
    """
    https://doc.qt.io/qt-6/qfilesystemmodel.html

    **Detailed Description**

    This class provides access to the local filesystem, providing functions for
    renaming and removing files and directories, and for creating new
    directories. In the simplest case, it can be used with a suitable display
    widget as part of a browser or filter.

    QFileSystemModel can be accessed using the standard interface provided by
    **QAbstractItemModel** , but it also provides some convenience functions
    that are specific to a directory model. The **fileInfo** (), **isDir** (),
    **fileName** () and **filePath** () functions provide information about the
    underlying files and directories related to items in the model. Directories
    can be created and removed using **mkdir** (), **rmdir** ().

    **Note:** QFileSystemModel requires an instance of **QApplication** .

    **Example Usage**

    A directory model that displays the contents of a default directory is
    usually constructed with a parent object:

    **QFileSystemModel**  *model = new **QFileSystemModel** ;
    model->setRootPath(**QDir** ::currentPath());

    A tree view can be used to display the contents of the model

    **QTreeView**  *tree = new **QTreeView** (splitter);
    tree->setModel(model);

    and the contents of a particular directory can be displayed by setting the
    tree view's root index:

    tree->setRootIndex(model->index(**QDir** ::currentPath()));

    The view's root index can be used to control how much of a hierarchical
    model is displayed. QFileSystemModel provides a convenience function that
    returns a suitable model index for a path to a directory within the model.

    **Caching and Performance**

    QFileSystemModel will not fetch any files or directories until
    **setRootPath** () is called. This will prevent any unnecessary querying on
    the file system until that point such as listing the drives on Windows.

    QFileSystemModel uses a separate thread to populate itself so it will not
    cause the main thread to hang as the file system is being queried. Calls to
    **rowCount** () will return 0 until the model populates a directory.

    QFileSystemModel keeps a cache with file information. The cache is
    automatically kept up to date using the **QFileSystemWatcher** .

    **See also** **Model Classes** .
    """

    DontWatchForChanges: QFileSystemModel.Option = ...
    DontResolveSymlinks: QFileSystemModel.Option = ...
    DontUseCustomDirectoryIcons: QFileSystemModel.Option = ...
    FileIconRole: QFileSystemModel.Roles = ...
    FilePathRole: QFileSystemModel.Roles = ...
    FileNameRole: QFileSystemModel.Roles = ...
    FilePermissions: QFileSystemModel.Roles = ...

    class Option(Enum):
        DontWatchForChanges: QFileSystemModel.Option = ...
        DontResolveSymlinks: QFileSystemModel.Option = ...
        DontUseCustomDirectoryIcons: QFileSystemModel.Option = ...

    class Options(object):
        ...

    class Roles(Enum):
        FileIconRole: QFileSystemModel.Roles = ...
        FilePathRole: QFileSystemModel.Roles = ...
        FileNameRole: QFileSystemModel.Roles = ...
        FilePermissions: QFileSystemModel.Roles = ...

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#QFileSystemModel

        **QFileSystemModel::QFileSystemModel(QObject * parent = nullptr)**

        Constructs a file system model with the given **parent**.
        """
        ...

    def canFetchMore(
        self,
        parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#canFetchMore

        **[override virtual] bool QFileSystemModel::canFetchMore(const
        QModelIndex & parent ) const**

        Reimplements: **QAbstractItemModel::canFetchMore(const QModelIndex
        &parent) const** .
        """
        ...

    def columnCount(
        self,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> int:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#columnCount

        **[override virtual] int QFileSystemModel::columnCount(const QModelIndex
        & parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::columnCount(const QModelIndex
        &parent) const** .
        """
        ...

    def data(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        role: int = ...,
    ) -> Any:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#data

        **[override virtual] QVariant QFileSystemModel::data(const QModelIndex &
        index , int role = Qt::DisplayRole) const**

        Reimplements: **QAbstractItemModel::data(const QModelIndex &index, int
        role) const** .

        **See also** **setData** ().
        """
        ...

    def dropMimeData(
        self,
        data: PySide6.QtCore.QMimeData,
        action: PySide6.QtCore.Qt.DropAction,
        row: int,
        column: int,
        parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#dropMimeData

        **[override virtual] bool QFileSystemModel::dropMimeData(const QMimeData
        * data , Qt::DropAction action , int row , int column , const
        QModelIndex & parent )**

        Reimplements: **QAbstractItemModel::dropMimeData** (const QMimeData
        *data, Qt::DropAction action, int row, int column, const QModelIndex
        &parent).

        Handles the **data** supplied by a drag and drop operation that ended
        with the given **action** over the row in the model specified by the
        **row** and **column** and by the **parent** index. Returns true if the
        operation was successful.

        **See also** **supportedDropActions** ().
        """
        ...

    def event(self, event: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#event

        **[override virtual protected] bool QFileSystemModel::event(QEvent *
        event )**

        Reimplements: **QObject::event** (QEvent *e).
        """
        ...

    def fetchMore(
        self,
        parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#fetchMore

        **[override virtual] void QFileSystemModel::fetchMore(const QModelIndex
        & parent )**

        Reimplements: **QAbstractItemModel::fetchMore** (const QModelIndex
        &parent).
        """
        ...

    def fileIcon(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> PySide6.QtGui.QIcon:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#fileIcon

        **QIcon QFileSystemModel::fileIcon(const QModelIndex & index ) const**

        Returns the icon for the item stored in the model under the given
        **index**.
        """
        ...

    def fileInfo(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> PySide6.QtCore.QFileInfo:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#fileInfo

        **QFileInfo QFileSystemModel::fileInfo(const QModelIndex & index )
        const**

        Returns the **QFileInfo**  for the item stored in the model under the
        given **index**.
        """
        ...

    def fileName(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> str:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#fileName

        **QString QFileSystemModel::fileName(const QModelIndex & index ) const**

        Returns the file name for the item stored in the model under the given
        **index**.
        """
        ...

    def filePath(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> str:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#filePath

        **QString QFileSystemModel::filePath(const QModelIndex & index ) const**

        Returns the path of the item stored in the model under the **index**
        given.
        """
        ...

    def filter(self) -> PySide6.QtCore.QDir.Filters:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#filter

        **QDir::Filters QFileSystemModel::filter() const**

        Returns the filter specified for the directory model.

        If a filter has not been set, the default filter is **QDir::AllEntries**
        | **QDir::NoDotAndDotDot**  | **QDir::AllDirs** .

        **See also** **setFilter** () and **QDir::Filters** .
        """
        ...

    def flags(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> PySide6.QtCore.Qt.ItemFlags:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#flags

        **[override virtual] Qt::ItemFlags QFileSystemModel::flags(const
        QModelIndex & index ) const**

        Reimplements: **QAbstractItemModel::flags(const QModelIndex &index)
        const** .
        """
        ...

    def hasChildren(
        self,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#hasChildren

        **[override virtual] bool QFileSystemModel::hasChildren(const
        QModelIndex & parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::hasChildren(const QModelIndex
        &parent) const** .
        """
        ...

    def headerData(
        self, section: int, orientation: PySide6.QtCore.Qt.Orientation, role: int = ...
    ) -> Any:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#headerData

        **[override virtual] QVariant QFileSystemModel::headerData(int section ,
        Qt::Orientation orientation , int role = Qt::DisplayRole) const**

        Reimplements: **QAbstractItemModel::headerData(int section,
        Qt::Orientation orientation, int role) const** .
        """
        ...

    def iconProvider(self) -> PySide6.QtGui.QAbstractFileIconProvider:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#iconProvider

        **QAbstractFileIconProvider *QFileSystemModel::iconProvider() const**

        Returns the file icon provider for this directory model.

        **See also** **setIconProvider** ().
        """
        ...

    @overload
    def index(self, path: str, column: int = ...) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#index

        **[override virtual] QModelIndex QFileSystemModel::index(int row , int
        column , const QModelIndex & parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::index(int row, int column, const
        QModelIndex &parent) const** .
        """
        ...

    @overload
    def index(
        self,
        row: int,
        column: int,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#index-1

        **QModelIndex QFileSystemModel::index(const QString & path , int column
        = 0) const**

        This is an overloaded function.

        Returns the model item index for the given **path** and **column**.
        """
        ...

    def isDir(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#isDir

        **bool QFileSystemModel::isDir(const QModelIndex & index ) const**

        Returns `true` if the model item **index** represents a directory;
        otherwise returns `false`.
        """
        ...

    def isReadOnly(self) -> bool:
        ...

    def lastModified(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> PySide6.QtCore.QDateTime:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#lastModified

        **QDateTime QFileSystemModel::lastModified(const QModelIndex & index )
        const**

        Returns the date and time when **index** was last modified.
        """
        ...

    def mimeData(self, indexes: List[int]) -> PySide6.QtCore.QMimeData:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#mimeData

        **[override virtual] QMimeData *QFileSystemModel::mimeData(const
        QModelIndexList & indexes ) const**

        Reimplements: **QAbstractItemModel::mimeData(const QModelIndexList
        &indexes) const** .

        Returns an object that contains a serialized description of the
        specified **indexes**. The format used to describe the items
        corresponding to the indexes is obtained from the **mimeTypes** ()
        function.

        If the list of indexes is empty, `nullptr` is returned rather than a
        serialized empty list.
        """
        ...

    def mimeTypes(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#mimeTypes

        **[override virtual] QStringList QFileSystemModel::mimeTypes() const**

        Reimplements: **QAbstractItemModel::mimeTypes() const** .

        Returns a list of MIME types that can be used to describe a list of
        items in the model.
        """
        ...

    def mkdir(
        self,
        parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        name: str,
    ) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#mkdir

        **QModelIndex QFileSystemModel::mkdir(const QModelIndex & parent , const
        QString & name )**

        Create a directory with the **name** in the **parent** model index.
        """
        ...

    def myComputer(self, role: int = ...) -> Any:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#myComputer

        **QVariant QFileSystemModel::myComputer(int role = Qt::DisplayRole)
        const**

        Returns the data stored under the given **role** for the item "My
        Computer".

        **See also** **Qt::ItemDataRole** .
        """
        ...

    def nameFilterDisables(self) -> bool:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#nameFilterDisables-prop

        **nameFilterDisables : bool**

        This property holds whether files that don't pass the name filter are
        hidden or disabled

        This property is `true` by default

        **Access functions:**

        bool **nameFilterDisables** () const
        void **setNameFilterDisables**
        (bool **enable** )
        """
        ...

    def nameFilters(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#nameFilters

        **QStringList QFileSystemModel::nameFilters() const**

        Returns a list of filters applied to the names in the model.

        **See also** **setNameFilters** ().
        """
        ...

    def options(self) -> PySide6.QtWidgets.QFileSystemModel.Options:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#options-prop

        **[since 5.14] options : Options**

        This property holds the various options that affect the model

        By default, all options are disabled.

        Options should be set before changing properties.

        This property was introduced in Qt 5.14.

        **Access functions:**

        QFileSystemModel::Options **options** () const
        void **setOptions**
        (QFileSystemModel::Options **options** )

        **See also** **setOption** () and **testOption** ().
        """
        ...

    @overload
    def parent(self) -> PySide6.QtCore.QObject:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#parent

        **[override virtual] QModelIndex QFileSystemModel::parent(const
        QModelIndex & index ) const**

        Reimplements: **QAbstractItemModel::parent(const QModelIndex &index)
        const** .
        """
        ...

    @overload
    def parent(
        self,
        child: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#parent

        **[override virtual] QModelIndex QFileSystemModel::parent(const
        QModelIndex & index ) const**

        Reimplements: **QAbstractItemModel::parent(const QModelIndex &index)
        const** .
        """
        ...

    def remove(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#remove

        **bool QFileSystemModel::remove(const QModelIndex & index )**

        Removes the model item **index** from the file system model and
        **deletes the corresponding file from the file system** , returning true
        if successful. If the item cannot be removed, false is returned.

        **Warning:** This function deletes files from the file system; it does
        **not** move them to a location where they can be recovered.

        **See also** **rmdir** ().
        """
        ...

    def resolveSymlinks(self) -> bool:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#resolveSymlinks-prop

        **resolveSymlinks : bool**

        This property holds whether the directory model should resolve symbolic
        links

        This is only relevant on Windows.

        By default, this property is `true`.

        **Access functions:**

        bool **resolveSymlinks** () const
        void **setResolveSymlinks** (bool
        **enable** )

        **See also** **QFileSystemModel::Options** .

        **Member Function Documentation**
        """
        ...

    def rmdir(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#rmdir

        **bool QFileSystemModel::rmdir(const QModelIndex & index )**

        Removes the directory corresponding to the model item **index** in the
        file system model and **deletes the corresponding directory from the
        file system** , returning true if successful. If the directory cannot be
        removed, false is returned.

        **Warning:** This function deletes directories from the file system; it
        does **not** move them to a location where they can be recovered.

        **See also** **remove** ().
        """
        ...

    def roleNames(self) -> Dict[int, PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#roleNames

        **[override virtual] QHash<int, QByteArray>
        QFileSystemModel::roleNames() const**

        Reimplements: **QAbstractItemModel::roleNames() const** .
        """
        ...

    def rootDirectory(self) -> PySide6.QtCore.QDir:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#rootDirectory

        **QDir QFileSystemModel::rootDirectory() const**

        The currently set directory

        **See also** **rootPath** ().
        """
        ...

    def rootPath(self) -> str:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#rootPath

        **QString QFileSystemModel::rootPath() const**

        The currently set root path

        **See also** **setRootPath** () and **rootDirectory** ().
        """
        ...

    def rowCount(
        self,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> int:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#rowCount

        **[override virtual] int QFileSystemModel::rowCount(const QModelIndex &
        parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::rowCount(const QModelIndex &parent)
        const** .
        """
        ...

    def setData(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        value: Any,
        role: int = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#setData

        **[override virtual] bool QFileSystemModel::setData(const QModelIndex &
        idx , const QVariant & value , int role = Qt::EditRole)**

        Reimplements: **QAbstractItemModel::setData** (const QModelIndex &index,
        const QVariant &value, int role).

        **See also** **data** ().
        """
        ...

    def setFilter(self, filters: PySide6.QtCore.QDir.Filters) -> None:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#setFilter

        **void QFileSystemModel::setFilter(QDir::Filters filters )**

        Sets the directory model's filter to that specified by **filters**.

        Note that the filter you set should always include the **QDir::AllDirs**
        enum value, otherwise **QFileSystemModel**  won't be able to read the
        directory structure.

        **See also** **filter** () and **QDir::Filters** .
        """
        ...

    def setIconProvider(
        self, provider: PySide6.QtGui.QAbstractFileIconProvider
    ) -> None:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#setIconProvider

        **void QFileSystemModel::setIconProvider(QAbstractFileIconProvider *
        provider )**

        Sets the **provider** of file icons for the directory model.

        **See also** **iconProvider** ().
        """
        ...

    def setNameFilterDisables(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#nameFilterDisables-prop

        **nameFilterDisables : bool**

        This property holds whether files that don't pass the name filter are
        hidden or disabled

        This property is `true` by default

        **Access functions:**

        bool **nameFilterDisables** () const
        void **setNameFilterDisables**
        (bool **enable** )
        """
        ...

    def setNameFilters(self, filters: Sequence[str]) -> None:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#setNameFilters

        **void QFileSystemModel::setNameFilters(const QStringList & filters )**

        Sets the name **filters** to apply against the existing files.

        **See also** **nameFilters** ().
        """
        ...

    def setOption(
        self, option: PySide6.QtWidgets.QFileSystemModel.Option, on: bool = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#setOption

        **[since 5.14] void QFileSystemModel::setOption(QFileSystemModel::Option
        option , bool on = true)**

        Sets the given **option** to be enabled if **on** is true; otherwise,
        clears the given **option**.

        Options should be set before changing properties.

        This function was introduced in Qt 5.14.

        **See also** **options**  and **testOption** ().
        """
        ...

    def setOptions(self, options: PySide6.QtWidgets.QFileSystemModel.Options) -> None:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#options-prop

        **[since 5.14] options : Options**

        This property holds the various options that affect the model

        By default, all options are disabled.

        Options should be set before changing properties.

        This property was introduced in Qt 5.14.

        **Access functions:**

        QFileSystemModel::Options **options** () const
        void **setOptions**
        (QFileSystemModel::Options **options** )

        **See also** **setOption** () and **testOption** ().
        """
        ...

    def setReadOnly(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#readOnly-prop

        **readOnly : bool**

        This property holds whether the directory model allows writing to the
        file system

        If this property is set to false, the directory model will allow
        renaming, copying and deleting of files and directories.

        This property is `true` by default

        **Access functions:**

        bool **isReadOnly** () const
        void **setReadOnly** (bool **enable** )
        """
        ...

    def setResolveSymlinks(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#resolveSymlinks-prop

        **resolveSymlinks : bool**

        This property holds whether the directory model should resolve symbolic
        links

        This is only relevant on Windows.

        By default, this property is `true`.

        **Access functions:**

        bool **resolveSymlinks** () const
        void **setResolveSymlinks** (bool
        **enable** )

        **See also** **QFileSystemModel::Options** .

        **Member Function Documentation**
        """
        ...

    def setRootPath(self, path: str) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#setRootPath

        **QModelIndex QFileSystemModel::setRootPath(const QString & newPath )**

        Sets the directory that is being watched by the model to **newPath** by
        installing a **file system watcher**  on it. Any changes to files and
        directories within this directory will be reflected in the model.

        If the path is changed, the **rootPathChanged** () signal will be
        emitted.

        **Note:** This function does not change the structure of the model or
        modify the data available to views. In other words, the "root" of the
        model is **not** changed to include only files and directories within
        the directory specified by **newPath** in the file system.

        **See also** **rootPath** ().
        """
        ...

    def sibling(
        self,
        row: int,
        column: int,
        idx: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#sibling

        **[override virtual] QModelIndex QFileSystemModel::sibling(int row , int
        column , const QModelIndex & idx ) const**

        Reimplements: **QAbstractItemModel::sibling(int row, int column, const
        QModelIndex &index) const** .
        """
        ...

    def size(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> int:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#size

        **qint64 QFileSystemModel::size(const QModelIndex & index ) const**

        Returns the size in bytes of **index**. If the file does not exist, 0 is
        returned.
        """
        ...

    def sort(self, column: int, order: PySide6.QtCore.Qt.SortOrder = ...) -> None:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#sort

        **[override virtual] void QFileSystemModel::sort(int column ,
        Qt::SortOrder order = Qt::AscendingOrder)**

        Reimplements: **QAbstractItemModel::sort** (int column, Qt::SortOrder
        order).
        """
        ...

    def supportedDropActions(self) -> PySide6.QtCore.Qt.DropActions:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#supportedDropActions

        **[override virtual] Qt::DropActions
        QFileSystemModel::supportedDropActions() const**

        Reimplements: **QAbstractItemModel::supportedDropActions() const** .
        """
        ...

    def testOption(self, option: PySide6.QtWidgets.QFileSystemModel.Option) -> bool:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#testOption

        **[since 5.14] bool
        QFileSystemModel::testOption(QFileSystemModel::Option option ) const**

        Returns `true` if the given **option** is enabled; otherwise, returns
        false.

        This function was introduced in Qt 5.14.

        **See also** **options**  and **setOption** ().
        """
        ...

    def timerEvent(self, event: PySide6.QtCore.QTimerEvent) -> None:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#timerEvent

        **[override virtual protected] void
        QFileSystemModel::timerEvent(QTimerEvent * event )**

        Reimplements: **QObject::timerEvent** (QTimerEvent *event).
        """
        ...

    def type(
        self,
        index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> str:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#type

        **QString QFileSystemModel::type(const QModelIndex & index ) const**

        Returns the type of file **index** such as "Directory" or "JPEG file".
        """
        ...

    @property
    def directoryLoaded(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#directoryLoaded

        **[signal] void QFileSystemModel::directoryLoaded(const QString & path
        )**

        This signal is emitted when the gatherer thread has finished to load the
        **path**.
        """
        ...

    @property
    def fileRenamed(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#fileRenamed

        **[signal] void QFileSystemModel::fileRenamed(const QString & path ,
        const QString & oldName , const QString & newName )**

        This signal is emitted whenever a file with the **oldName** is
        successfully renamed to **newName**. The file is located in in the
        directory **path**.
        """
        ...

    @property
    def rootPathChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qfilesystemmodel.html#rootPathChanged

        **[signal] void QFileSystemModel::rootPathChanged(const QString &
        newPath )**

        This signal is emitted whenever the root path has been changed to a
        **newPath**.
        """
        ...
