"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import List, Tuple
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QAccessibleWidget(
    PySide6.QtGui.QAccessibleObject, PySide6.QtGui.QAccessibleActionInterface
):
    """
    https://doc.qt.io/qt-6/qaccessiblewidget.html

    **Detailed Description**

    This class is part of **Accessibility for QWidget Applications** .

    This class is convenient to use as a base class for custom implementations
    of QAccessibleInterfaces that provide information about widget objects.

    The class provides functions to retrieve the **parentObject** () (the
    widget's parent widget), and the associated **widget** (). Controlling
    signals can be added with **addControllingSignal** (), and setters are
    provided for various aspects of the interface implementation, for example
    setValue(), setDescription(), setAccelerator(), and setHelp().

    **See also** **QAccessible**  and **QAccessibleObject** .
    """

    def __init__(
        self,
        o: PySide6.QtWidgets.QWidget,
        r: PySide6.QtGui.QAccessible.Role = ...,
        name: str = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qaccessiblewidget.html#QAccessibleWidget

        **QAccessibleWidget::QAccessibleWidget(QWidget * w , QAccessible::Role
        role = QAccessible::Client, const QString & name = QString())**

        Creates a QAccessibleWidget object for widget **w**. **role** and
        **name** are optional parameters that set the object's role and name
        properties.
        """
        ...

    def actionNames(self) -> List[str]:
        """
        https://doc.qt.io/qt-6/qaccessiblewidget.html#actionNames

        **[override virtual] QStringList QAccessibleWidget::actionNames()
        const**

        Reimplements: **QAccessibleActionInterface::actionNames() const** .
        """
        ...

    def addControllingSignal(self, signal: str) -> None:
        """
        https://doc.qt.io/qt-6/qaccessiblewidget.html#addControllingSignal

        **[protected] void QAccessibleWidget::addControllingSignal(const QString
        & signal )**

        Registers **signal** as a controlling signal.

        An object is a Controller to any other object connected to a controlling
        signal.
        """
        ...

    def backgroundColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qaccessiblewidget.html#backgroundColor

        **[override virtual] QColor QAccessibleWidget::backgroundColor() const**

        Reimplements: **QAccessibleInterface::backgroundColor() const** .
        """
        ...

    def child(self, index: int) -> PySide6.QtGui.QAccessibleInterface:
        """
        https://doc.qt.io/qt-6/qaccessiblewidget.html#child

        **[override virtual] QAccessibleInterface *QAccessibleWidget::child(int
        index ) const**

        Reimplements: **QAccessibleInterface::child(int index) const** .
        """
        ...

    def childCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qaccessiblewidget.html#childCount

        **[override virtual] int QAccessibleWidget::childCount() const**

        Reimplements: **QAccessibleInterface::childCount() const** .
        """
        ...

    def doAction(self, actionName: str) -> None:
        """
        https://doc.qt.io/qt-6/qaccessiblewidget.html#doAction

        **[override virtual] void QAccessibleWidget::doAction(const QString &
        actionName )**

        Reimplements: **QAccessibleActionInterface::doAction** (const QString
        &actionName).
        """
        ...

    def focusChild(self) -> PySide6.QtGui.QAccessibleInterface:
        """
        https://doc.qt.io/qt-6/qaccessiblewidget.html#focusChild

        **[override virtual] QAccessibleInterface
        *QAccessibleWidget::focusChild() const**

        Reimplements: **QAccessibleInterface::focusChild() const** .
        """
        ...

    def foregroundColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qaccessiblewidget.html#foregroundColor

        **[override virtual] QColor QAccessibleWidget::foregroundColor() const**

        Reimplements: **QAccessibleInterface::foregroundColor() const** .
        """
        ...

    def indexOfChild(self, child: PySide6.QtGui.QAccessibleInterface) -> int:
        """
        https://doc.qt.io/qt-6/qaccessiblewidget.html#indexOfChild

        **[override virtual] int QAccessibleWidget::indexOfChild(const
        QAccessibleInterface * child ) const**

        Reimplements: **QAccessibleInterface::indexOfChild(const
        QAccessibleInterface *child) const** .
        """
        ...

    def interface_cast(self, t: PySide6.QtGui.QAccessible.InterfaceType) -> int:
        """
        https://doc.qt.io/qt-6/qaccessiblewidget.html#interface_cast

        **[override virtual] void
        *QAccessibleWidget::interface_cast(QAccessible::InterfaceType t )**

        Reimplements: **QAccessibleInterface::interface_cast**
        (QAccessible::InterfaceType type).
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qaccessiblewidget.html#isValid

        **[override virtual] bool QAccessibleWidget::isValid() const**

        Reimplements: **QAccessibleObject::isValid() const** .
        """
        ...

    def keyBindingsForAction(self, actionName: str) -> List[str]:
        """
        https://doc.qt.io/qt-6/qaccessiblewidget.html#keyBindingsForAction

        **[override virtual] QStringList
        QAccessibleWidget::keyBindingsForAction(const QString & actionName )
        const**

        Reimplements: **QAccessibleActionInterface::keyBindingsForAction(const
        QString &actionName) const** .
        """
        ...

    def parent(self) -> PySide6.QtGui.QAccessibleInterface:
        """
        https://doc.qt.io/qt-6/qaccessiblewidget.html#parent

        **[override virtual] QAccessibleInterface *QAccessibleWidget::parent()
        const**

        Reimplements: **QAccessibleInterface::parent() const** .
        """
        ...

    def parentObject(self) -> PySide6.QtCore.QObject:
        """
        https://doc.qt.io/qt-6/qaccessiblewidget.html#parentObject

        **[protected] QObject *QAccessibleWidget::parentObject() const**

        Returns the associated widget's parent object, which is either the
        parent widget, or **qApp**  for top-level widgets.
        """
        ...

    def rect(self) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qaccessiblewidget.html#rect

        **[override virtual] QRect QAccessibleWidget::rect() const**

        Reimplements: **QAccessibleObject::rect() const** .
        """
        ...

    def relations(
        self, match: PySide6.QtGui.QAccessible.Relation = ...
    ) -> List[
        Tuple[PySide6.QtGui.QAccessibleInterface, PySide6.QtGui.QAccessible.Relation]
    ]:
        """
        https://doc.qt.io/qt-6/qaccessiblewidget.html#relations

        **[override virtual] QList<QPair<QAccessibleInterface *,
        QAccessible::Relation> >
        QAccessibleWidget::relations(QAccessible::Relation match =
        QAccessible::AllRelations) const**

        Reimplements: **QAccessibleInterface::relations(QAccessible::Relation
        match) const** .
        """
        ...

    def role(self) -> PySide6.QtGui.QAccessible.Role:
        """
        https://doc.qt.io/qt-6/qaccessiblewidget.html#role

        **[override virtual] QAccessible::Role QAccessibleWidget::role() const**

        Reimplements: **QAccessibleInterface::role() const** .
        """
        ...

    def state(self) -> PySide6.QtGui.QAccessible.State:
        """
        https://doc.qt.io/qt-6/qaccessiblewidget.html#state

        **[override virtual] QAccessible::State QAccessibleWidget::state()
        const**

        Reimplements: **QAccessibleInterface::state() const** .
        """
        ...

    def text(self, t: PySide6.QtGui.QAccessible.Text) -> str:
        """
        https://doc.qt.io/qt-6/qaccessiblewidget.html#text

        **[override virtual] QString QAccessibleWidget::text(QAccessible::Text t
        ) const**

        Reimplements: **QAccessibleInterface::text(QAccessible::Text t) const**
        .
        """
        ...

    def widget(self) -> PySide6.QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-6/qaccessiblewidget.html#widget

        **[protected] QWidget *QAccessibleWidget::widget() const**

        Returns the associated widget.
        """
        ...

    def window(self) -> PySide6.QtGui.QWindow:
        """
        https://doc.qt.io/qt-6/qaccessiblewidget.html#window

        **[override virtual] QWindow *QAccessibleWidget::window() const**

        Reimplements: **QAccessibleInterface::window() const** .
        """
        ...
