"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""
from typing import Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets

bytes = str


class QAbstractButton(PySide6.QtWidgets.QWidget):
    """
    https://doc.qt.io/qt-6/qabstractbutton.html

    **Detailed Description**

    This class implements an **abstract** button. Subclasses of this class
    handle user actions, and specify how the button is drawn.

    QAbstractButton provides support for both push buttons and checkable
    (toggle) buttons. Checkable buttons are implemented in the **QRadioButton**
    and **QCheckBox**  classes. Push buttons are implemented in the
    **QPushButton**  and **QToolButton**  classes; these also provide toggle
    behavior if required.

    Any button can display a label containing text and an icon. **setText** ()
    sets the text; **setIcon** () sets the icon. If a button is disabled, its
    label is changed to give the button a "disabled" appearance.

    If the button is a text button with a string containing an ampersand ('&'),
    QAbstractButton automatically creates a shortcut key. For example:

    **QPushButton**  *button = new **QPushButton** (tr("Ro&ck && Roll"), this);

    The **Alt+C** shortcut is assigned to the button, i.e., when the user
    presses **Alt+C** the button will call **animateClick** (). See the
    **QShortcut**  documentation for details. To display an actual ampersand,
    use '&&'.

    You can also set a custom shortcut key using the **setShortcut** ()
    function. This is useful mostly for buttons that do not have any text, and
    therefore can't have any automatic shortcut.

    button->setIcon(**QIcon** (":/images/print.png"));
    button->setShortcut(tr("Alt+F7"));

    All the buttons provided by Qt (**QPushButton** , **QToolButton** ,
    **QCheckBox** , and **QRadioButton** ) can display both **text**  and
    **icons** .

    A button can be made the default button in a dialog by means of
    **QPushButton::setDefault** () and **QPushButton::setAutoDefault** ().

    QAbstractButton provides most of the states used for buttons:

    * **isDown** () indicates whether the button is **pressed** down.
      *
    **isChecked** () indicates whether the button is **checked**. Only checkable
    buttons can be checked and unchecked (see below).
      * **isEnabled** ()
    indicates whether the button can be pressed by the user.

    **Note:** As
    opposed to other widgets, buttons derived from QAbstractButton accept mouse
    and context menu events when disabled.

      * **setAutoRepeat** () sets
    whether the button will auto-repeat if the user holds it down.
    **autoRepeatDelay**  and **autoRepeatInterval**  define how auto-repetition
    is done.
      * **setCheckable** () sets whether the button is a toggle button
    or not.

    The difference between **isDown** () and **isChecked** () is as follows.
    When the user clicks a toggle button to check it, the button is first
    **pressed** then released into the **checked** state. When the user clicks
    it again (to uncheck it), the button moves first to the **pressed** state,
    then to the **unchecked** state (**isChecked** () and **isDown** () are both
    false).

    QAbstractButton provides four signals:

    1. **pressed** () is emitted when the left mouse button is pressed while the
    mouse cursor is inside the button.
      2. **released** () is emitted when the
    left mouse button is released.
      3. **clicked** () is emitted when the
    button is first pressed and then released, when the shortcut key is typed,
    or when **click** () or **animateClick** () is called.
      4. **toggled** ()
    is emitted when the state of a toggle button changes.

    To subclass QAbstractButton, you must reimplement at least **paintEvent** ()
    to draw the button's outline and its text or pixmap. It is generally
    advisable to reimplement **sizeHint** () as well, and sometimes
    **hitButton** () (to determine whether a button press is within the button).
    For buttons with more than two states (like tri-state buttons), you will
    also have to reimplement **checkStateSet** () and **nextCheckState** ().

    **See also** **QButtonGroup** .
    """

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#QAbstractButton

        **QAbstractButton::QAbstractButton(QWidget * parent = nullptr)**

        Constructs an abstract button with a **parent**.
        """
        ...

    def animateClick(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#animateClick

        **[slot] void QAbstractButton::animateClick()**

        Performs an animated click: the button is pressed immediately, and
        released 100ms later.

        Calling this function again before the button is released resets the
        release timer.

        All signals associated with a click are emitted as appropriate.

        This function does nothing if the button is **disabled.**

        **See also** **click** ().
        """
        ...

    def autoExclusive(self) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#autoExclusive-prop

        **autoExclusive : bool**

        This property holds whether auto-exclusivity is enabled

        If auto-exclusivity is enabled, checkable buttons that belong to the
        same parent widget behave as if they were part of the same exclusive
        button group. In an exclusive button group, only one button can be
        checked at any time; checking another button automatically unchecks the
        previously checked one.

        The property has no effect on buttons that belong to a button group.

        autoExclusive is off by default, except for radio buttons.

        **Access functions:**

        bool **autoExclusive** () const
        void **setAutoExclusive** (bool)

        **See also** **QRadioButton** .
        """
        ...

    def autoRepeat(self) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#autoRepeat-prop

        **autoRepeat : bool**

        This property holds whether autoRepeat is enabled

        If autoRepeat is enabled, then the **pressed** (), **released** (), and
        **clicked** () signals are emitted at regular intervals when the button
        is down. autoRepeat is off by default. The initial delay and the
        repetition interval are defined in milliseconds by **autoRepeatDelay**
        and **autoRepeatInterval** .

        Note: If a button is pressed down by a shortcut key, then auto-repeat is
        enabled and timed by the system and not by this class. The **pressed**
        (), **released** (), and **clicked** () signals will be emitted like in
        the normal case.

        **Access functions:**

        bool **autoRepeat** () const
        void **setAutoRepeat** (bool)
        """
        ...

    def autoRepeatDelay(self) -> int:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#autoRepeatDelay-prop

        **autoRepeatDelay : int**

        This property holds the initial delay of auto-repetition

        If **autoRepeat**  is enabled, then autoRepeatDelay defines the initial
        delay in milliseconds before auto-repetition kicks in.

        **Access functions:**

        int **autoRepeatDelay** () const
        void **setAutoRepeatDelay** (int)

        **See also** **autoRepeat**  and **autoRepeatInterval** .
        """
        ...

    def autoRepeatInterval(self) -> int:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#autoRepeatInterval-prop

        **autoRepeatInterval : int**

        This property holds the interval of auto-repetition

        If **autoRepeat**  is enabled, then autoRepeatInterval defines the
        length of the auto-repetition interval in millisecons.

        **Access functions:**

        int **autoRepeatInterval** () const
        void **setAutoRepeatInterval**
        (int)

        **See also** **autoRepeat**  and **autoRepeatDelay** .
        """
        ...

    def changeEvent(self, e: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#changeEvent

        **[override virtual protected] void QAbstractButton::changeEvent(QEvent
        * e )**

        Reimplements: **QWidget::changeEvent** (QEvent *event).
        """
        ...

    def checkStateSet(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#checkStateSet

        **[virtual protected] void QAbstractButton::checkStateSet()**

        This virtual handler is called when **setChecked** () is used, unless it
        is called from within **nextCheckState** (). It allows subclasses to
        reset their intermediate button states.

        **See also** **nextCheckState** ().
        """
        ...

    def click(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#click

        **[slot] void QAbstractButton::click()**

        Performs a click.

        All the usual signals associated with a click are emitted as
        appropriate. If the button is checkable, the state of the button is
        toggled.

        This function does nothing if the button is **disabled.**

        **See also** **animateClick** ().
        """
        ...

    def event(self, e: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#event

        **[override virtual protected] bool QAbstractButton::event(QEvent * e
        )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    def focusInEvent(self, e: PySide6.QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#focusInEvent

        **[override virtual protected] void
        QAbstractButton::focusInEvent(QFocusEvent * e )**

        Reimplements: **QWidget::focusInEvent** (QFocusEvent *event).
        """
        ...

    def focusOutEvent(self, e: PySide6.QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#focusOutEvent

        **[override virtual protected] void
        QAbstractButton::focusOutEvent(QFocusEvent * e )**

        Reimplements: **QWidget::focusOutEvent** (QFocusEvent *event).
        """
        ...

    def group(self) -> PySide6.QtWidgets.QButtonGroup:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#group

        **QButtonGroup *QAbstractButton::group() const**

        Returns the group that this button belongs to.

        If the button is not a member of any **QButtonGroup** , this function
        returns `nullptr`.

        **See also** **QButtonGroup** .
        """
        ...

    def hitButton(self, pos: PySide6.QtCore.QPoint) -> bool:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#hitButton

        **[virtual protected] bool QAbstractButton::hitButton(const QPoint & pos
        ) const**

        Returns `true` if **pos** is inside the clickable button rectangle;
        otherwise returns `false`.

        By default, the clickable area is the entire widget. Subclasses may
        reimplement this function to provide support for clickable areas of
        different shapes and sizes.
        """
        ...

    def icon(self) -> PySide6.QtGui.QIcon:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#icon-prop

        **icon : QIcon**

        This property holds the icon shown on the button

        The icon's default size is defined by the GUI style, but can be adjusted
        by setting the **iconSize**  property.

        **Access functions:**

        QIcon **icon** () const
        void **setIcon** (const QIcon & **icon** )
        """
        ...

    def iconSize(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#iconSize-prop

        **iconSize : QSize**

        This property holds the icon size used for this button.

        The default size is defined by the GUI style. This is a maximum size for
        the icons. Smaller icons will not be scaled up.

        **Access functions:**

        QSize **iconSize** () const
        void **setIconSize** (const QSize &
        **size** )
        """
        ...

    def isCheckable(self) -> bool:
        ...

    def isChecked(self) -> bool:
        ...

    def isDown(self) -> bool:
        ...

    def keyPressEvent(self, e: PySide6.QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#keyPressEvent

        **[override virtual protected] void
        QAbstractButton::keyPressEvent(QKeyEvent * e )**

        Reimplements: **QWidget::keyPressEvent** (QKeyEvent *event).
        """
        ...

    def keyReleaseEvent(self, e: PySide6.QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#keyReleaseEvent

        **[override virtual protected] void
        QAbstractButton::keyReleaseEvent(QKeyEvent * e )**

        Reimplements: **QWidget::keyReleaseEvent** (QKeyEvent *event).
        """
        ...

    def mouseMoveEvent(self, e: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#mouseMoveEvent

        **[override virtual protected] void
        QAbstractButton::mouseMoveEvent(QMouseEvent * e )**

        Reimplements: **QWidget::mouseMoveEvent** (QMouseEvent *event).
        """
        ...

    def mousePressEvent(self, e: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#mousePressEvent

        **[override virtual protected] void
        QAbstractButton::mousePressEvent(QMouseEvent * e )**

        Reimplements: **QWidget::mousePressEvent** (QMouseEvent *event).
        """
        ...

    def mouseReleaseEvent(self, e: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#mouseReleaseEvent

        **[override virtual protected] void
        QAbstractButton::mouseReleaseEvent(QMouseEvent * e )**

        Reimplements: **QWidget::mouseReleaseEvent** (QMouseEvent *event).
        """
        ...

    def nextCheckState(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#nextCheckState

        **[virtual protected] void QAbstractButton::nextCheckState()**

        This virtual handler is called when a button is clicked. The default
        implementation calls **setChecked** (!**isChecked** ()) if the button
        **isCheckable** (). It allows subclasses to implement intermediate
        button states.

        **See also** **checkStateSet** ().
        """
        ...

    def paintEvent(self, e: PySide6.QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#paintEvent

        **[override pure virtual protected] void
        QAbstractButton::paintEvent(QPaintEvent * e )**

        Reimplements: **QWidget::paintEvent** (QPaintEvent *event).
        """
        ...

    def setAutoExclusive(self, arg__1: bool) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#autoExclusive-prop

        **autoExclusive : bool**

        This property holds whether auto-exclusivity is enabled

        If auto-exclusivity is enabled, checkable buttons that belong to the
        same parent widget behave as if they were part of the same exclusive
        button group. In an exclusive button group, only one button can be
        checked at any time; checking another button automatically unchecks the
        previously checked one.

        The property has no effect on buttons that belong to a button group.

        autoExclusive is off by default, except for radio buttons.

        **Access functions:**

        bool **autoExclusive** () const
        void **setAutoExclusive** (bool)

        **See also** **QRadioButton** .
        """
        ...

    def setAutoRepeat(self, arg__1: bool) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#autoRepeat-prop

        **autoRepeat : bool**

        This property holds whether autoRepeat is enabled

        If autoRepeat is enabled, then the **pressed** (), **released** (), and
        **clicked** () signals are emitted at regular intervals when the button
        is down. autoRepeat is off by default. The initial delay and the
        repetition interval are defined in milliseconds by **autoRepeatDelay**
        and **autoRepeatInterval** .

        Note: If a button is pressed down by a shortcut key, then auto-repeat is
        enabled and timed by the system and not by this class. The **pressed**
        (), **released** (), and **clicked** () signals will be emitted like in
        the normal case.

        **Access functions:**

        bool **autoRepeat** () const
        void **setAutoRepeat** (bool)
        """
        ...

    def setAutoRepeatDelay(self, arg__1: int) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#autoRepeatDelay-prop

        **autoRepeatDelay : int**

        This property holds the initial delay of auto-repetition

        If **autoRepeat**  is enabled, then autoRepeatDelay defines the initial
        delay in milliseconds before auto-repetition kicks in.

        **Access functions:**

        int **autoRepeatDelay** () const
        void **setAutoRepeatDelay** (int)

        **See also** **autoRepeat**  and **autoRepeatInterval** .
        """
        ...

    def setAutoRepeatInterval(self, arg__1: int) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#autoRepeatInterval-prop

        **autoRepeatInterval : int**

        This property holds the interval of auto-repetition

        If **autoRepeat**  is enabled, then autoRepeatInterval defines the
        length of the auto-repetition interval in millisecons.

        **Access functions:**

        int **autoRepeatInterval** () const
        void **setAutoRepeatInterval**
        (int)

        **See also** **autoRepeat**  and **autoRepeatDelay** .
        """
        ...

    def setCheckable(self, arg__1: bool) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#checkable-prop

        **checkable : bool**

        This property holds whether the button is checkable

        By default, the button is not checkable.

        **Access functions:**

        bool **isCheckable** () const
        void **setCheckable** (bool)

        **See also** **checked** .
        """
        ...

    def setChecked(self, arg__1: bool) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#checked-prop

        **checked : bool**

        This property holds whether the button is checked

        Only checkable buttons can be checked. By default, the button is
        unchecked.

        **Access functions:**

        bool **isChecked** () const
        void **setChecked** (bool)

        **Notifier signal:**

        void ****toggled** ** (bool **checked** )

        **See also** **checkable** .
        """
        ...

    def setDown(self, arg__1: bool) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#down-prop

        **down : bool**

        This property holds whether the button is pressed down

        If this property is `true`, the button is pressed down. The signals
        **pressed** () and **clicked** () are not emitted if you set this
        property to true. The default is false.

        **Access functions:**

        bool **isDown** () const
        void **setDown** (bool)
        """
        ...

    def setIcon(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap]) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#icon-prop

        **icon : QIcon**

        This property holds the icon shown on the button

        The icon's default size is defined by the GUI style, but can be adjusted
        by setting the **iconSize**  property.

        **Access functions:**

        QIcon **icon** () const
        void **setIcon** (const QIcon & **icon** )
        """
        ...

    def setIconSize(self, size: PySide6.QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#iconSize-prop

        **iconSize : QSize**

        This property holds the icon size used for this button.

        The default size is defined by the GUI style. This is a maximum size for
        the icons. Smaller icons will not be scaled up.

        **Access functions:**

        QSize **iconSize** () const
        void **setIconSize** (const QSize &
        **size** )
        """
        ...

    @overload
    def setShortcut(self, arg__1: PySide6.QtCore.Qt.Key) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#shortcut-prop

        **shortcut : QKeySequence**

        This property holds the mnemonic associated with the button

        **Access functions:**

        QKeySequence **shortcut** () const
        void **setShortcut** (const
        QKeySequence & **key** )
        """
        ...

    @overload
    def setShortcut(
        self,
        key: Union[
            PySide6.QtGui.QKeySequence,
            PySide6.QtCore.QKeyCombination,
            PySide6.QtGui.QKeySequence.StandardKey,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#shortcut-prop

        **shortcut : QKeySequence**

        This property holds the mnemonic associated with the button

        **Access functions:**

        QKeySequence **shortcut** () const
        void **setShortcut** (const
        QKeySequence & **key** )
        """
        ...

    def setText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#text-prop

        **text : QString**

        This property holds the text shown on the button

        If the button has no text, the text() function will return an empty
        string.

        If the text contains an ampersand character ('&'), a shortcut is
        automatically created for it. The character that follows the '&' will be
        used as the shortcut key. Any previous shortcut will be overwritten or
        cleared if no shortcut is defined by the text. See the **QShortcut**
        documentation for details. To display an actual ampersand, use '&&'.

        There is no default text.

        **Access functions:**

        QString **text** () const
        void **setText** (const QString & **text** )

        **Member Function Documentation**
        """
        ...

    def shortcut(self) -> PySide6.QtGui.QKeySequence:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#shortcut-prop

        **shortcut : QKeySequence**

        This property holds the mnemonic associated with the button

        **Access functions:**

        QKeySequence **shortcut** () const
        void **setShortcut** (const
        QKeySequence & **key** )
        """
        ...

    def text(self) -> str:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#text-prop

        **text : QString**

        This property holds the text shown on the button

        If the button has no text, the text() function will return an empty
        string.

        If the text contains an ampersand character ('&'), a shortcut is
        automatically created for it. The character that follows the '&' will be
        used as the shortcut key. Any previous shortcut will be overwritten or
        cleared if no shortcut is defined by the text. See the **QShortcut**
        documentation for details. To display an actual ampersand, use '&&'.

        There is no default text.

        **Access functions:**

        QString **text** () const
        void **setText** (const QString & **text** )

        **Member Function Documentation**
        """
        ...

    def timerEvent(self, e: PySide6.QtCore.QTimerEvent) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#timerEvent

        **[override virtual protected] void
        QAbstractButton::timerEvent(QTimerEvent * e )**

        Reimplements: **QObject::timerEvent** (QTimerEvent *event).
        """
        ...

    def toggle(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#toggle

        **[slot] void QAbstractButton::toggle()**

        Toggles the state of a checkable button.

        **See also** **checked** .
        """
        ...

    @property
    def clicked(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#clicked

        **[signal] void QAbstractButton::clicked(bool checked = false)**

        This signal is emitted when the button is activated (i.e., pressed down
        then released while the mouse cursor is inside the button), when the
        shortcut key is typed, or when **click** () or **animateClick** () is
        called. Notably, this signal is **not** emitted if you call **setDown**
        (), **setChecked** () or **toggle** ().

        If the button is checkable, **checked** is true if the button is
        checked, or false if the button is unchecked.

        **See also** **pressed** (), **released** (), and **toggled** ().
        """
        ...

    @property
    def pressed(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#pressed

        **[signal] void QAbstractButton::pressed()**

        This signal is emitted when the button is pressed down.

        **See also** **released** () and **clicked** ().
        """
        ...

    @property
    def released(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#released

        **[signal] void QAbstractButton::released()**

        This signal is emitted when the button is released.

        **See also** **pressed** (), **clicked** (), and **toggled** ().
        """
        ...

    @property
    def toggled(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qabstractbutton.html#toggled

        **[signal] void QAbstractButton::toggled(bool checked )**

        This signal is emitted whenever a checkable button changes its state.
        **checked** is true if the button is checked, or false if the button is
        unchecked.

        This may be the result of a user action, **click** () slot activation,
        or because **setChecked** () is called.

        The states of buttons in exclusive button groups are updated before this
        signal is emitted. This means that slots can act on either the "off"
        signal or the "on" signal emitted by the buttons in the group whose
        states have changed.

        For example, a slot that reacts to signals emitted by newly checked
        buttons but which ignores signals from buttons that have been unchecked
        can be implemented using the following pattern:

        void MyWidget::reactToToggle(bool checked)
            {
               if (checked) {
        // Examine the new button states.
                  ...
               }
            }

        Button groups can be created using the **QButtonGroup**  class, and
        updates to the button states monitored with the
        **QButtonGroup::buttonClicked** () signal.

        **Note:** Notifier signal for property **checked** .

        **See also** **checked**  and **clicked** ().
        """
        ...
