"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWebEngineCore, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtNetwork
import PySide6.QtWebChannel
import PySide6.QtWebEngineCore

bytes = str


class QWebEngineUrlSchemeHandler(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qwebengineurlschemehandler.html

    **Detailed Description**

    To implement a custom URL scheme for **QtWebEngine** , you first have to
    create an instance of **QWebEngineUrlScheme**  and register it using
    **QWebEngineUrlScheme::registerScheme** ().

    **Note:** Make sure that you create and register the scheme object
    **before** the **QGuiApplication**  or **QApplication**  object is
    instantiated.

    Then you must create a class derived from QWebEngineUrlSchemeHandler, and
    reimplement the **requestStarted** () method.

    Finally, install the scheme handler object via
    **QWebEngineProfile::installUrlSchemeHandler** () or
    **QQuickWebEngineProfile::installUrlSchemeHandler** ().

    class MySchemeHandler : public **QWebEngineUrlSchemeHandler**
        {
    public:
            MySchemeHandler(**QObject**  *parent = nullptr);
    void requestStarted(**QWebEngineUrlRequestJob**  *request)
            {
    // ....
            }
        };

        int main(int argc, char **argv)
        {
    **QWebEngineUrlScheme**  scheme("myscheme");
    scheme.setSyntax(**QWebEngineUrlScheme** ::Syntax::HostAndPort);
    scheme.setDefaultPort(2345);
            scheme.setFlags(**QWebEngineUrlScheme**
    ::SecureScheme);
            **QWebEngineUrlScheme** ::registerScheme(scheme);
    // ...
            **QApplication**  app(argc, argv);
            // ...
    // installUrlSchemeHandler does not take ownership of the handler.
    MySchemeHandler *handler = new MySchemeHandler(parent);
    **QWebEngineProfile**
    ::defaultProfile()->installUrlSchemeHandler("myscheme", handler);
        }

    **See also** **QWebEngineUrlScheme**  and **WebEngine Widgets WebUI
    Example** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineurlschemehandler.html#QWebEngineUrlSche
        meHandler

        **QWebEngineUrlSchemeHandler::QWebEngineUrlSchemeHandler(QObject *
        parent = nullptr)**

        Constructs a new URL scheme handler.

        The handler is created with the parent **parent**.
        """
        ...

    def requestStarted(
        self, arg__1: PySide6.QtWebEngineCore.QWebEngineUrlRequestJob
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebengineurlschemehandler.html#requestStarted

        **[pure virtual] void
        QWebEngineUrlSchemeHandler::requestStarted(QWebEngineUrlRequestJob *
        request )**

        This method is called whenever a request **request** for the registered
        scheme is started.

        This method must be reimplemented by all custom URL scheme handlers. The
        request is asynchronous and does not need to be handled right away.

        **See also** **QWebEngineUrlRequestJob** .
        """
        ...
