"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWebEngineCore, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, List, Optional, Sequence, Tuple, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtNetwork
import PySide6.QtWebChannel
import PySide6.QtWebEngineCore

bytes = str


class QWebEnginePage(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qwebenginepage.html

    **Detailed Description**

    A **web engine page** holds the contents of an HTML document, the history of
    navigated links, and actions.

    QWebEnginePage's API is very similar to **QWebEngineView** , as you are
    still provided with common functions like **action** () (known as
    **pageAction** () in **QWebEngineView** ), **triggerAction** (), and
    **findText** ().

    A page can be loaded using **load** () or **setUrl** (). Alternatively, if
    you have the HTML content readily available, you can use **setHtml** (). The
    GET method is always used to load URLs.

    The QWebEnginePage class also offers methods to retrieve both the URL
    currently loaded by the page (see **url** ()) as well as the URL originally
    requested to be loaded (see **requestedUrl** ()). These methods make
    possible the retrieval of the URL before and after a DNS resolution or a
    redirection occurs during the load process. The **requestedUrl** () also
    matches to the URL added to the page history (**QWebEngineHistory** ) if
    load is successful.

    The title of an HTML page can be accessed with the **title** () property.
    Additionally, a page may also specify an icon, which can be accessed using
    the **icon** () or its URL using the **iconUrl** () property. If the title
    or the icon changes, the corresponding **titleChanged** (), **iconChanged**
    () and **iconUrlChanged** () signals will be emitted. The **zoomFactor** ()
    property enables zooming the contents of the web page by a scale factor.

    The **loadStarted** () signal is emitted when the page begins to load,
    whereas the **loadProgress** () signal is emitted whenever an element of the
    web page completes loading, such as an embedded image or a script. The
    **loadFinished** () signal is emitted when the page contents have been
    loaded completely, independent of script execution or page rendering. Its
    argument, either `true` or `false`, indicates whether or not the load
    operation succeeded.

    An HTML document is loaded in a **main frame** within the web page. If it
    references **child frames** (as defined by the `<frame>` or `<iframe>`
    elements), they are considered part of the content. Child frames are
    individually accessible only through JavaScript.

    Web sites define **security origin** for safely accessing each other's
    resources for client-side scripting or databases. An origin consist of a
    host name, a scheme, and a port number. For example, the sites
    `http://www.example.com/my/page.html` and
    `http://www.example.com/my/overview.html` are allowed to share the same
    database or access each other's documents when used in HTML frame sets and
    JavaScript. At the same time, `http://www.malicious.com/evil.html` is
    prevented from accessing the resources of `http://www.example.com/`, because
    they are of a different security origin. By default, local schemes like
    `file://` and `qrc://` are considered to be in the same security origin, and
    can access each other's resources. Local resources are by default restricted
    from accessing remote content, which means that `file://` will not be able
    to access `http://domain.com/foo.html`.

    Scripts can be executed on the web page by using **runJavaScript** (),
    either in the main JavaScript **world** , along with the rest of the
    JavaScript coming from the web contents, or in their own isolated world.
    While the DOM of the page can be accessed from any world, JavaScript
    variables of a function defined in one world are not accessible from a
    different one. **QWebEngineScript::ScriptWorldId**  provides some predefined
    IDs for this purpose. Using the `runJavaScript()` version without the world
    ID is the same as running the script in the `MainWorld`.

    The **FocusOnNavigationEnabled**  setting can be used to make the view
    associated with the page automatically receive focus when a navigation
    operation occurs (like loading or reloading a page or navigating through
    history).
    """

    Notifications: QWebEnginePage.Feature = ...
    Geolocation: QWebEnginePage.Feature = ...
    MediaAudioCapture: QWebEnginePage.Feature = ...
    MediaVideoCapture: QWebEnginePage.Feature = ...
    MediaAudioVideoCapture: QWebEnginePage.Feature = ...
    MouseLock: QWebEnginePage.Feature = ...
    DesktopVideoCapture: QWebEnginePage.Feature = ...
    DesktopAudioVideoCapture: QWebEnginePage.Feature = ...
    FileSelectOpen: QWebEnginePage.FileSelectionMode = ...
    FileSelectOpenMultiple: QWebEnginePage.FileSelectionMode = ...
    FileSelectUploadFolder: QWebEnginePage.FileSelectionMode = ...
    FindBackward: QWebEnginePage.FindFlag = ...
    FindCaseSensitively: QWebEnginePage.FindFlag = ...
    InfoMessageLevel: QWebEnginePage.JavaScriptConsoleMessageLevel = ...
    WarningMessageLevel: QWebEnginePage.JavaScriptConsoleMessageLevel = ...
    ErrorMessageLevel: QWebEnginePage.JavaScriptConsoleMessageLevel = ...
    NavigationTypeLinkClicked: QWebEnginePage.NavigationType = ...
    NavigationTypeTyped: QWebEnginePage.NavigationType = ...
    NavigationTypeFormSubmitted: QWebEnginePage.NavigationType = ...
    NavigationTypeBackForward: QWebEnginePage.NavigationType = ...
    NavigationTypeReload: QWebEnginePage.NavigationType = ...
    NavigationTypeOther: QWebEnginePage.NavigationType = ...
    NavigationTypeRedirect: QWebEnginePage.NavigationType = ...
    PermissionUnknown: QWebEnginePage.PermissionPolicy = ...
    PermissionGrantedByUser: QWebEnginePage.PermissionPolicy = ...
    PermissionDeniedByUser: QWebEnginePage.PermissionPolicy = ...
    NormalTerminationStatus: QWebEnginePage.RenderProcessTerminationStatus = ...
    AbnormalTerminationStatus: QWebEnginePage.RenderProcessTerminationStatus = ...
    CrashedTerminationStatus: QWebEnginePage.RenderProcessTerminationStatus = ...
    KilledTerminationStatus: QWebEnginePage.RenderProcessTerminationStatus = ...
    NoWebAction: QWebEnginePage.WebAction = ...
    Back: QWebEnginePage.WebAction = ...
    Forward: QWebEnginePage.WebAction = ...
    Stop: QWebEnginePage.WebAction = ...
    Reload: QWebEnginePage.WebAction = ...
    Cut: QWebEnginePage.WebAction = ...
    Copy: QWebEnginePage.WebAction = ...
    Paste: QWebEnginePage.WebAction = ...
    Undo: QWebEnginePage.WebAction = ...
    Redo: QWebEnginePage.WebAction = ...
    SelectAll: QWebEnginePage.WebAction = ...
    ReloadAndBypassCache: QWebEnginePage.WebAction = ...
    PasteAndMatchStyle: QWebEnginePage.WebAction = ...
    OpenLinkInThisWindow: QWebEnginePage.WebAction = ...
    OpenLinkInNewWindow: QWebEnginePage.WebAction = ...
    OpenLinkInNewTab: QWebEnginePage.WebAction = ...
    CopyLinkToClipboard: QWebEnginePage.WebAction = ...
    DownloadLinkToDisk: QWebEnginePage.WebAction = ...
    CopyImageToClipboard: QWebEnginePage.WebAction = ...
    CopyImageUrlToClipboard: QWebEnginePage.WebAction = ...
    DownloadImageToDisk: QWebEnginePage.WebAction = ...
    CopyMediaUrlToClipboard: QWebEnginePage.WebAction = ...
    ToggleMediaControls: QWebEnginePage.WebAction = ...
    ToggleMediaLoop: QWebEnginePage.WebAction = ...
    ToggleMediaPlayPause: QWebEnginePage.WebAction = ...
    ToggleMediaMute: QWebEnginePage.WebAction = ...
    DownloadMediaToDisk: QWebEnginePage.WebAction = ...
    InspectElement: QWebEnginePage.WebAction = ...
    ExitFullScreen: QWebEnginePage.WebAction = ...
    RequestClose: QWebEnginePage.WebAction = ...
    Unselect: QWebEnginePage.WebAction = ...
    SavePage: QWebEnginePage.WebAction = ...
    OpenLinkInNewBackgroundTab: QWebEnginePage.WebAction = ...
    ViewSource: QWebEnginePage.WebAction = ...
    ToggleBold: QWebEnginePage.WebAction = ...
    ToggleItalic: QWebEnginePage.WebAction = ...
    ToggleUnderline: QWebEnginePage.WebAction = ...
    ToggleStrikethrough: QWebEnginePage.WebAction = ...
    AlignLeft: QWebEnginePage.WebAction = ...
    AlignCenter: QWebEnginePage.WebAction = ...
    AlignRight: QWebEnginePage.WebAction = ...
    AlignJustified: QWebEnginePage.WebAction = ...
    Indent: QWebEnginePage.WebAction = ...
    Outdent: QWebEnginePage.WebAction = ...
    InsertOrderedList: QWebEnginePage.WebAction = ...
    InsertUnorderedList: QWebEnginePage.WebAction = ...
    WebActionCount: QWebEnginePage.WebAction = ...
    WebBrowserWindow: QWebEnginePage.WebWindowType = ...
    WebBrowserTab: QWebEnginePage.WebWindowType = ...
    WebDialog: QWebEnginePage.WebWindowType = ...
    WebBrowserBackgroundTab: QWebEnginePage.WebWindowType = ...

    class Feature(Enum):
        Notifications: QWebEnginePage.Feature = ...
        Geolocation: QWebEnginePage.Feature = ...
        MediaAudioCapture: QWebEnginePage.Feature = ...
        MediaVideoCapture: QWebEnginePage.Feature = ...
        MediaAudioVideoCapture: QWebEnginePage.Feature = ...
        MouseLock: QWebEnginePage.Feature = ...
        DesktopVideoCapture: QWebEnginePage.Feature = ...
        DesktopAudioVideoCapture: QWebEnginePage.Feature = ...

    class FileSelectionMode(Enum):
        FileSelectOpen: QWebEnginePage.FileSelectionMode = ...
        FileSelectOpenMultiple: QWebEnginePage.FileSelectionMode = ...
        FileSelectUploadFolder: QWebEnginePage.FileSelectionMode = ...

    class FindFlag(Enum):
        FindBackward: QWebEnginePage.FindFlag = ...
        FindCaseSensitively: QWebEnginePage.FindFlag = ...

    class FindFlags(object):
        ...

    class JavaScriptConsoleMessageLevel(Enum):
        InfoMessageLevel: QWebEnginePage.JavaScriptConsoleMessageLevel = ...
        WarningMessageLevel: QWebEnginePage.JavaScriptConsoleMessageLevel = ...
        ErrorMessageLevel: QWebEnginePage.JavaScriptConsoleMessageLevel = ...

    class LifecycleState(Enum):
        Active: QWebEnginePage.LifecycleState = ...
        Frozen: QWebEnginePage.LifecycleState = ...
        Discarded: QWebEnginePage.LifecycleState = ...

    class NavigationType(Enum):
        NavigationTypeLinkClicked: QWebEnginePage.NavigationType = ...
        NavigationTypeTyped: QWebEnginePage.NavigationType = ...
        NavigationTypeFormSubmitted: QWebEnginePage.NavigationType = ...
        NavigationTypeBackForward: QWebEnginePage.NavigationType = ...
        NavigationTypeReload: QWebEnginePage.NavigationType = ...
        NavigationTypeOther: QWebEnginePage.NavigationType = ...
        NavigationTypeRedirect: QWebEnginePage.NavigationType = ...

    class PermissionPolicy(Enum):
        PermissionUnknown: QWebEnginePage.PermissionPolicy = ...
        PermissionGrantedByUser: QWebEnginePage.PermissionPolicy = ...
        PermissionDeniedByUser: QWebEnginePage.PermissionPolicy = ...

    class RenderProcessTerminationStatus(Enum):
        NormalTerminationStatus: QWebEnginePage.RenderProcessTerminationStatus = ...
        AbnormalTerminationStatus: QWebEnginePage.RenderProcessTerminationStatus = ...
        CrashedTerminationStatus: QWebEnginePage.RenderProcessTerminationStatus = ...
        KilledTerminationStatus: QWebEnginePage.RenderProcessTerminationStatus = ...

    class WebAction(Enum):
        NoWebAction: QWebEnginePage.WebAction = ...
        Back: QWebEnginePage.WebAction = ...
        Forward: QWebEnginePage.WebAction = ...
        Stop: QWebEnginePage.WebAction = ...
        Reload: QWebEnginePage.WebAction = ...
        Cut: QWebEnginePage.WebAction = ...
        Copy: QWebEnginePage.WebAction = ...
        Paste: QWebEnginePage.WebAction = ...
        Undo: QWebEnginePage.WebAction = ...
        Redo: QWebEnginePage.WebAction = ...
        SelectAll: QWebEnginePage.WebAction = ...
        ReloadAndBypassCache: QWebEnginePage.WebAction = ...
        PasteAndMatchStyle: QWebEnginePage.WebAction = ...
        OpenLinkInThisWindow: QWebEnginePage.WebAction = ...
        OpenLinkInNewWindow: QWebEnginePage.WebAction = ...
        OpenLinkInNewTab: QWebEnginePage.WebAction = ...
        CopyLinkToClipboard: QWebEnginePage.WebAction = ...
        DownloadLinkToDisk: QWebEnginePage.WebAction = ...
        CopyImageToClipboard: QWebEnginePage.WebAction = ...
        CopyImageUrlToClipboard: QWebEnginePage.WebAction = ...
        DownloadImageToDisk: QWebEnginePage.WebAction = ...
        CopyMediaUrlToClipboard: QWebEnginePage.WebAction = ...
        ToggleMediaControls: QWebEnginePage.WebAction = ...
        ToggleMediaLoop: QWebEnginePage.WebAction = ...
        ToggleMediaPlayPause: QWebEnginePage.WebAction = ...
        ToggleMediaMute: QWebEnginePage.WebAction = ...
        DownloadMediaToDisk: QWebEnginePage.WebAction = ...
        InspectElement: QWebEnginePage.WebAction = ...
        ExitFullScreen: QWebEnginePage.WebAction = ...
        RequestClose: QWebEnginePage.WebAction = ...
        Unselect: QWebEnginePage.WebAction = ...
        SavePage: QWebEnginePage.WebAction = ...
        OpenLinkInNewBackgroundTab: QWebEnginePage.WebAction = ...
        ViewSource: QWebEnginePage.WebAction = ...
        ToggleBold: QWebEnginePage.WebAction = ...
        ToggleItalic: QWebEnginePage.WebAction = ...
        ToggleUnderline: QWebEnginePage.WebAction = ...
        ToggleStrikethrough: QWebEnginePage.WebAction = ...
        AlignLeft: QWebEnginePage.WebAction = ...
        AlignCenter: QWebEnginePage.WebAction = ...
        AlignRight: QWebEnginePage.WebAction = ...
        AlignJustified: QWebEnginePage.WebAction = ...
        Indent: QWebEnginePage.WebAction = ...
        Outdent: QWebEnginePage.WebAction = ...
        InsertOrderedList: QWebEnginePage.WebAction = ...
        InsertUnorderedList: QWebEnginePage.WebAction = ...
        WebActionCount: QWebEnginePage.WebAction = ...

    class WebWindowType(Enum):
        WebBrowserWindow: QWebEnginePage.WebWindowType = ...
        WebBrowserTab: QWebEnginePage.WebWindowType = ...
        WebDialog: QWebEnginePage.WebWindowType = ...
        WebBrowserBackgroundTab: QWebEnginePage.WebWindowType = ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#QWebEnginePage

        **QWebEnginePage::QWebEnginePage(QObject * parent = nullptr)**

        Constructs an empty QWebEnginePage with the parent **parent**.
        """
        ...

    @overload
    def __init__(
        self,
        profile: PySide6.QtWebEngineCore.QWebEngineProfile,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#QWebEnginePage-1

        **[since 5.5] QWebEnginePage::QWebEnginePage(QWebEngineProfile * profile
        , QObject * parent = nullptr)**

        Constructs an empty web engine page in the web engine profile
        **profile** with the parent **parent**.

        If the profile is not the default profile, the caller must ensure that
        the profile stays alive for as long as the page does.

        This function was introduced in Qt 5.5.
        """
        ...

    def acceptAsNewWindow(
        self, request: PySide6.QtWebEngineCore.QWebEngineNewWindowRequest
    ) -> None:
        ...

    def acceptNavigationRequest(
        self,
        url: Union[PySide6.QtCore.QUrl, str],
        type: PySide6.QtWebEngineCore.QWebEnginePage.NavigationType,
        isMainFrame: bool,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#acceptNavigationRequest

        **[virtual protected, since 5.5] bool
        QWebEnginePage::acceptNavigationRequest(const QUrl & url ,
        QWebEnginePage::NavigationType type , bool isMainFrame )**

        This function is called upon receiving a request to navigate to the
        specified **url** by means of the specified navigation type **type**.
        **isMainFrame** indicates whether the request corresponds to the main
        frame or a child frame. If the function returns `true`, the navigation
        request is accepted and `url` is loaded. The default implementation
        accepts all navigation requests.

        Navigation requests can be delegated to the Qt application instead of
        having the HTML handler engine process them by overloading this
        function. This is necessary when an HTML document is used as part of the
        user interface, and not to display external data, for example, when
        displaying a list of results.

        **Note:** This function is not called for fragment navigation on the
        same page. Such navigation, for example, happens by clicking a link to a
        '#fragment' within the page. It does not trigger a load to a different
        document, even though it changes page's url and adds history entry. It
        only serves as a shortcut to scroll within the page. Hence, no
        delegation of this navigation type is expected to happen.

        **Note:** The loading process is started and the **loadStarted** ()
        signal is emitted **before** the request is accepted or rejected.
        Therefore, a **loadFinished** () signal that returns `false` is to be
        expected even after delegating the request.

        **Note:** When using **setHtml**  or **setContent**  with relative
        links, make sure to specify a base url, otherwise the links will be
        considered invalid and no navigation requests will be emitted.

        The **QWebEngineUrlRequestInterceptor**  class offers further options
        for intercepting and manipulating requests.

        This function was introduced in Qt 5.5.
        """
        ...

    def action(
        self, action: PySide6.QtWebEngineCore.QWebEnginePage.WebAction
    ) -> PySide6.QtGui.QAction:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#action

        **QAction *QWebEnginePage::action(QWebEnginePage::WebAction action )
        const**

        Returns a **QAction**  for the specified **WebAction**  **action**.

        The action is owned by the **QWebEnginePage**  but you can customize the
        look by changing its properties.

        **QWebEnginePage**  also takes care of implementing the action, so that
        upon triggering the corresponding action is performed on the page.

        **See also** **triggerAction** ().
        """
        ...

    def backgroundColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#backgroundColor-prop

        **[since 5.6] backgroundColor : QColor**

        This property holds the page's background color behind the document's
        body.

        You can set the background color to **Qt::transparent**  or to a
        translucent color to see through the document, or you can set it to
        match your web content in a hybrid application to prevent the white
        flashes that may appear during loading.

        The default value is white.

        This property was introduced in Qt 5.6.

        **Access functions:**

        QColor **backgroundColor** () const
        void **setBackgroundColor** (const
        QColor & **color** )
        """
        ...

    def chooseFiles(
        self,
        mode: PySide6.QtWebEngineCore.QWebEnginePage.FileSelectionMode,
        oldFiles: Sequence[str],
        acceptedMimeTypes: Sequence[str],
    ) -> List[str]:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#chooseFiles

        **[virtual protected] QStringList
        QWebEnginePage::chooseFiles(QWebEnginePage::FileSelectionMode mode ,
        const QStringList & oldFiles , const QStringList & acceptedMimeTypes )**

        This function is called when the web content requests a file name, for
        example as a result of the user clicking on a file upload button in an
        HTML form.

        **mode** indicates whether only one file or multiple files are expected
        to be returned.

        A suggested filename may be provided as the first entry of **oldFiles**.
        **acceptedMimeTypes** is ignored by the default implementation, but
        might be used by overrides.
        """
        ...

    def contentsSize(self) -> PySide6.QtCore.QSizeF:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#contentsSize-prop

        **[read-only, since 5.7] contentsSize : const QSizeF**

        This property holds the size of the page contents.

        This property was introduced in Qt 5.7.

        **Access functions:**

        QSizeF **contentsSize** () const

        **Notifier signal:**

        void **contentsSizeChanged** (const QSizeF & **size** )
        """
        ...

    def createWindow(
        self, type: PySide6.QtWebEngineCore.QWebEnginePage.WebWindowType
    ) -> PySide6.QtWebEngineCore.QWebEnginePage:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#createWindow

        **[virtual protected] QWebEnginePage
        *QWebEnginePage::createWindow(QWebEnginePage::WebWindowType type )**

        This function is called to create a new window of the specified
        **type**. For example, when a JavaScript program requests to open a
        document in a new window.

        If the new window can be created, the new window's **QWebEnginePage**
        is returned; otherwise a null pointer is returned.

        If the view associated with the web page is a **QWebEngineView**
        object, then the default implementation forwards the request to
        **QWebEngineView::createWindow** (); otherwise it returns a null
        pointer.

        If this call is not implemented or does not return a new page,
        **newWindowRequested** () is emitted to handle the request.

        **Note:** In the cases when the window creation is being triggered by
        JavaScript, apart from reimplementing this method the application must
        also set **QWebEngineSettings::JavascriptCanOpenWindows**  to `true` in
        order for the method to get called.

        **See also** **QWebEngineView::createWindow** () and
        **newWindowRequested** ().
        """
        ...

    def devToolsPage(self) -> PySide6.QtWebEngineCore.QWebEnginePage:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#devToolsPage

        **[since 5.11] QWebEnginePage *QWebEnginePage::devToolsPage() const**

        Returns the page that is hosting the developer tools of this page, if
        any.

        Returns `nullptr` if no developer tools page is set.

        This function was introduced in Qt 5.11.

        **See also** **setDevToolsPage** () and **inspectedPage** ().
        """
        ...

    def download(
        self, url: Union[PySide6.QtCore.QUrl, str], filename: str = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#download

        **[since 5.10] void QWebEnginePage::download(const QUrl & url , const
        QString & filename = QString())**

        Downloads the resource from the location given by **url** to a local
        file.

        If **filename** is given, it is used as the suggested file name. If it
        is relative, the file is saved in the standard download location with
        the given name. If it is a null or empty **QString** , the default file
        name is used.

        This will emit **QWebEngineProfile::downloadRequested** () after the
        download has started.

        This function was introduced in Qt 5.10.
        """
        ...

    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#event

        **[override virtual] bool QWebEnginePage::event(QEvent * e )**

        Reimplements: **QObject::event** (QEvent *e).
        """
        ...

    @overload
    def findText(
        self,
        arg__1: str,
        arg__2: PySide6.QtWebEngineCore.QWebEnginePage.FindFlags,
        arg__3: object,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#findText

        **void QWebEnginePage::findText(const QString & subString ,
        QWebEnginePage::FindFlags options = {}, const std::function<void (const
        QWebEngineFindTextResult &)> & resultCallback = ...)**

        Finds the specified string, **subString** , in the page, using the given
        **options**. The **findTextFinished** () signal is emitted when a string
        search is completed.

        To clear the search highlight, just pass an empty string.

        The **resultCallback** must take a **QWebEngineFindTextResult**
        parameter.

        **Warning:** We guarantee that the callback ( **resultCallback** ) is
        always called, but it might be done during page destruction. When
        **QWebEnginePage**  is deleted, the callback is triggered with an
        invalid value and it is not safe to use the corresponding
        **QWebEnginePage**  or **QWebEngineView**  instance inside it.

        For example:

        m_view->page()->findText(**QStringLiteral** ("Qt"), **QWebEnginePage**
        ::FindFlags(), [this](bool found) {
                    if (!found)
        **QMessageBox** ::information(m_view, **QString** (), **QStringLiteral**
        ("No occurrences found"));
                });

        **See also** **findTextFinished** ().
        """
        ...

    @overload
    def findText(
        self,
        subString: str,
        options: PySide6.QtWebEngineCore.QWebEnginePage.FindFlags = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#findText

        **void QWebEnginePage::findText(const QString & subString ,
        QWebEnginePage::FindFlags options = {}, const std::function<void (const
        QWebEngineFindTextResult &)> & resultCallback = ...)**

        Finds the specified string, **subString** , in the page, using the given
        **options**. The **findTextFinished** () signal is emitted when a string
        search is completed.

        To clear the search highlight, just pass an empty string.

        The **resultCallback** must take a **QWebEngineFindTextResult**
        parameter.

        **Warning:** We guarantee that the callback ( **resultCallback** ) is
        always called, but it might be done during page destruction. When
        **QWebEnginePage**  is deleted, the callback is triggered with an
        invalid value and it is not safe to use the corresponding
        **QWebEnginePage**  or **QWebEngineView**  instance inside it.

        For example:

        m_view->page()->findText(**QStringLiteral** ("Qt"), **QWebEnginePage**
        ::FindFlags(), [this](bool found) {
                    if (!found)
        **QMessageBox** ::information(m_view, **QString** (), **QStringLiteral**
        ("No occurrences found"));
                });

        **See also** **findTextFinished** ().
        """
        ...

    def hasSelection(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#hasSelection-prop

        **[read-only] hasSelection : const bool**

        This property holds whether this page contains selected content or not.

        **Access functions:**

        bool **hasSelection** () const

        **See also** **selectionChanged** ().
        """
        ...

    def history(self) -> PySide6.QtWebEngineCore.QWebEngineHistory:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#history

        **QWebEngineHistory *QWebEnginePage::history() const**

        Returns a pointer to the view's history of navigated web pages.
        """
        ...

    def icon(self) -> PySide6.QtGui.QIcon:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#icon-prop

        **[read-only, since 5.7] icon : const QIcon**

        This property holds the icon associated with the page currently viewed.

        By default, this property contains a null icon. If touch icons are
        disabled (see `QWebEngineSettings::TouchIconsEnabled`), the favicon is
        provided in two sizes (16x16 and 32x32 pixels) encapsulated in `QIcon`.
        Otherwise, single icon is provided with the largest available size.

        This property was introduced in Qt 5.7.

        **Access functions:**

        QIcon **icon** () const

        **Notifier signal:**

        void ****iconChanged** ** (const QIcon & **icon** )

        **See also** **iconChanged** (), **iconUrl** (), **iconUrlChanged** (),
        and **QWebEngineSettings::TouchIconsEnabled** .
        """
        ...

    def iconUrl(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#iconUrl-prop

        **[read-only] iconUrl : const QUrl**

        This property holds the URL of the icon associated with the page
        currently viewed.

        By default, this property contains an empty URL.

        **Access functions:**

        QUrl **iconUrl** () const

        **Notifier signal:**

        void ****iconUrlChanged** ** (const QUrl & **url** )

        **See also** **iconUrlChanged** (), **icon** (), and **iconChanged** ().
        """
        ...

    def inspectedPage(self) -> PySide6.QtWebEngineCore.QWebEnginePage:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#inspectedPage

        **[since 5.11] QWebEnginePage *QWebEnginePage::inspectedPage() const**

        Returns the page this page is inspecting, if any.

        Returns `nullptr` if this page is not a developer tools page.

        This function was introduced in Qt 5.11.

        **See also** **setInspectedPage** () and **devToolsPage** ().
        """
        ...

    def isAudioMuted(self) -> bool:
        ...

    def isLoading(self) -> bool:
        ...

    def isVisible(self) -> bool:
        ...

    def javaScriptAlert(
        self, securityOrigin: Union[PySide6.QtCore.QUrl, str], msg: str
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#javaScriptAlert

        **[virtual protected] void QWebEnginePage::javaScriptAlert(const QUrl &
        securityOrigin , const QString & msg )**

        This function is called whenever a JavaScript program running in a frame
        affiliated with **securityOrigin** calls the `alert()` function with the
        message **msg**.

        The default implementation shows the message, **msg** , with
        **QMessageBox::information** .
        """
        ...

    def javaScriptConfirm(
        self, securityOrigin: Union[PySide6.QtCore.QUrl, str], msg: str
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#javaScriptConfirm

        **[virtual protected] bool QWebEnginePage::javaScriptConfirm(const QUrl
        & securityOrigin , const QString & msg )**

        This function is called whenever a JavaScript program running in a frame
        affiliated with **securityOrigin** calls the `confirm()` function with
        the message **msg**. Returns `true` if the user confirms the message;
        otherwise returns `false`.

        It is also called when the `onbeforeunload` handler is requesting a
        confirmation before leaving a page.

        The default implementation executes the query using
        **QMessageBox::information**  with **QMessageBox::Ok**  and
        **QMessageBox::Cancel**  buttons.
        """
        ...

    def javaScriptConsoleMessage(
        self,
        level: PySide6.QtWebEngineCore.QWebEnginePage.JavaScriptConsoleMessageLevel,
        message: str,
        lineNumber: int,
        sourceID: str,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#javaScriptConsoleMessage

        **[virtual protected] void QWebEnginePage::javaScriptConsoleMessage(QWeb
        EnginePage::JavaScriptConsoleMessageLevel level , const QString &
        message , int lineNumber , const QString & sourceID )**

        This function is called when a JavaScript program tries to print the
        **message** to the web browser's console.

        For example, in case of evaluation errors the source URL may be provided
        in **sourceID** as well as the **lineNumber**.

        **level** indicates the severity of the event that triggered the
        message. That is, whether it was triggered by an error or a less severe
        event.

        Since Qt 5.6, the default implementation logs the messages in a `js`
        **logging category** .

        **See also** **Console Logging** .
        """
        ...

    def javaScriptPrompt(
        self,
        securityOrigin: Union[PySide6.QtCore.QUrl, str],
        msg: str,
        defaultValue: str,
    ) -> Tuple[bool, str]:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#javaScriptPrompt

        **[virtual protected] bool QWebEnginePage::javaScriptPrompt(const QUrl &
        securityOrigin , const QString & msg , const QString & defaultValue ,
        QString * result )**

        This function is called whenever a JavaScript program running in a frame
        affiliated with **securityOrigin** tries to prompt the user for input.
        The program may provide an optional message, **msg** , as well as a
        default value for the input in **defaultValue**.

        If the prompt was cancelled by the user, the implementation should
        return `false`; otherwise the result should be written to **result** and
        `true` should be returned. If the prompt was not cancelled by the user,
        the implementation should return `true` and the result string must not
        be null.

        The default implementation uses **QInputDialog::getText** ().
        """
        ...

    def lifecycleState(self) -> PySide6.QtWebEngineCore.QWebEnginePage.LifecycleState:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#lifecycleState-prop

        **[since 5.14] lifecycleState : LifecycleState**

        This property holds the current lifecycle state of the page.

        The following restrictions are enforced by the setter:

        * A **visible**  page must remain in the `Active` state.
          * If the page
        is being inspected by a **devToolsPage**  then both pages must remain in
        the `Active` states.
          * A page in the `Discarded` state can only
        transition to the `Active` state. This will cause a reload of the page.

        These are the only hard limits on the lifecycle state, but see also
        **recommendedState**  for the recommended soft limits.

        This property was introduced in Qt 5.14.

        **Access functions:**

        QWebEnginePage::LifecycleState **lifecycleState** () const
        void
        **setLifecycleState** (QWebEnginePage::LifecycleState **state** )

        **Notifier signal:**

        void **lifecycleStateChanged** (QWebEnginePage::LifecycleState **state**
        )

        **See also** **recommendedState** , **Page Lifecycle API** , and
        **WebEngine Lifecycle Example** .
        """
        ...

    @overload
    def load(self, request: PySide6.QtWebEngineCore.QWebEngineHttpRequest) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#load

        **void QWebEnginePage::load(const QUrl & url )**

        Loads **url** into this page.

        **Note:** The view remains the same until enough data has arrived to
        display the new URL.

        **See also** **setUrl** (), **setHtml** (), and **setContent** ().
        """
        ...

    @overload
    def load(self, url: Union[PySide6.QtCore.QUrl, str]) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#load-1

        **[since 5.9] void QWebEnginePage::load(const QWebEngineHttpRequest &
        request )**

        Issues the specified **request** and loads the response.

        This function was introduced in Qt 5.9.

        **See also** **load** (), **setUrl** (), **url** (), **urlChanged** (),
        and **QUrl::fromUserInput** ().
        """
        ...

    def printToPdf(
        self,
        filePath: str,
        layout: PySide6.QtGui.QPageLayout = ...,
        ranges: PySide6.QtGui.QPageRanges = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#printToPdf

        **void QWebEnginePage::printToPdf(const QString & filePath , const
        QPageLayout & layout = QPageLayout(QPageSize(QPageSize::A4),
        QPageLayout::Portrait, QMarginsF()), const QPageRanges & ranges = {})**

        Renders the current content of the page into a PDF document and saves it
        in the location specified in **filePath**. The page size and orientation
        of the produced PDF document are taken from the values specified in
        **layout** , while the range of pages printed is taken from **ranges**
        with the default being printing all pages.

        This method issues an asynchronous request for printing the web page
        into a PDF and returns immediately. To be informed about the result of
        the request, connect to the signal **pdfPrintingFinished** ().

        If a file already exists at the provided file path, it will be
        overwritten.

        **See also** **pdfPrintingFinished** ().
        """
        ...

    def profile(self) -> PySide6.QtWebEngineCore.QWebEngineProfile:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#profile

        **[since 5.5] QWebEngineProfile *QWebEnginePage::profile() const**

        Returns the web engine profile the page belongs to.

        This function was introduced in Qt 5.5.
        """
        ...

    def recentlyAudible(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#recentlyAudible-prop

        **[read-only, since 5.7] recentlyAudible : const bool**

        This property holds the current page's **audible state** , that is,
        whether audio was recently played or not.

        The default value is `false`.

        This property was introduced in Qt 5.7.

        **Access functions:**

        bool **recentlyAudible** () const

        **Notifier signal:**

        void ****recentlyAudibleChanged** ** (bool **recentlyAudible** )

        **See also** **audioMuted** .
        """
        ...

    def recommendedState(self) -> PySide6.QtWebEngineCore.QWebEnginePage.LifecycleState:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#recommendedState-prop

        **[read-only, since 5.14] recommendedState : const LifecycleState**

        This property holds the recommended limit for the lifecycle state of the
        page.

        Setting the lifecycle state to a lower resource usage state than the
        recommended state may cause side-effects such as stopping background
        audio playback or loss of HTML form input. Setting the lifecycle state
        to a higher resource state is however completely safe.

        This property was introduced in Qt 5.14.

        **Access functions:**

        QWebEnginePage::LifecycleState **recommendedState** () const

        **Notifier signal:**

        void **recommendedStateChanged** (QWebEnginePage::LifecycleState
        **state** )

        **See also** **lifecycleState** , **Page Lifecycle API** , and
        **WebEngine Lifecycle Example** .
        """
        ...

    def renderProcessPid(self) -> int:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#renderProcessPid-prop

        **[read-only, since 5.15] renderProcessPid : const qint64**

        This property holds the process ID (PID) of the render process assigned
        to the current page's main frame.

        If no render process is available yet, `0` is returned.

        This property was introduced in Qt 5.15.

        **Access functions:**

        qint64 **renderProcessPid** () const

        **Notifier signal:**

        void ****renderProcessPidChanged** ** (qint64 **pid** )
        """
        ...

    def replaceMisspelledWord(self, replacement: str) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#replaceMisspelledWord

        **[since 5.8] void QWebEnginePage::replaceMisspelledWord(const QString &
        replacement )**

        Replace the current misspelled word with **replacement**.

        The current misspelled word can be found in
        **QWebEngineContextMenuRequest::misspelledWord** (), and suggested
        replacements in
        **QWebEngineContextMenuRequest::spellCheckerSuggestions** ().

        This function was introduced in Qt 5.8.
        """
        ...

    def requestedUrl(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#requestedUrl-prop

        **[read-only] requestedUrl : const QUrl**

        This property holds the URL that was originally requested to be loaded
        by the page that is currently viewed.

        **Note:** The URL may differ from the one returned by **url** (), which
        is the actual URL that results from DNS resolution or redirection.

        **Access functions:**

        QUrl **requestedUrl** () const

        **See also** **url** () and **setUrl** ().
        """
        ...

    @overload
    def runJavaScript(self, arg__1: str, arg__2: int, arg__3: object) -> None:
        ...

    @overload
    def runJavaScript(self, scriptSource: str, worldId: int = ...) -> None:
        ...

    def save(
        self,
        filePath: str,
        format: PySide6.QtWebEngineCore.QWebEngineDownloadRequest.SavePageFormat = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#save

        **[since 5.8] void QWebEnginePage::save(const QString & filePath ,
        QWebEngineDownloadRequest::SavePageFormat format =
        QWebEngineDownloadRequest::MimeHtmlSaveFormat) const**

        Save the currently loaded web page to disk.

        The web page is saved to **filePath** in the specified **format**.

        This is a short cut for the following actions:

        * Trigger the Save web action.
          * Accept the next download item and set
        the specified file path and save format.

        This function issues an asynchronous download request for the web page
        and returns immediately.

        This function was introduced in Qt 5.8.

        **See also** **QWebEngineDownloadRequest::SavePageFormat** .
        """
        ...

    def scripts(self) -> PySide6.QtWebEngineCore.QWebEngineScriptCollection:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#scripts

        **QWebEngineScriptCollection &QWebEnginePage::scripts()**

        Returns the collection of scripts that are injected into the page.

        In addition, a page might also execute scripts added through
        **QWebEngineProfile::scripts** ().

        **See also** **QWebEngineScriptCollection** , **QWebEngineScript** , and
        **Script Injection** .
        """
        ...

    def scrollPosition(self) -> PySide6.QtCore.QPointF:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#scrollPosition-prop

        **[read-only, since 5.7] scrollPosition : const QPointF**

        This property holds the scroll position of the page contents.

        This property was introduced in Qt 5.7.

        **Access functions:**

        QPointF **scrollPosition** () const

        **Notifier signal:**

        void **scrollPositionChanged** (const QPointF & **position** )
        """
        ...

    def selectedText(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#selectedText-prop

        **[read-only] selectedText : const QString**

        This property holds the text currently selected.

        By default, this property contains an empty string.

        **Access functions:**

        QString **selectedText** () const

        **See also** **selectionChanged** ().
        """
        ...

    def setAudioMuted(self, muted: bool) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#audioMuted-prop

        **[since 5.7] audioMuted : bool**

        This property holds whether the current page audio is muted.

        The default value is `false`.

        This property was introduced in Qt 5.7.

        **Access functions:**

        bool **isAudioMuted** () const
        void **setAudioMuted** (bool **muted**
        )

        **Notifier signal:**

        void ****audioMutedChanged** ** (bool **muted** )

        **See also** **recentlyAudible** .
        """
        ...

    def setBackgroundColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#backgroundColor-prop

        **[since 5.6] backgroundColor : QColor**

        This property holds the page's background color behind the document's
        body.

        You can set the background color to **Qt::transparent**  or to a
        translucent color to see through the document, or you can set it to
        match your web content in a hybrid application to prevent the white
        flashes that may appear during loading.

        The default value is white.

        This property was introduced in Qt 5.6.

        **Access functions:**

        QColor **backgroundColor** () const
        void **setBackgroundColor** (const
        QColor & **color** )
        """
        ...

    def setContent(
        self,
        data: Union[PySide6.QtCore.QByteArray, bytes],
        mimeType: str = ...,
        baseUrl: Union[PySide6.QtCore.QUrl, str] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#setContent

        **void QWebEnginePage::setContent(const QByteArray & data , const
        QString & mimeType = QString(), const QUrl & baseUrl = QUrl())**

        Sets the content of the web page to **data**. If the **mimeType**
        argument is empty, it is assumed that the content is
        `text/plain,charset=US-ASCII`.

        External objects referenced in the content are located relative to
        **baseUrl**.

        The **data** is loaded immediately; external objects are loaded
        asynchronously.

        **Note:** This method will not affect session or global history for the
        page.

        **Warning:** The content will be percent encoded before being sent to
        the renderer via IPC. This may increase its size. The maximum size of
        the percent encoded content is 2 megabytes minus 6 bytes plus the length
        of the mime type string.

        **See also** **toHtml** () and **setHtml** ().
        """
        ...

    def setDevToolsPage(self, page: PySide6.QtWebEngineCore.QWebEnginePage) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#setDevToolsPage

        **[since 5.11] void QWebEnginePage::setDevToolsPage(QWebEnginePage *
        devToolsPage )**

        Binds **devToolsPage** to be the developer tools of this page. Triggers
        **devToolsPage** to navigate to an internal URL with the developer
        tools.

        This is the same as calling **setInspectedPage** () on **devToolsPage**
        with `this` as argument.

        This function was introduced in Qt 5.11.

        **See also** **devToolsPage** () and **setInspectedPage** ().
        """
        ...

    def setFeaturePermission(
        self,
        securityOrigin: Union[PySide6.QtCore.QUrl, str],
        feature: PySide6.QtWebEngineCore.QWebEnginePage.Feature,
        policy: PySide6.QtWebEngineCore.QWebEnginePage.PermissionPolicy,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#setFeaturePermission

        **void QWebEnginePage::setFeaturePermission(const QUrl & securityOrigin
        , QWebEnginePage::Feature feature , QWebEnginePage::PermissionPolicy
        policy )**

        Sets the permission for the web site identified by **securityOrigin** to
        use **feature** to **policy**.

        **Note:** This method is primarily for calling after a
        **featurePermissionRequested** () signal has been emitted to trigger the
        feature permission response. It can also be called before a request has
        been emitted, but will only set a granted permission for passive checks,
        mainly for Notification APIs that can check if permission has already
        been granted before explicitly requesting it.

        **See also** **featurePermissionRequested** () and
        **featurePermissionRequestCanceled** ().
        """
        ...

    def setHtml(
        self, html: str, baseUrl: Union[PySide6.QtCore.QUrl, str] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#setHtml

        **void QWebEnginePage::setHtml(const QString & html , const QUrl &
        baseUrl = QUrl())**

        Sets the content of this page to **html**. **baseUrl** is optional and
        used to resolve relative URLs in the document, such as referenced images
        or stylesheets.

        The **html** is loaded immediately; external objects are loaded
        asynchronously.

        If a script in the **html** runs longer than the default script timeout
        (currently 10 seconds), for example due to being blocked by a modal
        JavaScript alert dialog, this method will return as soon as possible
        after the timeout and any subsequent **html** will be loaded
        asynchronously.

        When using this method, the web engine assumes that external resources,
        such as JavaScript programs or style sheets, are encoded in UTF-8 unless
        otherwise specified. For example, the encoding of an external script can
        be specified through the charset attribute of the HTML script tag. It is
        also possible for the encoding to be specified by the web server.

        This is a convenience function equivalent to **setContent** (html,
        "text/html", baseUrl).

        **Note:** This method will not affect session or global history for the
        page.

        **Warning:** This function works only for HTML, for other mime types
        (such as XHTML and SVG) **setContent** () should be used instead.

        **Warning:** The content will be percent encoded before being sent to
        the renderer via IPC. This may increase its size. The maximum size of
        the percent encoded content is 2 megabytes minus 30 bytes.

        **See also** **toHtml** (), **setContent** (), and **load** ().
        """
        ...

    def setInspectedPage(self, page: PySide6.QtWebEngineCore.QWebEnginePage) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#setInspectedPage

        **[since 5.11] void QWebEnginePage::setInspectedPage(QWebEnginePage *
        page )**

        Navigates this page to an internal URL that is the developer tools of
        **page**.

        This is the same as calling **setDevToolsPage** () on **page** with
        `this` as argument.

        This function was introduced in Qt 5.11.

        **See also** **inspectedPage** () and **setDevToolsPage** ().
        """
        ...

    def setLifecycleState(
        self, state: PySide6.QtWebEngineCore.QWebEnginePage.LifecycleState
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#lifecycleState-prop

        **[since 5.14] lifecycleState : LifecycleState**

        This property holds the current lifecycle state of the page.

        The following restrictions are enforced by the setter:

        * A **visible**  page must remain in the `Active` state.
          * If the page
        is being inspected by a **devToolsPage**  then both pages must remain in
        the `Active` states.
          * A page in the `Discarded` state can only
        transition to the `Active` state. This will cause a reload of the page.

        These are the only hard limits on the lifecycle state, but see also
        **recommendedState**  for the recommended soft limits.

        This property was introduced in Qt 5.14.

        **Access functions:**

        QWebEnginePage::LifecycleState **lifecycleState** () const
        void
        **setLifecycleState** (QWebEnginePage::LifecycleState **state** )

        **Notifier signal:**

        void **lifecycleStateChanged** (QWebEnginePage::LifecycleState **state**
        )

        **See also** **recommendedState** , **Page Lifecycle API** , and
        **WebEngine Lifecycle Example** .
        """
        ...

    def setUrl(self, url: Union[PySide6.QtCore.QUrl, str]) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#url-prop

        **url : QUrl**

        This property holds the URL of the page currently viewed.

        Setting this property clears the view and loads the URL.

        By default, this property contains an empty, invalid URL.

        **Access functions:**

        QUrl **url** () const
        void **setUrl** (const QUrl & **url** )

        **See also** **urlChanged** ().
        """
        ...

    def setUrlRequestInterceptor(
        self, interceptor: PySide6.QtWebEngineCore.QWebEngineUrlRequestInterceptor
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#setUrlRequestInterceptor

        **[since 5.13] void
        QWebEnginePage::setUrlRequestInterceptor(QWebEngineUrlRequestInterceptor
        * interceptor )**

        Registers the request interceptor **interceptor** to intercept URL
        requests.

        The page does not take ownership of the pointer. This interceptor is
        called after any interceptors on the profile, and unlike profile
        interceptors, only URL requests from this page are intercepted.

        To unset the request interceptor, set a `nullptr`.

        This function was introduced in Qt 5.13.

        **See also** **QWebEngineUrlRequestInfo**  and
        **QWebEngineProfile::setUrlRequestInterceptor** ().
        """
        ...

    def setVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#visible-prop

        **[since 5.14] visible : bool**

        This property holds whether the page is considered visible in the Page
        Visibility API.

        Setting this property changes the `Document.hidden` and the
        `Document.visibilityState` properties in JavaScript which web sites can
        use to voluntarily reduce their resource usage if they are not visible
        to the user.

        If the page is connected to a **view** then this property will be
        managed automatically by the view according to it's own visibility.

        This property was introduced in Qt 5.14.

        **Access functions:**

        bool **isVisible** () const
        void **setVisible** (bool **visible** )

        **Notifier signal:**

        void **visibleChanged** (bool **visible** )

        **See also** **lifecycleState** .
        """
        ...

    def setWebChannel(
        self, arg__1: PySide6.QtWebChannel.QWebChannel, worldId: int = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#setWebChannel

        **[since 5.7] void QWebEnginePage::setWebChannel(QWebChannel * channel ,
        quint32 worldId = 0)**

        Sets the web channel instance to be used by this page to **channel** and
        connects it to web engine's transport using Chromium IPC messages. The
        transport is exposed in the JavaScript world **worldId** as
        `qt.webChannelTransport`, which should be used when using the **Qt
        WebChannel JavaScript API** .

        **Note:** The page does not take ownership of the channel object.

        **Note:** Only one web channel can be installed per page, setting one
        even in another JavaScript world uninstalls any already installed web
        channel.

        This function was introduced in Qt 5.7.

        **See also** **webChannel** () and **QWebEngineScript::ScriptWorldId** .
        """
        ...

    def setZoomFactor(self, factor: float) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#zoomFactor-prop

        **zoomFactor : qreal**

        This property holds the zoom factor for the page content.

        Valid values are within the range from `0.25` to `5.0`. The default
        factor is `1.0`.

        **Access functions:**

        qreal **zoomFactor** () const
        void **setZoomFactor** (qreal **factor**
        )

        **Member Function Documentation**

        **`[since 5.7] `void QWebEnginePage::runJavaScript(const **QString**  &
        **scriptSource** , const std::function<void (const **QVariant**  &)> &
        **resultCallback** )****`[since 5.7] `void
        QWebEnginePage::runJavaScript(const **QString**  & **scriptSource** ,
        **quint32**  **worldId** = 0, const std::function<void (const
        **QVariant**  &)> & **resultCallback** = {})**

        Runs the JavaScript code contained in **scriptSource** without checking
        whether the DOM of the page has been constructed. If you need more
        control over how the script is run, consider using **scripts** ()
        instead.

        To avoid conflicts with other scripts executed on the page, the world in
        which the script is run is specified by **worldId**. The world ID values
        are the same as provided by **QWebEngineScript::ScriptWorldId** , and
        between `0` and `256`. If you leave out the `world` ID, the script is
        run in the `MainWorld`.

        When the script has been executed, **resultCallback** is called with the
        result of the last executed statement. `resultCallback` can be any of a
        function pointer, a functor or a lambda, and it is expected to take a
        **QVariant**  parameter. For example:

        page.runJavaScript("document.title", [](const **QVariant**  &v) {
        **qDebug** () << v.toString(); });

        Only plain data can be returned from JavaScript as the result value.
        Supported data types include all of the JSON data types as well as, for
        example, `Date` and `ArrayBuffer`. Unsupported data types include, for
        example, `Function` and `Promise`.

        **Warning:** Do not execute lengthy routines in the callback function,
        because it might block the rendering of the web engine page.

        **Warning:** We guarantee that the callback ( **resultCallback** ) is
        always called, but it might be done during page destruction. When
        **QWebEnginePage**  is deleted, the callback is triggered with an
        invalid value and it is not safe to use the corresponding
        **QWebEnginePage**  or **QWebEngineView**  instance inside it.

        This function was introduced in Qt 5.7.

        **See also** **scripts** (), **QWebEngineScript::ScriptWorldId** , and
        **Script Injection** .
        """
        ...

    def settings(self) -> PySide6.QtWebEngineCore.QWebEngineSettings:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#settings

        **QWebEngineSettings *QWebEnginePage::settings() const**

        Returns a pointer to the page's settings object.
        """
        ...

    def title(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#title-prop

        **[read-only] title : const QString**

        This property holds the title of the page as defined by the HTML
        `<title>` element.

        If the page has no `<title>` element, then the URL is used instead. For
        `file://` URLs only the filename is used and not the full path.

        By default, before any content has been loaded, this property contains
        an empty string.

        **Access functions:**

        QString **title** () const

        **See also** **titleChanged** ().
        """
        ...

    def toHtml(self, arg__1: object) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#toHtml

        **void QWebEnginePage::toHtml(const std::function<void (const QString
        &)> & resultCallback ) const**

        Asynchronous method to retrieve the page's content as HTML, enclosed in
        HTML and BODY tags. Upon successful completion, **resultCallback** is
        called with the page's content.

        **Note:** **resultCallback** can be any of a function pointer, a functor
        or a lambda, and it is expected to take a **QString**  parameter.

        **Warning:** We guarantee that the callback ( **resultCallback** ) is
        always called, but it might be done during page destruction. When
        **QWebEnginePage**  is deleted, the callback is triggered with an
        invalid value and it is not safe to use the corresponding
        **QWebEnginePage**  or **QWebEngineView**  instance inside it.

        **See also** **setHtml** () and **toPlainText** ().
        """
        ...

    def toPlainText(self, arg__1: object) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#toPlainText

        **void QWebEnginePage::toPlainText(const std::function<void (const
        QString &)> & resultCallback ) const**

        Asynchronous method to retrieve the page's content converted to plain
        text, completely stripped of all HTML formatting. Upon successful
        completion, **resultCallback** is called with the page's content.

        **Note:** **resultCallback** can be any of a function pointer, a functor
        or a lambda, and it is expected to take a **QString**  parameter.

        **Warning:** We guarantee that the callback ( **resultCallback** ) is
        always called, but it might be done during page destruction. When
        **QWebEnginePage**  is deleted, the callback is triggered with an
        invalid value and it is not safe to use the corresponding
        **QWebEnginePage**  or **QWebEngineView**  instance inside it.

        **See also** **toHtml** ().
        """
        ...

    def triggerAction(
        self,
        action: PySide6.QtWebEngineCore.QWebEnginePage.WebAction,
        checked: bool = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#triggerAction

        **[virtual] void QWebEnginePage::triggerAction(QWebEnginePage::WebAction
        action , bool checked = false)**

        This function can be called to trigger the specified **action**. It is
        also called by Qt WebEngine if the user triggers the action, for example
        through a context menu item.

        If **action** is a checkable action, then **checked** specifies whether
        the action is toggled or not.

        **See also** **action** ().
        """
        ...

    def url(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#url-prop

        **url : QUrl**

        This property holds the URL of the page currently viewed.

        Setting this property clears the view and loads the URL.

        By default, this property contains an empty, invalid URL.

        **Access functions:**

        QUrl **url** () const
        void **setUrl** (const QUrl & **url** )

        **See also** **urlChanged** ().
        """
        ...

    def webChannel(self) -> PySide6.QtWebChannel.QWebChannel:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#webChannel

        **[since 5.5] QWebChannel *QWebEnginePage::webChannel() const**

        Returns a pointer to the web channel instance used by this page or a
        null pointer if none was set. This channel automatically uses the
        internal web engine transport mechanism over Chromium IPC that is
        exposed in the JavaScript context of this page as
        `qt.webChannelTransport`.

        This function was introduced in Qt 5.5.

        **See also** **setWebChannel** ().
        """
        ...

    def zoomFactor(self) -> float:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#zoomFactor-prop

        **zoomFactor : qreal**

        This property holds the zoom factor for the page content.

        Valid values are within the range from `0.25` to `5.0`. The default
        factor is `1.0`.

        **Access functions:**

        qreal **zoomFactor** () const
        void **setZoomFactor** (qreal **factor**
        )

        **Member Function Documentation**

        **`[since 5.7] `void QWebEnginePage::runJavaScript(const **QString**  &
        **scriptSource** , const std::function<void (const **QVariant**  &)> &
        **resultCallback** )****`[since 5.7] `void
        QWebEnginePage::runJavaScript(const **QString**  & **scriptSource** ,
        **quint32**  **worldId** = 0, const std::function<void (const
        **QVariant**  &)> & **resultCallback** = {})**

        Runs the JavaScript code contained in **scriptSource** without checking
        whether the DOM of the page has been constructed. If you need more
        control over how the script is run, consider using **scripts** ()
        instead.

        To avoid conflicts with other scripts executed on the page, the world in
        which the script is run is specified by **worldId**. The world ID values
        are the same as provided by **QWebEngineScript::ScriptWorldId** , and
        between `0` and `256`. If you leave out the `world` ID, the script is
        run in the `MainWorld`.

        When the script has been executed, **resultCallback** is called with the
        result of the last executed statement. `resultCallback` can be any of a
        function pointer, a functor or a lambda, and it is expected to take a
        **QVariant**  parameter. For example:

        page.runJavaScript("document.title", [](const **QVariant**  &v) {
        **qDebug** () << v.toString(); });

        Only plain data can be returned from JavaScript as the result value.
        Supported data types include all of the JSON data types as well as, for
        example, `Date` and `ArrayBuffer`. Unsupported data types include, for
        example, `Function` and `Promise`.

        **Warning:** Do not execute lengthy routines in the callback function,
        because it might block the rendering of the web engine page.

        **Warning:** We guarantee that the callback ( **resultCallback** ) is
        always called, but it might be done during page destruction. When
        **QWebEnginePage**  is deleted, the callback is triggered with an
        invalid value and it is not safe to use the corresponding
        **QWebEnginePage**  or **QWebEngineView**  instance inside it.

        This function was introduced in Qt 5.7.

        **See also** **scripts** (), **QWebEngineScript::ScriptWorldId** , and
        **Script Injection** .
        """
        ...

    @property
    def audioMutedChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#audioMutedChanged

        **[signal, since 5.7] void QWebEnginePage::audioMutedChanged(bool muted
        )**

        This signal is emitted when the page's **muted** state changes.

        **Note:** Not to be confused with a specific HTML5 audio or video
        element being muted.

        **Note:** Notifier signal for property **audioMuted** .

        This function was introduced in Qt 5.7.
        """
        ...

    @property
    def authenticationRequired(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#authenticationRequired

        **[signal] void QWebEnginePage::authenticationRequired(const QUrl &
        requestUrl , QAuthenticator * authenticator )**

        This signal is emitted when access to **requestUrl** requires
        authentication. **authenticator** should be used to pass the user name
        and password for the connection.
        """
        ...

    @property
    def certificateError(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#certificateError

        **[signal] void QWebEnginePage::certificateError(const
        QWebEngineCertificateError & certificateError )**

        This signal is emitted when an invalid certificate error is raised while
        loading a given request.

        The **certificateError** parameter contains information about the
        certificate and details of the error, it also provides the way to ignore
        the error and complete the request or stop loading the request.

        **See also** **QWebEngineCertificateError** .
        """
        ...

    @property
    def contentsSizeChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def featurePermissionRequestCanceled(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#featurePermissionRequestCance
        led

        **[signal] void QWebEnginePage::featurePermissionRequestCanceled(const
        QUrl & securityOrigin , QWebEnginePage::Feature feature )**

        This signal is emitted when the web site identified by
        **securityOrigin** cancels a previously issued request to make use of
        **feature**.

        **See also** **featurePermissionRequested** () and
        **setFeaturePermission** ().
        """
        ...

    @property
    def featurePermissionRequested(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#featurePermissionRequested

        **[signal] void QWebEnginePage::featurePermissionRequested(const QUrl &
        securityOrigin , QWebEnginePage::Feature feature )**

        This signal is emitted when the web site identified by
        **securityOrigin** requests to make use of the resource or device
        identified by **feature**.

        **See also** **featurePermissionRequestCanceled** () and
        **setFeaturePermission** ().
        """
        ...

    @property
    def findTextFinished(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#findTextFinished

        **[signal, since 5.14] void QWebEnginePage::findTextFinished(const
        QWebEngineFindTextResult & result )**

        This signal is emitted when a search string search on a page is
        completed. **result** is the result of the string search.

        This function was introduced in Qt 5.14.

        **See also** **findText** ().
        """
        ...

    @property
    def fullScreenRequested(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#fullScreenRequested

        **[signal] void
        QWebEnginePage::fullScreenRequested(QWebEngineFullScreenRequest
        fullScreenRequest )**

        This signal is emitted when the web page issues the request to enter
        fullscreen mode for a web-element, usually a video element.

        The request object **fullScreenRequest** can be used to accept or reject
        the request.

        If the request is accepted the element requesting fullscreen will fill
        the viewport, but it is up to the application to make the view
        fullscreen or move the page to a view that is fullscreen.

        **See also** **QWebEngineSettings::FullScreenSupportEnabled** .
        """
        ...

    @property
    def geometryChangeRequested(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#geometryChangeRequested

        **[signal] void QWebEnginePage::geometryChangeRequested(const QRect &
        geom )**

        This signal is emitted whenever the document wants to change the
        position and size of the page to **geom**. This can happen for example
        through JavaScript.

        **Note:****setGeometry** () expects a size excluding the window
        decoration, while **geom** includes it. You have to remove the size of
        the frame margins from **geom** to handle this signal correctly.

        window->setGeometry(geom.marginsRemoved(window->frameMargins()));
        """
        ...

    @property
    def iconChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#iconChanged

        **[signal, since 5.7] void QWebEnginePage::iconChanged(const QIcon &
        icon )**

        This signal is emitted when the icon ("favicon") associated with the
        page is changed. The new icon is specified by **icon**.

        **Note:** Notifier signal for property **icon** .

        This function was introduced in Qt 5.7.

        **See also** **icon** (), **iconUrl** (), and **iconUrlChanged** ().
        """
        ...

    @property
    def iconUrlChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#iconUrlChanged

        **[signal] void QWebEnginePage::iconUrlChanged(const QUrl & url )**

        This signal is emitted when the URL of the icon ("favicon") associated
        with the page is changed. The new URL is specified by **url**.

        **Note:** Notifier signal for property **iconUrl** .

        **See also** **iconUrl** (), **icon** (), and **iconChanged** ().
        """
        ...

    @property
    def lifecycleStateChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def linkHovered(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#linkHovered

        **[signal] void QWebEnginePage::linkHovered(const QString & url )**

        This signal is emitted when the mouse hovers over a link. **url**
        contains the target URL of the link.
        """
        ...

    @property
    def loadFinished(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#loadFinished

        **[signal] void QWebEnginePage::loadFinished(bool ok )**

        This signal is emitted when the page finishes loading content. This
        signal is independent of script execution or page rendering. **ok** will
        indicate whether the load was successful or any error occurred.

        **Note:** Navigation requests can be delegated to the Qt application
        instead of having the HTML handler engine process them by overloading
        the **acceptNavigationRequest** () function. Because the loading process
        is started and the **loadStarted** () signal is emitted **before** the
        request is accepted or rejected, a `loadFinished()` signal that returns
        `false` is to be expected even after delegating the request.

        **See also** **loadStarted** () and **acceptNavigationRequest** ().
        """
        ...

    @property
    def loadProgress(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#loadProgress

        **[signal] void QWebEnginePage::loadProgress(int progress )**

        This signal is emitted when the global progress status changes. The
        current value is provided by **progress** and scales from 0 to 100,
        which is the default range of **QProgressBar** . It accumulates changes
        from all the child frames.
        """
        ...

    @property
    def loadStarted(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#loadStarted

        **[signal] void QWebEnginePage::loadStarted()**

        This signal is emitted when a page starts loading content.

        **See also** **loadFinished** () and **acceptNavigationRequest** ().
        """
        ...

    @property
    def loadingChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#loadingChanged

        **[signal, since 6.2] void QWebEnginePage::loadingChanged(const
        QWebEngineLoadingInfo & loadingInfo )**

        This signal is emitted when loading the page specified by
        **loadingInfo** begins, ends, or fails.

        **Note:** Notifier signal for property **loading** .

        This function was introduced in Qt 6.2.
        """
        ...

    @property
    def navigationRequested(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#navigationRequested

        **[signal, since 6.2] void
        QWebEnginePage::navigationRequested(QWebEngineNavigationRequest &
        request )**

        This signal is emitted on navigation together with the call the
        **acceptNavigationRequest** (). It can be used to accept or ignore the
        **request**. The default is to accept.

        This function was introduced in Qt 6.2.

        **See also** **acceptNavigationRequest** ().
        """
        ...

    @property
    def newWindowRequested(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#newWindowRequested

        **[signal, since 6.2] void
        QWebEnginePage::newWindowRequested(QWebEngineNewWindowRequest & request
        )**

        This signal is emitted when **request** is issued to load a page in a
        separate web engine window. This can either be because the current page
        requested it explicitly through a JavaScript call to `window.open`, or
        because the user clicked on a link while holding Shift, Ctrl, or a
        built-in combination that triggers the page to open in a new window.

        The signal is handled by calling openIn() with the new page on the
        request. If this signal is not handled, the requested load will fail.

        **Note:** This signal is not emitted if **createWindow** () handled the
        request first.

        This function was introduced in Qt 6.2.

        **See also** **createWindow** () and
        **QWebEngineNewWindowRequest::openIn** ().
        """
        ...

    @property
    def pdfPrintingFinished(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#pdfPrintingFinished

        **[signal] void QWebEnginePage::pdfPrintingFinished(const QString &
        filePath , bool success )**

        This signal is emitted when printing the web page into a PDF file has
        finished. **filePath** will contain the path the file was requested to
        be created at, and **success** will be `true` if the file was
        successfully created and `false` otherwise.

        **See also** **printToPdf** ().
        """
        ...

    @property
    def proxyAuthenticationRequired(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#proxyAuthenticationRequired

        **[signal] void QWebEnginePage::proxyAuthenticationRequired(const QUrl &
        requestUrl , QAuthenticator * authenticator , const QString & proxyHost
        )**

        This signal is emitted when access to **requestUrl** via **proxyHost**
        requires authentication for the proxy. **authenticator** should be used
        to pass the user name and password for the connection.
        """
        ...

    @property
    def quotaRequested(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#quotaRequested

        **[signal, since 5.11] void
        QWebEnginePage::quotaRequested(QWebEngineQuotaRequest quotaRequest )**

        This signal is emitted when the web page requests larger persistent
        storage than the application's current allocation in File System API.
        The default quota is 0 bytes.

        The request object **quotaRequest** can be used to accept or reject the
        request.

        This function was introduced in Qt 5.11.
        """
        ...

    @property
    def recentlyAudibleChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#recentlyAudibleChanged

        **[signal, since 5.7] void QWebEnginePage::recentlyAudibleChanged(bool
        recentlyAudible )**

        This signal is emitted when the page's audible state,
        **recentlyAudible** , changes, because the audio is played or stopped.

        **Note:** The signal is also emitted when calling the **setAudioMuted**
        () method. Also, if the audio is paused, this signal is emitted with an
        approximate **two-second delay** , from the moment the audio is paused.

        **Note:** Notifier signal for property **recentlyAudible** .

        This function was introduced in Qt 5.7.
        """
        ...

    @property
    def recommendedStateChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def registerProtocolHandlerRequested(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#registerProtocolHandlerReques
        ted

        **[signal, since 5.11] void QWebEnginePage::registerProtocolHandlerReque
        sted(QWebEngineRegisterProtocolHandlerRequest request )**

        This signal is emitted when the web page tries to register a custom
        protocol using the **registerProtocolHandler**  API.

        The request object **request** can be used to accept or reject the
        request:

        void WebView::handleRegisterProtocolHandlerRequested(
        **QWebEngineRegisterProtocolHandlerRequest**  request)
            {
        auto answer = **QMessageBox** ::question(window(), tr("Permission
        Request"),
                                                    tr("Allow %1 to
        open all %2 links?")
        .arg(request.origin().host())
        .arg(request.scheme()));
                if (answer == **QMessageBox** ::Yes)
        request.accept();
                else
                    request.reject();
            }

        This function was introduced in Qt 5.11.
        """
        ...

    @property
    def renderProcessPidChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#renderProcessPidChanged

        **[signal, since 5.15] void
        QWebEnginePage::renderProcessPidChanged(qint64 pid )**

        This signal is emitted when the underlying render process PID, **pid** ,
        changes.

        **Note:** Notifier signal for property **renderProcessPid** .

        This function was introduced in Qt 5.15.
        """
        ...

    @property
    def renderProcessTerminated(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#renderProcessTerminated

        **[signal, since 5.6] void QWebEnginePage::renderProcessTerminated(QWebE
        nginePage::RenderProcessTerminationStatus terminationStatus , int
        exitCode )**

        This signal is emitted when the render process is terminated with a non-
        zero exit status. **terminationStatus** is the termination status of the
        process and **exitCode** is the status code with which the process
        terminated.

        This function was introduced in Qt 5.6.
        """
        ...

    @property
    def scrollPositionChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def selectClientCertificate(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#selectClientCertificate

        **[signal, since 5.12] void QWebEnginePage::selectClientCertificate(QWeb
        EngineClientCertificateSelection clientCertificateSelection )**

        This signal is emitted when a web site requests an SSL client
        certificate, and one or more were found in system's client certificate
        store.

        Handling the signal is asynchronous, and loading will be waiting until a
        certificate is selected, or the last copy of
        **clientCertificateSelection** is destroyed.

        If the signal is not handled, **clientCertificateSelection** is
        automatically destroyed, and loading will continue without a client
        certificate.

        This function was introduced in Qt 5.12.

        **See also** **QWebEngineClientCertificateSelection** .
        """
        ...

    @property
    def selectionChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#selectionChanged

        **[signal] void QWebEnginePage::selectionChanged()**

        This signal is emitted whenever the selection changes, either
        interactively or programmatically. For example, by calling
        **triggerAction** () with a selection action.

        **Note:** When using the mouse to select text by left-clicking and
        dragging, the signal will be emitted for each new character selected,
        and not upon releasing the left mouse button.

        **See also** **selectedText** ().
        """
        ...

    @property
    def titleChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#titleChanged

        **[signal] void QWebEnginePage::titleChanged(const QString & title )**

        This signal is emitted whenever the title of the page changes. The
        **title** string specifies the new title.

        **See also** **title** ().
        """
        ...

    @property
    def urlChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#urlChanged

        **[signal] void QWebEnginePage::urlChanged(const QUrl & url )**

        This signal is emitted with the URL of the page when the page title is
        received. The new URL is specified by **url**.

        **See also** **url** ().
        """
        ...

    @property
    def visibleChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def windowCloseRequested(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qwebenginepage.html#windowCloseRequested

        **[signal] void QWebEnginePage::windowCloseRequested()**

        This signal is emitted whenever the page requests the web browser window
        to be closed, for example through the JavaScript `window.close()` call.

        **See also** **RequestClose** .
        """
        ...
