"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWebEngineCore, except for defaults which are replaced by "...".
"""
from enum import Enum
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtNetwork
import PySide6.QtWebChannel
import PySide6.QtWebEngineCore

bytes = str


class QWebEngineLoadingInfo(object):
    """
    https://doc.qt.io/qt-6/qwebengineloadinginfo.html

    **Detailed Description**

    Contains information about a web page loading status change, such as the URL
    and current loading status (started, succeeded, stopped, failed).

    **See also** **QWebEnginePage::loadStarted** ,
    **QWebEnginePage::loadFinished** , and **WebEngineView::loadingChanged** .
    """

    NoErrorDomain: QWebEngineLoadingInfo.ErrorDomain = ...
    InternalErrorDomain: QWebEngineLoadingInfo.ErrorDomain = ...
    ConnectionErrorDomain: QWebEngineLoadingInfo.ErrorDomain = ...
    CertificateErrorDomain: QWebEngineLoadingInfo.ErrorDomain = ...
    HttpErrorDomain: QWebEngineLoadingInfo.ErrorDomain = ...
    FtpErrorDomain: QWebEngineLoadingInfo.ErrorDomain = ...
    DnsErrorDomain: QWebEngineLoadingInfo.ErrorDomain = ...
    LoadStartedStatus: QWebEngineLoadingInfo.LoadStatus = ...
    LoadStoppedStatus: QWebEngineLoadingInfo.LoadStatus = ...
    LoadSucceededStatus: QWebEngineLoadingInfo.LoadStatus = ...
    LoadFailedStatus: QWebEngineLoadingInfo.LoadStatus = ...

    class ErrorDomain(Enum):
        NoErrorDomain: QWebEngineLoadingInfo.ErrorDomain = ...
        InternalErrorDomain: QWebEngineLoadingInfo.ErrorDomain = ...
        ConnectionErrorDomain: QWebEngineLoadingInfo.ErrorDomain = ...
        CertificateErrorDomain: QWebEngineLoadingInfo.ErrorDomain = ...
        HttpErrorDomain: QWebEngineLoadingInfo.ErrorDomain = ...
        FtpErrorDomain: QWebEngineLoadingInfo.ErrorDomain = ...
        DnsErrorDomain: QWebEngineLoadingInfo.ErrorDomain = ...

    class LoadStatus(Enum):
        LoadStartedStatus: QWebEngineLoadingInfo.LoadStatus = ...
        LoadStoppedStatus: QWebEngineLoadingInfo.LoadStatus = ...
        LoadSucceededStatus: QWebEngineLoadingInfo.LoadStatus = ...
        LoadFailedStatus: QWebEngineLoadingInfo.LoadStatus = ...

    def __init__(self, other: PySide6.QtWebEngineCore.QWebEngineLoadingInfo) -> None:
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def errorCode(self) -> int:
        """
        https://doc.qt.io/qt-6/qwebengineloadinginfo.html#errorCode-prop

        **[read-only] errorCode : const int**

        Holds the error code.

        **Access functions:**

        int **errorCode** () const
        """
        ...

    def errorDomain(self) -> PySide6.QtWebEngineCore.QWebEngineLoadingInfo.ErrorDomain:
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-6/qwebengineloadinginfo.html#errorString-prop

        **[read-only] errorString : const QString**

        Holds the error message.

        **Access functions:**

        QString **errorString** () const
        """
        ...

    def isErrorPage(self) -> bool:
        """
        https://doc.qt.io/qt-6/qwebengineloadinginfo.html#isErrorPage-prop

        **[read-only] isErrorPage : const bool**

        Indicates if the load resulted in an error page.

        **Access functions:**

        bool **isErrorPage** () const
        """
        ...

    def status(self) -> PySide6.QtWebEngineCore.QWebEngineLoadingInfo.LoadStatus:
        """
        https://doc.qt.io/qt-6/qwebengineloadinginfo.html#status-prop

        **[read-only] status : const LoadStatus**

        This property holds the load status of the page.

        **Access functions:**

        QWebEngineLoadingInfo::LoadStatus **status** () const
        """
        ...

    def url(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qwebengineloadinginfo.html#url

        **QUrl QWebEngineLoadingInfo::url() const**

        Returns the URL of the load request.

        **Note:** Getter function for property url.
        """
        ...
