"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtWebEngineCore, except for defaults which are replaced by "...".
"""
from typing import overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtNetwork
import PySide6.QtWebChannel
import PySide6.QtWebEngineCore

bytes = str


class QWebEngineFindTextResult(object):
    """
    https://doc.qt.io/qt-6/qwebenginefindtextresult.html

    **Detailed Description**

    The string search can be initiated by the **QWebEnginePage::findText** () or
    **WebEngineView.findText** () method. The results of the search are
    highlighted in the view. The details of this result are passed as a
    QWebEngineFindTextResult object that can be used to show a status message,
    such as "2 of 2 matches". For example:

    **QObject** ::connect(view.page(), &**QWebEnginePage** ::findTextFinished,
    [](const QWebEngineFindTextResult &result) {
            **qInfo** () <<
    result.activeMatch() << "of" << result.numberOfMatches() << "matches";
    });

    Results are passed to the user in the **QWebEnginePage::findTextFinished**
    () and **WebEngineView.findTextFinished** () signals.
    """

    @overload
    def __init__(self) -> None:
        ...

    @overload
    def __init__(self, other: PySide6.QtWebEngineCore.QWebEngineFindTextResult) -> None:
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def activeMatch(self) -> int:
        """
        https://doc.qt.io/qt-6/qwebenginefindtextresult.html#activeMatch-prop

        **[read-only] activeMatch : const int**

        This property holds the index of the currently highlighted match.

        **Access functions:**

        int **activeMatch** () const
        """
        ...

    def numberOfMatches(self) -> int:
        """
        https://doc.qt.io/qt-6/qwebenginefindtextresult.html#numberOfMatches-
        prop

        **[read-only] numberOfMatches : const int**

        This property holds the number of matches found.

        **Access functions:**

        int **numberOfMatches** () const
        """
        ...
