"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtTest, except for defaults which are replaced by "...".
"""
from typing import Any, List, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtTest

bytes = str


class QSignalSpy(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qsignalspy.html

    **Detailed Description**

    QSignalSpy can connect to any signal of any object and records its emission.
    QSignalSpy itself is a list of **QVariant**  lists. Each emission of the
    signal will append one item to the list, containing the arguments of the
    signal.

    The following example records all signal emissions for the `clicked()`
    signal of a **QCheckBox** :

    **QCheckBox**  *box = ...;
        **QSignalSpy**  spy(box,
    SIGNAL(clicked(bool)));

        // do something that triggers the signal
    box->animateClick();

        QCOMPARE(spy.count(), 1); // make sure the
    signal was emitted exactly one time
        **QList** <**QVariant** > arguments
    = spy.takeFirst(); // take the first signal
    QVERIFY(arguments.at(0).toBool() == true); // verify the first argument

    `spy.takeFirst()` returns the arguments for the first emitted signal, as a
    list of **QVariant**  objects. The `clicked()` signal has a single bool
    argument, which is stored as the first entry in the list of arguments.

    The example below catches a signal from a custom object:

    **QSignalSpy**  spy(myCustomObject, SIGNAL(mySignal(int,**QString**
    ,double)));

        myCustomObject->doSomething(); // trigger emission of
    the signal

        **QList** <**QVariant** > arguments = spy.takeFirst();
    QVERIFY(arguments.at(0).typeId() == **QMetaType** ::Int);
    QVERIFY(arguments.at(1).typeId() == **QMetaType** ::**QString** );
    QVERIFY(arguments.at(2).typeId() == **QMetaType** ::Double);

    **Note:** Non-standard data types need to be registered, using the
    **qRegisterMetaType** () function, before you can create a QSignalSpy. For
    example:

    **qRegisterMetaType** <SomeStruct>();
        **QSignalSpy**  spy(&model,
    SIGNAL(whatever(SomeStruct)));

    To retrieve the instance, you can use **qvariant_cast** :

    // get the first argument from the first received signal:
        SomeStruct
    result = qvariant_cast<SomeStruct>(spy.at(0).at(0));

    **Verifying Signal Emissions**

    The QSignalSpy class provides an elegant mechanism for capturing the list of
    signals emitted by an object. However, you should verify its validity after
    construction. The constructor does a number of sanity checks, such as
    verifying that the signal to be spied upon actually exists. To make the
    diagnosis of test failures easier, the results of these checks should be
    checked by calling `QVERIFY(spy.isValid())` before proceeding further with a
    test.

    **See also** **QVERIFY** ().
    """

    @overload
    def __init__(self, obj: PySide6.QtCore.QObject, aSignal: bytes) -> None:
        """
        https://doc.qt.io/qt-6/qsignalspy.html#QSignalSpy

        **QSignalSpy::QSignalSpy(const QObject * object , const char * signal
        )**

        Constructs a new QSignalSpy that listens for emissions of the **signal**
        from the **QObject**  **object**. If QSignalSpy is not able to listen
        for a valid signal (for example, because **object** is `nullptr` or
        **signal** does not denote a valid signal of **object** ), an
        explanatory warning message will be output using **qWarning** () and
        subsequent calls to `isValid()` will return false.

        Example:

        QSignalSpy spy(myPushButton, SIGNAL(clicked(bool)));
        """
        ...

    @overload
    def __init__(
        self, obj: PySide6.QtCore.QObject, signal: PySide6.QtCore.QMetaMethod
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsignalspy.html#QSignalSpy-1

        **[since 5.4] template <typename PointerToMemberFunction>
        QSignalSpy::QSignalSpy(const QObject * object , PointerToMemberFunction
        signal )**

        Constructs a new QSignalSpy that listens for emissions of the **signal**
        from the **QObject**  **object**. If QSignalSpy is not able to listen
        for a valid signal (for example, because **object** is `nullptr` or
        **signal** does not denote a valid signal of **object** ), an
        explanatory warning message will be output using **qWarning** () and
        subsequent calls to `isValid()` will return false.

        Example:

        **QSignalSpy**  spy(myPushButton, &**QPushButton** ::clicked);

        This function was introduced in Qt 5.4.
        """
        ...

    @overload
    def __init__(self, signal: PySide6.QtCore.SignalInstance) -> None:
        """
        https://doc.qt.io/qt-6/qsignalspy.html#QSignalSpy-2

        **[since 5.14] QSignalSpy::QSignalSpy(const QObject * obj , const
        QMetaMethod & signal )**

        Constructs a new QSignalSpy that listens for emissions of the **signal**
        from the **QObject**  **obj**. If QSignalSpy is not able to listen for a
        valid signal (for example, because **obj** is `nullptr` or **signal**
        does not denote a valid signal of **obj** ), an explanatory warning
        message will be output using **qWarning** () and subsequent calls to
        `isValid()` will return false.

        This constructor is convenient to use when Qt's meta-object system is
        heavily used in a test.

        Basic usage example:

        **QObject**  object;
            auto mo = object.metaObject();
            auto
        signalIndex = mo->indexOfSignal("objectNameChanged(QString)");
            auto
        signal = mo->method(signalIndex);

            **QSignalSpy**  spy(&object,
        signal);
            object.setObjectName("A new object name");
        QCOMPARE(spy.count(), 1);

        Imagine we need to check whether all properties of the **QWindow**
        class that represent minimum and maximum dimensions are properly
        writable. The following example demonstrates one of the approaches:

        void tst_QWindow::writeMinMaxDimensionalProps_data()
        QTest::addColumn<int>("propertyIndex");

                // Collect all
        relevant properties
                static const auto mo = **QWindow**
        ::staticMetaObject;
                for (int i = mo.propertyOffset(); i <
        mo.propertyCount(); ++i) {
                    auto property = mo.property(i);
        // ...that have type int
                    if (property.type() == **QVariant**
        ::Int) {
                        static const **QRegularExpression**
        re("^minimum|maximum");
                        const auto name =
        property.name();

                        // ...and start with "minimum" or
        "maximum"
                        if (re.match(name).hasMatch()) {
        QTest::addRow("%s", name) << i;
                        }
                    }
        }
            }

            void tst_QWindow::writeMinMaxDimensionalProps()
            {
        QFETCH(int, propertyIndex);

                auto property = **QWindow**
        ::staticMetaObject.property(propertyIndex);
        QVERIFY(property.isWritable());
        QVERIFY(property.hasNotifySignal());

                **QWindow**  window;
        **QSignalSpy**  spy(&window, property.notifySignal());
        QVERIFY(property.write(&window, 42));
                QCOMPARE(spy.count(), 1);
        }

        This function was introduced in Qt 5.14.
        """
        ...

    def at(self, arg__1: int) -> List[Any]:
        ...

    def count(self) -> int:
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsignalspy.html#isValid

        **bool QSignalSpy::isValid() const**

        Returns `true` if the signal spy listens to a valid signal, otherwise
        false.
        """
        ...

    def signal(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qsignalspy.html#signal

        **QByteArray QSignalSpy::signal() const**

        Returns the normalized signal the spy is currently listening to.
        """
        ...

    def size(self) -> int:
        ...

    def wait(self, timeout: int = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qsignalspy.html#wait

        **[since 5.0] bool QSignalSpy::wait(int timeout = 5000)**

        Starts an event loop that runs until the given signal is received.
        Optionally the event loop can return earlier on a **timeout** (in
        milliseconds).

        Returns `true` if the signal was emitted at least once in **timeout**
        milliseconds, otherwise returns `false`.

        Example:

        QVERIFY(spy.wait(1000));

        This function was introduced in Qt 5.0.
        """
        ...
