"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtSvg, except for defaults which are replaced by "...".
"""
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtSvg

bytes = str


class QSvgGenerator(PySide6.QtGui.QPaintDevice):
    """
    https://doc.qt.io/qt-6/qsvggenerator.html

    **Detailed Description**

    This paint device represents a Scalable Vector Graphics (SVG) drawing. Like
    QPrinter, it is designed as a write-only device that generates output in a
    specific format.

    To write an SVG file, you first need to configure the output by setting the
    **fileName**  or **outputDevice**  properties. It is usually necessary to
    specify the size of the drawing by setting the **size**  property, and in
    some cases where the drawing will be included in another, the **viewBox**
    property also needs to be set.

    **QSvgGenerator**  generator;
            generator.setFileName(path);
    generator.setSize(**QSize** (200, 200));
    generator.setViewBox(**QRect** (0, 0, 200, 200));
    generator.setTitle(tr("SVG Generator Example Drawing"));
    generator.setDescription(tr("An SVG drawing created by the SVG Generator "
    "Example provided with Qt."));

    Other meta-data can be specified by setting the **title** , **description**
    and **resolution** properties.

    As with other **QPaintDevice**  subclasses, a **QPainter**  object is used
    to paint onto an instance of this class:

    **QPainter**  painter;
            painter.begin(&generator);
            ...
    painter.end();

    Painting is performed in the same way as for any other paint device.
    However, it is necessary to use the **QPainter::begin** () and **end** () to
    explicitly begin and end painting on the device.

    The **SVG Generator Example**  shows how the same painting commands can be
    used for painting a widget and writing an SVG file.

    **See also** **QSvgRenderer** , **QSvgWidget** , and **Qt SVG C++ Classes**
    .
    """

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qsvggenerator.html#QSvgGenerator

        **QSvgGenerator::QSvgGenerator()**

        Constructs a new generator.
        """
        ...

    def description(self) -> str:
        """
        https://doc.qt.io/qt-6/qsvggenerator.html#description-prop

        **description : QString**

        This property holds the description of the generated SVG drawing

        **Access functions:**

        QString **description** () const
        void **setDescription** (const
        QString & **description** )

        **See also** **title** .
        """
        ...

    def fileName(self) -> str:
        """
        https://doc.qt.io/qt-6/qsvggenerator.html#fileName-prop

        **fileName : QString**

        This property holds the target filename for the generated SVG drawing

        **Access functions:**

        QString **fileName** () const
        void **setFileName** (const QString &
        **fileName** )

        **See also** **outputDevice** .
        """
        ...

    def metric(self, metric: PySide6.QtGui.QPaintDevice.PaintDeviceMetric) -> int:
        """
        https://doc.qt.io/qt-6/qsvggenerator.html#metric

        **[override virtual protected] int
        QSvgGenerator::metric(QPaintDevice::PaintDeviceMetric metric ) const**

        Reimplements: **QPaintDevice::metric(QPaintDevice::PaintDeviceMetric
        metric) const** .
        """
        ...

    def outputDevice(self) -> PySide6.QtCore.QIODevice:
        """
        https://doc.qt.io/qt-6/qsvggenerator.html#outputDevice-prop

        **outputDevice : QIODevice***

        This property holds the output device for the generated SVG drawing

        If both output device and file name are specified, the output device
        will have precedence.

        **Access functions:**

        QIODevice * **outputDevice** () const
        void **setOutputDevice**
        (QIODevice * **outputDevice** )

        **See also** **fileName** .
        """
        ...

    def paintEngine(self) -> PySide6.QtGui.QPaintEngine:
        """
        https://doc.qt.io/qt-6/qsvggenerator.html#paintEngine

        **[override virtual protected] QPaintEngine
        *QSvgGenerator::paintEngine() const**

        Reimplements: **QPaintDevice::paintEngine() const** .

        Returns the paint engine used to render graphics to be converted to SVG
        format information.
        """
        ...

    def resolution(self) -> int:
        """
        https://doc.qt.io/qt-6/qsvggenerator.html#resolution-prop

        **resolution : int**

        This property holds the resolution of the generated output

        The resolution is specified in dots per inch, and is used to calculate
        the physical size of an SVG drawing.

        **Access functions:**

        int **resolution** () const
        void **setResolution** (int **dpi** )

        **See also** **size**  and **viewBox** .
        """
        ...

    def setDescription(self, description: str) -> None:
        """
        https://doc.qt.io/qt-6/qsvggenerator.html#description-prop

        **description : QString**

        This property holds the description of the generated SVG drawing

        **Access functions:**

        QString **description** () const
        void **setDescription** (const
        QString & **description** )

        **See also** **title** .
        """
        ...

    def setFileName(self, fileName: str) -> None:
        """
        https://doc.qt.io/qt-6/qsvggenerator.html#fileName-prop

        **fileName : QString**

        This property holds the target filename for the generated SVG drawing

        **Access functions:**

        QString **fileName** () const
        void **setFileName** (const QString &
        **fileName** )

        **See also** **outputDevice** .
        """
        ...

    def setOutputDevice(self, outputDevice: PySide6.QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-6/qsvggenerator.html#outputDevice-prop

        **outputDevice : QIODevice***

        This property holds the output device for the generated SVG drawing

        If both output device and file name are specified, the output device
        will have precedence.

        **Access functions:**

        QIODevice * **outputDevice** () const
        void **setOutputDevice**
        (QIODevice * **outputDevice** )

        **See also** **fileName** .
        """
        ...

    def setResolution(self, dpi: int) -> None:
        """
        https://doc.qt.io/qt-6/qsvggenerator.html#resolution-prop

        **resolution : int**

        This property holds the resolution of the generated output

        The resolution is specified in dots per inch, and is used to calculate
        the physical size of an SVG drawing.

        **Access functions:**

        int **resolution** () const
        void **setResolution** (int **dpi** )

        **See also** **size**  and **viewBox** .
        """
        ...

    def setSize(self, size: PySide6.QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-6/qsvggenerator.html#size-prop

        **size : QSize**

        This property holds the size of the generated SVG drawing

        By default this property is set to `QSize(-1, -1)`, which indicates that
        the generator should not output the width and height attributes of the
        `<svg>` element.

        **Note:** It is not possible to change this property while a
        **QPainter**  is active on the generator.

        **Access functions:**

        QSize **size** () const
        void **setSize** (const QSize & **size** )

        **See also** **viewBox**  and **resolution** .
        """
        ...

    def setTitle(self, title: str) -> None:
        """
        https://doc.qt.io/qt-6/qsvggenerator.html#title-prop

        **title : QString**

        This property holds the title of the generated SVG drawing

        **Access functions:**

        QString **title** () const
        void **setTitle** (const QString &
        **title** )

        **See also** **description** .
        """
        ...

    @overload
    def setViewBox(self, viewBox: PySide6.QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-6/qsvggenerator.html#viewBox

        **QRect QSvgGenerator::viewBox() const**

        Returns **viewBoxF** ().toRect().

        **See also** **setViewBox** () and **viewBoxF** ().
        """
        ...

    @overload
    def setViewBox(
        self, viewBox: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsvggenerator.html#viewBox-prop

        **viewBox : QRectF**

        This property holds the viewBox of the generated SVG drawing

        By default this property is set to `QRect(0, 0, -1, -1)`, which
        indicates that the generator should not output the viewBox attribute of
        the `<svg>` element.

        **Note:** It is not possible to change this property while a
        **QPainter**  is active on the generator.

        **Access functions:**

        QRectF **viewBoxF** () const
        void **setViewBox** (const QRect &
        **viewBox** )
        void **setViewBox** (const QRectF & **viewBox** )

        **See also** **viewBox** (), **size** , and **resolution** .

        **Member Function Documentation**
        """
        ...

    def size(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qsvggenerator.html#size-prop

        **size : QSize**

        This property holds the size of the generated SVG drawing

        By default this property is set to `QSize(-1, -1)`, which indicates that
        the generator should not output the width and height attributes of the
        `<svg>` element.

        **Note:** It is not possible to change this property while a
        **QPainter**  is active on the generator.

        **Access functions:**

        QSize **size** () const
        void **setSize** (const QSize & **size** )

        **See also** **viewBox**  and **resolution** .
        """
        ...

    def title(self) -> str:
        """
        https://doc.qt.io/qt-6/qsvggenerator.html#title-prop

        **title : QString**

        This property holds the title of the generated SVG drawing

        **Access functions:**

        QString **title** () const
        void **setTitle** (const QString &
        **title** )

        **See also** **description** .
        """
        ...

    def viewBox(self) -> PySide6.QtCore.QRect:
        """
        https://doc.qt.io/qt-6/qsvggenerator.html#viewBox

        **QRect QSvgGenerator::viewBox() const**

        Returns **viewBoxF** ().toRect().

        **See also** **setViewBox** () and **viewBoxF** ().
        """
        ...

    def viewBoxF(self) -> PySide6.QtCore.QRectF:
        ...
