"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtStateMachine, except for defaults which are replaced by "...".
"""
from typing import Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtStateMachine

bytes = str


class QSignalTransition(PySide6.QtStateMachine.QAbstractTransition):
    """
    https://doc.qt.io/qt-6/qsignaltransition.html

    **Detailed Description**

    Typically you would use the overload of **QState::addTransition** () that
    takes a sender and signal as arguments, rather than creating
    QSignalTransition objects directly. QSignalTransition is part of **Qt State
    Machine Framework** .

    You can subclass QSignalTransition and reimplement **eventTest** () to make
    a signal transition conditional; the event object passed to **eventTest** ()
    will be a **QStateMachine::SignalEvent**  object. Example:

    class CheckedTransition : public **QSignalTransition**
        {
        public:
    CheckedTransition(**QCheckBox**  *check)
                : **QSignalTransition**
    (check, SIGNAL(stateChanged(int))) {}
        protected:
            bool
    eventTest(**QEvent**  *e) {
                if (!**QSignalTransition**
    ::eventTest(e))
                    return false;
                **QStateMachine**
    ::SignalEvent *se = static_cast<**QStateMachine** ::SignalEvent*>(e);
    return (se->arguments().at(0).toInt() == Qt::Checked);
            }
        };
    ...

        **QCheckBox**  *check = new **QCheckBox** ();
    check->setTristate(true);

        **QState**  *s1 = new **QState** ();
    **QState**  *s2 = new **QState** ();
        CheckedTransition *t1 = new
    CheckedTransition(check);
        t1->setTargetState(s2);
    s1->addTransition(t1);
    """

    @overload
    def __init__(
        self, arg__1: object, arg__2: Optional[PySide6.QtStateMachine.QState] = ...
    ) -> PySide6.QtStateMachine.QSignalTransition:
        """
        https://doc.qt.io/qt-6/qsignaltransition.html#QSignalTransition

        **QSignalTransition::QSignalTransition(QState * sourceState = nullptr)**

        Constructs a new signal transition with the given **sourceState**.
        """
        ...

    @overload
    def __init__(
        self,
        sender: PySide6.QtCore.QObject,
        signal: bytes,
        sourceState: Optional[PySide6.QtStateMachine.QState] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsignaltransition.html#QSignalTransition-1

        **QSignalTransition::QSignalTransition(const QObject * sender , const
        char * signal , QState * sourceState = nullptr)**

        Constructs a new signal transition associated with the given **signal**
        of the given **sender** , and with the given **sourceState**.
        """
        ...

    @overload
    def __init__(
        self, sourceState: Optional[PySide6.QtStateMachine.QState] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsignaltransition.html#QSignalTransition-2

        **[since 5.7] template <typename PointerToMemberFunction>
        QSignalTransition::QSignalTransition(const QObject * sender ,
        PointerToMemberFunction signal , QState * sourceState = nullptr)**

        This is an overloaded function.

        Constructs a new signal transition associated with the given **signal**
        of the given **sender** object and with the given **sourceState**. This
        constructor is enabled if the compiler supports delegating constructors,
        as indicated by the presence of the macro
        Q_COMPILER_DELEGATING_CONSTRUCTORS.

        This function was introduced in Qt 5.7.
        """
        ...

    def event(self, e: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qsignaltransition.html#event

        **[override virtual protected] bool QSignalTransition::event(QEvent * e
        )**

        Reimplements: **QAbstractTransition::event** (QEvent *e).
        """
        ...

    def eventTest(self, event: PySide6.QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-6/qsignaltransition.html#eventTest

        **[override virtual protected] bool QSignalTransition::eventTest(QEvent
        * event )**

        Reimplements: **QAbstractTransition::eventTest** (QEvent *event).

        The default implementation returns `true` if the **event** is a
        **QStateMachine::SignalEvent**  object and the event's sender and signal
        index match this transition, and returns `false` otherwise.
        """
        ...

    def onTransition(self, event: PySide6.QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qsignaltransition.html#onTransition

        **[override virtual protected] void
        QSignalTransition::onTransition(QEvent * event )**

        Reimplements: **QAbstractTransition::onTransition** (QEvent *event).
        """
        ...

    def senderObject(self) -> PySide6.QtCore.QObject:
        """
        https://doc.qt.io/qt-6/qsignaltransition.html#senderObject

        **const QObject *QSignalTransition::senderObject() const**

        Returns the sender object associated with this signal transition.

        **Note:** Getter function for property senderObject.

        **See also** **setSenderObject** ().
        """
        ...

    def setSenderObject(self, sender: PySide6.QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-6/qsignaltransition.html#setSenderObject

        **void QSignalTransition::setSenderObject(const QObject * sender )**

        Sets the **sender** object associated with this signal transition.

        **Note:** Setter function for property **senderObject** .

        **See also** **senderObject** ().
        """
        ...

    def setSignal(self, signal: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qsignaltransition.html#setSignal

        **void QSignalTransition::setSignal(const QByteArray & signal )**

        Sets the **signal** associated with this signal transition.

        **Note:** Setter function for property **signal** .

        **See also** **signal** ().
        """
        ...

    def signal(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qsignaltransition.html#signal

        **QByteArray QSignalTransition::signal() const**

        Returns the signal associated with this signal transition.

        **Note:** Getter function for property signal.

        **See also** **setSignal** ().
        """
        ...

    @property
    def senderObjectChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsignaltransition.html#senderObjectChanged

        **[private signal, since 5.4] void
        QSignalTransition::senderObjectChanged()**

        This signal is emitted when the **senderObject**  property is changed.

        **Note:** This is a private signal. It can be used in signal connections
        but cannot be emitted by the user.

        **Note:** Notifier signal for property **senderObject** .

        This function was introduced in Qt 5.4.

        **See also** **QSignalTransition::senderObject** .
        """
        ...

    @property
    def signalChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsignaltransition.html#signalChanged

        **[private signal, since 5.4] void QSignalTransition::signalChanged()**

        This signal is emitted when the signal property is changed.

        **Note:** This is a private signal. It can be used in signal connections
        but cannot be emitted by the user.

        **Note:** Notifier signal for property **signal** .

        This function was introduced in Qt 5.4.

        **See also** **QSignalTransition::signal** .
        """
        ...
