"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtSql, except for defaults which are replaced by "...".
"""
from typing import Any, Dict, Optional, Union, overload
import PySide6.QtCore
import PySide6.QtWidgets
import PySide6.QtSql

bytes = str


class QSqlQueryModel(PySide6.QtCore.QAbstractTableModel):
    """
    https://doc.qt.io/qt-6/qsqlquerymodel.html

    **Detailed Description**

    QSqlQueryModel is a high-level interface for executing SQL statements and
    traversing the result set. It is built on top of the lower-level
    **QSqlQuery**  and can be used to provide data to view classes such as
    **QTableView** . For example:

    **QSqlQueryModel**  *model = new **QSqlQueryModel** ;
    model->setQuery("SELECT name, salary FROM employee");
    model->setHeaderData(0, Qt::Horizontal, tr("Name"));
    model->setHeaderData(1, Qt::Horizontal, tr("Salary"));
    **QTableView**  *view = new **QTableView** ;
            view->setModel(model);
    view->show();

    We set the model's query, then we set up the labels displayed in the view
    header.

    QSqlQueryModel can also be used to access a database programmatically,
    without binding it to a view:

    **QSqlQueryModel**  model;
            model.setQuery("SELECT name, salary FROM
    employee");
            int salary = model.record(4).value("salary").toInt();

    The code snippet above extracts the `salary` field from record 4 in the
    result set of the `SELECT` query. Since `salary` is the 2nd column (or
    column index 1), we can rewrite the last line as follows:

    int salary = model.data(model.index(4, 1)).toInt();

    The model is read-only by default. To make it read-write, you must subclass
    it and reimplement **setData** () and **flags** (). Another option is to use
    **QSqlTableModel** , which provides a read-write model based on a single
    database table.

    The **querymodel**  example illustrates how to use QSqlQueryModel to display
    the result of a query. It also shows how to subclass QSqlQueryModel to
    customize the contents of the data before showing it to the user, and how to
    create a read-write model based on QSqlQueryModel.

    If the database doesn't return the number of selected rows in a query, the
    model will fetch rows incrementally. See **fetchMore** () for more
    information.

    **See also** **QSqlTableModel** , **QSqlRelationalTableModel** ,
    **QSqlQuery** , **Model/View Programming** , and **Query Model Example** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qsqlquerymodel.html#QSqlQueryModel

        **QSqlQueryModel::QSqlQueryModel(QObject * parent = nullptr)**

        Creates an empty QSqlQueryModel with the given **parent**.
        """
        ...

    def beginInsertColumns(
        self,
        parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        first: int,
        last: int,
    ) -> None:
        ...

    def beginInsertRows(
        self,
        parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        first: int,
        last: int,
    ) -> None:
        ...

    def beginRemoveColumns(
        self,
        parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        first: int,
        last: int,
    ) -> None:
        ...

    def beginRemoveRows(
        self,
        parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        first: int,
        last: int,
    ) -> None:
        ...

    def beginResetModel(self) -> None:
        ...

    def canFetchMore(
        self,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlquerymodel.html#canFetchMore

        **[override virtual] bool QSqlQueryModel::canFetchMore(const QModelIndex
        & parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::canFetchMore(const QModelIndex
        &parent) const** .

        Returns `true` if it is possible to read more rows from the database.
        This only affects databases that don't report back the size of a query
        (see **QSqlDriver::hasFeature** ()).

        **parent** should always be an invalid **QModelIndex** .

        **See also** **fetchMore** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qsqlquerymodel.html#clear

        **[virtual] void QSqlQueryModel::clear()**

        Clears the model and releases any acquired resource.
        """
        ...

    def columnCount(
        self,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> int:
        """
        https://doc.qt.io/qt-6/qsqlquerymodel.html#columnCount

        **[override virtual] int QSqlQueryModel::columnCount(const QModelIndex &
        index = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::columnCount(const QModelIndex
        &parent) const** .
        """
        ...

    def data(
        self,
        item: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
        role: int = ...,
    ) -> Any:
        """
        https://doc.qt.io/qt-6/qsqlquerymodel.html#data

        **[override virtual] QVariant QSqlQueryModel::data(const QModelIndex &
        item , int role = Qt::DisplayRole) const**

        Reimplements: **QAbstractItemModel::data(const QModelIndex &index, int
        role) const** .

        Returns the value for the specified **item** and **role**.

        If **item** is out of bounds or if an error occurred, an invalid
        **QVariant**  is returned.

        **See also** **lastError** ().
        """
        ...

    def endInsertColumns(self) -> None:
        ...

    def endInsertRows(self) -> None:
        ...

    def endRemoveColumns(self) -> None:
        ...

    def endRemoveRows(self) -> None:
        ...

    def endResetModel(self) -> None:
        ...

    def fetchMore(
        self,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsqlquerymodel.html#fetchMore

        **[override virtual] void QSqlQueryModel::fetchMore(const QModelIndex &
        parent = QModelIndex())**

        Reimplements: **QAbstractItemModel::fetchMore** (const QModelIndex
        &parent).

        Fetches more rows from a database. This only affects databases that
        don't report back the size of a query (see **QSqlDriver::hasFeature**
        ()).

        To force fetching of the entire result set, you can use the following:

        while (myModel->canFetchMore())
                myModel->fetchMore();

        **parent** should always be an invalid **QModelIndex** .

        **See also** **canFetchMore** ().
        """
        ...

    def headerData(
        self, section: int, orientation: PySide6.QtCore.Qt.Orientation, role: int = ...
    ) -> Any:
        """
        https://doc.qt.io/qt-6/qsqlquerymodel.html#headerData

        **[override virtual] QVariant QSqlQueryModel::headerData(int section ,
        Qt::Orientation orientation , int role = Qt::DisplayRole) const**

        Reimplements: **QAbstractItemModel::headerData(int section,
        Qt::Orientation orientation, int role) const** .

        Returns the header data for the given **role** in the **section** of the
        header with the specified **orientation**.

        **See also** **setHeaderData** ().
        """
        ...

    def indexInQuery(
        self,
        item: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],
    ) -> PySide6.QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-6/qsqlquerymodel.html#indexInQuery

        **[virtual protected] QModelIndex QSqlQueryModel::indexInQuery(const
        QModelIndex & item ) const**

        Returns the index of the value in the database result set for the given
        **item** in the model.

        The return value is identical to **item** if no columns or rows have
        been inserted, removed, or moved around.

        Returns an invalid model index if **item** is out of bounds or if
        **item** does not point to a value in the result set.

        **See also** **QSqlTableModel::indexInQuery** (), **insertColumns** (),
        and **removeColumns** ().
        """
        ...

    def insertColumns(
        self,
        column: int,
        count: int,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlquerymodel.html#insertColumns

        **[override virtual] bool QSqlQueryModel::insertColumns(int column , int
        count , const QModelIndex & parent = QModelIndex())**

        Reimplements: **QAbstractItemModel::insertColumns** (int column, int
        count, const QModelIndex &parent).

        Inserts **count** columns into the model at position **column**. The
        **parent** parameter must always be an invalid **QModelIndex** , since
        the model does not support parent-child relationships.

        Returns `true` if **column** is within bounds; otherwise returns
        `false`.

        By default, inserted columns are empty. To fill them with data,
        reimplement **data** () and handle any inserted column separately:

        **QVariant**  MyModel::data(const **QModelIndex**  &item, int role)
        const
            {
                if (item.column() == m_specialColumnNo) {
        // handle column separately
                }
                return **QSqlQueryModel**
        ::data(item, role);
            }

        **See also** **removeColumns** ().
        """
        ...

    def lastError(self) -> PySide6.QtSql.QSqlError:
        """
        https://doc.qt.io/qt-6/qsqlquerymodel.html#lastError

        **QSqlError QSqlQueryModel::lastError() const**

        Returns information about the last error that occurred on the database.

        **See also** **setLastError** () and **query** ().
        """
        ...

    def query(self) -> PySide6.QtSql.QSqlQuery:
        """
        https://doc.qt.io/qt-6/qsqlquerymodel.html#query

        **QSqlQuery QSqlQueryModel::query() const**

        Returns the **QSqlQuery**  associated with this model.

        **See also** **setQuery** ().
        """
        ...

    def queryChange(self) -> None:
        """
        https://doc.qt.io/qt-6/qsqlquerymodel.html#queryChange

        **[virtual protected] void QSqlQueryModel::queryChange()**

        This virtual function is called whenever the query changes. The default
        implementation does nothing.

        **query** () returns the new query.

        **See also** **query** () and **setQuery** ().
        """
        ...

    @overload
    def record(self) -> PySide6.QtSql.QSqlRecord:
        """
        https://doc.qt.io/qt-6/qsqlquerymodel.html#record

        **QSqlRecord QSqlQueryModel::record(int row ) const**

        Returns the record containing information about the fields of the
        current query. If **row** is the index of a valid row, the record will
        be populated with values from that row.

        If the model is not initialized, an empty record will be returned.

        **See also** **QSqlRecord::isEmpty** ().
        """
        ...

    @overload
    def record(self, row: int) -> PySide6.QtSql.QSqlRecord:
        """
        https://doc.qt.io/qt-6/qsqlquerymodel.html#record-1

        **QSqlRecord QSqlQueryModel::record() const**

        This is an overloaded function.

        Returns an empty record containing information about the fields of the
        current query.

        If the model is not initialized, an empty record will be returned.

        **See also** **QSqlRecord::isEmpty** ().
        """
        ...

    def removeColumns(
        self,
        column: int,
        count: int,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlquerymodel.html#removeColumns

        **[override virtual] bool QSqlQueryModel::removeColumns(int column , int
        count , const QModelIndex & parent = QModelIndex())**

        Reimplements: **QAbstractItemModel::removeColumns** (int column, int
        count, const QModelIndex &parent).

        Removes **count** columns from the model starting from position
        **column**. The **parent** parameter must always be an invalid
        **QModelIndex** , since the model does not support parent-child
        relationships.

        Removing columns effectively hides them. It does not affect the
        underlying **QSqlQuery** .

        Returns `true` if the columns were removed; otherwise returns `false`.
        """
        ...

    def roleNames(self) -> Dict[int, PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qsqlquerymodel.html#roleNames

        **[override virtual, since 5.10] QHash<int, QByteArray>
        QSqlQueryModel::roleNames() const**

        Reimplements: **QAbstractItemModel::roleNames() const** .

        Returns the model's role names.

        Qt defines only one role for the **QSqlQueryModel** :

        Qt RoleQML Role Name
        **Qt::DisplayRole** display

        This function was introduced in Qt 5.10.
        """
        ...

    def rowCount(
        self,
        parent: Union[
            PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex
        ] = ...,
    ) -> int:
        """
        https://doc.qt.io/qt-6/qsqlquerymodel.html#rowCount

        **[override virtual] int QSqlQueryModel::rowCount(const QModelIndex &
        parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::rowCount(const QModelIndex &parent)
        const** .

        If the database supports returning the size of a query (see
        **QSqlDriver::hasFeature** ()), the number of rows of the current query
        is returned. Otherwise, returns the number of rows currently cached on
        the client.

        **parent** should always be an invalid **QModelIndex** .

        **See also** **canFetchMore** () and **QSqlDriver::hasFeature** ().
        """
        ...

    def setHeaderData(
        self,
        section: int,
        orientation: PySide6.QtCore.Qt.Orientation,
        value: Any,
        role: int = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlquerymodel.html#setHeaderData

        **[override virtual] bool QSqlQueryModel::setHeaderData(int section ,
        Qt::Orientation orientation , const QVariant & value , int role =
        Qt::EditRole)**

        Reimplements: **QAbstractItemModel::setHeaderData** (int section,
        Qt::Orientation orientation, const QVariant &value, int role).

        Sets the caption for a horizontal header for the specified **role** to
        **value**. This is useful if the model is used to display data in a view
        (e.g., **QTableView** ).

        Returns `true` if **orientation** is **Qt::Horizontal**  and the
        **section** refers to a valid section; otherwise returns false.

        Note that this function cannot be used to modify values in the database
        since the model is read-only.

        **See also** **headerData** () and **data** ().
        """
        ...

    def setLastError(self, error: PySide6.QtSql.QSqlError) -> None:
        """
        https://doc.qt.io/qt-6/qsqlquerymodel.html#setLastError

        **[protected] void QSqlQueryModel::setLastError(const QSqlError & error
        )**

        Protected function which allows derived classes to set the value of the
        last error that occurred on the database to **error**.

        **See also** **lastError** ().
        """
        ...

    @overload
    def setQuery(self, query: PySide6.QtSql.QSqlQuery) -> None:
        """
        https://doc.qt.io/qt-6/qsqlquerymodel.html#setQuery

        **[since 6.2] void QSqlQueryModel::setQuery(QSqlQuery && query )**

        Resets the model and sets the data provider to be the given **query**.
        Note that the query must be active and must not be isForwardOnly().

        **lastError** () can be used to retrieve verbose information if there
        was an error setting the query.

        **Note:** Calling setQuery() will remove any inserted columns.

        This function was introduced in Qt 6.2.

        **See also** **query** (), **QSqlQuery::isActive** (),
        **QSqlQuery::setForwardOnly** (), and **lastError** ().
        """
        ...

    @overload
    def setQuery(self, query: str, db: PySide6.QtSql.QSqlDatabase = ...) -> None:
        """
        https://doc.qt.io/qt-6/qsqlquerymodel.html#setQuery-2

        **void QSqlQueryModel::setQuery(const QString & query , const
        QSqlDatabase & db = QSqlDatabase())**

        This is an overloaded function.

        Executes the query **query** for the given database connection **db**.
        If no database (or an invalid database) is specified, the default
        connection is used.

        **lastError** () can be used to retrieve verbose information if there
        was an error setting the query.

        Example:

        **QSqlQueryModel**  model;
            model.setQuery("select * from MyTable");
        if (model.lastError().isValid())
                **qDebug** () <<
        model.lastError();

        **See also** **query** (), **queryChange** (), and **lastError** ().
        """
        ...
