"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtSql, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, overload
import PySide6.QtCore
import PySide6.QtWidgets
import PySide6.QtSql

bytes = str


class QSqlField(object):
    """
    https://doc.qt.io/qt-6/qsqlfield.html

    **Detailed Description**

    QSqlField represents the characteristics of a single column in a database
    table or view, such as the data type and column name. A field also contains
    the value of the database column, which can be viewed or changed.

    Field data values are stored as QVariants. Using an incompatible type is not
    permitted. For example:

    **QSqlField**  field("age", **QMetaType** ::fromType<int>());
    field.setValue(QPixmap());  // WRONG

    However, the field will attempt to cast certain data types to the field data
    type where possible:

    **QSqlField**  field("age", **QMetaType** ::fromType<int>());
    field.setValue(**QString** ("123"));  // casts QString to int

    QSqlField objects are rarely created explicitly in application code. They
    are usually accessed indirectly through **QSqlRecord** s that already
    contain a list of fields. For example:

    **QSqlQuery**  query;
            ...
            **QSqlRecord**  record =
    query.record();
            **QSqlField**  field = record.field("country");

    A QSqlField object can provide some meta-data about the field, for example,
    its **name** (), variant type(), **length** (), **precision** (),
    **defaultValue** (), typeID(), and its **requiredStatus** (),
    **isGenerated** () and **isReadOnly** (). The field's data can be checked to
    see if it **isNull** (), and its **value** () retrieved. When editing the
    data can be set with **setValue** () or set to NULL with **clear** ().

    **See also** **QSqlRecord** .
    """

    Unknown: QSqlField.RequiredStatus = ...
    Optional: QSqlField.RequiredStatus = ...
    Required: QSqlField.RequiredStatus = ...

    class RequiredStatus(Enum):
        Unknown: QSqlField.RequiredStatus = ...
        Optional: QSqlField.RequiredStatus = ...
        Required: QSqlField.RequiredStatus = ...

    @overload
    def __init__(
        self,
        fieldName: str = ...,
        type: PySide6.QtCore.QMetaType = ...,
        tableName: str = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#QSqlField

        **QSqlField::QSqlField(const QSqlField & other )**

        Constructs a copy of **other**.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtSql.QSqlField) -> None:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#QSqlField-1

        **[since 6.0] QSqlField::QSqlField(const QString & fieldName =
        QString(), QMetaType type = QMetaType(), const QString & table =
        QString())**

        This is an overloaded function.

        Constructs an empty field called **fieldName** of type **type** in
        **table**.

        This function was introduced in Qt 6.0.

        **See also** **setRequiredStatus** (), **setLength** (),
        **setPrecision** (), **setDefaultValue** (), **setGenerated** (), and
        **setReadOnly** ().
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#clear

        **void QSqlField::clear()**

        Clears the value of the field and sets it to NULL. If the field is read-
        only, nothing happens.

        **See also** **setValue** (), **isReadOnly** (), and **requiredStatus**
        ().
        """
        ...

    def defaultValue(self) -> Any:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#defaultValue

        **QVariant QSqlField::defaultValue() const**

        Returns the field's default value (which may be NULL).

        **See also** **setDefaultValue** (), **metaType** (), **requiredStatus**
        (), **length** (), **precision** (), and **isGenerated** ().
        """
        ...

    def isAutoValue(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#isAutoValue

        **bool QSqlField::isAutoValue() const**

        Returns `true` if the value is auto-generated by the database, for
        example auto-increment primary key values.

        **Note:** When using the ODBC driver, due to limitations in the ODBC
        API, the `isAutoValue()` field is only populated in a **QSqlField**
        resulting from a **QSqlRecord**  obtained by executing a `SELECT` query.
        It is `false` in a **QSqlField**  resulting from a **QSqlRecord**
        returned from **QSqlDatabase::record** () or
        **QSqlDatabase::primaryIndex** ().

        **See also** **setAutoValue** ().
        """
        ...

    def isGenerated(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#isGenerated

        **bool QSqlField::isGenerated() const**

        Returns `true` if the field is generated; otherwise returns false.

        **See also** **setGenerated** (), **metaType** (), **requiredStatus**
        (), **length** (), **precision** (), and **defaultValue** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#isNull

        **bool QSqlField::isNull() const**

        Returns `true` if the field's value is NULL; otherwise returns false.

        **See also** **value** ().
        """
        ...

    def isReadOnly(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#isReadOnly

        **bool QSqlField::isReadOnly() const**

        Returns `true` if the field's value is read-only; otherwise returns
        false.

        **See also** **setReadOnly** (), **metaType** (), **requiredStatus** (),
        **length** (), **precision** (), **defaultValue** (), and
        **isGenerated** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#isValid

        **bool QSqlField::isValid() const**

        Returns `true` if the field's variant type is valid; otherwise returns
        `false`.
        """
        ...

    def length(self) -> int:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#length

        **int QSqlField::length() const**

        Returns the field's length.

        If the returned value is negative, it means that the information is not
        available from the database.

        **See also** **setLength** (), **metaType** (), **requiredStatus** (),
        **precision** (), **defaultValue** (), and **isGenerated** ().
        """
        ...

    def metaType(self) -> PySide6.QtCore.QMetaType:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#metaType

        **QMetaType QSqlField::metaType() const**

        Returns the field's type as stored in the database. Note that the actual
        value might have a different type, Numerical values that are too large
        to store in a long int or double are usually stored as strings to
        prevent precision loss.

        **See also** **setMetaType** ().
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#name

        **QString QSqlField::name() const**

        Returns the name of the field.

        **See also** **setName** ().
        """
        ...

    def precision(self) -> int:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#precision

        **int QSqlField::precision() const**

        Returns the field's precision; this is only meaningful for numeric
        types.

        If the returned value is negative, it means that the information is not
        available from the database.

        **See also** **setPrecision** (), **metaType** (), **requiredStatus**
        (), **length** (), **defaultValue** (), and **isGenerated** ().
        """
        ...

    def requiredStatus(self) -> PySide6.QtSql.QSqlField.RequiredStatus:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#requiredStatus

        **QSqlField::RequiredStatus QSqlField::requiredStatus() const**

        Returns `true` if this is a required field; otherwise returns `false`.
        An `INSERT` will fail if a required field does not have a value.

        **See also** **setRequiredStatus** (), **metaType** (), **length** (),
        **precision** (), **defaultValue** (), and **isGenerated** ().
        """
        ...

    def setAutoValue(self, autoVal: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#setAutoValue

        **void QSqlField::setAutoValue(bool autoVal )**

        Marks the field as an auto-generated value if **autoVal** is true.

        **See also** **isAutoValue** ().
        """
        ...

    def setDefaultValue(self, value: Any) -> None:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#setDefaultValue

        **void QSqlField::setDefaultValue(const QVariant & value )**

        Sets the default value used for this field to **value**.

        **See also** **defaultValue** (), **value** (), **setMetaType** (),
        **setRequiredStatus** (), **setLength** (), **setPrecision** (),
        **setGenerated** (), and **setReadOnly** ().
        """
        ...

    def setGenerated(self, gen: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#setGenerated

        **void QSqlField::setGenerated(bool gen )**

        Sets the generated state. If **gen** is false, no SQL will be generated
        for this field; otherwise, Qt classes such as **QSqlQueryModel**  and
        **QSqlTableModel**  will generate SQL for this field.

        **See also** **isGenerated** (), **setMetaType** (),
        **setRequiredStatus** (), **setLength** (), **setPrecision** (),
        **setDefaultValue** (), and **setReadOnly** ().
        """
        ...

    def setLength(self, fieldLength: int) -> None:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#setLength

        **void QSqlField::setLength(int fieldLength )**

        Sets the field's length to **fieldLength**. For strings this is the
        maximum number of characters the string can hold; the meaning varies for
        other types.

        **See also** **length** (), **setMetaType** (), **setRequiredStatus**
        (), **setPrecision** (), **setDefaultValue** (), **setGenerated** (),
        and **setReadOnly** ().
        """
        ...

    def setMetaType(self, type: PySide6.QtCore.QMetaType) -> None:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#setMetaType

        **void QSqlField::setMetaType(QMetaType type )**

        Set's the field's variant type to **type**.

        **See also** **metaType** (), **setRequiredStatus** (), **setLength**
        (), **setPrecision** (), **setDefaultValue** (), **setGenerated** (),
        and **setReadOnly** ().
        """
        ...

    def setName(self, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#setName

        **void QSqlField::setName(const QString & name )**

        Sets the name of the field to **name**.

        **See also** **name** ().
        """
        ...

    def setPrecision(self, precision: int) -> None:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#setPrecision

        **void QSqlField::setPrecision(int precision )**

        Sets the field's **precision**. This only affects numeric fields.

        **See also** **precision** (), **setMetaType** (), **setRequiredStatus**
        (), **setLength** (), **setDefaultValue** (), **setGenerated** (), and
        **setReadOnly** ().
        """
        ...

    def setReadOnly(self, readOnly: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#setReadOnly

        **void QSqlField::setReadOnly(bool readOnly )**

        Sets the read only flag of the field's value to **readOnly**. A read-
        only field cannot have its value set with **setValue** () and cannot be
        cleared to NULL with **clear** ().

        **See also** **isReadOnly** ().
        """
        ...

    def setRequired(self, required: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#setRequired

        **void QSqlField::setRequired(bool required )**

        Sets the required status of this field to **Required**  if **required**
        is true; otherwise sets it to **Optional** .

        **See also** **setRequiredStatus** () and **requiredStatus** ().
        """
        ...

    def setRequiredStatus(self, status: PySide6.QtSql.QSqlField.RequiredStatus) -> None:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#setRequiredStatus

        **void QSqlField::setRequiredStatus(QSqlField::RequiredStatus required
        )**

        Sets the required status of this field to **required**.

        **See also** **requiredStatus** (), **setMetaType** (), **setLength**
        (), **setPrecision** (), **setDefaultValue** (), **setGenerated** (),
        and **setReadOnly** ().
        """
        ...

    def setSqlType(self, type: int) -> None:
        ...

    def setTableName(self, tableName: str) -> None:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#setTableName

        **void QSqlField::setTableName(const QString & table )**

        Sets the **tableName**  of the field to **table**.

        **See also** **tableName** ().
        """
        ...

    def setValue(self, value: Any) -> None:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#setValue

        **void QSqlField::setValue(const QVariant & value )**

        Sets the value of the field to **value**. If the field is read-only
        (**isReadOnly** () returns `true`), nothing happens.

        If the data type of **value** differs from the field's current data
        type, an attempt is made to cast it to the proper type. This preserves
        the data type of the field in the case of assignment, e.g. a **QString**
        to an integer data type.

        To set the value to NULL, use **clear** ().

        **See also** **value** (), **isReadOnly** (), and **defaultValue** ().
        """
        ...

    def tableName(self) -> str:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#tableName

        **QString QSqlField::tableName() const**

        Returns the tableName of the field.

        **Note:** When using the QPSQL driver, due to limitations in the libpq
        library, the `tableName()` field is not populated in a **QSqlField**
        resulting from a **QSqlRecord**  obtained by **QSqlQuery::record** () of
        a forward-only query.

        **See also** **setTableName** ().
        """
        ...

    def typeID(self) -> int:
        ...

    def value(self) -> Any:
        """
        https://doc.qt.io/qt-6/qsqlfield.html#value

        **QVariant QSqlField::value() const**

        Returns the value of the field as a **QVariant** .

        Use **isNull** () to check if the field's value is NULL.

        **See also** **setValue** ().
        """
        ...
