"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtSensors, except for defaults which are replaced by "...".
"""
import PySide6.QtCore
import PySide6.QtSensors

bytes = str


class QTiltReading(PySide6.QtSensors.QSensorReading):
    """
    https://doc.qt.io/qt-6/qtiltreading.html

    **Detailed Description**

    The tilt sensor reports the angle of tilt in degrees of the device along the
    X and Y plane.
    """

    def __init__(self, parent: PySide6.QtCore.QObject) -> None:
        ...

    def copyValuesFrom(self, other: PySide6.QtSensors.QSensorReading) -> None:
        ...

    def setXRotation(self, x: float) -> None:
        """
        https://doc.qt.io/qt-6/qtiltreading.html#setXRotation

        **void QTiltReading::setXRotation(qreal x )**

        Sets **xRotation**  to **x** degrees.

        **See also** **xRotation** ().
        """
        ...

    def setYRotation(self, y: float) -> None:
        """
        https://doc.qt.io/qt-6/qtiltreading.html#setYRotation

        **void QTiltReading::setYRotation(qreal y )**

        Sets **yRotation**  to **y** degrees.

        **See also** **yRotation** ().
        """
        ...

    def xRotation(self) -> float:
        """
        https://doc.qt.io/qt-6/qtiltreading.html#xRotation-prop

        **[read-only] xRotation : const qreal**

        This property holds the amount of tilt on the X axis, measured in
        degrees.

        **Access functions:**

        qreal **xRotation** () const
        """
        ...

    def yRotation(self) -> float:
        """
        https://doc.qt.io/qt-6/qtiltreading.html#yRotation-prop

        **[read-only] yRotation : const qreal**

        This property holds the amount of tilt on the Y axis, measured in
        degrees.

        **Access functions:**

        qreal **yRotation** () const

        **Member Function Documentation**
        """
        ...
