"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtSensors, except for defaults which are replaced by "...".
"""
import PySide6.QtCore
import PySide6.QtSensors

bytes = str


class QSensorReading(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qsensorreading.html

    **Detailed Description**

    Note that QSensorReading is not particularly useful by itself. The
    interesting data for each sensor is defined in a sub-class of
    QSensorReading.
    """

    def copyValuesFrom(self, other: PySide6.QtSensors.QSensorReading) -> None:
        ...

    def setTimestamp(self, timestamp: int) -> None:
        """
        https://doc.qt.io/qt-6/qsensorreading.html#setTimestamp

        **void QSensorReading::setTimestamp(quint64 timestamp )**

        Sets the **timestamp** of the reading.

        **See also** **timestamp** ().
        """
        ...

    def timestamp(self) -> int:
        """
        https://doc.qt.io/qt-6/qsensorreading.html#timestamp

        **quint64 QSensorReading::timestamp() const**

        Returns the timestamp of the reading.

        **Note:** Getter function for property timestamp.

        **See also** **setTimestamp** ().
        """
        ...

    def value(self, index: int) -> Any:
        """
        https://doc.qt.io/qt-6/qsensorreading.html#value

        **QVariant QSensorReading::value(int index ) const**

        Returns the value of the property at **index**.

        Note that this function is slower than calling the data function
        directly.

        Here is an example of getting a property via the different mechanisms
        available.

        Accessing directly provides the best performance but requires compile-
        time knowledge of the data you are accessing.

        **QAccelerometerReading**  *reading = ...;
             **qreal**  x =
        reading->x();

        You can also access a property by name. To do this you must call
        **QObject::property** ().

        **qreal**  x = reading->property("x").value<**qreal** >();

        Finally, you can access values via numeric index.

        **qreal**  x = reading->value(0).value<**qreal** >();

        Note that value() can only access properties declared with
        **Q_PROPERTY** () in sub-classes of **QSensorReading** .

        **See also** **valueCount** () and **QObject::property** ().
        """
        ...

    def valueCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qsensorreading.html#valueCount

        **int QSensorReading::valueCount() const**

        Returns the number of extra properties that the reading has.

        Note that this does not count properties declared in **QSensorReading**
        .

        As an example, this returns 3 for **QAccelerometerReading**  because
        there are 3 properties defined in that class.
        """
        ...
