"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtSensors, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtSensors

bytes = str


class QSensorBackend(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qsensorbackend.html

    **Detailed Description**

    Sensors on a device will be represented by sub-classes of QSensorBackend.
    """

    def __init__(
        self,
        sensor: PySide6.QtSensors.QSensor,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        ...

    def addDataRate(self, min: float, max: float) -> None:
        """
        https://doc.qt.io/qt-6/qsensorbackend.html#addDataRate

        **void QSensorBackend::addDataRate(qreal min , qreal max )**

        Add a data rate (consisting of **min** and **max** values) for the
        sensor.

        Note that this function should be called from the constructor so that
        the information is available immediately.

        **See also** **QSensor::availableDataRates** .
        """
        ...

    def addOutputRange(self, min: float, max: float, accuracy: float) -> None:
        """
        https://doc.qt.io/qt-6/qsensorbackend.html#addOutputRange

        **void QSensorBackend::addOutputRange(qreal min , qreal max , qreal
        accuracy )**

        Add an output range (consisting of **min** , **max** values and
        **accuracy** ) for the sensor.

        Note that this function should be called from the constructor so that
        the information is available immediately.

        **See also** **QSensor::outputRange**  and **QSensor::outputRanges** .
        """
        ...

    def isFeatureSupported(self, feature: PySide6.QtSensors.QSensor.Feature) -> bool:
        """
        https://doc.qt.io/qt-6/qsensorbackend.html#isFeatureSupported

        **[virtual, since 5.0] bool
        QSensorBackend::isFeatureSupported(QSensor::Feature feature ) const**

        Checks whether a feature is supported by this sensor backend.

        This is the backend side of **QSensor::isFeatureSupported** ().
        Reimplement this function if the backend supports one of the additional
        sensor features of **QSensor::Feature** .

        Returns whether the feature **feature** is supported by this backend.
        The default implementation returns false.

        This function was introduced in Qt 5.0.
        """
        ...

    def newReadingAvailable(self) -> None:
        """
        https://doc.qt.io/qt-6/qsensorbackend.html#newReadingAvailable

        **void QSensorBackend::newReadingAvailable()**

        Notify the **QSensor**  class that a new reading is available.
        """
        ...

    def reading(self) -> PySide6.QtSensors.QSensorReading:
        """
        https://doc.qt.io/qt-6/qsensorbackend.html#reading

        **QSensorReading *QSensorBackend::reading() const**

        If the backend has lost its reference to the reading it can call this
        method to get the address.

        Note that you will need to down-cast to the appropriate type.

        **See also** **setReading** ().
        """
        ...

    def sensor(self) -> PySide6.QtSensors.QSensor:
        """
        https://doc.qt.io/qt-6/qsensorbackend.html#sensor

        **QSensor *QSensorBackend::sensor() const**

        Returns the sensor front end associated with this backend.
        """
        ...

    def sensorBusy(self, busy: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qsensorbackend.html#sensorBusy

        **void QSensorBackend::sensorBusy(bool busy = true)**

        Inform the front end of the sensor's busy state according to the
        provided **busy** parameter.

        If the sensor is set **busy** this implicitly calls **sensorStopped**
        (). Busy indication is typically done in **start** ().

        Note that the front end must call **QSensor::isBusy** () to see if the
        sensor is busy. If the sensor has stopped due to an error the
        **sensorError** () function should be called to notify the class of the
        error condition.
        """
        ...

    def sensorError(self, error: int) -> None:
        """
        https://doc.qt.io/qt-6/qsensorbackend.html#sensorError

        **void QSensorBackend::sensorError(int error )**

        Inform the front end that a sensor error occurred. Note that this only
        reports an **error** code. It does not stop the sensor.

        **See also** **sensorStopped** ().
        """
        ...

    def sensorStopped(self) -> None:
        """
        https://doc.qt.io/qt-6/qsensorbackend.html#sensorStopped

        **void QSensorBackend::sensorStopped()**

        Inform the front end that the sensor has stopped. This can be due to
        **start** () failing or for some unexpected reason (eg. hardware
        failure).

        Note that the front end must call **QSensor::isActive** () to see if the
        sensor has stopped. If the sensor has stopped due to an error the
        **sensorError** () function should be called to notify the class of the
        error condition.
        """
        ...

    def setDataRates(self, otherSensor: PySide6.QtSensors.QSensor) -> None:
        """
        https://doc.qt.io/qt-6/qsensorbackend.html#setDataRates

        **void QSensorBackend::setDataRates(const QSensor * otherSensor )**

        Set the data rates for the sensor based on **otherSensor**.

        This is designed for sensors that are based on other sensors.

        setDataRates(otherSensor);

        Note that this function must be called from the constructor.

        **See also** **QSensor::availableDataRates**  and **addDataRate** ().
        """
        ...

    def setDescription(self, description: str) -> None:
        """
        https://doc.qt.io/qt-6/qsensorbackend.html#setDescription

        **void QSensorBackend::setDescription(const QString & description )**

        Set the **description** for the sensor.

        Note that this function should be called from the constructor so that
        the information is available immediately.
        """
        ...

    def start(self) -> None:
        """
        https://doc.qt.io/qt-6/qsensorbackend.html#start

        **[pure virtual] void QSensorBackend::start()**

        Start reporting values.
        """
        ...

    def stop(self) -> None:
        """
        https://doc.qt.io/qt-6/qsensorbackend.html#stop

        **[pure virtual] void QSensorBackend::stop()**

        Stop reporting values.
        """
        ...
