"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtSensors, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, Optional, Tuple, Union
import PySide6.QtCore
import PySide6.QtSensors

bytes = str


class QSensor(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qsensor.html

    **Detailed Description**

    The life cycle of a sensor is typically:

    * Create a sub-class of QSensor on the stack or heap.
      * Setup as required
    by the application.
      * Start receiving values.
      * Sensor data is used by
    the application.
      * Stop receiving values.

    The sensor data is delivered via **QSensorReading**  and its sub-classes.

    **Orientation**

    Some sensors react to screen orientation changes, such as **QAccelerometer**
    , **QMagnetometer**  and **QRotationSensor** . These are so called
    **orientable** sensors. For orientable sensors, QSensor supports changing
    the reporting of the reading values based on the orientation of the screen.

    For orientable sensors, the **axesOrientationMode**  property controls how
    the orientation affects the reading values.

    In the default mode, **QSensor::FixedOrientation** , the reading values
    remain unaffected by the orientation. In the
    **QSensor::AutomaticOrientation**  mode, the reading values are
    automatically rotated by taking the current screen orientation into account.
    And finally, in the **QSensor::UserOrientation**  mode, the reading values
    are rotated according to a user-specified orientation.

    The functionality of this is only available if it is supported by the
    backend and if the sensor is orientable, which can be checked by calling
    **QSensor::isFeatureSupported** () with the **QSensor::AxesOrientation**
    flag.

    The orientation values here are always of the screen orientation, not the
    device orientation. The screen orientation is the orientation of the GUI.
    For example when rotating a device by 90 degrees counter-clockwise, the
    screen orientation compensates for that by rotating 90 degrees clockwise, to
    the effect that the GUI is still facing upright after the device has been
    rotated. Note that applications can lock the screen orientation, for example
    to force portrait or landscape mode. For locked orientations, orientable
    sensors will not react with reading changes if the device orientation is
    changed, as orientable sensors react to screen orientation changes only.
    This makes sense, as the purpose of orientable sensors is to keep the sensor
    orientation in sync with the screen orientation.

    The orientation values range from 0 to 270 degrees. The orientation is
    applied in clockwise direction, e.g. an orientation value of 90 degrees
    means that the screen has been rotated 90 degress to the right from its
    origin position, to compensate a device rotation of 90 degrees to the left.

    **See also** **QSensorReading** .
    """

    FixedOrientation: QSensor.AxesOrientationMode = ...
    AutomaticOrientation: QSensor.AxesOrientationMode = ...
    UserOrientation: QSensor.AxesOrientationMode = ...
    Buffering: QSensor.Feature = ...
    AlwaysOn: QSensor.Feature = ...
    GeoValues: QSensor.Feature = ...
    FieldOfView: QSensor.Feature = ...
    AccelerationMode: QSensor.Feature = ...
    SkipDuplicates: QSensor.Feature = ...
    AxesOrientation: QSensor.Feature = ...
    PressureSensorTemperature: QSensor.Feature = ...
    Reserved: QSensor.Feature = ...

    class AxesOrientationMode(Enum):
        FixedOrientation: QSensor.AxesOrientationMode = ...
        AutomaticOrientation: QSensor.AxesOrientationMode = ...
        UserOrientation: QSensor.AxesOrientationMode = ...

    class Feature(Enum):
        Buffering: QSensor.Feature = ...
        AlwaysOn: QSensor.Feature = ...
        GeoValues: QSensor.Feature = ...
        FieldOfView: QSensor.Feature = ...
        AccelerationMode: QSensor.Feature = ...
        SkipDuplicates: QSensor.Feature = ...
        AxesOrientation: QSensor.Feature = ...
        PressureSensorTemperature: QSensor.Feature = ...
        Reserved: QSensor.Feature = ...

    def __init__(
        self,
        type: Union[PySide6.QtCore.QByteArray, bytes],
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsensor.html#QSensor

        **QSensor::QSensor(const QByteArray & type , QObject * parent =
        nullptr)**

        Construct the **type** sensor as a child of **parent**.

        Do not use this constructor if a derived class exists for the specific
        sensor type.

        The wrong way is to use the base class constructor:

        QSensor *magnetometer = new QSensor(**QMagnetometer** ::sensorType,
        this);

        The right way is to create an instance of the derived class:

        **QMagnetometer**  *magnetometer = new **QMagnetometer** (this);

        The derived classes have additional properties and data members which
        are needed for certain features such as geo value support in
        **QMagnetometer**  or acceleration mode support in **QAccelerometer** .
        These features will only work properly when creating a sensor instance
        from a QSensor subclass.

        Only use this constructor if there is no derived sensor class available.
        Note that all built-in sensors have a derived class, so using this
        constructor should only be necessary when implementing custom sensors,
        like in the **Grue sensor example** .
        """
        ...

    def addFilter(self, filter: PySide6.QtSensors.QSensorFilter) -> None:
        """
        https://doc.qt.io/qt-6/qsensor.html#addFilter

        **void QSensor::addFilter(QSensorFilter * filter )**

        Add a **filter** to the sensor.

        The sensor does not take ownership of the filter. **QSensorFilter**
        will inform the sensor if it is destroyed.

        **See also** **QSensorFilter** .
        """
        ...

    def availableDataRates(self) -> List[Tuple[int, int]]:
        """
        https://doc.qt.io/qt-6/qsensor.html#availableDataRates-prop

        **[read-only] availableDataRates : const qrangelist**

        This property holds the data rates that the sensor supports.

        This is a list of the data rates that the sensor supports. Measured in
        Hertz.

        Entries in the list can represent discrete rates or a continuous range
        of rates. A discrete rate is noted by having both values the same.

        See the sensor_explorer example for an example of how to interpret and
        use this information.

        Note that this information is not mandatory as not all sensors have a
        rate at which they run. In such cases, the list will be empty.

        **Access functions:**

        qrangelist **availableDataRates** () const

        **See also** **QSensor::dataRate**  and **qrangelist** .
        """
        ...

    def axesOrientationMode(self) -> PySide6.QtSensors.QSensor.AxesOrientationMode:
        """
        https://doc.qt.io/qt-6/qsensor.html#axesOrientationMode-prop

        **[since 5.1] axesOrientationMode : AxesOrientationMode**

        This property holds the mode that affects how the screen orientation
        changes reading values.

        When set to **FixedOrientation** , which is the default mode, no
        automatic rotation is applied to the reading. This is the only mode
        available for backends that do not support the
        **QSensor::AxesOrientation**  feature.

        When set to **AutomaticOrientation** , the reading values are
        automatically rotated when the screen orientation changes. In effect,
        the screen orientation is canceled out.

        As an example, assume the device is rotated by 180 degrees and therefore
        the screen orientation also is rotated by 180 degrees from the native
        orientation. Without automatic axes orientation, the reading values
        would now be changed: Both the X and the Y values would be negated,
        forcing an application developer to manually cancel out the negation in
        application code. Automatic axes orientation does this automatically, in
        this mode the X and Y values would be the same as with the default
        screen orientation.

        This automatic rotation of the axes is handy is some usecases, for
        example in a bubble level application that measures how level a surface
        is by looking at the X axis value of an accelerometer. When the device
        and screen orientation change by 90 degrees, an application developer
        does not need to change anything, he can continue using the X axis value
        even though the device is rotated. Without automatic axes orientation,
        the application developer would need to look at the Y values instead,
        thereby adding code to the application that reads from a different axis
        depending on the screen orientation.

        The **UserOrientation**  mode is quite similar to
        **AutomaticOrientation** , only that the screen orientation is manually
        controlled instead of automatically determined. The angle of the
        **userOrientation**  property is then used for rotating the reading
        values.

        Since the rotation of the reading values is based on the screen
        orientation, Z values will never change, as the Z axis is perpendicular
        to the screen. As screen orientation changes in 90 degree steps,
        rotating the reading values is also done in steps of 90 degrees.

        This property is only used for orientable sensors.

        This property was introduced in Qt 5.1.

        **Access functions:**

        QSensor::AxesOrientationMode **axesOrientationMode** () const
        void
        **setAxesOrientationMode** (QSensor::AxesOrientationMode
        **axesOrientationMode** )

        **Notifier signal:**

        void **axesOrientationModeChanged** (QSensor::AxesOrientationMode
        **axesOrientationMode** )
        """
        ...

    def backend(self) -> PySide6.QtSensors.QSensorBackend:
        ...

    def bufferSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qsensor.html#bufferSize-prop

        **bufferSize : int**

        This property holds the size of the buffer. By default, the buffer size
        is 1, which means no buffering. If the maximum buffer size is 1, then
        buffering is not supported by the sensor.

        Setting bufferSize greater than **maxBufferSize**  will cause
        **maxBufferSize**  to be used.

        Buffering is turned on when bufferSize is greater than 1. The sensor
        will collect the requested number of samples and deliver them all to the
        application at one time. They will be delivered to the application as a
        burst of changed readings so it is particularly important that the
        application processes each reading immediately or saves the values
        somewhere else.

        If **stop** () is called when buffering is on-going, the partial buffer
        is not delivered.

        When the sensor is started with buffering option, values are collected
        from that moment onwards. There is no pre-existing buffer that can be
        utilized.

        Some backends only support enabling or disabling the buffer and do not
        give control over the size. In this case, the **maxBufferSize**  and
        **efficientBufferSize**  properties might not be set at all, even though
        buffering is supported. Setting the bufferSize property to any value
        greater than 1 will enable buffering. After the sensor has been started,
        the bufferSize property will be set to the actual value by the backend.

        **Access functions:**

        int **bufferSize** () const
        void **setBufferSize** (int **bufferSize**
        )

        **Notifier signal:**

        void **bufferSizeChanged** (int **bufferSize** )

        **See also** **QSensor::maxBufferSize**  and
        **QSensor::efficientBufferSize** .
        """
        ...

    def connectToBackend(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsensor.html#connectToBackend

        **[invokable] bool QSensor::connectToBackend()**

        Try to connect to a sensor backend.

        Returns true if a suitable backend could be found, false otherwise.

        The type must be set before calling this method if you are using
        **QSensor**  directly.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        **See also** **isConnectedToBackend** ().
        """
        ...

    def currentOrientation(self) -> int:
        """
        https://doc.qt.io/qt-6/qsensor.html#currentOrientation-prop

        **[read-only, since 5.1] currentOrientation : const int**

        This property holds the current orientation that is used for rotating
        the reading values.

        This might not be the same as the screen orientation. For example, in
        the **FixedOrientation**  mode, the reading values are not rotated, and
        therefore the property is 0.

        In the **UserOrientation**  mode, the readings are rotated based on the
        **userOrientation**  property, and therefore this property is equal to
        the **userOrientation**  property.

        In the **AutomaticOrientation**  mode, the readings are rotated based on
        the screen orientation, and therefore this property will be equal to the
        current screen orientation.

        This property is set by the backend and only valid for orientable
        sensors.

        This property was introduced in Qt 5.1.

        **Access functions:**

        int **currentOrientation** () const

        **Notifier signal:**

        void **currentOrientationChanged** (int **currentOrientation** )
        """
        ...

    def dataRate(self) -> int:
        """
        https://doc.qt.io/qt-6/qsensor.html#dataRate-prop

        **dataRate : int**

        This property holds the data rate that the sensor should be run at.

        Measured in Hertz.

        The data rate is the maximum frequency at which the sensor can detect
        changes.

        Setting this property is not portable and can cause conflicts with other
        applications. Check with the sensor backend and platform documentation
        for any policy regarding multiple applications requesting a data rate.

        The default value (0) means that the app does not care what the data
        rate is. Applications should consider using a timer-based poll of the
        current value or ensure that the code that processes values can run very
        quickly as the platform may provide updates hundreds of times each
        second.

        This should be set before calling **start** () because the sensor may
        not notice changes to this value while it is running.

        Note that there is no mechanism to determine the current data rate in
        use by the platform.

        **Access functions:**

        int **dataRate** () const
        void **setDataRate** (int **rate** )

        **Notifier signal:**

        void **dataRateChanged** ()

        **See also** **QSensor::availableDataRates** .
        """
        ...

    @staticmethod
    def defaultSensorForType(
        type: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qsensor.html#defaultSensorForType

        **[static] QByteArray QSensor::defaultSensorForType(const QByteArray &
        type )**

        Returns the default sensor identifier for **type**. This is set in a
        config file and can be overridden if required. If no default is
        available the system will return the first registered sensor for
        **type**.

        Note that there is special case logic to prevent the generic plugin's
        backends from becoming the default when another backend is registered
        for the same type. This logic means that a backend identifier starting
        with `generic.` will only be the default if no other backends have been
        registered for that type or if it is specified in `Sensors.conf`.

        **See also** **Determining the default sensor for a type** .
        """
        ...

    def description(self) -> str:
        """
        https://doc.qt.io/qt-6/qsensor.html#description-prop

        **[read-only] description : const QString**

        This property holds a descriptive string for the sensor.

        **Access functions:**

        QString **description** () const
        """
        ...

    def efficientBufferSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qsensor.html#efficientBufferSize-prop

        **[read-only] efficientBufferSize : const int**

        The property holds the most efficient buffer size. Normally this is 1
        (which means no particular size is most efficient). Some sensor drivers
        have a FIFO buffer which makes it more efficient to deliver the FIFO's
        size worth of readings at one time.

        **Access functions:**

        int **efficientBufferSize** () const

        **Notifier signal:**

        void **efficientBufferSizeChanged** (int **efficientBufferSize** )

        **See also** **QSensor::bufferSize**  and **QSensor::maxBufferSize** .
        """
        ...

    def error(self) -> int:
        """
        https://doc.qt.io/qt-6/qsensor.html#error-prop

        **[read-only] error : const int**

        This property holds the last error code set on the sensor.

        Note that error codes are sensor-specific.

        **Access functions:**

        int **error** () const

        **Notifier signal:**

        void ****sensorError** ** (int **error** )
        """
        ...

    def filters(self) -> List[PySide6.QtSensors.QSensorFilter]:
        """
        https://doc.qt.io/qt-6/qsensor.html#filters

        **QList<QSensorFilter *> QSensor::filters() const**

        Returns the filters currently attached to the sensor.

        **See also** **QSensorFilter** .
        """
        ...

    def identifier(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qsensor.html#identifier-prop

        **identifier : QByteArray**

        This property holds the backend identifier for the sensor.

        Note that the identifier is filled out automatically when the sensor is
        connected to a backend. If you want to connect a specific backend, you
        should call setIdentifier() before **connectToBackend** ().

        **Access functions:**

        QByteArray **identifier** () const
        void **setIdentifier** (const
        QByteArray & **identifier** )

        **Notifier signal:**

        void **identifierChanged** ()
        """
        ...

    def isActive(self) -> bool:
        ...

    def isAlwaysOn(self) -> bool:
        ...

    def isBusy(self) -> bool:
        ...

    def isConnectedToBackend(self) -> bool:
        ...

    def isFeatureSupported(self, feature: PySide6.QtSensors.QSensor.Feature) -> bool:
        """
        https://doc.qt.io/qt-6/qsensor.html#isFeatureSupported

        **[invokable, since 5.0] bool
        QSensor::isFeatureSupported(QSensor::Feature feature ) const**

        Checks if a specific feature is supported by the backend.

        **QtSensors**  supports a rich API for controlling and providing
        information about sensors. Naturally, not all of this functionality can
        be supported by all of the backends.

        To check if the current backend supports the feature **feature** , call
        this function.

        The backend needs to be connected, otherwise false will be returned.
        Calling **connectToBackend** () or **start** () will create a connection
        to the backend.

        Backends have to implement **QSensorBackend::isFeatureSupported** () to
        make this work.

        Returns whether or not the feature is supported if the backend is
        connected, or false if the backend is not connected.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        This function was introduced in Qt 5.0.
        """
        ...

    def maxBufferSize(self) -> int:
        """
        https://doc.qt.io/qt-6/qsensor.html#maxBufferSize-prop

        **[read-only] maxBufferSize : const int**

        The property holds the maximum buffer size.

        Note that this may be 1, in which case the sensor does not support any
        form of buffering. In that case, **isFeatureSupported**
        (**QSensor::Buffering** ) will also return false.

        **Access functions:**

        int **maxBufferSize** () const

        **Notifier signal:**

        void **maxBufferSizeChanged** (int **maxBufferSize** )

        **See also** **QSensor::bufferSize**  and
        **QSensor::efficientBufferSize** .
        """
        ...

    def outputRange(self) -> int:
        """
        https://doc.qt.io/qt-6/qsensor.html#outputRange-prop

        **outputRange : int**

        This property holds the output range in use by the sensor.

        This value represents the index in the **QSensor::outputRanges**  list
        to use.

        Setting this property is not portable and can cause conflicts with other
        applications. Check with the sensor backend and platform documentation
        for any policy regarding multiple applications requesting an output
        range.

        The default value (-1) means that the app does not care what the output
        range is.

        Note that there is no mechanism to determine the current output range in
        use by the platform.

        **Access functions:**

        int **outputRange** () const
        void **setOutputRange** (int **index** )

        **See also** **QSensor::outputRanges** .
        """
        ...

    def outputRanges(self) -> List[PySide6.QtSensors.qoutputrange]:
        """
        https://doc.qt.io/qt-6/qsensor.html#outputRanges-prop

        **[read-only] outputRanges : const qoutputrangelist**

        This property holds a list of output ranges the sensor supports.

        A sensor may have more than one output range. Typically this is done to
        give a greater measurement range at the cost of lowering accuracy.

        Note that this information is not mandatory. This information is
        typically only available for sensors that have selectable output ranges
        (such as typical accelerometers).

        **Access functions:**

        qoutputrangelist **outputRanges** () const

        **See also** **QSensor::outputRange**  and **qoutputrangelist** .
        """
        ...

    def reading(self) -> PySide6.QtSensors.QSensorReading:
        """
        https://doc.qt.io/qt-6/qsensor.html#reading-prop

        **[read-only] reading : QSensorReading* const**

        This property holds the reading class.

        The reading class provides access to sensor readings. The reading object
        is a volatile cache of the most recent sensor reading that has been
        received so the application should process readings immediately or save
        the values somewhere for later processing.

        Note that this will return 0 until a sensor backend is connected to a
        backend.

        Also note that readings are not immediately available after **start** ()
        is called. Applications must wait for the **readingChanged** () signal
        to be emitted.

        **Access functions:**

        QSensorReading * **reading** () const

        **Notifier signal:**

        void ****readingChanged** ** ()

        **See also** **isConnectedToBackend** () and **start** ().
        """
        ...

    def removeFilter(self, filter: PySide6.QtSensors.QSensorFilter) -> None:
        """
        https://doc.qt.io/qt-6/qsensor.html#removeFilter

        **void QSensor::removeFilter(QSensorFilter * filter )**

        Remove **filter** from the sensor.

        **See also** **QSensorFilter** .
        """
        ...

    @staticmethod
    def sensorTypes() -> List[PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qsensor.html#sensorTypes

        **[static] QList<QByteArray> QSensor::sensorTypes()**

        Returns a list of all sensor types.
        """
        ...

    @staticmethod
    def sensorsForType(
        type: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> List[PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qsensor.html#sensorsForType

        **[static] QList<QByteArray> QSensor::sensorsForType(const QByteArray &
        type )**

        Returns a list of ids for each of the sensors for **type**. If there are
        no sensors of that type available the list will be empty.
        """
        ...

    def setActive(self, active: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsensor.html#active-prop

        **active : bool**

        This property holds a value to indicate if the sensor is active.

        This is true if the sensor is active (returning values). This is false
        otherwise.

        Note that setting this value to true will not have an immediate effect.
        Instead, the sensor will be started once the event loop has been
        reached.

        **Access functions:**

        bool **isActive** () const
        void **setActive** (bool **active** )

        **Notifier signal:**

        void ****activeChanged** ** ()
        """
        ...

    def setAlwaysOn(self, alwaysOn: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsensor.html#alwaysOn-prop

        **alwaysOn : bool**

        This property holds a value to indicate if the sensor should remain
        running when the screen is off.

        Some platforms have a policy of suspending sensors when the screen turns
        off. Setting this property to true will ensure the sensor continues to
        run.

        **Access functions:**

        bool **isAlwaysOn** () const
        void **setAlwaysOn** (bool **alwaysOn** )

        **Notifier signal:**

        void ****alwaysOnChanged** ** ()
        """
        ...

    def setAxesOrientationMode(
        self, axesOrientationMode: PySide6.QtSensors.QSensor.AxesOrientationMode
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsensor.html#axesOrientationMode-prop

        **[since 5.1] axesOrientationMode : AxesOrientationMode**

        This property holds the mode that affects how the screen orientation
        changes reading values.

        When set to **FixedOrientation** , which is the default mode, no
        automatic rotation is applied to the reading. This is the only mode
        available for backends that do not support the
        **QSensor::AxesOrientation**  feature.

        When set to **AutomaticOrientation** , the reading values are
        automatically rotated when the screen orientation changes. In effect,
        the screen orientation is canceled out.

        As an example, assume the device is rotated by 180 degrees and therefore
        the screen orientation also is rotated by 180 degrees from the native
        orientation. Without automatic axes orientation, the reading values
        would now be changed: Both the X and the Y values would be negated,
        forcing an application developer to manually cancel out the negation in
        application code. Automatic axes orientation does this automatically, in
        this mode the X and Y values would be the same as with the default
        screen orientation.

        This automatic rotation of the axes is handy is some usecases, for
        example in a bubble level application that measures how level a surface
        is by looking at the X axis value of an accelerometer. When the device
        and screen orientation change by 90 degrees, an application developer
        does not need to change anything, he can continue using the X axis value
        even though the device is rotated. Without automatic axes orientation,
        the application developer would need to look at the Y values instead,
        thereby adding code to the application that reads from a different axis
        depending on the screen orientation.

        The **UserOrientation**  mode is quite similar to
        **AutomaticOrientation** , only that the screen orientation is manually
        controlled instead of automatically determined. The angle of the
        **userOrientation**  property is then used for rotating the reading
        values.

        Since the rotation of the reading values is based on the screen
        orientation, Z values will never change, as the Z axis is perpendicular
        to the screen. As screen orientation changes in 90 degree steps,
        rotating the reading values is also done in steps of 90 degrees.

        This property is only used for orientable sensors.

        This property was introduced in Qt 5.1.

        **Access functions:**

        QSensor::AxesOrientationMode **axesOrientationMode** () const
        void
        **setAxesOrientationMode** (QSensor::AxesOrientationMode
        **axesOrientationMode** )

        **Notifier signal:**

        void **axesOrientationModeChanged** (QSensor::AxesOrientationMode
        **axesOrientationMode** )
        """
        ...

    def setBufferSize(self, bufferSize: int) -> None:
        """
        https://doc.qt.io/qt-6/qsensor.html#bufferSize-prop

        **bufferSize : int**

        This property holds the size of the buffer. By default, the buffer size
        is 1, which means no buffering. If the maximum buffer size is 1, then
        buffering is not supported by the sensor.

        Setting bufferSize greater than **maxBufferSize**  will cause
        **maxBufferSize**  to be used.

        Buffering is turned on when bufferSize is greater than 1. The sensor
        will collect the requested number of samples and deliver them all to the
        application at one time. They will be delivered to the application as a
        burst of changed readings so it is particularly important that the
        application processes each reading immediately or saves the values
        somewhere else.

        If **stop** () is called when buffering is on-going, the partial buffer
        is not delivered.

        When the sensor is started with buffering option, values are collected
        from that moment onwards. There is no pre-existing buffer that can be
        utilized.

        Some backends only support enabling or disabling the buffer and do not
        give control over the size. In this case, the **maxBufferSize**  and
        **efficientBufferSize**  properties might not be set at all, even though
        buffering is supported. Setting the bufferSize property to any value
        greater than 1 will enable buffering. After the sensor has been started,
        the bufferSize property will be set to the actual value by the backend.

        **Access functions:**

        int **bufferSize** () const
        void **setBufferSize** (int **bufferSize**
        )

        **Notifier signal:**

        void **bufferSizeChanged** (int **bufferSize** )

        **See also** **QSensor::maxBufferSize**  and
        **QSensor::efficientBufferSize** .
        """
        ...

    def setCurrentOrientation(self, currentOrientation: int) -> None:
        """
        https://doc.qt.io/qt-6/qsensor.html#setCurrentOrientation

        **[since 5.1] void QSensor::setCurrentOrientation(int currentOrientation
        )**

        Sets the current screen orientation to **currentOrientation**. This is
        to be called from the backend whenever the screen orientation or the
        **userOrientation**  property changes.

        This function was introduced in Qt 5.1.

        **See also** **currentOrientation** ().
        """
        ...

    def setDataRate(self, rate: int) -> None:
        """
        https://doc.qt.io/qt-6/qsensor.html#dataRate-prop

        **dataRate : int**

        This property holds the data rate that the sensor should be run at.

        Measured in Hertz.

        The data rate is the maximum frequency at which the sensor can detect
        changes.

        Setting this property is not portable and can cause conflicts with other
        applications. Check with the sensor backend and platform documentation
        for any policy regarding multiple applications requesting a data rate.

        The default value (0) means that the app does not care what the data
        rate is. Applications should consider using a timer-based poll of the
        current value or ensure that the code that processes values can run very
        quickly as the platform may provide updates hundreds of times each
        second.

        This should be set before calling **start** () because the sensor may
        not notice changes to this value while it is running.

        Note that there is no mechanism to determine the current data rate in
        use by the platform.

        **Access functions:**

        int **dataRate** () const
        void **setDataRate** (int **rate** )

        **Notifier signal:**

        void **dataRateChanged** ()

        **See also** **QSensor::availableDataRates** .
        """
        ...

    def setEfficientBufferSize(self, efficientBufferSize: int) -> None:
        """
        https://doc.qt.io/qt-6/qsensor.html#setEfficientBufferSize

        **[since 5.1] void QSensor::setEfficientBufferSize(int
        efficientBufferSize )**

        Sets the efficient buffer size to **efficientBufferSize**. This is to be
        called from the backend.

        This function was introduced in Qt 5.1.

        **See also** **efficientBufferSize** ().
        """
        ...

    def setIdentifier(
        self, identifier: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsensor.html#identifier-prop

        **identifier : QByteArray**

        This property holds the backend identifier for the sensor.

        Note that the identifier is filled out automatically when the sensor is
        connected to a backend. If you want to connect a specific backend, you
        should call setIdentifier() before **connectToBackend** ().

        **Access functions:**

        QByteArray **identifier** () const
        void **setIdentifier** (const
        QByteArray & **identifier** )

        **Notifier signal:**

        void **identifierChanged** ()
        """
        ...

    def setMaxBufferSize(self, maxBufferSize: int) -> None:
        """
        https://doc.qt.io/qt-6/qsensor.html#setMaxBufferSize

        **[since 5.1] void QSensor::setMaxBufferSize(int maxBufferSize )**

        Sets the maximum buffer size to **maxBufferSize**. This is to be called
        from the backend.

        This function was introduced in Qt 5.1.

        **See also** **maxBufferSize** ().
        """
        ...

    def setOutputRange(self, index: int) -> None:
        """
        https://doc.qt.io/qt-6/qsensor.html#outputRange-prop

        **outputRange : int**

        This property holds the output range in use by the sensor.

        This value represents the index in the **QSensor::outputRanges**  list
        to use.

        Setting this property is not portable and can cause conflicts with other
        applications. Check with the sensor backend and platform documentation
        for any policy regarding multiple applications requesting an output
        range.

        The default value (-1) means that the app does not care what the output
        range is.

        Note that there is no mechanism to determine the current output range in
        use by the platform.

        **Access functions:**

        int **outputRange** () const
        void **setOutputRange** (int **index** )

        **See also** **QSensor::outputRanges** .
        """
        ...

    def setSkipDuplicates(self, skipDuplicates: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsensor.html#setSkipDuplicates

        **[since 5.1] void QSensor::setSkipDuplicates(bool skipDuplicates )**

        Sets the duplicate skipping to **skipDuplicates**.

        **Note:** Setter function for property **skipDuplicates** .

        This function was introduced in Qt 5.1.

        **See also** **skipDuplicates** ().
        """
        ...

    def setUserOrientation(self, userOrientation: int) -> None:
        """
        https://doc.qt.io/qt-6/qsensor.html#userOrientation-prop

        **[since 5.1] userOrientation : int**

        This property holds the angle used for rotating the reading values in
        the **UserOrientation**  mode.

        When the **axesOrientationMode**  property is set to **UserOrientation**
        , the angle for rotating the reading values is taken from this property.
        In other modes, the property has no effect.

        The default is 0. The only valid values are 0, 90, 180 and 270, as those
        are the only possible screen orientations.

        This property is only valid for orientable sensors.

        This property was introduced in Qt 5.1.

        **Access functions:**

        int **userOrientation** () const
        void **setUserOrientation** (int
        **userOrientation** )

        **Notifier signal:**

        void **userOrientationChanged** (int **userOrientation** )

        **Member Function Documentation**
        """
        ...

    def skipDuplicates(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsensor.html#skipDuplicates-prop

        **[since 5.1] skipDuplicates : bool**

        Indicates whether duplicate reading values should be omitted.

        When duplicate skipping is enabled, successive readings with the same or
        very similar values are omitted. This helps reducing the amount of
        processing done, as less sensor readings are made available. As a
        consequence, readings arrive at an irregular interval.

        Duplicate skipping is not just enabled for readings that are exactly the
        same, but also for readings that are quite similar, as each sensor has a
        bit of jitter even if the device is not moved.

        Support for this property depends on the backend. Use
        **isFeatureSupported** () to check if it is supported on the current
        platform.

        Duplicate skipping is disabled by default.

        Duplicate skipping takes effect when the sensor is started, changing the
        property while the sensor is active has no immediate effect.

        This property was introduced in Qt 5.1.

        **Access functions:**

        bool **skipDuplicates** () const
        void ****setSkipDuplicates** ** (bool
        **skipDuplicates** )

        **Notifier signal:**

        void ****skipDuplicatesChanged** ** (bool **skipDuplicates** )
        """
        ...

    def start(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsensor.html#start

        **[slot] bool QSensor::start()**

        Start retrieving values from the sensor. Returns true if the sensor was
        started, false otherwise.

        The sensor may fail to start for several reasons.

        Once an application has started a sensor it must wait until the sensor
        receives a new value before it can query the sensor's values. This is
        due to how the sensor receives values from the system. Sensors do not
        (in general) poll for new values, rather new values are pushed to the
        sensors as they happen.

        For example, this code will not work as intended.

        sensor->start();
             sensor->reading()->x(); // no data available

        To work correctly, the code that accesses the reading should ensure the
        **readingChanged** () signal has been emitted.

        connect(sensor, SIGNAL(readingChanged()), this, SLOT(checkReading()));
        sensor->start();
             }
             void MyClass::checkReading() {
        sensor->reading()->x();

        **See also** **QSensor::busy** .
        """
        ...

    def stop(self) -> None:
        """
        https://doc.qt.io/qt-6/qsensor.html#stop

        **[slot] void QSensor::stop()**

        Stop retrieving values from the sensor.

        This releases the sensor so that other processes can use it.

        **See also** **QSensor::busy** .
        """
        ...

    def type(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qsensor.html#type-prop

        **[read-only] type : const QByteArray**

        This property holds the type of the sensor.

        **Access functions:**

        QByteArray **type** () const
        """
        ...

    def userOrientation(self) -> int:
        """
        https://doc.qt.io/qt-6/qsensor.html#userOrientation-prop

        **[since 5.1] userOrientation : int**

        This property holds the angle used for rotating the reading values in
        the **UserOrientation**  mode.

        When the **axesOrientationMode**  property is set to **UserOrientation**
        , the angle for rotating the reading values is taken from this property.
        In other modes, the property has no effect.

        The default is 0. The only valid values are 0, 90, 180 and 270, as those
        are the only possible screen orientations.

        This property is only valid for orientable sensors.

        This property was introduced in Qt 5.1.

        **Access functions:**

        int **userOrientation** () const
        void **setUserOrientation** (int
        **userOrientation** )

        **Notifier signal:**

        void **userOrientationChanged** (int **userOrientation** )

        **Member Function Documentation**
        """
        ...

    @property
    def activeChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsensor.html#activeChanged

        **[signal] void QSensor::activeChanged()**

        This signal is emitted when the **QSensor::active**  property has
        changed.

        **Note:** Notifier signal for property **active** .

        **See also** **QSensor::active** .
        """
        ...

    @property
    def alwaysOnChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsensor.html#alwaysOnChanged

        **[signal] void QSensor::alwaysOnChanged()**

        This signal is emitted when the **alwaysOn**  property changes.

        **Note:** Notifier signal for property **alwaysOn** .
        """
        ...

    @property
    def availableSensorsChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsensor.html#availableSensorsChanged

        **[signal] void QSensor::availableSensorsChanged()**

        This signal is emitted when the list of available sensors has changed.
        The sensors available to a program will not generally change over time
        however some of the available sensors may represent hardware that is not
        permanently connected. For example, a game controller that is connected
        via bluetooth would become available when it was on and would become
        unavailable when it was off.

        **See also** **QSensor::sensorTypes** () and **QSensor::sensorsForType**
        ().
        """
        ...

    @property
    def axesOrientationModeChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def bufferSizeChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def busyChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsensor.html#busyChanged

        **[signal] void QSensor::busyChanged()**

        This signal is emitted when the sensor is no longer busy. This can be
        used to grab a sensor when it becomes available.

        sensor.start();
             if (sensor.isBusy()) {
                 // need to wait for
        busyChanged signal and try again
             }

        **Note:** Notifier signal for property **busy** .
        """
        ...

    @property
    def currentOrientationChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def dataRateChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def efficientBufferSizeChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def identifierChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def maxBufferSizeChanged(self) -> PySide6.QtCore.SignalInstance:
        ...

    @property
    def readingChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsensor.html#readingChanged

        **[signal] void QSensor::readingChanged()**

        This signal is emitted when a new sensor reading is received.

        The sensor reading can be found in the **QSensor::reading**  property.
        Note that the reading object is a volatile cache of the most recent
        sensor reading that has been received so the application should process
        the reading immediately or save the values somewhere for later
        processing.

        Before this signal has been emitted for the first time, the reading
        object will have uninitialized data.

        **Note:** Notifier signal for property **reading** .

        **See also** **start** ().
        """
        ...

    @property
    def sensorError(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsensor.html#sensorError

        **[signal] void QSensor::sensorError(int error )**

        This signal is emitted when an **error** code is set on the sensor. Note
        that some errors will cause the sensor to stop working. You should call
        **isActive** () to determine if the sensor is still running.

        **Note:** Notifier signal for property **error** .
        """
        ...

    @property
    def skipDuplicatesChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qsensor.html#skipDuplicatesChanged

        **[signal, since 5.1] void QSensor::skipDuplicatesChanged(bool
        skipDuplicates )**

        This signal is emitted when the **skipDuplicates** property changes.

        **Note:** Notifier signal for property **skipDuplicates** .

        This function was introduced in Qt 5.1.
        """
        ...

    @property
    def userOrientationChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
