"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtSensors, except for defaults which are replaced by "...".
"""
import PySide6.QtCore
import PySide6.QtSensors

bytes = str


class QRotationReading(PySide6.QtSensors.QSensorReading):
    """
    https://doc.qt.io/qt-6/qrotationreading.html

    **Detailed Description**

    **QRotationReading Units**

    The rotation reading contains 3 angles, measured in degrees that define the
    orientation of the device in three-dimensional space. These angles are
    similar to yaw, pitch and roll but are defined using only right hand
    rotation with axes as defined by the right hand cartesian coordinate system.

    ![](images/sensors-rotation.jpg)

    The three angles are applied to the device in the following order.

    * Right-handed rotation z (-180, 180]. Starting from the y-axis and
    incrementing in the counter-clockwise direction.
      * Right-handed rotation x
    [-90, 90]. Starting from the new (once-rotated) y-axis and incrementing
    towards the z-axis.
      * Right-handed rotation y (-180, 180]. Starting from
    the new (twice-rotated) z-axis and incrementing towards the x-axis.

    Here is a visualization showing the order in which angles are applied.

    ![](images/sensors-rotation-anim.gif)

    The 0 point for the z angle is defined as a fixed, external entity and is
    device-specific. While magnetic North is typically used as this reference
    point it may not be. Do not attempt to compare values for the z angle
    between devices or even on the same device if it has moved a significant
    distance.

    If the device cannot detect a fixed, external entity the z angle will always
    be 0 and the **QRotationSensor::hasZ**  property will be set to false.

    The 0 point for the x and y angles are defined as when the x and y axes of
    the device are oriented towards the horizon. Here is an example of how the x
    value will change with device movement.

    ![](images/sensors-rotation2.jpg)

    Here is an example of how the y value will change with device movement.

    ![](images/sensors-rotation3.jpg)

    Note that when x is 90 or -90, values for z and y achieve rotation around
    the same axis (due to the order of operations). In this case the y rotation
    will be 0.
    """

    def __init__(self, parent: PySide6.QtCore.QObject) -> None:
        ...

    def copyValuesFrom(self, other: PySide6.QtSensors.QSensorReading) -> None:
        ...

    def setFromEuler(self, x: float, y: float, z: float) -> None:
        """
        https://doc.qt.io/qt-6/qrotationreading.html#setFromEuler

        **[since 5.0] void QRotationReading::setFromEuler(qreal x , qreal y ,
        qreal z )**

        Sets the rotation from three euler angles.

        This is to be called from the backend.

        The angles are measured in degrees. The order of the rotations matters,
        as first the **z** rotation is applied, then the **x** rotation and
        finally the **y** rotation.

        This function was introduced in Qt 5.0.
        """
        ...

    def x(self) -> float:
        """
        https://doc.qt.io/qt-6/qrotationreading.html#x-prop

        **[read-only] x : const qreal**

        This property holds the rotation around the x axis.

        Measured as degrees.

        **Access functions:**

        qreal **x** () const

        **See also** **QRotationReading Units** .
        """
        ...

    def y(self) -> float:
        """
        https://doc.qt.io/qt-6/qrotationreading.html#y-prop

        **[read-only] y : const qreal**

        This property holds the rotation around the y axis.

        Measured as degrees.

        **Access functions:**

        qreal **y** () const

        **See also** **QRotationReading Units** .
        """
        ...

    def z(self) -> float:
        """
        https://doc.qt.io/qt-6/qrotationreading.html#z-prop

        **[read-only] z : const qreal**

        This property holds the rotation around the z axis.

        Measured as degrees.

        **Access functions:**

        qreal **z** () const

        **See also** **QRotationReading Units** .

        **Member Function Documentation**
        """
        ...
