"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtSensors, except for defaults which are replaced by "...".
"""
import PySide6.QtCore
import PySide6.QtSensors

bytes = str


class QPressureReading(PySide6.QtSensors.QSensorReading):
    """
    https://doc.qt.io/qt-6/qpressurereading.html

    **Detailed Description**

    **QPressureReading Units**

    The pressure sensor returns atmospheric pressure values in Pascals.
    """

    def __init__(self, parent: PySide6.QtCore.QObject) -> None:
        ...

    def copyValuesFrom(self, other: PySide6.QtSensors.QSensorReading) -> None:
        ...

    def pressure(self) -> float:
        """
        https://doc.qt.io/qt-6/qpressurereading.html#pressure-prop

        **[read-only] pressure : const qreal**

        This property holds the measured atmospheric pressure.

        Returned as Pascals.

        **Access functions:**

        qreal **pressure** () const

        **See also** **QPressureReading Units** .
        """
        ...

    def setPressure(self, pressure: float) -> None:
        """
        https://doc.qt.io/qt-6/qpressurereading.html#setPressure

        **void QPressureReading::setPressure(qreal pressure )**

        Sets the pressure to **pressure**.

        **See also** **pressure** ().
        """
        ...

    def setTemperature(self, temperature: float) -> None:
        """
        https://doc.qt.io/qt-6/qpressurereading.html#setTemperature

        **[since 5.2] void QPressureReading::setTemperature(qreal temperature
        )**

        Sets the pressure sensor's temperature to **temperature**.

        This function was introduced in Qt 5.2.

        **See also** **temperature** ().
        """
        ...

    def temperature(self) -> float:
        """
        https://doc.qt.io/qt-6/qpressurereading.html#temperature-prop

        **[read-only, since 5.2] temperature : const qreal**

        This property holds the pressure sensor's temperature.

        The temperature is returned in degree Celsius. This property, if
        supported, provides the pressure sensor die temperature. Note that this
        temperature may be (and usually is) different than the temperature
        reported from **QAmbientTemperatureSensor** . Use
        **QSensor::isFeatureSupported** () with the
        **QSensor::PressureSensorTemperature**  flag to determine its
        availability.

        This property was introduced in Qt 5.2.

        **Access functions:**

        qreal **temperature** () const

        **Member Function Documentation**
        """
        ...
