"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtSensors, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtSensors

bytes = str


class QLightSensor(PySide6.QtSensors.QSensor):
    """
    https://doc.qt.io/qt-6/qlightsensor.html

    **Detailed Description**

    The only behavioural difference is that this class sets the type properly.

    This class also features a **reading** () function that returns a
    **QLightReading**  instead of a **QSensorReading** .

    For details about how the sensor works, see **QLightReading** .

    **See also** **QLightReading** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qlightsensor.html#QLightSensor

        **QLightSensor::QLightSensor(QObject * parent = nullptr)**

        Construct the sensor as a child of **parent**.
        """
        ...

    def fieldOfView(self) -> float:
        """
        https://doc.qt.io/qt-6/qlightsensor.html#fieldOfView-prop

        **[read-only] fieldOfView : const qreal**

        This property holds a value indicating the field of view.

        This is an angle that represents the field of view of the sensor.

        Not all light sensor support retrieving their field of view. For sensors
        that don't support this property, the value will be 0. Whether the field
        of view is supported can be checked with **QSensor::isFeatureSupported**
        () and the **QSensor::FieldOfView**  flag.

        **Access functions:**

        qreal **fieldOfView** () const

        **Notifier signal:**

        void **fieldOfViewChanged** (qreal **fieldOfView** )

        **Member Function Documentation**
        """
        ...

    def reading(self) -> PySide6.QtSensors.QLightReading:
        """
        https://doc.qt.io/qt-6/qlightsensor.html#reading

        **QLightReading *QLightSensor::reading() const**

        Returns the reading class for this sensor.

        **See also** **QSensor::reading** ().
        """
        ...

    def setFieldOfView(self, fieldOfView: float) -> None:
        """
        https://doc.qt.io/qt-6/qlightsensor.html#setFieldOfView

        **[since 5.1] void QLightSensor::setFieldOfView(qreal fieldOfView )**

        Sets the field of view to **fieldOfView**. This is to be called from the
        backend.

        This function was introduced in Qt 5.1.

        **See also** **fieldOfView** ().
        """
        ...

    @property
    def fieldOfViewChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
