"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtSensors, except for defaults which are replaced by "...".
"""
from enum import Enum
import PySide6.QtCore
import PySide6.QtSensors

bytes = str


class QAmbientLightReading(PySide6.QtSensors.QSensorReading):
    """
    https://doc.qt.io/qt-6/qambientlightreading.html

    **Detailed Description**

    **QAmbientLightReading Units**

    The ambient light sensor returns the intensity of the ambient light using
    the pre-defined values found in the **QAmbientLightReading::LightLevel**
    enum.
    """

    Undefined: QAmbientLightReading.LightLevel = ...
    Dark: QAmbientLightReading.LightLevel = ...
    Twilight: QAmbientLightReading.LightLevel = ...
    Light: QAmbientLightReading.LightLevel = ...
    Bright: QAmbientLightReading.LightLevel = ...
    Sunny: QAmbientLightReading.LightLevel = ...

    class LightLevel(Enum):
        Undefined: QAmbientLightReading.LightLevel = ...
        Dark: QAmbientLightReading.LightLevel = ...
        Twilight: QAmbientLightReading.LightLevel = ...
        Light: QAmbientLightReading.LightLevel = ...
        Bright: QAmbientLightReading.LightLevel = ...
        Sunny: QAmbientLightReading.LightLevel = ...

    def __init__(self, parent: PySide6.QtCore.QObject) -> None:
        ...

    def copyValuesFrom(self, other: PySide6.QtSensors.QSensorReading) -> None:
        ...

    def lightLevel(self) -> PySide6.QtSensors.QAmbientLightReading.LightLevel:
        """
        https://doc.qt.io/qt-6/qambientlightreading.html#lightLevel-prop

        **[read-only] lightLevel : const LightLevel**

        This property holds the ambient light level.

        The value represents the ambient light and comes from
        **QAmbientLightReading::LightLevel** .

        **Access functions:**

        QAmbientLightReading::LightLevel **lightLevel** () const

        **See also** **QAmbientLightReading Units** .

        **Member Function Documentation**
        """
        ...

    def setLightLevel(
        self, lightLevel: PySide6.QtSensors.QAmbientLightReading.LightLevel
    ) -> None:
        """
        https://doc.qt.io/qt-6/qambientlightreading.html#setLightLevel

        **void
        QAmbientLightReading::setLightLevel(QAmbientLightReading::LightLevel
        lightLevel )**

        Sets the ambient light level to **lightLevel**.

        **See also** **lightLevel** ().
        """
        ...
