"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtRemoteObjects, except for defaults which are replaced by "...".
"""
from typing import Optional
import PySide6.QtCore
import PySide6.QtRemoteObjects

bytes = str


class QRemoteObjectPendingCallWatcher(
    PySide6.QtCore.QObject, PySide6.QtRemoteObjects.QRemoteObjectPendingCall
):
    """
    https://doc.qt.io/qt-6/qremoteobjectpendingcallwatcher.html

    **Detailed Description**

    QRemoteObjectPendingCallWatcher provides a signal indicating when a
    **QRemoteObjectPendingCall**  has finished, allowing for convenient, non-
    blocking handling of the call.
    """

    def __init__(
        self,
        call: PySide6.QtRemoteObjects.QRemoteObjectPendingCall,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        ...

    def isFinished(self) -> bool:
        """
        https://doc.qt.io/qt-6/qremoteobjectpendingcallwatcher.html#isFinished

        **bool QRemoteObjectPendingCallWatcher::isFinished() const**

        Returns true if the remote call has finished, false otherwise.

        A finished call will include a returnValue or error.
        """
        ...

    def waitForFinished(self) -> None:
        """
        https://doc.qt.io/qt-6/qremoteobjectpendingcallwatcher.html#waitForFinis
        hed

        **void QRemoteObjectPendingCallWatcher::waitForFinished()**

        Blocks until the remote call has finished.
        """
        ...

    @property
    def finished(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qremoteobjectpendingcallwatcher.html#finished

        **[signal] void QRemoteObjectPendingCallWatcher::finished(QRemoteObjectP
        endingCallWatcher * self )**

        This signal is emitted when the remote call has finished. **self** is
        the pointer to the watcher object that emitted the signal. A finished
        call will include a returnValue or error.
        """
        ...
