"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtRemoteObjects, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, overload
import PySide6.QtCore
import PySide6.QtRemoteObjects

bytes = str


class QRemoteObjectPendingCall(object):
    """
    https://doc.qt.io/qt-6/qremoteobjectpendingcall.html

    **Detailed Description**
    """

    NoError: QRemoteObjectPendingCall.Error = ...
    InvalidMessage: QRemoteObjectPendingCall.Error = ...

    class Error(Enum):
        NoError: QRemoteObjectPendingCall.Error = ...
        InvalidMessage: QRemoteObjectPendingCall.Error = ...

    @overload
    def __init__(self) -> None:
        ...

    @overload
    def __init__(self, other: PySide6.QtRemoteObjects.QRemoteObjectPendingCall) -> None:
        ...

    def error(self) -> PySide6.QtRemoteObjects.QRemoteObjectPendingCall.Error:
        """
        https://doc.qt.io/qt-6/qremoteobjectpendingcall.html#error

        **QRemoteObjectPendingCall::Error QRemoteObjectPendingCall::error()
        const**

        Returns the error, if any, from the remote call.
        """
        ...

    @staticmethod
    def fromCompletedCall(
        returnValue: Any,
    ) -> PySide6.QtRemoteObjects.QRemoteObjectPendingCall:
        ...

    def isFinished(self) -> bool:
        """
        https://doc.qt.io/qt-6/qremoteobjectpendingcall.html#isFinished

        **bool QRemoteObjectPendingCall::isFinished() const**

        Returns true if the remote call has finished, false otherwise.

        A finished call will include a **returnValue**  or **error** .
        """
        ...

    def returnValue(self) -> Any:
        """
        https://doc.qt.io/qt-6/qremoteobjectpendingcall.html#returnValue

        **QVariant QRemoteObjectPendingCall::returnValue() const**

        Returns the return value of the remote call.

        returnValue will only be valid when the remote call has finished and
        there are no **error** s.
        """
        ...

    def waitForFinished(self, timeout: int = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qremoteobjectpendingcall.html#waitForFinished

        **bool QRemoteObjectPendingCall::waitForFinished(int timeout = 30000)**

        Blocks for up to **timeout** milliseconds, until the remote call has
        finished.

        Returns `true` on success, `false` otherwise.
        """
        ...
