"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtQuick3D, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtQml
import PySide6.QtQuick3D

bytes = str


class QQuick3DGeometry(PySide6.QtQuick3D.QQuick3DObject):
    """
    https://doc.qt.io/qt-6/qquick3dgeometry.html

    **Detailed Description**

    The QQuick3DGeometry can be used to specify custom geometry for a Model in
    the Qt Quick 3D scene.

    While not strictly required, the typical usage is to inherit from this
    class. The subclass is then exposed to QML by registering it to the type
    system. The **geometry**  property of a Model can then be set to reference
    an instance of the registered type.

    The high-level structure of such a class is typically similar to the
    following:

    class CustomGeometry : public QQuick3DGeometry
        {
        public:
    CustomGeometry() { rebuildGeometry(); }

            void setSomething() {
    // Change relevant internal data.
               // ...

               // Then
    rebuild the vertex and index data and pass it to QQuick3DGeometry.
    rebuildGeometry();

               // Finally, trigger an update. This is
    relevant in case nothing else
               // is changing in the scene; this
    way we make sure a new frame will
               // be rendered.
    update();
            }

        private:
            void rebuildGeometry()
    {
                **QByteArray**  vertices;
                **QByteArray**  indices;
    ...
                setPrimitiveType(Lines);
    setVertexBuffer(vertices);
                setIndexBuffer(indices);
    setStride(3 * sizeof(float)); // e.g. when having 3 components per vertex
    setBounds(...); // minimum and maximum extents, for picking
    addAttribute(PositionSemantic, 0, F32Type);
                ...
            }
        };

    This class can then be registered as a QML type and used with **Model** .

    In Qt 5 type registration happened with **qmlRegisterType** :

    qmlRegisterType<CustomGeometry>("Example", 1, 0, "CustomGeometry");

    In Qt 6 the default approach is to use automatic registration with the help
    of the build system. Instead of calling **qmlRegisterType** , the `.pro`
    file can now contain:

    CONFIG += qmltypes
        QML_IMPORT_NAME = Example
    QML_IMPORT_MAJOR_VERSION = 1

    With CMake, automatic registration is the default behavior, so no special
    settings are needed beyond basic QML module setup:

    qt_add_qml_module(application
            URI Example
            VERSION 1.0
        )

    The class implementation should add **QML_NAMED_ELEMENT** :

    class CustomGeometry : public QQuick3DGeometry
        {
            Q_OBJECT
    QML_NAMED_ELEMENT(CustomGeometry)
            ...
        };

    The QML code can then use the custom type:

    import Example 1.0

        Model {
            id: customModel
    geometry: CustomGeometry {
            }
        }

    At minimum, a custom geometry should have the following specified:

    * vertex data,
      * vertex stride,
      * primitive type,
      * an attribute with
    PositionSemantic.

    These are sufficient to render the mesh. For indexed drawing, the index
    buffer data and an attribute with IndexSemantic needs to be specified as
    well. In order to support picking (input), the class must specify the
    bounding volume using **setBounds** (). For proper lighting, an attribute
    with NormalSemantic is needed. When the material uses texturing, at least
    one set of UV coordinates must be provided and described in an
    TexCoord0Semantic or TexCoord1Semantic attribute. Some materials may require
    tangents and binormals as well.

    As a concrete, minimal example, the following class would provide geometry
    for a single triangle:

    class ExampleGeometry : public QQuick3DGeometry
        {
            Q_OBJECT
    QML_NAMED_ELEMENT(ExampleGeometry)

        public:
    ExampleGeometry();

        private:
            void updateData();
        };
    ExampleGeometry::ExampleGeometry()
        {
            updateData();
        }
    void ExampleGeometry::updateData()
        {
            **QByteArray**  v;
    v.resize(3 * 3 * sizeof(float));
            float *p = reinterpret_cast<float
    *>(v.data());

            // a triangle, front face = counter-clockwise
    *p++ = -1.0f; *p++ = -1.0f; *p++ = 0.0f;
            *p++ = 1.0f; *p++ = -1.0f;
    *p++ = 0.0f;
            *p++ = 0.0f; *p++ = 1.0f; *p++ = 0.0f;
    setVertexData(v);
            setStride(3 * sizeof(float));
    setPrimitiveType(QQuick3DGeometry::PrimitiveType::Triangles);
    addAttribute(QQuick3DGeometry::Attribute::PositionSemantic,
    0,
                         QQuick3DGeometry::Attribute::F32Type);
        }

    Depending on the lighting in the scene, the result of referencing this
    geometry from a Model:

    ![](images/customgeometry.jpg)

    **Note:** Vertex data is expected to follow OpenGL conventions. This means
    the data must be provided with the assumption that the Y axis is pointing up
    in the normalized device coordinate system, and that front faces have a
    counter clockwise winding.

    **See also** **Model**  and **Geometry** .
    """

    class Attribute(object):
        U16Type: QQuick3DGeometry.Attribute.ComponentType = ...
        U32Type: QQuick3DGeometry.Attribute.ComponentType = ...
        I32Type: QQuick3DGeometry.Attribute.ComponentType = ...
        F32Type: QQuick3DGeometry.Attribute.ComponentType = ...
        IndexSemantic: QQuick3DGeometry.Attribute.Semantic = ...
        PositionSemantic: QQuick3DGeometry.Attribute.Semantic = ...
        NormalSemantic: QQuick3DGeometry.Attribute.Semantic = ...
        TexCoord0Semantic: QQuick3DGeometry.Attribute.Semantic = ...
        TexCoordSemantic: QQuick3DGeometry.Attribute.Semantic = ...
        TangentSemantic: QQuick3DGeometry.Attribute.Semantic = ...
        BinormalSemantic: QQuick3DGeometry.Attribute.Semantic = ...
        JointSemantic: QQuick3DGeometry.Attribute.Semantic = ...
        WeightSemantic: QQuick3DGeometry.Attribute.Semantic = ...
        ColorSemantic: QQuick3DGeometry.Attribute.Semantic = ...
        TargetPositionSemantic: QQuick3DGeometry.Attribute.Semantic = ...
        TargetNormalSemantic: QQuick3DGeometry.Attribute.Semantic = ...
        TargetTangentSemantic: QQuick3DGeometry.Attribute.Semantic = ...
        TargetBinormalSemantic: QQuick3DGeometry.Attribute.Semantic = ...
        TexCoord1Semantic: QQuick3DGeometry.Attribute.Semantic = ...

        class ComponentType(Enum):
            U16Type: QQuick3DGeometry.Attribute.ComponentType = ...
            U32Type: QQuick3DGeometry.Attribute.ComponentType = ...
            I32Type: QQuick3DGeometry.Attribute.ComponentType = ...
            F32Type: QQuick3DGeometry.Attribute.ComponentType = ...

        class Semantic(Enum):
            IndexSemantic: QQuick3DGeometry.Attribute.Semantic = ...
            PositionSemantic: QQuick3DGeometry.Attribute.Semantic = ...
            NormalSemantic: QQuick3DGeometry.Attribute.Semantic = ...
            TexCoord0Semantic: QQuick3DGeometry.Attribute.Semantic = ...
            TexCoordSemantic: QQuick3DGeometry.Attribute.Semantic = ...
            TangentSemantic: QQuick3DGeometry.Attribute.Semantic = ...
            BinormalSemantic: QQuick3DGeometry.Attribute.Semantic = ...
            JointSemantic: QQuick3DGeometry.Attribute.Semantic = ...
            WeightSemantic: QQuick3DGeometry.Attribute.Semantic = ...
            ColorSemantic: QQuick3DGeometry.Attribute.Semantic = ...
            TargetPositionSemantic: QQuick3DGeometry.Attribute.Semantic = ...
            TargetNormalSemantic: QQuick3DGeometry.Attribute.Semantic = ...
            TargetTangentSemantic: QQuick3DGeometry.Attribute.Semantic = ...
            TargetBinormalSemantic: QQuick3DGeometry.Attribute.Semantic = ...
            TexCoord1Semantic: QQuick3DGeometry.Attribute.Semantic = ...

        @overload
        def __init__(self) -> None:
            ...

        @overload
        def __init__(
            self, Attribute: PySide6.QtQuick3D.QQuick3DGeometry.Attribute
        ) -> None:
            ...

        @staticmethod
        def __copy__() -> None:
            ...

    class PrimitiveType(Enum):
        Points: QQuick3DGeometry.PrimitiveType = ...
        LineStrip: QQuick3DGeometry.PrimitiveType = ...
        Lines: QQuick3DGeometry.PrimitiveType = ...
        TriangleStrip: QQuick3DGeometry.PrimitiveType = ...
        TriangleFan: QQuick3DGeometry.PrimitiveType = ...
        Triangles: QQuick3DGeometry.PrimitiveType = ...

    def __init__(
        self, parent: Optional[PySide6.QtQuick3D.QQuick3DObject] = ...
    ) -> None:
        ...

    @overload
    def addAttribute(self, att: PySide6.QtQuick3D.QQuick3DGeometry.Attribute) -> None:
        """
        https://doc.qt.io/qt-6/qquick3dgeometry.html#addAttribute

        **void QQuick3DGeometry::addAttribute(Attribute::Semantic semantic , int
        offset , Attribute::ComponentType componentType )**

        Adds vertex attribute description. Each attribute has a **semantic** ,
        which specifies the usage of the attribute and the number of components
        it has, an **offset** from the beginning to the vertex to the attribute
        location inside a vertex and a **componentType** specifying the datatype
        and size of the attribute.

        The semantic can be one of the following:

        ConstantDescription
        `PositionSemantic`The attribute is a position. 3
        components: **x** , **y** , and **z**
        `NormalSemantic`The attribute is
        a normal vector. 3 components: **x** , **y** , and **z**
        `TexCoord0Semantic`The attribute is a texture coordinate. 2 components:
        **u** and **v**
        `TexCoord1Semantic`The attribute is a texture
        coordinate. 2 components: **u** and **v**
        `TangentSemantic`The
        attribute is a tangent vector. 3 components: **x** , **y** , and **z**
        `BinormalSemantic`The attribute is a binormal vector. 3 components:
        **x** , **y** , and **z**
        `JointSemantic`The attribute is a joint
        index vector for **skinning** . 4 components: joint index 1-4
        `WeightSemantic`The attribute is a weight vector for **skinning** . 4
        components: joint weight 1-4
        `ColorSemantic`The attribute is a vertex
        color vector. 4 components: **r** , **g** , **b** , and **a**
        `TargetPositionSemantic`The attribute is a position for the first
        **morph target** . 3 components: **x** , **y** , and **z**
        `TargetNormalSemantic`The attribute is a normal vector for the first
        **morph target** . 3 components: **x** , **y** , and **z**
        `TargetTangentSemantic`The attribute is a tangent vector for the first
        **morph target** . 3 components: **x** , **y** , and **z**
        `TargetBinormalSemantic`The attribute is a binormal vector for the first
        **morph target** . 3 components: **x** , **y** , and **z**

        In addition, **semantic** can be `IndexSemantic`. In this case the
        attribute does not represent an entry in the vertex buffer, but rather
        describes the index data in the index buffer. Since there is always just
        one index per vertex, **offset** makes no sense for the index buffer,
        and should be left at zero.

        The component type can be one of the following:

        ConstantDescription
        `U16Type`The attribute is an unsigned 16-bit
        integer.
        `U32Type`The attribute is an unsigned 32-bit integer.
        `I32Type`The attribute is a signed 32-bit integer.
        `F32Type`The
        attribute is a single-precision float.

        **Note:** The joint index data is typically `I32Type`. `F32Type` is also
        supported in order to enable functioning with APIs, such as OpenGL ES
        2.0, that do not support integer vertex input attributes.
        """
        ...

    @overload
    def addAttribute(
        self,
        semantic: PySide6.QtQuick3D.QQuick3DGeometry.Attribute.Semantic,
        offset: int,
        componentType: PySide6.QtQuick3D.QQuick3DGeometry.Attribute.ComponentType,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qquick3dgeometry.html#addAttribute-1

        **void QQuick3DGeometry::addAttribute(const QQuick3DGeometry::Attribute
        & attribute )**

        This is an overloaded function.

        Adds vertex attribute description. Each attribute has a semantic, which
        specifies the usage of the attribute and the number of components it
        has, an offset from the beginning to the vertex to the attribute
        location inside a vertex and a componentType specifying the datatype and
        size of the attribute.
        """
        ...

    def attribute(self, index: int) -> PySide6.QtQuick3D.QQuick3DGeometry.Attribute:
        """
        https://doc.qt.io/qt-6/qquick3dgeometry.html#attribute

        **QQuick3DGeometry::Attribute QQuick3DGeometry::attribute(int index )
        const**

        Returns attribute definition number **index**

        The attribute definitions are numbered from 0 to `attributeCount() - 1`
        """
        ...

    def attributeCount(self) -> int:
        """
        https://doc.qt.io/qt-6/qquick3dgeometry.html#attributeCount

        **int QQuick3DGeometry::attributeCount() const**

        Returns the number of attributes defined for this geometry.

        **See also** **attribute** .
        """
        ...

    def boundsMax(self) -> PySide6.QtGui.QVector3D:
        """
        https://doc.qt.io/qt-6/qquick3dgeometry.html#boundsMax

        **QVector3D QQuick3DGeometry::boundsMax() const**

        Returns the maximum coordinate of the bounding volume.

        **See also** **setBounds** .
        """
        ...

    def boundsMin(self) -> PySide6.QtGui.QVector3D:
        """
        https://doc.qt.io/qt-6/qquick3dgeometry.html#boundsMin

        **QVector3D QQuick3DGeometry::boundsMin() const**

        Returns the minimum coordinate of the bounding volume.

        **See also** **setBounds** .
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qquick3dgeometry.html#clear

        **void QQuick3DGeometry::clear()**

        Resets the geometry to its initial state, clearing previously set vertex
        and index data as well as attributes.
        """
        ...

    def indexData(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qquick3dgeometry.html#indexData

        **QByteArray QQuick3DGeometry::indexData() const**

        Returns the index buffer data.

        **See also** **setIndexData** ().
        """
        ...

    def markAllDirty(self) -> None:
        ...

    def primitiveType(self) -> PySide6.QtQuick3D.QQuick3DGeometry.PrimitiveType:
        """
        https://doc.qt.io/qt-6/qquick3dgeometry.html#primitiveType

        **QQuick3DGeometry::PrimitiveType QQuick3DGeometry::primitiveType()
        const**

        Returns the primitive type used when rendering. The default is
        `Triangles`.

        **See also** **setPrimitiveType** .
        """
        ...

    def setBounds(
        self, min: PySide6.QtGui.QVector3D, max: PySide6.QtGui.QVector3D
    ) -> None:
        """
        https://doc.qt.io/qt-6/qquick3dgeometry.html#setBounds

        **void QQuick3DGeometry::setBounds(const QVector3D & min , const
        QVector3D & max )**

        Sets the bounding volume of the geometry to the cube defined by the
        points **min** and **max**. This is used for **picking** .
        """
        ...

    @overload
    def setIndexData(self, data: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qquick3dgeometry.html#setIndexData

        **void QQuick3DGeometry::setIndexData(const QByteArray & data )**

        Sets the index buffer to **data**. To use indexed drawing, add an
        attribute with `IndexSemantic`

        **See also** **indexData** () and **addAttribute** .
        """
        ...

    @overload
    def setIndexData(
        self, offset: int, data: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qquick3dgeometry.html#setIndexData-1

        **void QQuick3DGeometry::setIndexData(int offset , const QByteArray &
        data )**

        This is an overloaded function.

        Updates a subset of the index buffer. **offset** specifies the offset in
        bytes, **data** specifies the size and the data.

        This function will not resize the buffer. If `offset + data.size()` is
        greater than the current size of the buffer, the overshooting data will
        be ignored.

        **Note:** The partial update functions for vertex and index data do not
        offer any guarantee on how such changes are implemented internally.
        Depending on the underlying implementation, even partial changes may
        lead to updating the entire graphics resource.
        """
        ...

    def setPrimitiveType(
        self, type: PySide6.QtQuick3D.QQuick3DGeometry.PrimitiveType
    ) -> None:
        """
        https://doc.qt.io/qt-6/qquick3dgeometry.html#setPrimitiveType

        **void
        QQuick3DGeometry::setPrimitiveType(QQuick3DGeometry::PrimitiveType type
        )**

        Sets the primitive type used for rendering to **type**.

        ConstantDescription
        `Points`The primitives are points.
        `LineStrip`The primitives are lines in a strip.
        `Lines`The primitives
        are lines in a list.
        `TriangleStrip`The primitives are triangles in a
        strip.
        `TriangleFan`The primitives are triangles in a fan. Be aware
        that triangle fans may not be supported at run time, depending on the
        underlying graphics API.
        `Triangles`The primitives are triangles in a
        list.

        The initial value is `Triangles`.

        **Note:** Be aware that triangle fans (TriangleFan) may not be supported
        at run time, depending on the underlying graphics API. For example, with
        Direct 3D this topology will not be functional at all.

        **Note:** The point size for Points and the line width for Lines and
        LineStrip are controlled by the **material** . Be aware however that
        sizes other than 1 may not be supported at run time, depending on the
        underlying graphics API.

        **See also** **primitiveType** ().
        """
        ...

    def setStride(self, stride: int) -> None:
        """
        https://doc.qt.io/qt-6/qquick3dgeometry.html#setStride

        **void QQuick3DGeometry::setStride(int stride )**

        Sets the stride of the vertex buffer to **stride** , measured in bytes.
        This is the distance between two consecutive vertices in the buffer.

        For example, a tightly packed, interleaved vertex buffer for a geometry
        using `PositionSemantic`, `IndexSemantic`, and `ColorSemantic` will have
        a stride of `28` (Seven floats in total: Three for position, four for
        color, and none for indexes, which do not go in the vertex buffer.)

        **Note:****QQuick3DGeometry**  expects, and works only with, vertex data
        with an interleaved attribute layout.

        **See also** **stride** () and **addAttribute** .
        """
        ...

    @overload
    def setVertexData(self, data: Union[PySide6.QtCore.QByteArray, bytes]) -> None:
        """
        https://doc.qt.io/qt-6/qquick3dgeometry.html#setVertexData

        **void QQuick3DGeometry::setVertexData(const QByteArray & data )**

        Sets the vertex buffer **data**. The buffer should hold all the vertex
        data packed in the array, as described by the attribute definitions.
        Note that this does not include attributes with `IndexSemantic`, which
        belong in the index buffer.

        **See also** **vertexData** (), **addAttribute** , **setStride** , and
        **setIndexData** .
        """
        ...

    @overload
    def setVertexData(
        self, offset: int, data: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qquick3dgeometry.html#setVertexData-1

        **void QQuick3DGeometry::setVertexData(int offset , const QByteArray &
        data )**

        This is an overloaded function.

        Updates a subset of the vertex buffer. **offset** specifies the offset
        in bytes, **data** specifies the size and the data.

        This function will not resize the buffer. If `offset + data.size()` is
        greater than the current size of the buffer, the overshooting data will
        be ignored.

        **Note:** The partial update functions for vertex and index data do not
        offer any guarantee on how such changes are implemented internally.
        Depending on the underlying implementation, even partial changes may
        lead to updating the entire graphics resource.
        """
        ...

    def stride(self) -> int:
        """
        https://doc.qt.io/qt-6/qquick3dgeometry.html#stride

        **int QQuick3DGeometry::stride() const**

        Returns the byte stride of the vertex buffer.

        **See also** **setStride** .
        """
        ...

    def vertexData(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qquick3dgeometry.html#vertexData

        **QByteArray QQuick3DGeometry::vertexData() const**

        Returns the vertex buffer data set by **setVertexData** .

        **See also** **setVertexData** ().
        """
        ...
