"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtQuick3D, except for defaults which are replaced by "...".
"""
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtQml
import PySide6.QtQuick3D

bytes = str


class QQuick3D(object):
    """
    https://doc.qt.io/qt-6/qquick3d.html

    **Detailed Description**

    When using Qt Quick 3D with OpenGL it is necessary to take extra steps to
    define what kind of **surface format**  is used when initializing Qt Quick.
    This is because by the time Qt Quick is aware that 3D content is being used,
    the OpenGL context and window surface has already been initialized. So this
    helper class is provided to request the ideal surface format from Qt Quick
    3D so that it can be set as the default surface for Qt Quick before
    initialization.

    If this helper is run when using any other rendering backends than OpenGL
    then it just returns a copy of the current default **QSurfaceFormat**  with
    the requested samples.

    If this helper is run when using the OpenGL rendering backend, then it will
    test for sufficiently modern versions of OpenGL and support for
    multisampling if requested. Normally Qt Quick will request an OpenGL 2.0 or
    OpenGL ES 2.0 context, which would limit the features available when using
    Qt Quick 3D, so an extra step is needed to request a more capable context.

    The correct usage pattern is to call **QSurfaceFormat::setDefaultFormat**
    to set the **QSurfaceFormat**  returned by **QQuick3D::idealSurfaceFormat**
    . It is important that this method is called after **QGuiApplication**  is
    constructed, but before the Qt Quick application content is loaded. This
    code snippet shows the correct usage pattern:

    #include <QGuiApplication>
        #include <QQmlApplicationEngine>
    #include <QtGui>
        #include <QtQuick3D/qquick3d.h>

        int main(int
    argc, char *argv[])
        {
            **QGuiApplication**  app(argc, argv);
    **QSurfaceFormat** ::setDefaultFormat(QQuick3D::idealSurfaceFormat(4));
    **QQmlApplicationEngine**  engine;
            engine.load(**QUrl**
    (**QStringLiteral** ("qrc:/main.qml")));
            if
    (engine.rootObjects().isEmpty())
                return -1;

            return
    app.exec();
        }
    """

    def __init__(self) -> None:
        ...

    @staticmethod
    def idealSurfaceFormat(samples: int = ...) -> PySide6.QtGui.QSurfaceFormat:
        """
        https://doc.qt.io/qt-6/qquick3d.html#idealSurfaceFormat

        **[static] QSurfaceFormat QQuick3D::idealSurfaceFormat(int samples =
        -1)**

        Returns an ideal surface format for the platform. Optionally,
        **samples** can be specified to select the number of multisamples for
        antialiasing.
        """
        ...
