"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtQuick, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtOpenGL
import PySide6.QtQml
import PySide6.QtQuick

bytes = str


class QSGSimpleTextureNode(PySide6.QtQuick.QSGGeometryNode):
    """
    https://doc.qt.io/qt-6/qsgsimpletexturenode.html

    **Detailed Description**

    **Warning:** The simple texture node class must have a texture before being
    added to the scene graph to be rendered.

    **Warning:** This utility class is only functional when running with the
    default or software backends of the Qt Quick scenegraph. As an alternative,
    prefer using **QSGImageNode**  via **QQuickWindow::createImageNode** ().
    However, this standalone class is still useful when used via subclassing and
    the application knows that no special scenegraph backends will be involved.
    """

    NoTransform: QSGSimpleTextureNode.TextureCoordinatesTransformFlag = ...
    MirrorHorizontally: QSGSimpleTextureNode.TextureCoordinatesTransformFlag = ...
    MirrorVertically: QSGSimpleTextureNode.TextureCoordinatesTransformFlag = ...

    class TextureCoordinatesTransformFlag(Enum):
        NoTransform: QSGSimpleTextureNode.TextureCoordinatesTransformFlag = ...
        MirrorHorizontally: QSGSimpleTextureNode.TextureCoordinatesTransformFlag = ...
        MirrorVertically: QSGSimpleTextureNode.TextureCoordinatesTransformFlag = ...

    class TextureCoordinatesTransformMode(object):
        ...

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qsgsimpletexturenode.html#QSGSimpleTextureNode

        **QSGSimpleTextureNode::QSGSimpleTextureNode()**

        Constructs a new simple texture node
        """
        ...

    def filtering(self) -> PySide6.QtQuick.QSGTexture.Filtering:
        """
        https://doc.qt.io/qt-6/qsgsimpletexturenode.html#filtering

        **QSGTexture::Filtering QSGSimpleTextureNode::filtering() const**

        Returns the filtering currently set on this texture node

        **See also** **setFiltering** ().
        """
        ...

    def ownsTexture(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsgsimpletexturenode.html#ownsTexture

        **[since 5.4] bool QSGSimpleTextureNode::ownsTexture() const**

        Returns `true` if the node takes ownership of the texture; otherwise
        returns `false`.

        This function was introduced in Qt 5.4.

        **See also** **setOwnsTexture** ().
        """
        ...

    def rect(self) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qsgsimpletexturenode.html#rect

        **QRectF QSGSimpleTextureNode::rect() const**

        Returns the target rect of this texture node.

        **See also** **setRect** ().
        """
        ...

    def setFiltering(self, filtering: PySide6.QtQuick.QSGTexture.Filtering) -> None:
        """
        https://doc.qt.io/qt-6/qsgsimpletexturenode.html#setFiltering

        **void QSGSimpleTextureNode::setFiltering(QSGTexture::Filtering
        filtering )**

        Sets the filtering to be used for this texture node to **filtering**.

        For smooth scaling, use **QSGTexture::Linear** ; for normal scaling, use
        **QSGTexture::Nearest** .

        **See also** **filtering** ().
        """
        ...

    def setOwnsTexture(self, owns: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsgsimpletexturenode.html#setOwnsTexture

        **[since 5.4] void QSGSimpleTextureNode::setOwnsTexture(bool owns )**

        Sets whether the node takes ownership of the texture to **owns**.

        By default, the node does not take ownership of the texture.

        This function was introduced in Qt 5.4.

        **See also** **ownsTexture** () and **setTexture** ().
        """
        ...

    @overload
    def setRect(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None:
        """
        https://doc.qt.io/qt-6/qsgsimpletexturenode.html#setRect

        **void QSGSimpleTextureNode::setRect(const QRectF & r )**

        Sets the target rect of this texture node to **r**.

        **See also** **rect** ().
        """
        ...

    @overload
    def setRect(self, x: float, y: float, w: float, h: float) -> None:
        """
        https://doc.qt.io/qt-6/qsgsimpletexturenode.html#setRect-1

        **void QSGSimpleTextureNode::setRect(qreal x , qreal y , qreal w , qreal
        h )**

        This is an overloaded function.

        Sets the rectangle of this texture node to begin at ( **x** , **y** )
        and have width **w** and height **h**.
        """
        ...

    @overload
    def setSourceRect(
        self, r: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsgsimpletexturenode.html#setSourceRect

        **[since 5.5] void QSGSimpleTextureNode::setSourceRect(const QRectF & r
        )**

        Sets the source rect of this texture node to **r**.

        This function was introduced in Qt 5.5.

        **See also** **sourceRect** ().
        """
        ...

    @overload
    def setSourceRect(self, x: float, y: float, w: float, h: float) -> None:
        """
        https://doc.qt.io/qt-6/qsgsimpletexturenode.html#setSourceRect-1

        **[since 5.5] void QSGSimpleTextureNode::setSourceRect(qreal x , qreal y
        , qreal w , qreal h )**

        This is an overloaded function.

        Sets the rectangle of this texture node to show its texture from ( **x**
        , **y** ) and have width **w** and height **h** relatively to the
        **QSGTexture::textureSize** .

        This function was introduced in Qt 5.5.
        """
        ...

    def setTexture(self, texture: PySide6.QtQuick.QSGTexture) -> None:
        """
        https://doc.qt.io/qt-6/qsgsimpletexturenode.html#setTexture

        **void QSGSimpleTextureNode::setTexture(QSGTexture * texture )**

        Sets the texture of this texture node to **texture**.

        Use **setOwnsTexture** () to set whether the node should take ownership
        of the texture. By default, the node does not take ownership.

        **Warning:** A texture node must have a texture before being added to
        the scenegraph to be rendered.

        **See also** **texture** ().
        """
        ...

    def setTextureCoordinatesTransform(
        self, mode: PySide6.QtQuick.QSGSimpleTextureNode.TextureCoordinatesTransformMode
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsgsimpletexturenode.html#setTextureCoordinatesTr
        ansform

        **void QSGSimpleTextureNode::setTextureCoordinatesTransform(QSGSimpleTex
        tureNode::TextureCoordinatesTransformMode mode )**

        Sets the method used to generate texture coordinates to **mode**. This
        can be used to obtain correct orientation of the texture. This is
        commonly needed when using a third party OpenGL library to render to
        texture as OpenGL has an inverted y-axis relative to Qt Quick.

        **See also** **textureCoordinatesTransform** ().
        """
        ...

    def sourceRect(self) -> PySide6.QtCore.QRectF:
        """
        https://doc.qt.io/qt-6/qsgsimpletexturenode.html#sourceRect

        **[since 5.5] QRectF QSGSimpleTextureNode::sourceRect() const**

        Returns the source rect of this texture node.

        This function was introduced in Qt 5.5.

        **See also** **setSourceRect** ().
        """
        ...

    def texture(self) -> PySide6.QtQuick.QSGTexture:
        """
        https://doc.qt.io/qt-6/qsgsimpletexturenode.html#texture

        **QSGTexture *QSGSimpleTextureNode::texture() const**

        Returns the texture for this texture node

        **See also** **setTexture** ().
        """
        ...

    def textureCoordinatesTransform(
        self,
    ) -> PySide6.QtQuick.QSGSimpleTextureNode.TextureCoordinatesTransformMode:
        """
        https://doc.qt.io/qt-6/qsgsimpletexturenode.html#textureCoordinatesTrans
        form

        **QSGSimpleTextureNode::TextureCoordinatesTransformMode
        QSGSimpleTextureNode::textureCoordinatesTransform() const**

        Returns the mode used to generate texture coordinates for this node.

        **See also** **setTextureCoordinatesTransform** ().
        """
        ...
