"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtQuick, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, Dict, List, Optional, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtOpenGL
import PySide6.QtQml
import PySide6.QtQuick

bytes = str


class QQuickView(PySide6.QtQuick.QQuickWindow):
    """
    https://doc.qt.io/qt-6/qquickview.html

    **Detailed Description**

    This is a convenience subclass of **QQuickWindow**  which will automatically
    load and display a QML scene when given the URL of the main source file.
    Alternatively, you can instantiate your own objects using **QQmlComponent**
    and place them in a manually setup **QQuickWindow** .

    Typical usage:

    int main(int argc, char *argv[])
        {
            **QGuiApplication**
    app(argc, argv);

            **QQuickView**  *view = new **QQuickView** ;
    view->setSource(**QUrl** ::fromLocalFile("myqmlfile.qml"));
    view->show();
            return app.exec();
        }

    To receive errors related to loading and executing QML with QQuickView, you
    can connect to the **statusChanged** () signal and monitor for
    **QQuickView::Error** . The errors are available via **QQuickView::errors**
    ().

    QQuickView also manages sizing of the view and root object. By default, the
    **resizeMode**  is **SizeViewToRootObject** , which will load the component
    and resize it to the size of the view. Alternatively the **resizeMode**  may
    be set to **SizeRootObjectToView**  which will resize the view to the size
    of the root object.

    **See also** **Exposing Attributes of C++ Types to QML**  and
    **QQuickWidget** .
    """

    SizeViewToRootObject: QQuickView.ResizeMode = ...
    SizeRootObjectToView: QQuickView.ResizeMode = ...
    Null: QQuickView.Status = ...
    Ready: QQuickView.Status = ...
    Loading: QQuickView.Status = ...
    Error: QQuickView.Status = ...

    class ResizeMode(Enum):
        SizeViewToRootObject: QQuickView.ResizeMode = ...
        SizeRootObjectToView: QQuickView.ResizeMode = ...

    class Status(Enum):
        Null: QQuickView.Status = ...
        Ready: QQuickView.Status = ...
        Loading: QQuickView.Status = ...
        Error: QQuickView.Status = ...

    @overload
    def __init__(
        self, engine: PySide6.QtQml.QQmlEngine, parent: PySide6.QtGui.QWindow
    ) -> None:
        """
        https://doc.qt.io/qt-6/qquickview.html#QQuickView

        **QQuickView::QQuickView(QWindow * parent = nullptr)**

        Constructs a QQuickView with the given **parent**. The default value of
        **parent** is 0.
        """
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtGui.QWindow] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qquickview.html#QQuickView-1

        **QQuickView::QQuickView(QQmlEngine * engine , QWindow * parent )**

        Constructs a QQuickView with the given QML **engine** and **parent**.

        Note: In this case, the QQuickView does not own the given **engine**
        object; it is the caller's responsibility to destroy the engine. If the
        **engine** is deleted before the view, **status** () will return
        **QQuickView::Error** .

        **See also** **Status** , **status** (), and **errors** ().
        """
        ...

    @overload
    def __init__(
        self,
        source: Union[PySide6.QtCore.QUrl, str],
        parent: Optional[PySide6.QtGui.QWindow] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qquickview.html#QQuickView-2

        **QQuickView::QQuickView(const QUrl & source , QWindow * parent =
        nullptr)**

        Constructs a QQuickView with the given QML **source** and **parent**.
        The default value of **parent** is 0.
        """
        ...

    @overload
    def __init__(
        self,
        source: Union[PySide6.QtCore.QUrl, str],
        renderControl: PySide6.QtQuick.QQuickRenderControl,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qquickview.html#QQuickView

        **QQuickView::QQuickView(QWindow * parent = nullptr)**

        Constructs a QQuickView with the given **parent**. The default value of
        **parent** is 0.
        """
        ...

    def engine(self) -> PySide6.QtQml.QQmlEngine:
        """
        https://doc.qt.io/qt-6/qquickview.html#engine

        **QQmlEngine *QQuickView::engine() const**

        Returns a pointer to the **QQmlEngine**  used for instantiating QML
        Components.
        """
        ...

    def errors(self) -> List[PySide6.QtQml.QQmlError]:
        """
        https://doc.qt.io/qt-6/qquickview.html#errors

        **QList<QQmlError> QQuickView::errors() const**

        Return the list of errors that occurred during the last compile or
        create operation. When the status is not Error, an empty list is
        returned.
        """
        ...

    def initialSize(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qquickview.html#initialSize

        **QSize QQuickView::initialSize() const**

        Returns the initial size of the root object.

        If **resizeMode**  is QQuickItem::SizeRootObjectToView the root object
        will be resized to the size of the view. initialSize contains the size
        of the root object before it was resized.
        """
        ...

    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qquickview.html#keyPressEvent

        **[override virtual protected] void QQuickView::keyPressEvent(QKeyEvent
        * e )**

        Reimplements: **QQuickWindow::keyPressEvent** (QKeyEvent *e).
        """
        ...

    def keyReleaseEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-6/qquickview.html#keyReleaseEvent

        **[override virtual protected] void
        QQuickView::keyReleaseEvent(QKeyEvent * e )**

        Reimplements: **QQuickWindow::keyReleaseEvent** (QKeyEvent *e).
        """
        ...

    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qquickview.html#mouseMoveEvent

        **[override virtual protected] void
        QQuickView::mouseMoveEvent(QMouseEvent * e )**

        Reimplements: **QQuickWindow::mouseMoveEvent** (QMouseEvent *event).
        """
        ...

    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qquickview.html#mousePressEvent

        **[override virtual protected] void
        QQuickView::mousePressEvent(QMouseEvent * e )**

        Reimplements: **QQuickWindow::mousePressEvent** (QMouseEvent *event).
        """
        ...

    def mouseReleaseEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-6/qquickview.html#mouseReleaseEvent

        **[override virtual protected] void
        QQuickView::mouseReleaseEvent(QMouseEvent * e )**

        Reimplements: **QQuickWindow::mouseReleaseEvent** (QMouseEvent *event).
        """
        ...

    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent) -> None:
        ...

    def resizeMode(self) -> PySide6.QtQuick.QQuickView.ResizeMode:
        """
        https://doc.qt.io/qt-6/qquickview.html#resizeMode-prop

        **resizeMode : ResizeMode**

        This property holds whether the view should resize the window contents

        If this property is set to **SizeViewToRootObject**  (the default), the
        view resizes to the size of the root item in the QML.

        If this property is set to **SizeRootObjectToView** , the view will
        automatically resize the root item to the size of the view.

        **Access functions:**

        QQuickView::ResizeMode **resizeMode** () const
        void **setResizeMode**
        (QQuickView::ResizeMode)

        **See also** **initialSize** ().
        """
        ...

    def rootContext(self) -> PySide6.QtQml.QQmlContext:
        """
        https://doc.qt.io/qt-6/qquickview.html#rootContext

        **QQmlContext *QQuickView::rootContext() const**

        This function returns the root of the context hierarchy. Each QML
        component is instantiated in a **QQmlContext** . **QQmlContext** 's are
        essential for passing data to QML components. In QML, contexts are
        arranged hierarchically and this hierarchy is managed by the
        **QQmlEngine** .
        """
        ...

    def rootObject(self) -> PySide6.QtQuick.QQuickItem:
        """
        https://doc.qt.io/qt-6/qquickview.html#rootObject

        **QQuickItem *QQuickView::rootObject() const**

        Returns the view's root **item** .
        """
        ...

    def setContent(
        self,
        url: Union[PySide6.QtCore.QUrl, str],
        component: PySide6.QtQml.QQmlComponent,
        item: PySide6.QtCore.QObject,
    ) -> None:
        ...

    def setInitialProperties(self, initialProperties: Dict[str, Any]) -> None:
        """
        https://doc.qt.io/qt-6/qquickview.html#setInitialProperties

        **[slot, since 5.14] void QQuickView::setInitialProperties(const
        QVariantMap & initialProperties )**

        Sets the initial properties **initialProperties** with which the QML
        component gets initialized after calling **QQuickView::setSource** ().

        **QScopedPointer** <**QQuickView** > view { new **QQuickView**  };
        view->setInitialProperties({"x, 100"}, {"width", 50});
        view->setSource(**QUrl** ::fromLocalFile("myqmlfile.qml"));
        view->show();

        **Note:** You can only use this function to initialize top-level
        properties.

        **Note:** This function should always be called before **setSource** ,
        as it has no effect once the component has become `Ready`.

        This function was introduced in Qt 5.14.

        **See also** **QQmlComponent::createWithInitialProperties** ().
        """
        ...

    def setResizeMode(self, arg__1: PySide6.QtQuick.QQuickView.ResizeMode) -> None:
        """
        https://doc.qt.io/qt-6/qquickview.html#resizeMode-prop

        **resizeMode : ResizeMode**

        This property holds whether the view should resize the window contents

        If this property is set to **SizeViewToRootObject**  (the default), the
        view resizes to the size of the root item in the QML.

        If this property is set to **SizeRootObjectToView** , the view will
        automatically resize the root item to the size of the view.

        **Access functions:**

        QQuickView::ResizeMode **resizeMode** () const
        void **setResizeMode**
        (QQuickView::ResizeMode)

        **See also** **initialSize** ().
        """
        ...

    def setSource(self, arg__1: Union[PySide6.QtCore.QUrl, str]) -> None:
        """
        https://doc.qt.io/qt-6/qquickview.html#setSource

        **[slot] void QQuickView::setSource(const QUrl & url )**

        Sets the source to the **url** , loads the QML component and
        instantiates it.

        Ensure that the URL provided is full and correct, in particular, use
        **QUrl::fromLocalFile** () when loading a file from the local
        filesystem.

        Calling this method multiple times with the same url will result in the
        QML component being reinstantiated.

        **Note:** Setter function for property **source** .

        **See also** **source** ().
        """
        ...

    def sizeHint(self) -> PySide6.QtCore.QSize:
        ...

    def source(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qquickview.html#source

        **QUrl QQuickView::source() const**

        Returns the source URL, if set.

        **Note:** Getter function for property source.

        **See also** **setSource** ().
        """
        ...

    def status(self) -> PySide6.QtQuick.QQuickView.Status:
        """
        https://doc.qt.io/qt-6/qquickview.html#status-prop

        **[read-only] status : const Status**

        The component's current **status** .

        **Access functions:**

        QQuickView::Status **status** () const

        **Notifier signal:**

        void ****statusChanged** ** (QQuickView::Status **status** )

        **Member Function Documentation**
        """
        ...

    def timerEvent(self, arg__1: PySide6.QtCore.QTimerEvent) -> None:
        ...

    @property
    def statusChanged(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qquickview.html#statusChanged

        **[signal] void QQuickView::statusChanged(QQuickView::Status status )**

        This signal is emitted when the component's current **status** changes.

        **Note:** Notifier signal for property **status** .
        """
        ...
