"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtPrintSupport, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtWidgets
import PySide6.QtPrintSupport

bytes = str


class QPrintEngine(object):
    """
    https://doc.qt.io/qt-6/qprintengine.html

    **Detailed Description**

    The common case when creating your own print engine is to derive from both
    **QPaintEngine**  and QPrintEngine. Various properties of a print engine are
    given with **property** () and set with **setProperty** ().

    **See also** **QPaintEngine** .
    """

    PPK_CollateCopies: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_ColorMode: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_Creator: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_DocumentName: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_FullPage: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_NumberOfCopies: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_Orientation: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_OutputFileName: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_PageOrder: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_PageRect: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_PageSize: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_PaperSize: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_PaperRect: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_PaperSource: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_PrinterName: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_PrinterProgram: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_Resolution: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_SelectionOption: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_SupportedResolutions: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_WindowsPageSize: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_FontEmbedding: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_Duplex: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_PaperSources: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_CustomPaperSize: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_PageMargins: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_CopyCount: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_SupportsMultipleCopies: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_PaperName: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_QPageSize: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_QPageMargins: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_QPageLayout: QPrintEngine.PrintEnginePropertyKey = ...
    PPK_CustomBase: QPrintEngine.PrintEnginePropertyKey = ...

    class PrintEnginePropertyKey(Enum):
        PPK_CollateCopies: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_ColorMode: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_Creator: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_DocumentName: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_FullPage: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_NumberOfCopies: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_Orientation: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_OutputFileName: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_PageOrder: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_PageRect: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_PageSize: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_PaperSize: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_PaperRect: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_PaperSource: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_PrinterName: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_PrinterProgram: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_Resolution: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_SelectionOption: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_SupportedResolutions: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_WindowsPageSize: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_FontEmbedding: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_Duplex: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_PaperSources: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_CustomPaperSize: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_PageMargins: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_CopyCount: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_SupportsMultipleCopies: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_PaperName: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_QPageSize: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_QPageMargins: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_QPageLayout: QPrintEngine.PrintEnginePropertyKey = ...
        PPK_CustomBase: QPrintEngine.PrintEnginePropertyKey = ...

    def __init__(self) -> None:
        ...

    def abort(self) -> bool:
        """
        https://doc.qt.io/qt-6/qprintengine.html#abort

        **[pure virtual] bool QPrintEngine::abort()**

        Instructs the print engine to abort the printing process. Returns true
        if successful; otherwise returns `false`.
        """
        ...

    def metric(self, arg__1: PySide6.QtGui.QPaintDevice.PaintDeviceMetric) -> int:
        """
        https://doc.qt.io/qt-6/qprintengine.html#metric

        **[pure virtual] int
        QPrintEngine::metric(QPaintDevice::PaintDeviceMetric id ) const**

        Returns the metric for the given **id**.
        """
        ...

    def newPage(self) -> bool:
        """
        https://doc.qt.io/qt-6/qprintengine.html#newPage

        **[pure virtual] bool QPrintEngine::newPage()**

        Instructs the print engine to start a new page. Returns `true` if the
        printer was able to create the new page; otherwise returns `false`.
        """
        ...

    def printerState(self) -> PySide6.QtPrintSupport.QPrinter.PrinterState:
        """
        https://doc.qt.io/qt-6/qprintengine.html#printerState

        **[pure virtual] QPrinter::PrinterState QPrintEngine::printerState()
        const**

        Returns the current state of the printer being used by the print engine.
        """
        ...

    def property(
        self, key: PySide6.QtPrintSupport.QPrintEngine.PrintEnginePropertyKey
    ) -> Any:
        """
        https://doc.qt.io/qt-6/qprintengine.html#property

        **[pure virtual] QVariant
        QPrintEngine::property(QPrintEngine::PrintEnginePropertyKey key )
        const**

        Returns the print engine's property specified by **key**.

        **See also** **setProperty** ().
        """
        ...

    def setProperty(
        self,
        key: PySide6.QtPrintSupport.QPrintEngine.PrintEnginePropertyKey,
        value: Any,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qprintengine.html#setProperty

        **[pure virtual] void
        QPrintEngine::setProperty(QPrintEngine::PrintEnginePropertyKey key ,
        const QVariant & value )**

        Sets the print engine's property specified by **key** to the given
        **value**.

        **See also** **property** ().
        """
        ...
