"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtPositioning, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import overload
import PySide6.QtCore
import PySide6.QtPositioning

bytes = str


class QGeoPositionInfo(object):
    """
    https://doc.qt.io/qt-6/qgeopositioninfo.html

    **Detailed Description**

    A QGeoPositionInfo contains, at a minimum, a geographical coordinate and a
    timestamp. It may also have heading and speed measurements as well as
    estimates of the accuracy of the provided data.

    **See also** **QGeoPositionInfoSource** .
    """

    Direction: QGeoPositionInfo.Attribute = ...
    GroundSpeed: QGeoPositionInfo.Attribute = ...
    VerticalSpeed: QGeoPositionInfo.Attribute = ...
    MagneticVariation: QGeoPositionInfo.Attribute = ...
    HorizontalAccuracy: QGeoPositionInfo.Attribute = ...
    VerticalAccuracy: QGeoPositionInfo.Attribute = ...

    class Attribute(Enum):
        Direction: QGeoPositionInfo.Attribute = ...
        GroundSpeed: QGeoPositionInfo.Attribute = ...
        VerticalSpeed: QGeoPositionInfo.Attribute = ...
        MagneticVariation: QGeoPositionInfo.Attribute = ...
        HorizontalAccuracy: QGeoPositionInfo.Attribute = ...
        VerticalAccuracy: QGeoPositionInfo.Attribute = ...

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qgeopositioninfo.html#QGeoPositionInfo

        **QGeoPositionInfo::QGeoPositionInfo()**

        Creates an invalid QGeoPositionInfo object.

        **See also** **isValid** ().
        """
        ...

    @overload
    def __init__(
        self,
        coordinate: PySide6.QtPositioning.QGeoCoordinate,
        updateTime: PySide6.QtCore.QDateTime,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgeopositioninfo.html#QGeoPositionInfo-1

        **QGeoPositionInfo::QGeoPositionInfo(const QGeoCoordinate & coordinate ,
        const QDateTime & timestamp )**

        Creates a QGeoPositionInfo for the given **coordinate** and
        **timestamp**.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtPositioning.QGeoPositionInfo) -> None:
        """
        https://doc.qt.io/qt-6/qgeopositioninfo.html#QGeoPositionInfo-2

        **QGeoPositionInfo::QGeoPositionInfo(const QGeoPositionInfo & other )**

        Creates a QGeoPositionInfo with the values of **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def __lshift__(
        self, stream: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def __rshift__(
        self, stream: PySide6.QtCore.QDataStream
    ) -> PySide6.QtCore.QDataStream:
        ...

    def attribute(
        self, attribute: PySide6.QtPositioning.QGeoPositionInfo.Attribute
    ) -> float:
        """
        https://doc.qt.io/qt-6/qgeopositioninfo.html#attribute

        **qreal QGeoPositionInfo::attribute(QGeoPositionInfo::Attribute
        attribute ) const**

        Returns the value of the specified **attribute** as a qreal value.

        Returns NaN if the value has not been set.

        The function **hasAttribute** () should be used to determine whether or
        not a value has been set for an attribute.

        **See also** **hasAttribute** () and **setAttribute** ().
        """
        ...

    def coordinate(self) -> PySide6.QtPositioning.QGeoCoordinate:
        """
        https://doc.qt.io/qt-6/qgeopositioninfo.html#coordinate

        **QGeoCoordinate QGeoPositionInfo::coordinate() const**

        Returns the coordinate for this position.

        Returns an invalid coordinate if no coordinate has been set.

        **See also** **setCoordinate** ().
        """
        ...

    def hasAttribute(
        self, attribute: PySide6.QtPositioning.QGeoPositionInfo.Attribute
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qgeopositioninfo.html#hasAttribute

        **bool QGeoPositionInfo::hasAttribute(QGeoPositionInfo::Attribute
        attribute ) const**

        Returns true if the specified **attribute** is present for this
        **QGeoPositionInfo**  object.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qgeopositioninfo.html#isValid

        **bool QGeoPositionInfo::isValid() const**

        Returns true if the **timestamp** () and **coordinate** () values are
        both valid.

        **See also** **QGeoCoordinate::isValid** () and **QDateTime::isValid**
        ().
        """
        ...

    def removeAttribute(
        self, attribute: PySide6.QtPositioning.QGeoPositionInfo.Attribute
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgeopositioninfo.html#removeAttribute

        **void QGeoPositionInfo::removeAttribute(QGeoPositionInfo::Attribute
        attribute )**

        Removes the specified **attribute** and its value.
        """
        ...

    def setAttribute(
        self, attribute: PySide6.QtPositioning.QGeoPositionInfo.Attribute, value: float
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgeopositioninfo.html#setAttribute

        **void QGeoPositionInfo::setAttribute(QGeoPositionInfo::Attribute
        attribute , qreal value )**

        Sets the value for **attribute** to **value**.

        **See also** **attribute** ().
        """
        ...

    def setCoordinate(self, coordinate: PySide6.QtPositioning.QGeoCoordinate) -> None:
        """
        https://doc.qt.io/qt-6/qgeopositioninfo.html#setCoordinate

        **void QGeoPositionInfo::setCoordinate(const QGeoCoordinate & coordinate
        )**

        Sets the coordinate for this position to **coordinate**.

        **See also** **coordinate** ().
        """
        ...

    def setTimestamp(self, timestamp: PySide6.QtCore.QDateTime) -> None:
        """
        https://doc.qt.io/qt-6/qgeopositioninfo.html#setTimestamp

        **void QGeoPositionInfo::setTimestamp(const QDateTime & timestamp )**

        Sets the date and time at which this position was reported to
        **timestamp**.

        The **timestamp** must be in UTC time.

        **See also** **timestamp** ().
        """
        ...

    def swap(self, other: PySide6.QtPositioning.QGeoPositionInfo) -> None:
        ...

    def timestamp(self) -> PySide6.QtCore.QDateTime:
        """
        https://doc.qt.io/qt-6/qgeopositioninfo.html#timestamp

        **QDateTime QGeoPositionInfo::timestamp() const**

        Returns the date and time at which this position was reported, in UTC
        time.

        Returns an invalid **QDateTime**  if no date/time value has been set.

        **See also** **setTimestamp** ().
        """
        ...
