"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtPositioning, except for defaults which are replaced by "...".
"""
from typing import Any, Dict, overload
import PySide6.QtCore
import PySide6.QtPositioning

bytes = str


class QGeoLocation(object):
    """
    https://doc.qt.io/qt-6/qgeolocation.html

    **Detailed Description**

    A QGeoLocation consists of a coordinate and corresponding address, along
    with an optional bounding shape, which is the recommended region to be
    displayed when viewing the location.
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qgeolocation.html#QGeoLocation

        **QGeoLocation::QGeoLocation()**

        Constructs an new location object.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtPositioning.QGeoLocation) -> None:
        """
        https://doc.qt.io/qt-6/qgeolocation.html#QGeoLocation-1

        **QGeoLocation::QGeoLocation(const QGeoLocation & other )**

        Constructs a copy of **other**
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def address(self) -> PySide6.QtPositioning.QGeoAddress:
        """
        https://doc.qt.io/qt-6/qgeolocation.html#address

        **QGeoAddress QGeoLocation::address() const**

        Returns the address of the location.

        **See also** **setAddress** ().
        """
        ...

    def boundingShape(self) -> PySide6.QtPositioning.QGeoShape:
        """
        https://doc.qt.io/qt-6/qgeolocation.html#boundingShape

        **[since 6.2] QGeoShape QGeoLocation::boundingShape() const**

        Returns a bounding shape which represents the recommended region to
        display when viewing this location.

        For example, a building's location may have a region centered around the
        building, but the region is large enough to show it's immediate
        surrounding geographical context.

        **Note:** This method was introduced in Qt6 instead of boundingBox()
        method. It returns a **QGeoShape**  instead of a **QGeoRectangle** . Use
        **QGeoShape::boundingGeoRectangle** () to obtain a bounding
        **QGeoRectangle**  for the shape.

        This function was introduced in Qt 6.2.

        **See also** **setBoundingShape** ().
        """
        ...

    def coordinate(self) -> PySide6.QtPositioning.QGeoCoordinate:
        """
        https://doc.qt.io/qt-6/qgeolocation.html#coordinate

        **QGeoCoordinate QGeoLocation::coordinate() const**

        Returns the coordinate of the location.

        **See also** **setCoordinate** ().
        """
        ...

    def extendedAttributes(self) -> Dict[str, Any]:
        """
        https://doc.qt.io/qt-6/qgeolocation.html#extendedAttributes

        **[since 5.13] QVariantMap QGeoLocation::extendedAttributes() const**

        Returns the extended attributes associated to this location. Extended
        attributes are backend-dependent and can be location-dependent.

        This function was introduced in Qt 5.13.

        **See also** **setExtendedAttributes** ().
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qgeolocation.html#isEmpty

        **bool QGeoLocation::isEmpty() const**

        Returns `true` if the location coordinate is **invalid** , and all the
        other location fields are empty. Otherwise returns `false`.
        """
        ...

    def setAddress(self, address: PySide6.QtPositioning.QGeoAddress) -> None:
        """
        https://doc.qt.io/qt-6/qgeolocation.html#setAddress

        **void QGeoLocation::setAddress(const QGeoAddress & address )**

        Sets the **address** of the location.

        **See also** **address** ().
        """
        ...

    def setBoundingShape(self, shape: PySide6.QtPositioning.QGeoShape) -> None:
        """
        https://doc.qt.io/qt-6/qgeolocation.html#setBoundingShape

        **[since 6.2] void QGeoLocation::setBoundingShape(const QGeoShape &
        boundingShape )**

        Sets the **boundingShape** of the location.

        This function was introduced in Qt 6.2.

        **See also** **boundingShape** ().
        """
        ...

    def setCoordinate(self, position: PySide6.QtPositioning.QGeoCoordinate) -> None:
        """
        https://doc.qt.io/qt-6/qgeolocation.html#setCoordinate

        **void QGeoLocation::setCoordinate(const QGeoCoordinate & coordinate )**

        Sets the **coordinate** of the location.

        **See also** **coordinate** ().
        """
        ...

    def setExtendedAttributes(self, data: Dict[str, Any]) -> None:
        """
        https://doc.qt.io/qt-6/qgeolocation.html#setExtendedAttributes

        **[since 5.13] void QGeoLocation::setExtendedAttributes(const
        QVariantMap & data )**

        Sets the extended attributes of the location with the parameters
        specified in **data**.

        This function was introduced in Qt 5.13.

        **See also** **extendedAttributes** ().
        """
        ...

    def swap(self, other: PySide6.QtPositioning.QGeoLocation) -> None:
        ...
