"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtPositioning, except for defaults which are replaced by "...".
"""
from typing import Union, overload
import PySide6.QtCore
import PySide6.QtPositioning

bytes = str


class QGeoCircle(PySide6.QtPositioning.QGeoShape):
    """
    https://doc.qt.io/qt-6/qgeocircle.html

    **Detailed Description**

    The circle is defined in terms of a **QGeoCoordinate**  which specifies the
    center of the circle and a qreal which specifies the radius of the circle in
    meters.

    The circle is considered invalid if the center coordinate is invalid or if
    the radius is less than zero.

    This class is a **Q_GADGET**  since Qt 5.5. It can be **directly used from
    C++ and QML** .
    """

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qgeocircle.html#QGeoCircle

        **QGeoCircle::QGeoCircle()**

        Constructs a new, invalid geo circle.
        """
        ...

    @overload
    def __init__(
        self, center: PySide6.QtPositioning.QGeoCoordinate, radius: float = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgeocircle.html#QGeoCircle-1

        **QGeoCircle::QGeoCircle(const QGeoCoordinate & center , qreal radius =
        -1.0)**

        Constructs a new geo circle centered at **center** and with a radius of
        **radius** meters.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtPositioning.QGeoShape) -> None:
        """
        https://doc.qt.io/qt-6/qgeocircle.html#QGeoCircle-2

        **QGeoCircle::QGeoCircle(const QGeoCircle & other )**

        Constructs a new geo circle from the contents of **other**.
        """
        ...

    @overload
    def __init__(
        self,
        other: Union[
            PySide6.QtPositioning.QGeoCoordinate, PySide6.QtPositioning.QGeoShape
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qgeocircle.html#QGeoCircle-3

        **QGeoCircle::QGeoCircle(const QGeoShape & other )**

        Constructs a new geo circle from the contents of **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def center(self) -> PySide6.QtPositioning.QGeoCoordinate:
        """
        https://doc.qt.io/qt-6/qgeocircle.html#center

        **QGeoCoordinate QGeoCircle::center() const**

        Returns the center coordinate of this geo circle. Equivalent to
        **QGeoShape::center** ().

        **Note:** Getter function for property **center** .

        **See also** **setCenter** ().
        """
        ...

    def extendCircle(self, coordinate: PySide6.QtPositioning.QGeoCoordinate) -> None:
        """
        https://doc.qt.io/qt-6/qgeocircle.html#extendCircle

        **[invokable, since 5.9] void QGeoCircle::extendCircle(const
        QGeoCoordinate & coordinate )**

        Extends the geo circle to also cover the coordinate **coordinate**

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        This function was introduced in Qt 5.9.
        """
        ...

    def radius(self) -> float:
        """
        https://doc.qt.io/qt-6/qgeocircle.html#radius

        **qreal QGeoCircle::radius() const**

        Returns the radius in meters of this geo circle.

        **Note:** Getter function for property **radius** .

        **See also** **setRadius** ().
        """
        ...

    def setCenter(self, center: PySide6.QtPositioning.QGeoCoordinate) -> None:
        """
        https://doc.qt.io/qt-6/qgeocircle.html#setCenter

        **void QGeoCircle::setCenter(const QGeoCoordinate & center )**

        Sets the center coordinate of this geo circle to **center**.

        **Note:** Setter function for property **center** .

        **See also** **center** ().
        """
        ...

    def setRadius(self, radius: float) -> None:
        """
        https://doc.qt.io/qt-6/qgeocircle.html#setRadius

        **void QGeoCircle::setRadius(qreal radius )**

        Sets the radius in meters of this geo circle to **radius**.

        **Note:** Setter function for property **radius** .

        **See also** **radius** ().
        """
        ...

    def toString(self) -> str:
        """
        https://doc.qt.io/qt-6/qgeocircle.html#toString

        **[invokable, since 5.5] QString QGeoCircle::toString() const**

        Returns the geo circle properties as a string.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        This function was introduced in Qt 5.5.
        """
        ...

    def translate(self, degreesLatitude: float, degreesLongitude: float) -> None:
        """
        https://doc.qt.io/qt-6/qgeocircle.html#translate

        **[invokable] void QGeoCircle::translate(double degreesLatitude , double
        degreesLongitude )**

        Translates this geo circle by **degreesLatitude** northwards and
        **degreesLongitude** eastwards.

        Negative values of **degreesLatitude** and **degreesLongitude**
        correspond to southward and westward translation respectively.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def translated(
        self, degreesLatitude: float, degreesLongitude: float
    ) -> PySide6.QtPositioning.QGeoCircle:
        """
        https://doc.qt.io/qt-6/qgeocircle.html#translated

        **[invokable] QGeoCircle QGeoCircle::translated(double degreesLatitude ,
        double degreesLongitude ) const**

        Returns a copy of this geo circle translated by **degreesLatitude**
        northwards and **degreesLongitude** eastwards.

        Negative values of **degreesLatitude** and **degreesLongitude**
        correspond to southward and westward translation respectively.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        **See also** **translate** ().
        """
        ...
