"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtOpenGL, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, Optional, Tuple, Union, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtOpenGL

bytes = str


class QOpenGLTexture(object):
    """
    https://doc.qt.io/qt-6/qopengltexture.html

    **Detailed Description**

    QOpenGLTexture makes it easy to work with OpenGL textures and the myriad
    features and targets that they offer depending upon the capabilities of your
    OpenGL implementation.

    The typical usage pattern for QOpenGLTexture is

    * Instantiate the object specifying the texture target type
      * Set
    properties that affect the storage requirements e.g. storage format,
    dimensions
      * Allocate the server-side storage
      * Optionally upload pixel
    data
      * Optionally set any additional properties e.g. filtering and border
    options
      * Render with texture or render to texture

    In the common case of simply using a **QImage**  as the source of texture
    pixel data most of the above steps are performed automatically.

    // Prepare texture
        **QOpenGLTexture**  *texture = new **QOpenGLTexture**
    (**QImage** (fileName).mirrored());
    texture->setMinificationFilter(**QOpenGLTexture** ::LinearMipMapLinear);
    texture->setMagnificationFilter(**QOpenGLTexture** ::Linear);
        ...
        //
    Render with texture
        texture->bind();
        glDrawArrays(...);

    Note that the **QImage**  is mirrored vertically to account for the fact
    that OpenGL and **QImage**  use opposite directions for the y axis. Another
    option would be to transform your texture coordinates.
    """

    BindingTarget1D: QOpenGLTexture.BindingTarget = ...
    BindingTarget2D: QOpenGLTexture.BindingTarget = ...
    BindingTarget3D: QOpenGLTexture.BindingTarget = ...
    BindingTargetRectangle: QOpenGLTexture.BindingTarget = ...
    BindingTargetCubeMap: QOpenGLTexture.BindingTarget = ...
    BindingTarget1DArray: QOpenGLTexture.BindingTarget = ...
    BindingTarget2DArray: QOpenGLTexture.BindingTarget = ...
    BindingTargetBuffer: QOpenGLTexture.BindingTarget = ...
    BindingTargetCubeMapArray: QOpenGLTexture.BindingTarget = ...
    BindingTarget2DMultisample: QOpenGLTexture.BindingTarget = ...
    BindingTarget2DMultisampleArray: QOpenGLTexture.BindingTarget = ...
    CompareNever: QOpenGLTexture.ComparisonFunction = ...
    CompareLess: QOpenGLTexture.ComparisonFunction = ...
    CompareEqual: QOpenGLTexture.ComparisonFunction = ...
    CompareLessEqual: QOpenGLTexture.ComparisonFunction = ...
    CompareGreater: QOpenGLTexture.ComparisonFunction = ...
    CommpareNotEqual: QOpenGLTexture.ComparisonFunction = ...
    CompareNotEqual: QOpenGLTexture.ComparisonFunction = ...
    CompareGreaterEqual: QOpenGLTexture.ComparisonFunction = ...
    CompareAlways: QOpenGLTexture.ComparisonFunction = ...
    CompareNone: QOpenGLTexture.ComparisonMode = ...
    CompareRefToTexture: QOpenGLTexture.ComparisonMode = ...
    DirectionS: QOpenGLTexture.CoordinateDirection = ...
    DirectionT: QOpenGLTexture.CoordinateDirection = ...
    DirectionR: QOpenGLTexture.CoordinateDirection = ...
    CubeMapPositiveX: QOpenGLTexture.CubeMapFace = ...
    CubeMapNegativeX: QOpenGLTexture.CubeMapFace = ...
    CubeMapPositiveY: QOpenGLTexture.CubeMapFace = ...
    CubeMapNegativeY: QOpenGLTexture.CubeMapFace = ...
    CubeMapPositiveZ: QOpenGLTexture.CubeMapFace = ...
    CubeMapNegativeZ: QOpenGLTexture.CubeMapFace = ...
    StencilMode: QOpenGLTexture.DepthStencilMode = ...
    DepthMode: QOpenGLTexture.DepthStencilMode = ...
    ImmutableStorage: QOpenGLTexture.Feature = ...
    ImmutableMultisampleStorage: QOpenGLTexture.Feature = ...
    TextureRectangle: QOpenGLTexture.Feature = ...
    TextureArrays: QOpenGLTexture.Feature = ...
    Texture3D: QOpenGLTexture.Feature = ...
    TextureMultisample: QOpenGLTexture.Feature = ...
    TextureBuffer: QOpenGLTexture.Feature = ...
    TextureCubeMapArrays: QOpenGLTexture.Feature = ...
    Swizzle: QOpenGLTexture.Feature = ...
    StencilTexturing: QOpenGLTexture.Feature = ...
    AnisotropicFiltering: QOpenGLTexture.Feature = ...
    NPOTTextures: QOpenGLTexture.Feature = ...
    NPOTTextureRepeat: QOpenGLTexture.Feature = ...
    Texture1D: QOpenGLTexture.Feature = ...
    TextureComparisonOperators: QOpenGLTexture.Feature = ...
    TextureMipMapLevel: QOpenGLTexture.Feature = ...
    MaxFeatureFlag: QOpenGLTexture.Feature = ...
    Nearest: QOpenGLTexture.Filter = ...
    Linear: QOpenGLTexture.Filter = ...
    NearestMipMapNearest: QOpenGLTexture.Filter = ...
    LinearMipMapNearest: QOpenGLTexture.Filter = ...
    NearestMipMapLinear: QOpenGLTexture.Filter = ...
    LinearMipMapLinear: QOpenGLTexture.Filter = ...
    GenerateMipMaps: QOpenGLTexture.MipMapGeneration = ...
    DontGenerateMipMaps: QOpenGLTexture.MipMapGeneration = ...
    NoSourceFormat: QOpenGLTexture.PixelFormat = ...
    Stencil: QOpenGLTexture.PixelFormat = ...
    Depth: QOpenGLTexture.PixelFormat = ...
    Red: QOpenGLTexture.PixelFormat = ...
    Alpha: QOpenGLTexture.PixelFormat = ...
    RGB: QOpenGLTexture.PixelFormat = ...
    RGBA: QOpenGLTexture.PixelFormat = ...
    Luminance: QOpenGLTexture.PixelFormat = ...
    LuminanceAlpha: QOpenGLTexture.PixelFormat = ...
    BGR: QOpenGLTexture.PixelFormat = ...
    BGRA: QOpenGLTexture.PixelFormat = ...
    RG: QOpenGLTexture.PixelFormat = ...
    RG_Integer: QOpenGLTexture.PixelFormat = ...
    DepthStencil: QOpenGLTexture.PixelFormat = ...
    Red_Integer: QOpenGLTexture.PixelFormat = ...
    RGB_Integer: QOpenGLTexture.PixelFormat = ...
    RGBA_Integer: QOpenGLTexture.PixelFormat = ...
    BGR_Integer: QOpenGLTexture.PixelFormat = ...
    BGRA_Integer: QOpenGLTexture.PixelFormat = ...
    NoPixelType: QOpenGLTexture.PixelType = ...
    Int8: QOpenGLTexture.PixelType = ...
    UInt8: QOpenGLTexture.PixelType = ...
    Int16: QOpenGLTexture.PixelType = ...
    UInt16: QOpenGLTexture.PixelType = ...
    Int32: QOpenGLTexture.PixelType = ...
    UInt32: QOpenGLTexture.PixelType = ...
    Float32: QOpenGLTexture.PixelType = ...
    Float16: QOpenGLTexture.PixelType = ...
    UInt8_RG3B2: QOpenGLTexture.PixelType = ...
    UInt16_RGBA4: QOpenGLTexture.PixelType = ...
    UInt16_RGB5A1: QOpenGLTexture.PixelType = ...
    UInt32_RGBA8: QOpenGLTexture.PixelType = ...
    UInt32_RGB10A2: QOpenGLTexture.PixelType = ...
    UInt8_RG3B2_Rev: QOpenGLTexture.PixelType = ...
    UInt16_R5G6B5: QOpenGLTexture.PixelType = ...
    UInt16_R5G6B5_Rev: QOpenGLTexture.PixelType = ...
    UInt16_RGBA4_Rev: QOpenGLTexture.PixelType = ...
    UInt16_RGB5A1_Rev: QOpenGLTexture.PixelType = ...
    UInt32_RGBA8_Rev: QOpenGLTexture.PixelType = ...
    UInt32_RGB10A2_Rev: QOpenGLTexture.PixelType = ...
    UInt32_D24S8: QOpenGLTexture.PixelType = ...
    UInt32_RG11B10F: QOpenGLTexture.PixelType = ...
    UInt32_RGB9_E5: QOpenGLTexture.PixelType = ...
    Float16OES: QOpenGLTexture.PixelType = ...
    Float32_D32_UInt32_S8_X24: QOpenGLTexture.PixelType = ...
    SwizzleRed: QOpenGLTexture.SwizzleComponent = ...
    SwizzleGreen: QOpenGLTexture.SwizzleComponent = ...
    SwizzleBlue: QOpenGLTexture.SwizzleComponent = ...
    SwizzleAlpha: QOpenGLTexture.SwizzleComponent = ...
    ZeroValue: QOpenGLTexture.SwizzleValue = ...
    OneValue: QOpenGLTexture.SwizzleValue = ...
    RedValue: QOpenGLTexture.SwizzleValue = ...
    GreenValue: QOpenGLTexture.SwizzleValue = ...
    BlueValue: QOpenGLTexture.SwizzleValue = ...
    AlphaValue: QOpenGLTexture.SwizzleValue = ...
    Target1D: QOpenGLTexture.Target = ...
    Target2D: QOpenGLTexture.Target = ...
    Target3D: QOpenGLTexture.Target = ...
    TargetRectangle: QOpenGLTexture.Target = ...
    TargetCubeMap: QOpenGLTexture.Target = ...
    Target1DArray: QOpenGLTexture.Target = ...
    Target2DArray: QOpenGLTexture.Target = ...
    TargetBuffer: QOpenGLTexture.Target = ...
    TargetCubeMapArray: QOpenGLTexture.Target = ...
    Target2DMultisample: QOpenGLTexture.Target = ...
    Target2DMultisampleArray: QOpenGLTexture.Target = ...
    NoFormat: QOpenGLTexture.TextureFormat = ...
    DepthFormat: QOpenGLTexture.TextureFormat = ...
    AlphaFormat: QOpenGLTexture.TextureFormat = ...
    RGBFormat: QOpenGLTexture.TextureFormat = ...
    RGBAFormat: QOpenGLTexture.TextureFormat = ...
    LuminanceFormat: QOpenGLTexture.TextureFormat = ...
    LuminanceAlphaFormat: QOpenGLTexture.TextureFormat = ...
    RG3B2: QOpenGLTexture.TextureFormat = ...
    RGB8_UNorm: QOpenGLTexture.TextureFormat = ...
    RGB16_UNorm: QOpenGLTexture.TextureFormat = ...
    RGBA4: QOpenGLTexture.TextureFormat = ...
    RGB5A1: QOpenGLTexture.TextureFormat = ...
    RGBA8_UNorm: QOpenGLTexture.TextureFormat = ...
    RGBA16_UNorm: QOpenGLTexture.TextureFormat = ...
    D16: QOpenGLTexture.TextureFormat = ...
    D24: QOpenGLTexture.TextureFormat = ...
    D32: QOpenGLTexture.TextureFormat = ...
    R8_UNorm: QOpenGLTexture.TextureFormat = ...
    R16_UNorm: QOpenGLTexture.TextureFormat = ...
    RG8_UNorm: QOpenGLTexture.TextureFormat = ...
    RG16_UNorm: QOpenGLTexture.TextureFormat = ...
    R16F: QOpenGLTexture.TextureFormat = ...
    R32F: QOpenGLTexture.TextureFormat = ...
    RG16F: QOpenGLTexture.TextureFormat = ...
    RG32F: QOpenGLTexture.TextureFormat = ...
    R8I: QOpenGLTexture.TextureFormat = ...
    R8U: QOpenGLTexture.TextureFormat = ...
    R16I: QOpenGLTexture.TextureFormat = ...
    R16U: QOpenGLTexture.TextureFormat = ...
    R32I: QOpenGLTexture.TextureFormat = ...
    R32U: QOpenGLTexture.TextureFormat = ...
    RG8I: QOpenGLTexture.TextureFormat = ...
    RG8U: QOpenGLTexture.TextureFormat = ...
    RG16I: QOpenGLTexture.TextureFormat = ...
    RG16U: QOpenGLTexture.TextureFormat = ...
    RG32I: QOpenGLTexture.TextureFormat = ...
    RG32U: QOpenGLTexture.TextureFormat = ...
    RGB_DXT1: QOpenGLTexture.TextureFormat = ...
    RGBA_DXT1: QOpenGLTexture.TextureFormat = ...
    RGBA_DXT3: QOpenGLTexture.TextureFormat = ...
    RGBA_DXT5: QOpenGLTexture.TextureFormat = ...
    RGBA32F: QOpenGLTexture.TextureFormat = ...
    RGB32F: QOpenGLTexture.TextureFormat = ...
    RGBA16F: QOpenGLTexture.TextureFormat = ...
    RGB16F: QOpenGLTexture.TextureFormat = ...
    D24S8: QOpenGLTexture.TextureFormat = ...
    RG11B10F: QOpenGLTexture.TextureFormat = ...
    RGB9E5: QOpenGLTexture.TextureFormat = ...
    SRGB8: QOpenGLTexture.TextureFormat = ...
    SRGB8_Alpha8: QOpenGLTexture.TextureFormat = ...
    SRGB_DXT1: QOpenGLTexture.TextureFormat = ...
    SRGB_Alpha_DXT1: QOpenGLTexture.TextureFormat = ...
    SRGB_Alpha_DXT3: QOpenGLTexture.TextureFormat = ...
    SRGB_Alpha_DXT5: QOpenGLTexture.TextureFormat = ...
    D32F: QOpenGLTexture.TextureFormat = ...
    D32FS8X24: QOpenGLTexture.TextureFormat = ...
    S8: QOpenGLTexture.TextureFormat = ...
    R5G6B5: QOpenGLTexture.TextureFormat = ...
    RGB8_ETC1: QOpenGLTexture.TextureFormat = ...
    RGBA32U: QOpenGLTexture.TextureFormat = ...
    RGB32U: QOpenGLTexture.TextureFormat = ...
    RGBA16U: QOpenGLTexture.TextureFormat = ...
    RGB16U: QOpenGLTexture.TextureFormat = ...
    RGBA8U: QOpenGLTexture.TextureFormat = ...
    RGB8U: QOpenGLTexture.TextureFormat = ...
    RGBA32I: QOpenGLTexture.TextureFormat = ...
    RGB32I: QOpenGLTexture.TextureFormat = ...
    RGBA16I: QOpenGLTexture.TextureFormat = ...
    RGB16I: QOpenGLTexture.TextureFormat = ...
    RGBA8I: QOpenGLTexture.TextureFormat = ...
    RGB8I: QOpenGLTexture.TextureFormat = ...
    R_ATI1N_UNorm: QOpenGLTexture.TextureFormat = ...
    R_ATI1N_SNorm: QOpenGLTexture.TextureFormat = ...
    RG_ATI2N_UNorm: QOpenGLTexture.TextureFormat = ...
    RG_ATI2N_SNorm: QOpenGLTexture.TextureFormat = ...
    RGB_BP_UNorm: QOpenGLTexture.TextureFormat = ...
    SRGB_BP_UNorm: QOpenGLTexture.TextureFormat = ...
    RGB_BP_SIGNED_FLOAT: QOpenGLTexture.TextureFormat = ...
    RGB_BP_UNSIGNED_FLOAT: QOpenGLTexture.TextureFormat = ...
    R8_SNorm: QOpenGLTexture.TextureFormat = ...
    RG8_SNorm: QOpenGLTexture.TextureFormat = ...
    RGB8_SNorm: QOpenGLTexture.TextureFormat = ...
    RGBA8_SNorm: QOpenGLTexture.TextureFormat = ...
    R16_SNorm: QOpenGLTexture.TextureFormat = ...
    RG16_SNorm: QOpenGLTexture.TextureFormat = ...
    RGB16_SNorm: QOpenGLTexture.TextureFormat = ...
    RGBA16_SNorm: QOpenGLTexture.TextureFormat = ...
    RGB10A2: QOpenGLTexture.TextureFormat = ...
    R11_EAC_UNorm: QOpenGLTexture.TextureFormat = ...
    R11_EAC_SNorm: QOpenGLTexture.TextureFormat = ...
    RG11_EAC_UNorm: QOpenGLTexture.TextureFormat = ...
    RG11_EAC_SNorm: QOpenGLTexture.TextureFormat = ...
    RGB8_ETC2: QOpenGLTexture.TextureFormat = ...
    SRGB8_ETC2: QOpenGLTexture.TextureFormat = ...
    RGB8_PunchThrough_Alpha1_ETC2: QOpenGLTexture.TextureFormat = ...
    SRGB8_PunchThrough_Alpha1_ETC2: QOpenGLTexture.TextureFormat = ...
    RGBA8_ETC2_EAC: QOpenGLTexture.TextureFormat = ...
    SRGB8_Alpha8_ETC2_EAC: QOpenGLTexture.TextureFormat = ...
    RGBA_ASTC_4x4: QOpenGLTexture.TextureFormat = ...
    RGBA_ASTC_5x4: QOpenGLTexture.TextureFormat = ...
    RGBA_ASTC_5x5: QOpenGLTexture.TextureFormat = ...
    RGBA_ASTC_6x5: QOpenGLTexture.TextureFormat = ...
    RGBA_ASTC_6x6: QOpenGLTexture.TextureFormat = ...
    RGBA_ASTC_8x5: QOpenGLTexture.TextureFormat = ...
    RGBA_ASTC_8x6: QOpenGLTexture.TextureFormat = ...
    RGBA_ASTC_8x8: QOpenGLTexture.TextureFormat = ...
    RGBA_ASTC_10x5: QOpenGLTexture.TextureFormat = ...
    RGBA_ASTC_10x6: QOpenGLTexture.TextureFormat = ...
    RGBA_ASTC_10x8: QOpenGLTexture.TextureFormat = ...
    RGBA_ASTC_10x10: QOpenGLTexture.TextureFormat = ...
    RGBA_ASTC_12x10: QOpenGLTexture.TextureFormat = ...
    RGBA_ASTC_12x12: QOpenGLTexture.TextureFormat = ...
    SRGB8_Alpha8_ASTC_4x4: QOpenGLTexture.TextureFormat = ...
    SRGB8_Alpha8_ASTC_5x4: QOpenGLTexture.TextureFormat = ...
    SRGB8_Alpha8_ASTC_5x5: QOpenGLTexture.TextureFormat = ...
    SRGB8_Alpha8_ASTC_6x5: QOpenGLTexture.TextureFormat = ...
    SRGB8_Alpha8_ASTC_6x6: QOpenGLTexture.TextureFormat = ...
    SRGB8_Alpha8_ASTC_8x5: QOpenGLTexture.TextureFormat = ...
    SRGB8_Alpha8_ASTC_8x6: QOpenGLTexture.TextureFormat = ...
    SRGB8_Alpha8_ASTC_8x8: QOpenGLTexture.TextureFormat = ...
    SRGB8_Alpha8_ASTC_10x5: QOpenGLTexture.TextureFormat = ...
    SRGB8_Alpha8_ASTC_10x6: QOpenGLTexture.TextureFormat = ...
    SRGB8_Alpha8_ASTC_10x8: QOpenGLTexture.TextureFormat = ...
    SRGB8_Alpha8_ASTC_10x10: QOpenGLTexture.TextureFormat = ...
    SRGB8_Alpha8_ASTC_12x10: QOpenGLTexture.TextureFormat = ...
    SRGB8_Alpha8_ASTC_12x12: QOpenGLTexture.TextureFormat = ...
    NoFormatClass: QOpenGLTexture.TextureFormatClass = ...
    FormatClass_128Bit: QOpenGLTexture.TextureFormatClass = ...
    FormatClass_96Bit: QOpenGLTexture.TextureFormatClass = ...
    FormatClass_64Bit: QOpenGLTexture.TextureFormatClass = ...
    FormatClass_48Bit: QOpenGLTexture.TextureFormatClass = ...
    FormatClass_32Bit: QOpenGLTexture.TextureFormatClass = ...
    FormatClass_24Bit: QOpenGLTexture.TextureFormatClass = ...
    FormatClass_16Bit: QOpenGLTexture.TextureFormatClass = ...
    FormatClass_8Bit: QOpenGLTexture.TextureFormatClass = ...
    FormatClass_RGTC1_R: QOpenGLTexture.TextureFormatClass = ...
    FormatClass_RGTC2_RG: QOpenGLTexture.TextureFormatClass = ...
    FormatClass_BPTC_Unorm: QOpenGLTexture.TextureFormatClass = ...
    FormatClass_BPTC_Float: QOpenGLTexture.TextureFormatClass = ...
    FormatClass_S3TC_DXT1_RGB: QOpenGLTexture.TextureFormatClass = ...
    FormatClass_S3TC_DXT1_RGBA: QOpenGLTexture.TextureFormatClass = ...
    FormatClass_S3TC_DXT3_RGBA: QOpenGLTexture.TextureFormatClass = ...
    FormatClass_S3TC_DXT5_RGBA: QOpenGLTexture.TextureFormatClass = ...
    FormatClass_Unique: QOpenGLTexture.TextureFormatClass = ...
    ResetTextureUnit: QOpenGLTexture.TextureUnitReset = ...
    DontResetTextureUnit: QOpenGLTexture.TextureUnitReset = ...
    Repeat: QOpenGLTexture.WrapMode = ...
    ClampToBorder: QOpenGLTexture.WrapMode = ...
    ClampToEdge: QOpenGLTexture.WrapMode = ...
    MirroredRepeat: QOpenGLTexture.WrapMode = ...

    class BindingTarget(Enum):
        BindingTarget1D: QOpenGLTexture.BindingTarget = ...
        BindingTarget2D: QOpenGLTexture.BindingTarget = ...
        BindingTarget3D: QOpenGLTexture.BindingTarget = ...
        BindingTargetRectangle: QOpenGLTexture.BindingTarget = ...
        BindingTargetCubeMap: QOpenGLTexture.BindingTarget = ...
        BindingTarget1DArray: QOpenGLTexture.BindingTarget = ...
        BindingTarget2DArray: QOpenGLTexture.BindingTarget = ...
        BindingTargetBuffer: QOpenGLTexture.BindingTarget = ...
        BindingTargetCubeMapArray: QOpenGLTexture.BindingTarget = ...
        BindingTarget2DMultisample: QOpenGLTexture.BindingTarget = ...
        BindingTarget2DMultisampleArray: QOpenGLTexture.BindingTarget = ...

    class ComparisonFunction(Enum):
        CompareNever: QOpenGLTexture.ComparisonFunction = ...
        CompareLess: QOpenGLTexture.ComparisonFunction = ...
        CompareEqual: QOpenGLTexture.ComparisonFunction = ...
        CompareLessEqual: QOpenGLTexture.ComparisonFunction = ...
        CompareGreater: QOpenGLTexture.ComparisonFunction = ...
        CommpareNotEqual: QOpenGLTexture.ComparisonFunction = ...
        CompareNotEqual: QOpenGLTexture.ComparisonFunction = ...
        CompareGreaterEqual: QOpenGLTexture.ComparisonFunction = ...
        CompareAlways: QOpenGLTexture.ComparisonFunction = ...

    class ComparisonMode(Enum):
        CompareNone: QOpenGLTexture.ComparisonMode = ...
        CompareRefToTexture: QOpenGLTexture.ComparisonMode = ...

    class CoordinateDirection(Enum):
        DirectionS: QOpenGLTexture.CoordinateDirection = ...
        DirectionT: QOpenGLTexture.CoordinateDirection = ...
        DirectionR: QOpenGLTexture.CoordinateDirection = ...

    class CubeMapFace(Enum):
        CubeMapPositiveX: QOpenGLTexture.CubeMapFace = ...
        CubeMapNegativeX: QOpenGLTexture.CubeMapFace = ...
        CubeMapPositiveY: QOpenGLTexture.CubeMapFace = ...
        CubeMapNegativeY: QOpenGLTexture.CubeMapFace = ...
        CubeMapPositiveZ: QOpenGLTexture.CubeMapFace = ...
        CubeMapNegativeZ: QOpenGLTexture.CubeMapFace = ...

    class DepthStencilMode(Enum):
        StencilMode: QOpenGLTexture.DepthStencilMode = ...
        DepthMode: QOpenGLTexture.DepthStencilMode = ...

    class Feature(Enum):
        ImmutableStorage: QOpenGLTexture.Feature = ...
        ImmutableMultisampleStorage: QOpenGLTexture.Feature = ...
        TextureRectangle: QOpenGLTexture.Feature = ...
        TextureArrays: QOpenGLTexture.Feature = ...
        Texture3D: QOpenGLTexture.Feature = ...
        TextureMultisample: QOpenGLTexture.Feature = ...
        TextureBuffer: QOpenGLTexture.Feature = ...
        TextureCubeMapArrays: QOpenGLTexture.Feature = ...
        Swizzle: QOpenGLTexture.Feature = ...
        StencilTexturing: QOpenGLTexture.Feature = ...
        AnisotropicFiltering: QOpenGLTexture.Feature = ...
        NPOTTextures: QOpenGLTexture.Feature = ...
        NPOTTextureRepeat: QOpenGLTexture.Feature = ...
        Texture1D: QOpenGLTexture.Feature = ...
        TextureComparisonOperators: QOpenGLTexture.Feature = ...
        TextureMipMapLevel: QOpenGLTexture.Feature = ...
        MaxFeatureFlag: QOpenGLTexture.Feature = ...

    class Features(object):
        ...

    class Filter(Enum):
        Nearest: QOpenGLTexture.Filter = ...
        Linear: QOpenGLTexture.Filter = ...
        NearestMipMapNearest: QOpenGLTexture.Filter = ...
        LinearMipMapNearest: QOpenGLTexture.Filter = ...
        NearestMipMapLinear: QOpenGLTexture.Filter = ...
        LinearMipMapLinear: QOpenGLTexture.Filter = ...

    class MipMapGeneration(Enum):
        GenerateMipMaps: QOpenGLTexture.MipMapGeneration = ...
        DontGenerateMipMaps: QOpenGLTexture.MipMapGeneration = ...

    class PixelFormat(Enum):
        NoSourceFormat: QOpenGLTexture.PixelFormat = ...
        Stencil: QOpenGLTexture.PixelFormat = ...
        Depth: QOpenGLTexture.PixelFormat = ...
        Red: QOpenGLTexture.PixelFormat = ...
        Alpha: QOpenGLTexture.PixelFormat = ...
        RGB: QOpenGLTexture.PixelFormat = ...
        RGBA: QOpenGLTexture.PixelFormat = ...
        Luminance: QOpenGLTexture.PixelFormat = ...
        LuminanceAlpha: QOpenGLTexture.PixelFormat = ...
        BGR: QOpenGLTexture.PixelFormat = ...
        BGRA: QOpenGLTexture.PixelFormat = ...
        RG: QOpenGLTexture.PixelFormat = ...
        RG_Integer: QOpenGLTexture.PixelFormat = ...
        DepthStencil: QOpenGLTexture.PixelFormat = ...
        Red_Integer: QOpenGLTexture.PixelFormat = ...
        RGB_Integer: QOpenGLTexture.PixelFormat = ...
        RGBA_Integer: QOpenGLTexture.PixelFormat = ...
        BGR_Integer: QOpenGLTexture.PixelFormat = ...
        BGRA_Integer: QOpenGLTexture.PixelFormat = ...

    class PixelType(Enum):
        NoPixelType: QOpenGLTexture.PixelType = ...
        Int8: QOpenGLTexture.PixelType = ...
        UInt8: QOpenGLTexture.PixelType = ...
        Int16: QOpenGLTexture.PixelType = ...
        UInt16: QOpenGLTexture.PixelType = ...
        Int32: QOpenGLTexture.PixelType = ...
        UInt32: QOpenGLTexture.PixelType = ...
        Float32: QOpenGLTexture.PixelType = ...
        Float16: QOpenGLTexture.PixelType = ...
        UInt8_RG3B2: QOpenGLTexture.PixelType = ...
        UInt16_RGBA4: QOpenGLTexture.PixelType = ...
        UInt16_RGB5A1: QOpenGLTexture.PixelType = ...
        UInt32_RGBA8: QOpenGLTexture.PixelType = ...
        UInt32_RGB10A2: QOpenGLTexture.PixelType = ...
        UInt8_RG3B2_Rev: QOpenGLTexture.PixelType = ...
        UInt16_R5G6B5: QOpenGLTexture.PixelType = ...
        UInt16_R5G6B5_Rev: QOpenGLTexture.PixelType = ...
        UInt16_RGBA4_Rev: QOpenGLTexture.PixelType = ...
        UInt16_RGB5A1_Rev: QOpenGLTexture.PixelType = ...
        UInt32_RGBA8_Rev: QOpenGLTexture.PixelType = ...
        UInt32_RGB10A2_Rev: QOpenGLTexture.PixelType = ...
        UInt32_D24S8: QOpenGLTexture.PixelType = ...
        UInt32_RG11B10F: QOpenGLTexture.PixelType = ...
        UInt32_RGB9_E5: QOpenGLTexture.PixelType = ...
        Float16OES: QOpenGLTexture.PixelType = ...
        Float32_D32_UInt32_S8_X24: QOpenGLTexture.PixelType = ...

    class SwizzleComponent(Enum):
        SwizzleRed: QOpenGLTexture.SwizzleComponent = ...
        SwizzleGreen: QOpenGLTexture.SwizzleComponent = ...
        SwizzleBlue: QOpenGLTexture.SwizzleComponent = ...
        SwizzleAlpha: QOpenGLTexture.SwizzleComponent = ...

    class SwizzleValue(Enum):
        ZeroValue: QOpenGLTexture.SwizzleValue = ...
        OneValue: QOpenGLTexture.SwizzleValue = ...
        RedValue: QOpenGLTexture.SwizzleValue = ...
        GreenValue: QOpenGLTexture.SwizzleValue = ...
        BlueValue: QOpenGLTexture.SwizzleValue = ...
        AlphaValue: QOpenGLTexture.SwizzleValue = ...

    class Target(Enum):
        Target1D: QOpenGLTexture.Target = ...
        Target2D: QOpenGLTexture.Target = ...
        Target3D: QOpenGLTexture.Target = ...
        TargetRectangle: QOpenGLTexture.Target = ...
        TargetCubeMap: QOpenGLTexture.Target = ...
        Target1DArray: QOpenGLTexture.Target = ...
        Target2DArray: QOpenGLTexture.Target = ...
        TargetBuffer: QOpenGLTexture.Target = ...
        TargetCubeMapArray: QOpenGLTexture.Target = ...
        Target2DMultisample: QOpenGLTexture.Target = ...
        Target2DMultisampleArray: QOpenGLTexture.Target = ...

    class TextureFormat(Enum):
        NoFormat: QOpenGLTexture.TextureFormat = ...
        DepthFormat: QOpenGLTexture.TextureFormat = ...
        AlphaFormat: QOpenGLTexture.TextureFormat = ...
        RGBFormat: QOpenGLTexture.TextureFormat = ...
        RGBAFormat: QOpenGLTexture.TextureFormat = ...
        LuminanceFormat: QOpenGLTexture.TextureFormat = ...
        LuminanceAlphaFormat: QOpenGLTexture.TextureFormat = ...
        RG3B2: QOpenGLTexture.TextureFormat = ...
        RGB8_UNorm: QOpenGLTexture.TextureFormat = ...
        RGB16_UNorm: QOpenGLTexture.TextureFormat = ...
        RGBA4: QOpenGLTexture.TextureFormat = ...
        RGB5A1: QOpenGLTexture.TextureFormat = ...
        RGBA8_UNorm: QOpenGLTexture.TextureFormat = ...
        RGBA16_UNorm: QOpenGLTexture.TextureFormat = ...
        D16: QOpenGLTexture.TextureFormat = ...
        D24: QOpenGLTexture.TextureFormat = ...
        D32: QOpenGLTexture.TextureFormat = ...
        R8_UNorm: QOpenGLTexture.TextureFormat = ...
        R16_UNorm: QOpenGLTexture.TextureFormat = ...
        RG8_UNorm: QOpenGLTexture.TextureFormat = ...
        RG16_UNorm: QOpenGLTexture.TextureFormat = ...
        R16F: QOpenGLTexture.TextureFormat = ...
        R32F: QOpenGLTexture.TextureFormat = ...
        RG16F: QOpenGLTexture.TextureFormat = ...
        RG32F: QOpenGLTexture.TextureFormat = ...
        R8I: QOpenGLTexture.TextureFormat = ...
        R8U: QOpenGLTexture.TextureFormat = ...
        R16I: QOpenGLTexture.TextureFormat = ...
        R16U: QOpenGLTexture.TextureFormat = ...
        R32I: QOpenGLTexture.TextureFormat = ...
        R32U: QOpenGLTexture.TextureFormat = ...
        RG8I: QOpenGLTexture.TextureFormat = ...
        RG8U: QOpenGLTexture.TextureFormat = ...
        RG16I: QOpenGLTexture.TextureFormat = ...
        RG16U: QOpenGLTexture.TextureFormat = ...
        RG32I: QOpenGLTexture.TextureFormat = ...
        RG32U: QOpenGLTexture.TextureFormat = ...
        RGB_DXT1: QOpenGLTexture.TextureFormat = ...
        RGBA_DXT1: QOpenGLTexture.TextureFormat = ...
        RGBA_DXT3: QOpenGLTexture.TextureFormat = ...
        RGBA_DXT5: QOpenGLTexture.TextureFormat = ...
        RGBA32F: QOpenGLTexture.TextureFormat = ...
        RGB32F: QOpenGLTexture.TextureFormat = ...
        RGBA16F: QOpenGLTexture.TextureFormat = ...
        RGB16F: QOpenGLTexture.TextureFormat = ...
        D24S8: QOpenGLTexture.TextureFormat = ...
        RG11B10F: QOpenGLTexture.TextureFormat = ...
        RGB9E5: QOpenGLTexture.TextureFormat = ...
        SRGB8: QOpenGLTexture.TextureFormat = ...
        SRGB8_Alpha8: QOpenGLTexture.TextureFormat = ...
        SRGB_DXT1: QOpenGLTexture.TextureFormat = ...
        SRGB_Alpha_DXT1: QOpenGLTexture.TextureFormat = ...
        SRGB_Alpha_DXT3: QOpenGLTexture.TextureFormat = ...
        SRGB_Alpha_DXT5: QOpenGLTexture.TextureFormat = ...
        D32F: QOpenGLTexture.TextureFormat = ...
        D32FS8X24: QOpenGLTexture.TextureFormat = ...
        S8: QOpenGLTexture.TextureFormat = ...
        R5G6B5: QOpenGLTexture.TextureFormat = ...
        RGB8_ETC1: QOpenGLTexture.TextureFormat = ...
        RGBA32U: QOpenGLTexture.TextureFormat = ...
        RGB32U: QOpenGLTexture.TextureFormat = ...
        RGBA16U: QOpenGLTexture.TextureFormat = ...
        RGB16U: QOpenGLTexture.TextureFormat = ...
        RGBA8U: QOpenGLTexture.TextureFormat = ...
        RGB8U: QOpenGLTexture.TextureFormat = ...
        RGBA32I: QOpenGLTexture.TextureFormat = ...
        RGB32I: QOpenGLTexture.TextureFormat = ...
        RGBA16I: QOpenGLTexture.TextureFormat = ...
        RGB16I: QOpenGLTexture.TextureFormat = ...
        RGBA8I: QOpenGLTexture.TextureFormat = ...
        RGB8I: QOpenGLTexture.TextureFormat = ...
        R_ATI1N_UNorm: QOpenGLTexture.TextureFormat = ...
        R_ATI1N_SNorm: QOpenGLTexture.TextureFormat = ...
        RG_ATI2N_UNorm: QOpenGLTexture.TextureFormat = ...
        RG_ATI2N_SNorm: QOpenGLTexture.TextureFormat = ...
        RGB_BP_UNorm: QOpenGLTexture.TextureFormat = ...
        SRGB_BP_UNorm: QOpenGLTexture.TextureFormat = ...
        RGB_BP_SIGNED_FLOAT: QOpenGLTexture.TextureFormat = ...
        RGB_BP_UNSIGNED_FLOAT: QOpenGLTexture.TextureFormat = ...
        R8_SNorm: QOpenGLTexture.TextureFormat = ...
        RG8_SNorm: QOpenGLTexture.TextureFormat = ...
        RGB8_SNorm: QOpenGLTexture.TextureFormat = ...
        RGBA8_SNorm: QOpenGLTexture.TextureFormat = ...
        R16_SNorm: QOpenGLTexture.TextureFormat = ...
        RG16_SNorm: QOpenGLTexture.TextureFormat = ...
        RGB16_SNorm: QOpenGLTexture.TextureFormat = ...
        RGBA16_SNorm: QOpenGLTexture.TextureFormat = ...
        RGB10A2: QOpenGLTexture.TextureFormat = ...
        R11_EAC_UNorm: QOpenGLTexture.TextureFormat = ...
        R11_EAC_SNorm: QOpenGLTexture.TextureFormat = ...
        RG11_EAC_UNorm: QOpenGLTexture.TextureFormat = ...
        RG11_EAC_SNorm: QOpenGLTexture.TextureFormat = ...
        RGB8_ETC2: QOpenGLTexture.TextureFormat = ...
        SRGB8_ETC2: QOpenGLTexture.TextureFormat = ...
        RGB8_PunchThrough_Alpha1_ETC2: QOpenGLTexture.TextureFormat = ...
        SRGB8_PunchThrough_Alpha1_ETC2: QOpenGLTexture.TextureFormat = ...
        RGBA8_ETC2_EAC: QOpenGLTexture.TextureFormat = ...
        SRGB8_Alpha8_ETC2_EAC: QOpenGLTexture.TextureFormat = ...
        RGBA_ASTC_4x4: QOpenGLTexture.TextureFormat = ...
        RGBA_ASTC_5x4: QOpenGLTexture.TextureFormat = ...
        RGBA_ASTC_5x5: QOpenGLTexture.TextureFormat = ...
        RGBA_ASTC_6x5: QOpenGLTexture.TextureFormat = ...
        RGBA_ASTC_6x6: QOpenGLTexture.TextureFormat = ...
        RGBA_ASTC_8x5: QOpenGLTexture.TextureFormat = ...
        RGBA_ASTC_8x6: QOpenGLTexture.TextureFormat = ...
        RGBA_ASTC_8x8: QOpenGLTexture.TextureFormat = ...
        RGBA_ASTC_10x5: QOpenGLTexture.TextureFormat = ...
        RGBA_ASTC_10x6: QOpenGLTexture.TextureFormat = ...
        RGBA_ASTC_10x8: QOpenGLTexture.TextureFormat = ...
        RGBA_ASTC_10x10: QOpenGLTexture.TextureFormat = ...
        RGBA_ASTC_12x10: QOpenGLTexture.TextureFormat = ...
        RGBA_ASTC_12x12: QOpenGLTexture.TextureFormat = ...
        SRGB8_Alpha8_ASTC_4x4: QOpenGLTexture.TextureFormat = ...
        SRGB8_Alpha8_ASTC_5x4: QOpenGLTexture.TextureFormat = ...
        SRGB8_Alpha8_ASTC_5x5: QOpenGLTexture.TextureFormat = ...
        SRGB8_Alpha8_ASTC_6x5: QOpenGLTexture.TextureFormat = ...
        SRGB8_Alpha8_ASTC_6x6: QOpenGLTexture.TextureFormat = ...
        SRGB8_Alpha8_ASTC_8x5: QOpenGLTexture.TextureFormat = ...
        SRGB8_Alpha8_ASTC_8x6: QOpenGLTexture.TextureFormat = ...
        SRGB8_Alpha8_ASTC_8x8: QOpenGLTexture.TextureFormat = ...
        SRGB8_Alpha8_ASTC_10x5: QOpenGLTexture.TextureFormat = ...
        SRGB8_Alpha8_ASTC_10x6: QOpenGLTexture.TextureFormat = ...
        SRGB8_Alpha8_ASTC_10x8: QOpenGLTexture.TextureFormat = ...
        SRGB8_Alpha8_ASTC_10x10: QOpenGLTexture.TextureFormat = ...
        SRGB8_Alpha8_ASTC_12x10: QOpenGLTexture.TextureFormat = ...
        SRGB8_Alpha8_ASTC_12x12: QOpenGLTexture.TextureFormat = ...

    class TextureFormatClass(Enum):
        NoFormatClass: QOpenGLTexture.TextureFormatClass = ...
        FormatClass_128Bit: QOpenGLTexture.TextureFormatClass = ...
        FormatClass_96Bit: QOpenGLTexture.TextureFormatClass = ...
        FormatClass_64Bit: QOpenGLTexture.TextureFormatClass = ...
        FormatClass_48Bit: QOpenGLTexture.TextureFormatClass = ...
        FormatClass_32Bit: QOpenGLTexture.TextureFormatClass = ...
        FormatClass_24Bit: QOpenGLTexture.TextureFormatClass = ...
        FormatClass_16Bit: QOpenGLTexture.TextureFormatClass = ...
        FormatClass_8Bit: QOpenGLTexture.TextureFormatClass = ...
        FormatClass_RGTC1_R: QOpenGLTexture.TextureFormatClass = ...
        FormatClass_RGTC2_RG: QOpenGLTexture.TextureFormatClass = ...
        FormatClass_BPTC_Unorm: QOpenGLTexture.TextureFormatClass = ...
        FormatClass_BPTC_Float: QOpenGLTexture.TextureFormatClass = ...
        FormatClass_S3TC_DXT1_RGB: QOpenGLTexture.TextureFormatClass = ...
        FormatClass_S3TC_DXT1_RGBA: QOpenGLTexture.TextureFormatClass = ...
        FormatClass_S3TC_DXT3_RGBA: QOpenGLTexture.TextureFormatClass = ...
        FormatClass_S3TC_DXT5_RGBA: QOpenGLTexture.TextureFormatClass = ...
        FormatClass_Unique: QOpenGLTexture.TextureFormatClass = ...

    class TextureUnitReset(Enum):
        ResetTextureUnit: QOpenGLTexture.TextureUnitReset = ...
        DontResetTextureUnit: QOpenGLTexture.TextureUnitReset = ...

    class WrapMode(Enum):
        Repeat: QOpenGLTexture.WrapMode = ...
        ClampToBorder: QOpenGLTexture.WrapMode = ...
        ClampToEdge: QOpenGLTexture.WrapMode = ...
        MirroredRepeat: QOpenGLTexture.WrapMode = ...

    @overload
    def __init__(
        self,
        image: Union[PySide6.QtGui.QImage, str],
        genMipMaps: PySide6.QtOpenGL.QOpenGLTexture.MipMapGeneration = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#QOpenGLTexture

        **QOpenGLTexture::QOpenGLTexture(QOpenGLTexture::Target target )**

        Creates a QOpenGLTexture object that can later be bound to **target**.

        This does not create the underlying OpenGL texture object. Therefore,
        construction using this constructor does not require a valid current
        OpenGL context.
        """
        ...

    @overload
    def __init__(self, target: PySide6.QtOpenGL.QOpenGLTexture.Target) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#QOpenGLTexture-1

        **QOpenGLTexture::QOpenGLTexture(const QImage & image ,
        QOpenGLTexture::MipMapGeneration genMipMaps = GenerateMipMaps)**

        Creates a QOpenGLTexture object that can later be bound to the 2D
        texture target and contains the pixel data contained in **image**. If
        you wish to have a chain of mipmaps generated then set **genMipMaps** to
        `true` (this is the default).

        This does create the underlying OpenGL texture object. Therefore,
        construction using this constructor does require a valid current OpenGL
        context.
        """
        ...

    @overload
    def allocateStorage(self) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#allocateStorage

        **void QOpenGLTexture::allocateStorage()**

        Allocates server-side storage for this texture object taking into
        account, the format, dimensions, mipmap levels, array layers and cubemap
        faces.

        Once storage has been allocated it is no longer possible to change these
        properties.

        If supported **QOpenGLTexture**  makes use of immutable texture storage.

        Once storage has been allocated for the texture then pixel data can be
        uploaded via one of the **setData** () overloads.

        **Note:** If immutable texture storage is not available, then a default
        pixel format and pixel type will be used to create the mutable storage.
        You can use the other allocateStorage() overload to specify exactly the
        pixel format and the pixel type to use when allocating mutable storage;
        this is particulary useful under certain OpenGL ES implementations
        (notably, OpenGL ES 2), where the pixel format and the pixel type used
        at allocation time must perfectly match the format and the type passed
        to any subsequent **setData** () call.

        **See also** **isStorageAllocated** () and **setData** ().
        """
        ...

    @overload
    def allocateStorage(
        self,
        pixelFormat: PySide6.QtOpenGL.QOpenGLTexture.PixelFormat,
        pixelType: PySide6.QtOpenGL.QOpenGLTexture.PixelType,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#allocateStorage-1

        **[since 5.5] void
        QOpenGLTexture::allocateStorage(QOpenGLTexture::PixelFormat pixelFormat
        , QOpenGLTexture::PixelType pixelType )**

        Allocates server-side storage for this texture object taking into
        account, the format, dimensions, mipmap levels, array layers and cubemap
        faces.

        Once storage has been allocated it is no longer possible to change these
        properties.

        If supported **QOpenGLTexture**  makes use of immutable texture storage.
        However, if immutable texture storage is not available, then the
        specified **pixelFormat** and **pixelType** will be used to allocate
        mutable storage; note that in certain OpenGL implementations (notably,
        OpenGL ES 2) they must perfectly match the format and the type passed to
        any subsequent **setData** () call.

        Once storage has been allocated for the texture then pixel data can be
        uploaded via one of the **setData** () overloads.

        This function was introduced in Qt 5.5.

        **See also** **isStorageAllocated** () and **setData** ().
        """
        ...

    @overload
    def bind(self) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#bind

        **void QOpenGLTexture::bind()**

        Binds this texture to the currently active texture unit ready for
        rendering. Note that you do not need to bind **QOpenGLTexture**  objects
        in order to modify them as the implementation makes use of the
        EXT_direct_state_access extension where available and simulates it where
        it is not.

        **See also** **release** ().
        """
        ...

    @overload
    def bind(
        self, unit: int, reset: PySide6.QtOpenGL.QOpenGLTexture.TextureUnitReset = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#bind-1

        **void QOpenGLTexture::bind(uint unit , QOpenGLTexture::TextureUnitReset
        reset = DontResetTextureUnit)**

        Binds this texture to texture unit **unit** ready for rendering. Note
        that you do not need to bind **QOpenGLTexture**  objects in order to
        modify them as the implementation makes use of the
        EXT_direct_state_access extension where available and simulates it where
        it is not.

        If parameter **reset** is `true` then this function will restore the
        active unit to the texture unit that was active upon entry.

        **See also** **release** ().
        """
        ...

    def borderColor(self) -> PySide6.QtGui.QColor:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#borderColor

        **QColor QOpenGLTexture::borderColor() const**

        Returns the borderColor of this texture.

        **See also** **setBorderColor** ().
        """
        ...

    @overload
    @staticmethod
    def boundTextureId(target: PySide6.QtOpenGL.QOpenGLTexture.BindingTarget) -> int:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#boundTextureId

        **[static] GLuint
        QOpenGLTexture::boundTextureId(QOpenGLTexture::BindingTarget target )**

        Returns the **textureId**  of the texture that is bound to the
        **target** of the currently active texture unit.
        """
        ...

    @overload
    @staticmethod
    def boundTextureId(
        unit: int, target: PySide6.QtOpenGL.QOpenGLTexture.BindingTarget
    ) -> int:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#boundTextureId-1

        **[static] GLuint QOpenGLTexture::boundTextureId(uint unit ,
        QOpenGLTexture::BindingTarget target )**

        Returns the **textureId**  of the texture that is bound to the
        **target** of the texture unit **unit**.
        """
        ...

    def comparisonFunction(self) -> PySide6.QtOpenGL.QOpenGLTexture.ComparisonFunction:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#comparisonFunction

        **[since 5.5] QOpenGLTexture::ComparisonFunction
        QOpenGLTexture::comparisonFunction() const**

        Returns the texture comparison operator set on this texture. By default,
        a texture has a **CompareLessEqual**  comparison function.

        This function was introduced in Qt 5.5.

        **See also** **setComparisonFunction** ().
        """
        ...

    def comparisonMode(self) -> PySide6.QtOpenGL.QOpenGLTexture.ComparisonMode:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#comparisonMode

        **[since 5.5] QOpenGLTexture::ComparisonMode
        QOpenGLTexture::comparisonMode() const**

        Returns the texture comparison mode set on this texture. By default, a
        texture has a **CompareNone**  comparison mode (i.e. comparisons are
        disabled).

        This function was introduced in Qt 5.5.

        **See also** **setComparisonMode** ().
        """
        ...

    def create(self) -> bool:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#create

        **bool QOpenGLTexture::create()**

        Creates the underlying OpenGL texture object. This requires a current
        valid OpenGL context. If the texture object already exists, this
        function does nothing.

        Once the texture object is created you can obtain the object name from
        the **textureId** () function. This may be useful if you wish to make
        some raw OpenGL calls related to this texture.

        Normally it should not be necessary to call this function directly as
        all functions that set properties of the texture object implicitly call
        create() on your behalf.

        Returns `true` if the creation succeeded, otherwise returns `false`.

        **See also** **destroy** (), **isCreated** (), and **textureId** ().
        """
        ...

    def createTextureView(
        self,
        target: PySide6.QtOpenGL.QOpenGLTexture.Target,
        viewFormat: PySide6.QtOpenGL.QOpenGLTexture.TextureFormat,
        minimumMipmapLevel: int,
        maximumMipmapLevel: int,
        minimumLayer: int,
        maximumLayer: int,
    ) -> PySide6.QtOpenGL.QOpenGLTexture:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#createTextureView

        **QOpenGLTexture
        *QOpenGLTexture::createTextureView(QOpenGLTexture::Target target ,
        QOpenGLTexture::TextureFormat viewFormat , int minimumMipmapLevel , int
        maximumMipmapLevel , int minimumLayer , int maximumLayer ) const**

        Attempts to create a texture view onto this texture. A texture view is
        somewhat analogous to a view in SQL in that it presents a restricted or
        reinterpreted view of the original data. Texture views do not allocate
        any more server-side storage, insted relying on the storage buffer of
        the source texture.

        Texture views are only available when using immutable storage. For more
        information on texture views see
        http://www.opengl.org/wiki/Texture_Storage#Texture_views.

        The **target** argument specifies the target to use for the view. Only
        some targets can be used depending upon the target of the original
        target. For e.g. a view onto a **Target1DArray**  texture can specify
        either **Target1DArray**  or **Target1D**  but for the latter the number
        of array layers specified with **minimumLayer** and **maximumLayer**
        must be exactly 1.

        Simpliar constraints apply for the **viewFormat**. See the above link
        and the specification for more details.

        The **minimumMipmapLevel** , **maximumMipmapLevel** , **minimumLayer** ,
        and **maximumLayer** arguments serve to restrict the parts of the
        texture accessible by the texture view.

        If creation of the texture view fails this function will return 0. If
        the function succeeds it will return a pointer to a new
        **QOpenGLTexture**  object that will return `true` from its
        **isTextureView** () function.

        **See also** **isTextureView** ().
        """
        ...

    def depth(self) -> int:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#depth

        **int QOpenGLTexture::depth() const**

        Returns the depth of a 3D texture.

        **See also** **width** (), **height** (), and **setSize** ().
        """
        ...

    def depthStencilMode(self) -> PySide6.QtOpenGL.QOpenGLTexture.DepthStencilMode:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#depthStencilMode

        **[since 5.4] QOpenGLTexture::DepthStencilMode
        QOpenGLTexture::depthStencilMode() const**

        Returns the depth stencil mode for textures using a combined
        depth/stencil format.

        This function was introduced in Qt 5.4.

        **See also** **setDepthStencilMode** ().
        """
        ...

    def destroy(self) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#destroy

        **void QOpenGLTexture::destroy()**

        Destroys the underlying OpenGL texture object. This requires a current
        valid OpenGL context.

        **See also** **create** (), **isCreated** (), and **textureId** ().
        """
        ...

    def faces(self) -> int:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#faces

        **int QOpenGLTexture::faces() const**

        Returns the number of faces for this texture. For cubemap and cubemap
        array type targets this will be 6.

        For non-cubemap type targets this will return 1.
        """
        ...

    def format(self) -> PySide6.QtOpenGL.QOpenGLTexture.TextureFormat:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#format

        **QOpenGLTexture::TextureFormat QOpenGLTexture::format() const**

        Returns the format of this texture object.

        **See also** **setFormat** ().
        """
        ...

    @overload
    def generateMipMaps(self) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#generateMipMaps

        **void QOpenGLTexture::generateMipMaps()**

        Generates mipmaps for this texture object from mipmap level 0. If you
        are using a texture target and filtering option that requires mipmaps
        and you have disabled automatic mipmap generation then you need to call
        this function or the overload to create the mipmap chain.

        **Note:** Mipmap generation is not supported for compressed textures
        with OpenGL ES.

        **See also** **setAutoMipMapGenerationEnabled** (), **setMipLevels** (),
        and **mipLevels** ().
        """
        ...

    @overload
    def generateMipMaps(self, baseLevel: int, resetBaseLevel: bool = ...) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#generateMipMaps-1

        **void QOpenGLTexture::generateMipMaps(int baseLevel , bool
        resetBaseLevel = true)**

        Generates mipmaps for this texture object from mipmap level
        **baseLevel**. If you are using a texture target and filtering option
        that requires mipmaps and you have disabled automatic mipmap generation
        then you need to call this function or the overload to create the mipmap
        chain.

        The generation of mipmaps to above **baseLevel** is achieved by setting
        the mipmap base level to **baseLevel** and then generating the mipmap
        chain. If **resetBaseLevel** is `true`, then the baseLevel of the
        texture will be reset to its previous value.

        **See also** **setAutoMipMapGenerationEnabled** (), **setMipLevels** (),
        and **mipLevels** ().
        """
        ...

    @staticmethod
    def hasFeature(feature: PySide6.QtOpenGL.QOpenGLTexture.Feature) -> bool:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#hasFeature

        **[static] bool QOpenGLTexture::hasFeature(QOpenGLTexture::Feature
        feature )**

        Returns `true` if your OpenGL implementation and version supports the
        texture feature **feature**.
        """
        ...

    def height(self) -> int:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#height

        **int QOpenGLTexture::height() const**

        Returns the height of a 2D or 3D texture.

        **See also** **width** (), **depth** (), and **setSize** ().
        """
        ...

    def isAutoMipMapGenerationEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#isAutoMipMapGenerationEnabled

        **bool QOpenGLTexture::isAutoMipMapGenerationEnabled() const**

        Returns whether auto mipmap generation is enabled for this texture
        object.

        **See also** **setAutoMipMapGenerationEnabled** () and
        **generateMipMaps** ().
        """
        ...

    @overload
    def isBound(self) -> bool:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#isBound

        **bool QOpenGLTexture::isBound() const**

        Returns `true` if this texture is bound to the corresponding target of
        the currently active texture unit.

        **See also** **bind** () and **release** ().
        """
        ...

    @overload
    def isBound(self, unit: int) -> bool:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#isBound-1

        **bool QOpenGLTexture::isBound(uint unit )**

        Returns `true` if this texture is bound to the corresponding target of
        texture unit **unit**.

        **See also** **bind** () and **release** ().
        """
        ...

    def isCreated(self) -> bool:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#isCreated

        **bool QOpenGLTexture::isCreated() const**

        Returns `true` if the underlying OpenGL texture object has been created.

        **See also** **create** (), **destroy** (), and **textureId** ().
        """
        ...

    def isFixedSamplePositions(self) -> bool:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#isFixedSamplePositions

        **bool QOpenGLTexture::isFixedSamplePositions() const**

        Returns whether this texture uses a fixed pattern of multisample
        samples. If storage has not yet been allocated for this texture then
        this function returns the requested fixed sample position setting.

        For texture targets that do not support multisampling this will return
        `true`.

        **See also** **setFixedSamplePositions** () and **isStorageAllocated**
        ().
        """
        ...

    def isStorageAllocated(self) -> bool:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#isStorageAllocated

        **bool QOpenGLTexture::isStorageAllocated() const**

        Returns `true` if server-side storage for this texture as been
        allocated.

        The texture format, dimensions, mipmap levels and array layers cannot be
        altered once storage ihas been allocated.

        **See also** **allocateStorage** (), **setSize** (), **setMipLevels**
        (), **setLayers** (), and **setFormat** ().
        """
        ...

    def isTextureView(self) -> bool:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#isTextureView

        **bool QOpenGLTexture::isTextureView() const**

        Returns `true` if this texture object is actually a view onto another
        texture object.

        **See also** **createTextureView** ().
        """
        ...

    def layers(self) -> int:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#layers

        **int QOpenGLTexture::layers() const**

        Returns the number of array layers for this texture. If storage has not
        yet been allocated for this texture then this function returns the
        requested number of array layers.

        For texture targets that do not support array layers this will return 1.

        **See also** **setLayers** () and **isStorageAllocated** ().
        """
        ...

    def levelOfDetailRange(self) -> Tuple[float, float]:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#levelOfDetailRange

        **QPair<float, float> QOpenGLTexture::levelOfDetailRange() const**

        Returns the minimum and maximum level of detail parameters.

        **See also** **setLevelOfDetailRange** (), **minimumLevelOfDetail** (),
        and **maximumLevelOfDetail** ().
        """
        ...

    def levelofDetailBias(self) -> float:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#levelofDetailBias

        **float QOpenGLTexture::levelofDetailBias() const**

        Returns the level of detail bias parameter.

        **See also** **setLevelofDetailBias** ().
        """
        ...

    def magnificationFilter(self) -> PySide6.QtOpenGL.QOpenGLTexture.Filter:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#magnificationFilter

        **QOpenGLTexture::Filter QOpenGLTexture::magnificationFilter() const**

        Returns the magnification filter.

        **See also** **setMagnificationFilter** ().
        """
        ...

    def maximumAnisotropy(self) -> float:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#maximumAnisotropy

        **float QOpenGLTexture::maximumAnisotropy() const**

        Returns the maximum level of anisotropy to be accounted for when
        performing texture lookups. This requires the
        GL_EXT_texture_filter_anisotropic extension.

        **See also** **setMaximumAnisotropy** ().
        """
        ...

    def maximumLevelOfDetail(self) -> float:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#maximumLevelOfDetail

        **float QOpenGLTexture::maximumLevelOfDetail() const**

        Returns the maximum level of detail parameter.

        **See also** **setMaximumLevelOfDetail** (), **minimumLevelOfDetail**
        (), and **levelOfDetailRange** ().
        """
        ...

    def maximumMipLevels(self) -> int:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#maximumMipLevels

        **int QOpenGLTexture::maximumMipLevels() const**

        Returns the maximum number of mipmap levels that this texture can have
        given the current dimensions.

        **See also** **setMipLevels** (), **mipLevels** (), and **setSize** ().
        """
        ...

    def minMagFilters(
        self,
    ) -> Tuple[
        PySide6.QtOpenGL.QOpenGLTexture.Filter, PySide6.QtOpenGL.QOpenGLTexture.Filter
    ]:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#minMagFilters

        **QPair<QOpenGLTexture::Filter, QOpenGLTexture::Filter>
        QOpenGLTexture::minMagFilters() const**

        Returns the current minification and magnification filters.

        **See also** **setMinMagFilters** ().
        """
        ...

    def minificationFilter(self) -> PySide6.QtOpenGL.QOpenGLTexture.Filter:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#minificationFilter

        **QOpenGLTexture::Filter QOpenGLTexture::minificationFilter() const**

        Returns the minification filter.

        **See also** **setMinificationFilter** ().
        """
        ...

    def minimumLevelOfDetail(self) -> float:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#minimumLevelOfDetail

        **float QOpenGLTexture::minimumLevelOfDetail() const**

        Returns the minimum level of detail parameter.

        **See also** **setMinimumLevelOfDetail** (), **maximumLevelOfDetail**
        (), and **levelOfDetailRange** ().
        """
        ...

    def mipBaseLevel(self) -> int:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#mipBaseLevel

        **int QOpenGLTexture::mipBaseLevel() const**

        Returns the mipmap base level used for all texture lookups with this
        texture. The default is 0.

        **See also** **setMipBaseLevel** (), **mipMaxLevel** (), and
        **mipLevelRange** ().
        """
        ...

    def mipLevelRange(self) -> Tuple[int, int]:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#mipLevelRange

        **QPair<int, int> QOpenGLTexture::mipLevelRange() const**

        Returns the range of mipmap levels that can be used for texture lookups
        with this texture.

        **See also** **setMipLevelRange** (), **mipBaseLevel** (), and
        **mipMaxLevel** ().
        """
        ...

    def mipLevels(self) -> int:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#mipLevels

        **int QOpenGLTexture::mipLevels() const**

        Returns the number of mipmap levels for this texture. If storage has not
        yet been allocated for this texture it returns the requested number of
        mipmap levels.

        **See also** **setMipLevels** (), **maximumMipLevels** (), and
        **isStorageAllocated** ().
        """
        ...

    def mipMaxLevel(self) -> int:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#mipMaxLevel

        **int QOpenGLTexture::mipMaxLevel() const**

        Returns the mipmap maximum level used for all texture lookups with this
        texture.

        **See also** **setMipMaxLevel** (), **mipBaseLevel** (), and
        **mipLevelRange** ().
        """
        ...

    @overload
    def release(self) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#release

        **void QOpenGLTexture::release()**

        Unbinds this texture from the currently active texture unit.

        **See also** **bind** ().
        """
        ...

    @overload
    def release(
        self, unit: int, reset: PySide6.QtOpenGL.QOpenGLTexture.TextureUnitReset = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#release-1

        **void QOpenGLTexture::release(uint unit ,
        QOpenGLTexture::TextureUnitReset reset = DontResetTextureUnit)**

        Unbinds this texture from texture unit **unit**.

        If parameter **reset** is `true` then this function will restore the
        active unit to the texture unit that was active upon entry.
        """
        ...

    def samples(self) -> int:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#samples

        **int QOpenGLTexture::samples() const**

        Returns the number of multisample sample points for this texture. If
        storage has not yet been allocated for this texture then this function
        returns the requested number of samples.

        For texture targets that do not support multisampling this will return
        0.

        **See also** **setSamples** () and **isStorageAllocated** ().
        """
        ...

    def setAutoMipMapGenerationEnabled(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setAutoMipMapGenerationEnable
        d

        **void QOpenGLTexture::setAutoMipMapGenerationEnabled(bool enabled )**

        If **enabled** is `true`, enables automatic mipmap generation for this
        texture object to occur whenever the level 0 mipmap data is set via
        **setData** ().

        The automatic mipmap generation is enabled by default.

        **Note:** Mipmap generation is not supported for compressed textures
        with OpenGL ES 2.0.

        **See also** **isAutoMipMapGenerationEnabled** () and
        **generateMipMaps** ().
        """
        ...

    @overload
    def setBorderColor(
        self,
        color: Union[
            PySide6.QtGui.QColor,
            PySide6.QtGui.QRgba64,
            Any,
            PySide6.QtCore.Qt.GlobalColor,
            str,
            int,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setBorderColor

        **void QOpenGLTexture::setBorderColor(const QColor & color )**

        Sets the border color of the texture to **color**.

        **Note:** This function has no effect on Mac and Qt built for OpenGL ES
        2.

        **See also** **borderColor** ().
        """
        ...

    @overload
    def setBorderColor(self, r: float, g: float, b: float, a: float) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setBorderColor-1

        **void QOpenGLTexture::setBorderColor(float r , float g , float b ,
        float a )**

        Sets the color red to **r** , green to **g** , blue to **b** , and **a**
        to the alpha value.

        This is an overloaded function.
        """
        ...

    @overload
    def setBorderColor(self, r: int, g: int, b: int, a: int) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setBorderColor-2

        **void QOpenGLTexture::setBorderColor(int r , int g , int b , int a )**

        Sets the color red to **r** , green to **g** , blue to **b** , and the
        alpha value to **a**.

        This is an overloaded function.
        """
        ...

    @overload
    def setBorderColor(self, r: int, g: int, b: int, a: int) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setBorderColor-3

        **void QOpenGLTexture::setBorderColor(uint r , uint g , uint b , uint a
        )**

        Sets the color red to **r** , green to **g** , blue to **b** , and the
        alpha value to **a**.

        This is an overloaded function.
        """
        ...

    def setComparisonFunction(
        self, function: PySide6.QtOpenGL.QOpenGLTexture.ComparisonFunction
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setComparisonFunction

        **[since 5.5] void
        QOpenGLTexture::setComparisonFunction(QOpenGLTexture::ComparisonFunction
        function )**

        Sets the texture comparison function on this texture to **function**.
        The texture comparison function is used by shadow samplers when sampling
        a depth texture.

        This function was introduced in Qt 5.5.

        **See also** **comparisonFunction** ().
        """
        ...

    def setComparisonMode(
        self, mode: PySide6.QtOpenGL.QOpenGLTexture.ComparisonMode
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setComparisonMode

        **[since 5.5] void
        QOpenGLTexture::setComparisonMode(QOpenGLTexture::ComparisonMode mode
        )**

        Sets the texture comparison mode on this texture to **mode**. The
        texture comparison mode is used by shadow samplers when sampling a depth
        texture.

        This function was introduced in Qt 5.5.

        **See also** **comparisonMode** ().
        """
        ...

    @overload
    def setCompressedData(
        self,
        dataSize: int,
        data: int,
        options: Optional[PySide6.QtOpenGL.QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setCompressedData

        **[since 5.3] void QOpenGLTexture::setCompressedData(int mipLevel , int
        layer , QOpenGLTexture::CubeMapFace cubeFace , int dataSize , const void
        * data , const QOpenGLPixelTransferOptions *const options = nullptr)**

        Uploads compressed pixel **data** to **mipLevel** , array **layer** ,
        and **cubeFace**. The pixel transfer can optionally be controlled with
        **options**. The **dataSize** argument should specify the size of the
        data pointed to by **data**.

        If not using a compressed **format** () then you should use **setData**
        () instead of this function.

        This function was introduced in Qt 5.3.
        """
        ...

    @overload
    def setCompressedData(
        self,
        mipLevel: int,
        dataSize: int,
        data: int,
        options: Optional[PySide6.QtOpenGL.QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setCompressedData-1

        **[since 5.9] void QOpenGLTexture::setCompressedData(int mipLevel , int
        layer , int layerCount , QOpenGLTexture::CubeMapFace cubeFace , int
        dataSize , const void * data , const QOpenGLPixelTransferOptions *const
        options = nullptr)**

        This is an overloaded function.

        Parameter **layerCount** is the number of layers in a texture array that
        are being uploaded/populated by this call.

        This function was introduced in Qt 5.9.
        """
        ...

    @overload
    def setCompressedData(
        self,
        mipLevel: int,
        layer: int,
        cubeFace: PySide6.QtOpenGL.QOpenGLTexture.CubeMapFace,
        dataSize: int,
        data: int,
        options: Optional[PySide6.QtOpenGL.QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setCompressedData-2

        **void QOpenGLTexture::setCompressedData(int mipLevel , int layer , int
        dataSize , const void * data , const QOpenGLPixelTransferOptions *const
        options = nullptr)**

        This is an overloaded function.
        """
        ...

    @overload
    def setCompressedData(
        self,
        mipLevel: int,
        layer: int,
        dataSize: int,
        data: int,
        options: Optional[PySide6.QtOpenGL.QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setCompressedData-3

        **void QOpenGLTexture::setCompressedData(int mipLevel , int dataSize ,
        const void * data , const QOpenGLPixelTransferOptions *const options =
        nullptr)**

        This is an overloaded function.
        """
        ...

    @overload
    def setCompressedData(
        self,
        mipLevel: int,
        layer: int,
        layerCount: int,
        cubeFace: PySide6.QtOpenGL.QOpenGLTexture.CubeMapFace,
        dataSize: int,
        data: int,
        options: Optional[PySide6.QtOpenGL.QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setCompressedData-4

        **void QOpenGLTexture::setCompressedData(int dataSize , const void *
        data , const QOpenGLPixelTransferOptions *const options = nullptr)**

        This is an overloaded function.
        """
        ...

    @overload
    def setData(
        self,
        image: Union[PySide6.QtGui.QImage, str],
        genMipMaps: PySide6.QtOpenGL.QOpenGLTexture.MipMapGeneration = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setData

        **[since 5.3] void QOpenGLTexture::setData(int mipLevel , int layer ,
        QOpenGLTexture::CubeMapFace cubeFace , QOpenGLTexture::PixelFormat
        sourceFormat , QOpenGLTexture::PixelType sourceType , const void * data
        , const QOpenGLPixelTransferOptions *const options = nullptr)**

        Uploads pixel **data** for this texture object **mipLevel** , array
        **layer** , and **cubeFace**. Storage must have been allocated before
        uploading pixel data. Some overloads of setData() will set appropriate
        dimensions, mipmap levels, and array layers and then allocate storage
        for you if they have enough information to do so. This will be noted in
        the function documentation.

        The structure of the pixel data pointed to by **data** is specified by
        **sourceFormat** and **sourceType**. The pixel data upload can
        optionally be controlled by **options**.

        If using a compressed **format** () then you should use
        **setCompressedData** () instead of this function.

        This function was introduced in Qt 5.3.

        **See also** **setCompressedData** ().
        """
        ...

    @overload
    def setData(
        self,
        mipLevel: int,
        layer: int,
        cubeFace: PySide6.QtOpenGL.QOpenGLTexture.CubeMapFace,
        sourceFormat: PySide6.QtOpenGL.QOpenGLTexture.PixelFormat,
        sourceType: PySide6.QtOpenGL.QOpenGLTexture.PixelType,
        data: int,
        options: Optional[PySide6.QtOpenGL.QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setData-1

        **[since 5.9] void QOpenGLTexture::setData(int mipLevel , int layer ,
        int layerCount , QOpenGLTexture::CubeMapFace cubeFace ,
        QOpenGLTexture::PixelFormat sourceFormat , QOpenGLTexture::PixelType
        sourceType , const void * data , const QOpenGLPixelTransferOptions
        *const options = nullptr)**

        This is an overloaded function.

        Parameter **layerCount** is the number of layers in a texture array that
        are being uploaded/populated by this call.

        This function was introduced in Qt 5.9.
        """
        ...

    @overload
    def setData(
        self,
        mipLevel: int,
        layer: int,
        layerCount: int,
        cubeFace: PySide6.QtOpenGL.QOpenGLTexture.CubeMapFace,
        sourceFormat: PySide6.QtOpenGL.QOpenGLTexture.PixelFormat,
        sourceType: PySide6.QtOpenGL.QOpenGLTexture.PixelType,
        data: int,
        options: Optional[PySide6.QtOpenGL.QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setData-2

        **[since 5.3] void QOpenGLTexture::setData(int mipLevel , int layer ,
        QOpenGLTexture::PixelFormat sourceFormat , QOpenGLTexture::PixelType
        sourceType , const void * data , const QOpenGLPixelTransferOptions
        *const options = nullptr)**

        This is an overloaded function.

        This function was introduced in Qt 5.3.
        """
        ...

    @overload
    def setData(
        self,
        mipLevel: int,
        layer: int,
        sourceFormat: PySide6.QtOpenGL.QOpenGLTexture.PixelFormat,
        sourceType: PySide6.QtOpenGL.QOpenGLTexture.PixelType,
        data: int,
        options: Optional[PySide6.QtOpenGL.QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setData-3

        **[since 5.3] void QOpenGLTexture::setData(int mipLevel ,
        QOpenGLTexture::PixelFormat sourceFormat , QOpenGLTexture::PixelType
        sourceType , const void * data , const QOpenGLPixelTransferOptions
        *const options = nullptr)**

        This is an overloaded function.

        This function was introduced in Qt 5.3.
        """
        ...

    @overload
    def setData(
        self,
        mipLevel: int,
        sourceFormat: PySide6.QtOpenGL.QOpenGLTexture.PixelFormat,
        sourceType: PySide6.QtOpenGL.QOpenGLTexture.PixelType,
        data: int,
        options: Optional[PySide6.QtOpenGL.QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setData-4

        **[since 5.3] void QOpenGLTexture::setData(QOpenGLTexture::PixelFormat
        sourceFormat , QOpenGLTexture::PixelType sourceType , const void * data
        , const QOpenGLPixelTransferOptions *const options = nullptr)**

        This is an overloaded function.

        This function was introduced in Qt 5.3.
        """
        ...

    @overload
    def setData(
        self,
        sourceFormat: PySide6.QtOpenGL.QOpenGLTexture.PixelFormat,
        sourceType: PySide6.QtOpenGL.QOpenGLTexture.PixelType,
        data: int,
        options: Optional[PySide6.QtOpenGL.QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setData-5

        **[since 5.14] void QOpenGLTexture::setData(int xOffset , int yOffset ,
        int zOffset , int width , int height , int depth ,
        QOpenGLTexture::PixelFormat sourceFormat , QOpenGLTexture::PixelType
        sourceType , const void * data , const QOpenGLPixelTransferOptions
        *const options = nullptr)**

        This is an overloaded function.

        This overload is to be used to update a part of the texture. Parameters
        **xOffset** , **yOffset** , **zOffset** specify the texel offsets within
        the texture. Parameters **width** , **height** and **depth** specify the
        dimensions of the sub image.

        The structure of the pixel data pointed to by **data** is specified by
        **sourceFormat** and **sourceType**. The pixel data upload can
        optionally be controlled by **options**.

        This function was introduced in Qt 5.14.
        """
        ...

    @overload
    def setData(
        self,
        xOffset: int,
        yOffset: int,
        zOffset: int,
        width: int,
        height: int,
        depth: int,
        mipLevel: int,
        layer: int,
        cubeFace: PySide6.QtOpenGL.QOpenGLTexture.CubeMapFace,
        layerCount: int,
        sourceFormat: PySide6.QtOpenGL.QOpenGLTexture.PixelFormat,
        sourceType: PySide6.QtOpenGL.QOpenGLTexture.PixelType,
        data: int,
        options: Optional[PySide6.QtOpenGL.QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setData-6

        **[since 5.14] void QOpenGLTexture::setData(int xOffset , int yOffset ,
        int zOffset , int width , int height , int depth , int mipLevel ,
        QOpenGLTexture::PixelFormat sourceFormat , QOpenGLTexture::PixelType
        sourceType , const void * data , const QOpenGLPixelTransferOptions
        *const options = nullptr)**

        This is an overloaded function.

        This overload is to be used to update a part of the texture. Parameters
        **xOffset** , **yOffset** , **zOffset** specify the texel offsets within
        the texture. Parameters **width** , **height** and **depth** specify the
        dimensions of the sub image. The mip map level the sub image we want to
        update is specified with **mipLevel**.

        The structure of the pixel data pointed to by **data** is specified by
        **sourceFormat** and **sourceType**. The pixel data upload can
        optionally be controlled by **options**.

        This function was introduced in Qt 5.14.
        """
        ...

    @overload
    def setData(
        self,
        xOffset: int,
        yOffset: int,
        zOffset: int,
        width: int,
        height: int,
        depth: int,
        mipLevel: int,
        layer: int,
        cubeFace: PySide6.QtOpenGL.QOpenGLTexture.CubeMapFace,
        sourceFormat: PySide6.QtOpenGL.QOpenGLTexture.PixelFormat,
        sourceType: PySide6.QtOpenGL.QOpenGLTexture.PixelType,
        data: int,
        options: Optional[PySide6.QtOpenGL.QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setData-7

        **[since 5.14] void QOpenGLTexture::setData(int xOffset , int yOffset ,
        int zOffset , int width , int height , int depth , int mipLevel , int
        layer , QOpenGLTexture::PixelFormat sourceFormat ,
        QOpenGLTexture::PixelType sourceType , const void * data , const
        QOpenGLPixelTransferOptions *const options = nullptr)**

        This is an overloaded function.

        This overload is to be used to update a part of the texture. Parameters
        **xOffset** , **yOffset** , **zOffset** specify the texel offsets within
        the texture. Parameters **width** , **height** and **depth** specify the
        dimensions of the sub image. The mip map level and layerof the sub image
        we want to update are specified with **mipLevel** and **layer**.

        The structure of the pixel data pointed to by **data** is specified by
        **sourceFormat** and **sourceType**. The pixel data upload can
        optionally be controlled by **options**.

        This function was introduced in Qt 5.14.
        """
        ...

    @overload
    def setData(
        self,
        xOffset: int,
        yOffset: int,
        zOffset: int,
        width: int,
        height: int,
        depth: int,
        mipLevel: int,
        layer: int,
        sourceFormat: PySide6.QtOpenGL.QOpenGLTexture.PixelFormat,
        sourceType: PySide6.QtOpenGL.QOpenGLTexture.PixelType,
        data: int,
        options: Optional[PySide6.QtOpenGL.QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setData-8

        **[since 5.14] void QOpenGLTexture::setData(int xOffset , int yOffset ,
        int zOffset , int width , int height , int depth , int mipLevel , int
        layer , QOpenGLTexture::CubeMapFace face , QOpenGLTexture::PixelFormat
        sourceFormat , QOpenGLTexture::PixelType sourceType , const void * data
        , const QOpenGLPixelTransferOptions *const options = nullptr)**

        This is an overloaded function.

        This overload is to be used to update a part of the texture. Parameters
        **xOffset** , **yOffset** , **zOffset** specify the texel offsets within
        the texture. Parameters **width** , **height** and **depth** specify the
        dimensions of the sub image.The mip map level, layer and cube map face
        of the sub image we want to update are specified with **mipLevel** ,
        **layer** and **face**.

        The structure of the pixel data pointed to by **data** is specified by
        **sourceFormat** and **sourceType**. The pixel data upload can
        optionally be controlled by **options**.

        This function was introduced in Qt 5.14.
        """
        ...

    @overload
    def setData(
        self,
        xOffset: int,
        yOffset: int,
        zOffset: int,
        width: int,
        height: int,
        depth: int,
        mipLevel: int,
        sourceFormat: PySide6.QtOpenGL.QOpenGLTexture.PixelFormat,
        sourceType: PySide6.QtOpenGL.QOpenGLTexture.PixelType,
        data: int,
        options: Optional[PySide6.QtOpenGL.QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setData-9

        **[since 5.14] void QOpenGLTexture::setData(int xOffset , int yOffset ,
        int zOffset , int width , int height , int depth , int mipLevel , int
        layer , QOpenGLTexture::CubeMapFace face , int layerCount ,
        QOpenGLTexture::PixelFormat sourceFormat , QOpenGLTexture::PixelType
        sourceType , const void * data , const QOpenGLPixelTransferOptions
        *const options = nullptr)**

        This is an overloaded function.

        This overload is to be used to update a part of the texture. Parameters
        **xOffset** , **yOffset** , **zOffset** specify the texel offsets within
        the texture. Parameters **width** , **height** and **depth** specify the
        dimensions of the sub image.The mip map level, starting layer, cube map
        face and number of layers of the sub image we want to update are
        specified with **mipLevel** , **layer** , **face** and **layerCount**.

        The structure of the pixel data pointed to by **data** is specified by
        **sourceFormat** and **sourceType**. The pixel data upload can
        optionally be controlled by **options**.

        This function was introduced in Qt 5.14.
        """
        ...

    @overload
    def setData(
        self,
        xOffset: int,
        yOffset: int,
        zOffset: int,
        width: int,
        height: int,
        depth: int,
        sourceFormat: PySide6.QtOpenGL.QOpenGLTexture.PixelFormat,
        sourceType: PySide6.QtOpenGL.QOpenGLTexture.PixelType,
        data: int,
        options: Optional[PySide6.QtOpenGL.QOpenGLPixelTransferOptions] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setData-10

        **void QOpenGLTexture::setData(const QImage & image ,
        QOpenGLTexture::MipMapGeneration genMipMaps = GenerateMipMaps)**

        This overload of setData() will allocate storage for you. The pixel data
        is contained in **image**. Mipmaps are generated by default. Set
        **genMipMaps** to **DontGenerateMipMaps**  to turn off mipmap
        generation.

        This is an overloaded function.
        """
        ...

    def setDepthStencilMode(
        self, mode: PySide6.QtOpenGL.QOpenGLTexture.DepthStencilMode
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setDepthStencilMode

        **[since 5.4] void
        QOpenGLTexture::setDepthStencilMode(QOpenGLTexture::DepthStencilMode
        mode )**

        If using a texture that has a combined depth/stencil format this
        function sets which component of the texture is accessed to **mode**.

        When the parameter is set to **DepthMode** , then accessing it from the
        shader will access the depth component as a single float, as normal. But
        when the parameter is set to **StencilMode** , the shader will access
        the stencil component.

        **Note:** This function has no effect on Mac and Qt built for OpenGL ES
        2.

        This function was introduced in Qt 5.4.

        **See also** **depthStencilMode** ().
        """
        ...

    def setFixedSamplePositions(self, fixed: bool) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setFixedSamplePositions

        **void QOpenGLTexture::setFixedSamplePositions(bool fixed )**

        Sets whether the sample positions and number of samples used with a
        multisample capable texture target to **fixed**. If set to `true` the
        sample positions and number of samples used are the same for all texels
        in the image and will not depend upon the image size or internal format.
        This function should be called before storage is allocated for the
        texture.

        For targets that do not support multisampling this function has no
        effect.

        The default value is `true`.

        **See also** **isFixedSamplePositions** () and **isStorageAllocated**
        ().
        """
        ...

    def setFormat(self, format: PySide6.QtOpenGL.QOpenGLTexture.TextureFormat) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setFormat

        **void QOpenGLTexture::setFormat(QOpenGLTexture::TextureFormat format
        )**

        Sets the format of this texture object to **format**. This function must
        be called before texture storage is allocated.

        Note that all formats may not be supported. The exact set of supported
        formats is dependent upon your OpenGL implementation and version.

        **See also** **format** () and **allocateStorage** ().
        """
        ...

    def setLayers(self, layers: int) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setLayers

        **void QOpenGLTexture::setLayers(int layers )**

        Sets the number of array **layers** to allocate storage for. This
        function should be called before storage is allocated for the texture.

        For targets that do not support array layers this function has no
        effect.

        **See also** **layers** () and **isStorageAllocated** ().
        """
        ...

    def setLevelOfDetailRange(self, min: float, max: float) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setLevelOfDetailRange

        **void QOpenGLTexture::setLevelOfDetailRange(float min , float max )**

        Sets the minimum level of detail parameters to **min** and the maximum
        level to **max**.

        **Note:** This function has no effect on Qt built for OpenGL ES 2.

        **See also** **levelOfDetailRange** (), **setMinimumLevelOfDetail** (),
        and **setMaximumLevelOfDetail** ().
        """
        ...

    def setLevelofDetailBias(self, bias: float) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setLevelofDetailBias

        **void QOpenGLTexture::setLevelofDetailBias(float bias )**

        Sets the level of detail bias to **bias**. Level of detail bias affects
        the point at which mipmapping levels change. Increasing values for level
        of detail bias makes the overall images blurrier or smoother. Decreasing
        values make the overall images sharper.

        **Note:** This function has no effect on Qt built for OpenGL ES 2.

        **See also** **levelofDetailBias** ().
        """
        ...

    def setMagnificationFilter(
        self, filter: PySide6.QtOpenGL.QOpenGLTexture.Filter
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setMagnificationFilter

        **void QOpenGLTexture::setMagnificationFilter(QOpenGLTexture::Filter
        filter )**

        Sets the magnification filter to **filter**.

        **See also** **magnificationFilter** (), **setMinificationFilter** (),
        and **setMinMagFilters** ().
        """
        ...

    def setMaximumAnisotropy(self, anisotropy: float) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setMaximumAnisotropy

        **void QOpenGLTexture::setMaximumAnisotropy(float anisotropy )**

        If your OpenGL implementation supports the
        GL_EXT_texture_filter_anisotropic extension this function sets the
        maximum anisotropy level to **anisotropy**.

        **See also** **maximumAnisotropy** ().
        """
        ...

    def setMaximumLevelOfDetail(self, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setMaximumLevelOfDetail

        **void QOpenGLTexture::setMaximumLevelOfDetail(float value )**

        Sets the maximum level of detail to **value**. This limits the selection
        of lowest resolution mipmap (highest mipmap level). The default value is
        1000.

        **Note:** This function has no effect on Qt built for OpenGL ES 2.

        **See also** **maximumLevelOfDetail** (), **setMinimumLevelOfDetail**
        (), and **setLevelOfDetailRange** ().
        """
        ...

    def setMinMagFilters(
        self,
        minificationFilter: PySide6.QtOpenGL.QOpenGLTexture.Filter,
        magnificationFilter: PySide6.QtOpenGL.QOpenGLTexture.Filter,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setMinMagFilters

        **void QOpenGLTexture::setMinMagFilters(QOpenGLTexture::Filter
        minificationFilter , QOpenGLTexture::Filter magnificationFilter )**

        Sets the minification filter to **minificationFilter** and the
        magnification filter to **magnificationFilter**.

        **See also** **minMagFilters** (), **setMinificationFilter** (), and
        **setMagnificationFilter** ().
        """
        ...

    def setMinificationFilter(
        self, filter: PySide6.QtOpenGL.QOpenGLTexture.Filter
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setMinificationFilter

        **void QOpenGLTexture::setMinificationFilter(QOpenGLTexture::Filter
        filter )**

        Sets the filter used for minification to **filter**.

        **See also** **minificationFilter** (), **setMagnificationFilter** (),
        and **setMinMagFilters** ().
        """
        ...

    def setMinimumLevelOfDetail(self, value: float) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setMinimumLevelOfDetail

        **void QOpenGLTexture::setMinimumLevelOfDetail(float value )**

        Sets the minimum level of detail to **value**. This limits the selection
        of highest resolution mipmap (lowest mipmap level). The default value is
        -1000.

        **Note:** This function has no effect on Qt built for OpenGL ES 2.

        **See also** **minimumLevelOfDetail** (), **setMaximumLevelOfDetail**
        (), and **setLevelOfDetailRange** ().
        """
        ...

    def setMipBaseLevel(self, baseLevel: int) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setMipBaseLevel

        **void QOpenGLTexture::setMipBaseLevel(int baseLevel )**

        Sets the base mipmap level used for all texture lookups with this
        texture to **baseLevel**.

        **Note:** This function has no effect on Qt built for OpenGL ES 2.

        **See also** **mipBaseLevel** (), **setMipMaxLevel** (), and
        **setMipLevelRange** ().
        """
        ...

    def setMipLevelRange(self, baseLevel: int, maxLevel: int) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setMipLevelRange

        **void QOpenGLTexture::setMipLevelRange(int baseLevel , int maxLevel )**

        Sets the range of mipmap levels that can be used for texture lookups
        with this texture to range from **baseLevel** to **maxLevel**.

        **Note:** This function has no effect on Qt built for OpenGL ES 2.

        **See also** **setMipBaseLevel** (), **setMipMaxLevel** (), and
        **mipLevelRange** ().
        """
        ...

    def setMipLevels(self, levels: int) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setMipLevels

        **void QOpenGLTexture::setMipLevels(int levels )**

        For texture targets that support mipmaps, this function sets the
        requested number of mipmap **levels** to allocate storage for. This
        function should be called before storage is allocated for the texture.

        If the texture target does not support mipmaps this function has no
        effect.

        **See also** **mipLevels** (), **maximumMipLevels** (), and
        **isStorageAllocated** ().
        """
        ...

    def setMipMaxLevel(self, maxLevel: int) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setMipMaxLevel

        **void QOpenGLTexture::setMipMaxLevel(int maxLevel )**

        Sets the maximum mipmap level used for all texture lookups with this
        texture to **maxLevel**.

        **Note:** This function has no effect on Qt built for OpenGL ES 2.

        **See also** **mipMaxLevel** (), **setMipBaseLevel** (), and
        **setMipLevelRange** ().
        """
        ...

    def setSamples(self, samples: int) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setSamples

        **void QOpenGLTexture::setSamples(int samples )**

        Sets the number of **samples** to allocate storage for when rendering to
        a multisample capable texture target. This function should be called
        before storage is allocated for the texture.

        For targets that do not support multisampling this function has no
        effect.

        **See also** **samples** () and **isStorageAllocated** ().
        """
        ...

    def setSize(self, width: int, height: int = ..., depth: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setSize

        **void QOpenGLTexture::setSize(int width , int height = 1, int depth =
        1)**

        Sets the dimensions of this texture object to **width** , **height** ,
        and **depth**. The default for each dimension is 1. The maximum
        allowable texture size is dependent upon your OpenGL implementation.
        Allocating storage for a texture less than the maximum size can still
        fail if your system is low on resources.

        If a non-power-of-two **width** , **height** or **depth** is provided
        and your OpenGL implementation doesn't have support for repeating non-
        power-of-two textures, then the wrap mode is automatically set to
        **ClampToEdge** .

        **See also** **width** (), **height** (), and **depth** ().
        """
        ...

    @overload
    def setSwizzleMask(
        self,
        component: PySide6.QtOpenGL.QOpenGLTexture.SwizzleComponent,
        value: PySide6.QtOpenGL.QOpenGLTexture.SwizzleValue,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setSwizzleMask

        **void QOpenGLTexture::setSwizzleMask(QOpenGLTexture::SwizzleComponent
        component , QOpenGLTexture::SwizzleValue value )**

        GLSL shaders are able to reorder the components of the vec4 returned by
        texture functions. It is also desirable to be able to control this
        reordering from CPU side code. This is made possible by swizzle masks
        since OpenGL 3.3.

        Each component of the texture can be mapped to one of the
        **SwizzleValue**  options.

        This function maps **component** to the output **value**.

        **Note:** This function has no effect on Mac and Qt built for OpenGL ES
        2.

        **See also** **swizzleMask** ().
        """
        ...

    @overload
    def setSwizzleMask(
        self,
        r: PySide6.QtOpenGL.QOpenGLTexture.SwizzleValue,
        g: PySide6.QtOpenGL.QOpenGLTexture.SwizzleValue,
        b: PySide6.QtOpenGL.QOpenGLTexture.SwizzleValue,
        a: PySide6.QtOpenGL.QOpenGLTexture.SwizzleValue,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setSwizzleMask-1

        **void QOpenGLTexture::setSwizzleMask(QOpenGLTexture::SwizzleValue r ,
        QOpenGLTexture::SwizzleValue g , QOpenGLTexture::SwizzleValue b ,
        QOpenGLTexture::SwizzleValue a )**

        Parameters **r** , **g** , **b** , and **a** are values used for setting
        the colors red, green, blue, and the alpha value.

        This is an overloaded function.
        """
        ...

    @overload
    def setWrapMode(
        self,
        direction: PySide6.QtOpenGL.QOpenGLTexture.CoordinateDirection,
        mode: PySide6.QtOpenGL.QOpenGLTexture.WrapMode,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setWrapMode

        **void QOpenGLTexture::setWrapMode(QOpenGLTexture::WrapMode mode )**

        Sets the wrap (or repeat mode) for all texture dimentions to **mode**.

        **See also** **wrapMode** ().
        """
        ...

    @overload
    def setWrapMode(self, mode: PySide6.QtOpenGL.QOpenGLTexture.WrapMode) -> None:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#setWrapMode-1

        **void QOpenGLTexture::setWrapMode(QOpenGLTexture::CoordinateDirection
        direction , QOpenGLTexture::WrapMode mode )**

        Holds the texture dimension **direction**.

        This is an overloaded function.
        """
        ...

    def swizzleMask(
        self, component: PySide6.QtOpenGL.QOpenGLTexture.SwizzleComponent
    ) -> PySide6.QtOpenGL.QOpenGLTexture.SwizzleValue:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#swizzleMask

        **QOpenGLTexture::SwizzleValue
        QOpenGLTexture::swizzleMask(QOpenGLTexture::SwizzleComponent component )
        const**

        Returns the swizzle mask for texture **component**.

        **See also** **setSwizzleMask** ().
        """
        ...

    def target(self) -> PySide6.QtOpenGL.QOpenGLTexture.Target:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#target

        **[since 5.4] QOpenGLTexture::Target QOpenGLTexture::target() const**

        Returns the binding target of this texture.

        This function was introduced in Qt 5.4.
        """
        ...

    def textureId(self) -> int:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#textureId

        **GLuint QOpenGLTexture::textureId() const**

        Returns the name of the underlying OpenGL texture object or 0 if it has
        not yet been created.

        **See also** **create** (), **destroy** (), and **isCreated** ().
        """
        ...

    def width(self) -> int:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#width

        **int QOpenGLTexture::width() const**

        Returns the width of a 1D, 2D or 3D texture.

        **See also** **height** (), **depth** (), and **setSize** ().
        """
        ...

    def wrapMode(
        self, direction: PySide6.QtOpenGL.QOpenGLTexture.CoordinateDirection
    ) -> PySide6.QtOpenGL.QOpenGLTexture.WrapMode:
        """
        https://doc.qt.io/qt-6/qopengltexture.html#wrapMode

        **QOpenGLTexture::WrapMode
        QOpenGLTexture::wrapMode(QOpenGLTexture::CoordinateDirection direction )
        const**

        Returns the wrap mode for the texture dimension **direction**.

        **See also** **setWrapMode** ().
        """
        ...
