"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtOpenGL, except for defaults which are replaced by "...".
"""
from typing import Sequence, Tuple
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtOpenGL

bytes = str


class QOpenGLFunctions_4_5_Core(PySide6.QtOpenGL.QAbstractOpenGLFunctions):
    """
    https://doc.qt.io/qt-6/qopenglfunctions-4-5-core.html

    **Detailed Description**

    This class is a wrapper for functions from OpenGL 4.5 core profile. See
    reference pages on **opengl.org**  for function documentation.

    **See also** **QAbstractOpenGLFunctions** .
    """

    def __init__(self) -> None:
        ...

    def glActiveShaderProgram(self, pipeline: int, program: int) -> None:
        ...

    def glActiveTexture(self, texture: int) -> None:
        ...

    def glAttachShader(self, program: int, shader: int) -> None:
        ...

    def glBeginConditionalRender(self, id: int, mode: int) -> None:
        ...

    def glBeginQuery(self, target: int, id: int) -> None:
        ...

    def glBeginQueryIndexed(self, target: int, index: int, id: int) -> None:
        ...

    def glBeginTransformFeedback(self, primitiveMode: int) -> None:
        ...

    def glBindAttribLocation(self, program: int, index: int, name: bytes) -> None:
        ...

    def glBindBuffer(self, target: int, buffer: int) -> None:
        ...

    def glBindBufferBase(self, target: int, index: int, buffer: int) -> None:
        ...

    def glBindBuffersBase(
        self, target: int, first: int, count: int, buffers: Sequence[int]
    ) -> None:
        ...

    def glBindBuffersRange(
        self, target: int, first: int, count: int
    ) -> Tuple[int, int, int]:
        ...

    def glBindFragDataLocation(self, program: int, color: int, name: bytes) -> None:
        ...

    def glBindFragDataLocationIndexed(
        self, program: int, colorNumber: int, index: int, name: bytes
    ) -> None:
        ...

    def glBindFramebuffer(self, target: int, framebuffer: int) -> None:
        ...

    def glBindImageTexture(
        self,
        unit: int,
        texture: int,
        level: int,
        layered: int,
        layer: int,
        access: int,
        format: int,
    ) -> None:
        ...

    def glBindImageTextures(
        self, first: int, count: int, textures: Sequence[int]
    ) -> None:
        ...

    def glBindProgramPipeline(self, pipeline: int) -> None:
        ...

    def glBindRenderbuffer(self, target: int, renderbuffer: int) -> None:
        ...

    def glBindSampler(self, unit: int, sampler: int) -> None:
        ...

    def glBindSamplers(self, first: int, count: int, samplers: Sequence[int]) -> None:
        ...

    def glBindTexture(self, target: int, texture: int) -> None:
        ...

    def glBindTextureUnit(self, unit: int, texture: int) -> None:
        ...

    def glBindTextures(self, first: int, count: int, textures: Sequence[int]) -> None:
        ...

    def glBindTransformFeedback(self, target: int, id: int) -> None:
        ...

    def glBindVertexArray(self, array: int) -> None:
        ...

    def glBindVertexBuffers(self, first: int, count: int) -> Tuple[int, int, int]:
        ...

    def glBlendColor(self, red: float, green: float, blue: float, alpha: float) -> None:
        ...

    def glBlendEquation(self, mode: int) -> None:
        ...

    def glBlendEquationSeparate(self, modeRGB: int, modeAlpha: int) -> None:
        ...

    def glBlendEquationSeparatei(self, buf: int, modeRGB: int, modeAlpha: int) -> None:
        ...

    def glBlendEquationi(self, buf: int, mode: int) -> None:
        ...

    def glBlendFunc(self, sfactor: int, dfactor: int) -> None:
        ...

    def glBlendFuncSeparate(
        self, sfactorRGB: int, dfactorRGB: int, sfactorAlpha: int, dfactorAlpha: int
    ) -> None:
        ...

    def glBlendFuncSeparatei(
        self, buf: int, srcRGB: int, dstRGB: int, srcAlpha: int, dstAlpha: int
    ) -> None:
        ...

    def glBlendFunci(self, buf: int, src: int, dst: int) -> None:
        ...

    def glBlitFramebuffer(
        self,
        srcX0: int,
        srcY0: int,
        srcX1: int,
        srcY1: int,
        dstX0: int,
        dstY0: int,
        dstX1: int,
        dstY1: int,
        mask: int,
        filter: int,
    ) -> None:
        ...

    def glBlitNamedFramebuffer(
        self,
        readFramebuffer: int,
        drawFramebuffer: int,
        srcX0: int,
        srcY0: int,
        srcX1: int,
        srcY1: int,
        dstX0: int,
        dstY0: int,
        dstX1: int,
        dstY1: int,
        mask: int,
        filter: int,
    ) -> None:
        ...

    def glCheckFramebufferStatus(self, target: int) -> int:
        ...

    def glCheckNamedFramebufferStatus(self, framebuffer: int, target: int) -> int:
        ...

    def glClampColor(self, target: int, clamp: int) -> None:
        ...

    def glClear(self, mask: int) -> None:
        ...

    def glClearBufferData(
        self, target: int, internalformat: int, format: int, type: int, data: int
    ) -> None:
        ...

    def glClearBufferfi(
        self, buffer: int, drawbuffer: int, depth: float, stencil: int
    ) -> None:
        ...

    def glClearBufferfv(
        self, buffer: int, drawbuffer: int, value: Sequence[float]
    ) -> None:
        ...

    def glClearBufferiv(
        self, buffer: int, drawbuffer: int, value: Sequence[int]
    ) -> None:
        ...

    def glClearBufferuiv(
        self, buffer: int, drawbuffer: int, value: Sequence[int]
    ) -> None:
        ...

    def glClearColor(self, red: float, green: float, blue: float, alpha: float) -> None:
        ...

    def glClearDepth(self, depth: float) -> None:
        ...

    def glClearDepthf(self, dd: float) -> None:
        ...

    def glClearNamedBufferData(
        self, buffer: int, internalformat: int, format: int, type: int, data: int
    ) -> None:
        ...

    def glClearNamedFramebufferfi(
        self, framebuffer: int, buffer: int, depth: float, stencil: int
    ) -> None:
        ...

    def glClearNamedFramebufferfv(
        self, framebuffer: int, buffer: int, drawbuffer: int, value: Sequence[float]
    ) -> None:
        ...

    def glClearNamedFramebufferiv(
        self, framebuffer: int, buffer: int, drawbuffer: int, value: Sequence[int]
    ) -> None:
        ...

    def glClearNamedFramebufferuiv(
        self, framebuffer: int, buffer: int, drawbuffer: int, value: Sequence[int]
    ) -> None:
        ...

    def glClearStencil(self, s: int) -> None:
        ...

    def glClearTexImage(
        self, texture: int, level: int, format: int, type: int, data: int
    ) -> None:
        ...

    def glClearTexSubImage(
        self,
        texture: int,
        level: int,
        xoffset: int,
        yoffset: int,
        zoffset: int,
        width: int,
        height: int,
        depth: int,
        format: int,
        type: int,
        data: int,
    ) -> None:
        ...

    def glClipControl(self, origin: int, depth: int) -> None:
        ...

    def glColorMask(self, red: int, green: int, blue: int, alpha: int) -> None:
        ...

    def glColorMaski(self, index: int, r: int, g: int, b: int, a: int) -> None:
        ...

    def glCompileShader(self, shader: int) -> None:
        ...

    def glCompressedTexImage1D(
        self,
        target: int,
        level: int,
        internalformat: int,
        width: int,
        border: int,
        imageSize: int,
        data: int,
    ) -> None:
        ...

    def glCompressedTexImage2D(
        self,
        target: int,
        level: int,
        internalformat: int,
        width: int,
        height: int,
        border: int,
        imageSize: int,
        data: int,
    ) -> None:
        ...

    def glCompressedTexImage3D(
        self,
        target: int,
        level: int,
        internalformat: int,
        width: int,
        height: int,
        depth: int,
        border: int,
        imageSize: int,
        data: int,
    ) -> None:
        ...

    def glCompressedTexSubImage1D(
        self,
        target: int,
        level: int,
        xoffset: int,
        width: int,
        format: int,
        imageSize: int,
        data: int,
    ) -> None:
        ...

    def glCompressedTexSubImage2D(
        self,
        target: int,
        level: int,
        xoffset: int,
        yoffset: int,
        width: int,
        height: int,
        format: int,
        imageSize: int,
        data: int,
    ) -> None:
        ...

    def glCompressedTexSubImage3D(
        self,
        target: int,
        level: int,
        xoffset: int,
        yoffset: int,
        zoffset: int,
        width: int,
        height: int,
        depth: int,
        format: int,
        imageSize: int,
        data: int,
    ) -> None:
        ...

    def glCompressedTextureSubImage1D(
        self,
        texture: int,
        level: int,
        xoffset: int,
        width: int,
        format: int,
        imageSize: int,
        data: int,
    ) -> None:
        ...

    def glCompressedTextureSubImage2D(
        self,
        texture: int,
        level: int,
        xoffset: int,
        yoffset: int,
        width: int,
        height: int,
        format: int,
        imageSize: int,
        data: int,
    ) -> None:
        ...

    def glCompressedTextureSubImage3D(
        self,
        texture: int,
        level: int,
        xoffset: int,
        yoffset: int,
        zoffset: int,
        width: int,
        height: int,
        depth: int,
        format: int,
        imageSize: int,
        data: int,
    ) -> None:
        ...

    def glCopyImageSubData(
        self,
        srcName: int,
        srcTarget: int,
        srcLevel: int,
        srcX: int,
        srcY: int,
        srcZ: int,
        dstName: int,
        dstTarget: int,
        dstLevel: int,
        dstX: int,
        dstY: int,
        dstZ: int,
        srcWidth: int,
        srcHeight: int,
        srcDepth: int,
    ) -> None:
        ...

    def glCopyTexImage1D(
        self,
        target: int,
        level: int,
        internalformat: int,
        x: int,
        y: int,
        width: int,
        border: int,
    ) -> None:
        ...

    def glCopyTexImage2D(
        self,
        target: int,
        level: int,
        internalformat: int,
        x: int,
        y: int,
        width: int,
        height: int,
        border: int,
    ) -> None:
        ...

    def glCopyTexSubImage1D(
        self, target: int, level: int, xoffset: int, x: int, y: int, width: int
    ) -> None:
        ...

    def glCopyTexSubImage2D(
        self,
        target: int,
        level: int,
        xoffset: int,
        yoffset: int,
        x: int,
        y: int,
        width: int,
        height: int,
    ) -> None:
        ...

    def glCopyTexSubImage3D(
        self,
        target: int,
        level: int,
        xoffset: int,
        yoffset: int,
        zoffset: int,
        x: int,
        y: int,
        width: int,
        height: int,
    ) -> None:
        ...

    def glCopyTextureSubImage1D(
        self, texture: int, level: int, xoffset: int, x: int, y: int, width: int
    ) -> None:
        ...

    def glCopyTextureSubImage2D(
        self,
        texture: int,
        level: int,
        xoffset: int,
        yoffset: int,
        x: int,
        y: int,
        width: int,
        height: int,
    ) -> None:
        ...

    def glCopyTextureSubImage3D(
        self,
        texture: int,
        level: int,
        xoffset: int,
        yoffset: int,
        zoffset: int,
        x: int,
        y: int,
        width: int,
        height: int,
    ) -> None:
        ...

    def glCreateProgram(self) -> int:
        ...

    def glCreateShader(self, type: int) -> int:
        ...

    def glCullFace(self, mode: int) -> None:
        ...

    def glDebugMessageControl(
        self,
        source: int,
        type: int,
        severity: int,
        count: int,
        ids: Sequence[int],
        enabled: int,
    ) -> None:
        ...

    def glDebugMessageInsert(
        self, source: int, type: int, id: int, severity: int, length: int, buf: bytes
    ) -> None:
        ...

    def glDeleteBuffers(self, n: int, buffers: Sequence[int]) -> None:
        ...

    def glDeleteFramebuffers(self, n: int, framebuffers: Sequence[int]) -> None:
        ...

    def glDeleteProgram(self, program: int) -> None:
        ...

    def glDeleteProgramPipelines(self, n: int, pipelines: Sequence[int]) -> None:
        ...

    def glDeleteQueries(self, n: int, ids: Sequence[int]) -> None:
        ...

    def glDeleteRenderbuffers(self, n: int, renderbuffers: Sequence[int]) -> None:
        ...

    def glDeleteSamplers(self, count: int, samplers: Sequence[int]) -> None:
        ...

    def glDeleteShader(self, shader: int) -> None:
        ...

    def glDeleteTextures(self, n: int, textures: Sequence[int]) -> None:
        ...

    def glDeleteTransformFeedbacks(self, n: int, ids: Sequence[int]) -> None:
        ...

    def glDeleteVertexArrays(self, n: int, arrays: Sequence[int]) -> None:
        ...

    def glDepthFunc(self, func: int) -> None:
        ...

    def glDepthMask(self, flag: int) -> None:
        ...

    def glDepthRange(self, nearVal: float, farVal: float) -> None:
        ...

    def glDepthRangeArrayv(self, first: int, count: int, v: Sequence[float]) -> None:
        ...

    def glDepthRangeIndexed(self, index: int, n: float, f: float) -> None:
        ...

    def glDepthRangef(self, n: float, f: float) -> None:
        ...

    def glDetachShader(self, program: int, shader: int) -> None:
        ...

    def glDisable(self, cap: int) -> None:
        ...

    def glDisableVertexArrayAttrib(self, vaobj: int, index: int) -> None:
        ...

    def glDisableVertexAttribArray(self, index: int) -> None:
        ...

    def glDisablei(self, target: int, index: int) -> None:
        ...

    def glDispatchCompute(
        self, num_groups_x: int, num_groups_y: int, num_groups_z: int
    ) -> None:
        ...

    def glDrawArrays(self, mode: int, first: int, count: int) -> None:
        ...

    def glDrawArraysIndirect(self, mode: int, indirect: int) -> None:
        ...

    def glDrawArraysInstanced(
        self, mode: int, first: int, count: int, instancecount: int
    ) -> None:
        ...

    def glDrawArraysInstancedBaseInstance(
        self, mode: int, first: int, count: int, instancecount: int, baseinstance: int
    ) -> None:
        ...

    def glDrawBuffer(self, buf: int) -> None:
        ...

    def glDrawBuffers(self, n: int, bufs: Sequence[int]) -> None:
        ...

    def glDrawElements(self, mode: int, count: int, type: int, indices: int) -> None:
        ...

    def glDrawElementsBaseVertex(
        self, mode: int, count: int, type: int, indices: int, basevertex: int
    ) -> None:
        ...

    def glDrawElementsIndirect(self, mode: int, type: int, indirect: int) -> None:
        ...

    def glDrawElementsInstanced(
        self, mode: int, count: int, type: int, indices: int, instancecount: int
    ) -> None:
        ...

    def glDrawElementsInstancedBaseInstance(
        self,
        mode: int,
        count: int,
        type: int,
        indices: int,
        instancecount: int,
        baseinstance: int,
    ) -> None:
        ...

    def glDrawElementsInstancedBaseVertex(
        self,
        mode: int,
        count: int,
        type: int,
        indices: int,
        instancecount: int,
        basevertex: int,
    ) -> None:
        ...

    def glDrawElementsInstancedBaseVertexBaseInstance(
        self,
        mode: int,
        count: int,
        type: int,
        indices: int,
        instancecount: int,
        basevertex: int,
        baseinstance: int,
    ) -> None:
        ...

    def glDrawRangeElements(
        self, mode: int, start: int, end: int, count: int, type: int, indices: int
    ) -> None:
        ...

    def glDrawRangeElementsBaseVertex(
        self,
        mode: int,
        start: int,
        end: int,
        count: int,
        type: int,
        indices: int,
        basevertex: int,
    ) -> None:
        ...

    def glDrawTransformFeedback(self, mode: int, id: int) -> None:
        ...

    def glDrawTransformFeedbackInstanced(
        self, mode: int, id: int, instancecount: int
    ) -> None:
        ...

    def glDrawTransformFeedbackStream(self, mode: int, id: int, stream: int) -> None:
        ...

    def glDrawTransformFeedbackStreamInstanced(
        self, mode: int, id: int, stream: int, instancecount: int
    ) -> None:
        ...

    def glEnable(self, cap: int) -> None:
        ...

    def glEnableVertexArrayAttrib(self, vaobj: int, index: int) -> None:
        ...

    def glEnableVertexAttribArray(self, index: int) -> None:
        ...

    def glEnablei(self, target: int, index: int) -> None:
        ...

    def glEndConditionalRender(self) -> None:
        ...

    def glEndQuery(self, target: int) -> None:
        ...

    def glEndQueryIndexed(self, target: int, index: int) -> None:
        ...

    def glEndTransformFeedback(self) -> None:
        ...

    def glFinish(self) -> None:
        ...

    def glFlush(self) -> None:
        ...

    def glFramebufferParameteri(self, target: int, pname: int, param: int) -> None:
        ...

    def glFramebufferRenderbuffer(
        self, target: int, attachment: int, renderbuffertarget: int, renderbuffer: int
    ) -> None:
        ...

    def glFramebufferTexture(
        self, target: int, attachment: int, texture: int, level: int
    ) -> None:
        ...

    def glFramebufferTexture1D(
        self, target: int, attachment: int, textarget: int, texture: int, level: int
    ) -> None:
        ...

    def glFramebufferTexture2D(
        self, target: int, attachment: int, textarget: int, texture: int, level: int
    ) -> None:
        ...

    def glFramebufferTexture3D(
        self,
        target: int,
        attachment: int,
        textarget: int,
        texture: int,
        level: int,
        zoffset: int,
    ) -> None:
        ...

    def glFramebufferTextureLayer(
        self, target: int, attachment: int, texture: int, level: int, layer: int
    ) -> None:
        ...

    def glFrontFace(self, mode: int) -> None:
        ...

    def glGenerateMipmap(self, target: int) -> None:
        ...

    def glGenerateTextureMipmap(self, texture: int) -> None:
        ...

    def glGetAttribLocation(self, program: int, name: bytes) -> int:
        ...

    def glGetCompressedTexImage(self, target: int, level: int, img: int) -> None:
        ...

    def glGetCompressedTextureImage(
        self, texture: int, level: int, bufSize: int, pixels: int
    ) -> None:
        ...

    def glGetCompressedTextureSubImage(
        self,
        texture: int,
        level: int,
        xoffset: int,
        yoffset: int,
        zoffset: int,
        width: int,
        height: int,
        depth: int,
        bufSize: int,
        pixels: int,
    ) -> None:
        ...

    def glGetError(self) -> int:
        ...

    def glGetFragDataIndex(self, program: int, name: bytes) -> int:
        ...

    def glGetFragDataLocation(self, program: int, name: bytes) -> int:
        ...

    def glGetGraphicsResetStatus(self) -> int:
        ...

    def glGetProgramResourceIndex(
        self, program: int, programInterface: int, name: bytes
    ) -> int:
        ...

    def glGetProgramResourceLocation(
        self, program: int, programInterface: int, name: bytes
    ) -> int:
        ...

    def glGetProgramResourceLocationIndex(
        self, program: int, programInterface: int, name: bytes
    ) -> int:
        ...

    def glGetString(self, name: int) -> str:
        ...

    def glGetStringi(self, name: int, index: int) -> str:
        ...

    def glGetSubroutineIndex(self, program: int, shadertype: int, name: bytes) -> int:
        ...

    def glGetSubroutineUniformLocation(
        self, program: int, shadertype: int, name: bytes
    ) -> int:
        ...

    def glGetTexImage(
        self, target: int, level: int, format: int, type: int, pixels: int
    ) -> None:
        ...

    def glGetTextureImage(
        self,
        texture: int,
        level: int,
        format: int,
        type: int,
        bufSize: int,
        pixels: int,
    ) -> None:
        ...

    def glGetTextureSubImage(
        self,
        texture: int,
        level: int,
        xoffset: int,
        yoffset: int,
        zoffset: int,
        width: int,
        height: int,
        depth: int,
        format: int,
        type: int,
        bufSize: int,
        pixels: int,
    ) -> None:
        ...

    def glGetUniformBlockIndex(self, program: int, uniformBlockName: bytes) -> int:
        ...

    def glGetUniformLocation(self, program: int, name: bytes) -> int:
        ...

    def glGetnCompressedTexImage(
        self, target: int, lod: int, bufSize: int, pixels: int
    ) -> None:
        ...

    def glGetnTexImage(
        self, target: int, level: int, format: int, type: int, bufSize: int, pixels: int
    ) -> None:
        ...

    def glHint(self, target: int, mode: int) -> None:
        ...

    def glInvalidateBufferData(self, buffer: int) -> None:
        ...

    def glInvalidateFramebuffer(
        self, target: int, numAttachments: int, attachments: Sequence[int]
    ) -> None:
        ...

    def glInvalidateNamedFramebufferData(
        self, framebuffer: int, numAttachments: int, attachments: Sequence[int]
    ) -> None:
        ...

    def glInvalidateNamedFramebufferSubData(
        self,
        framebuffer: int,
        numAttachments: int,
        attachments: Sequence[int],
        x: int,
        y: int,
        width: int,
        height: int,
    ) -> None:
        ...

    def glInvalidateSubFramebuffer(
        self,
        target: int,
        numAttachments: int,
        attachments: Sequence[int],
        x: int,
        y: int,
        width: int,
        height: int,
    ) -> None:
        ...

    def glInvalidateTexImage(self, texture: int, level: int) -> None:
        ...

    def glInvalidateTexSubImage(
        self,
        texture: int,
        level: int,
        xoffset: int,
        yoffset: int,
        zoffset: int,
        width: int,
        height: int,
        depth: int,
    ) -> None:
        ...

    def glIsBuffer(self, buffer: int) -> int:
        ...

    def glIsEnabled(self, cap: int) -> int:
        ...

    def glIsEnabledi(self, target: int, index: int) -> int:
        ...

    def glIsFramebuffer(self, framebuffer: int) -> int:
        ...

    def glIsProgram(self, program: int) -> int:
        ...

    def glIsProgramPipeline(self, pipeline: int) -> int:
        ...

    def glIsQuery(self, id: int) -> int:
        ...

    def glIsRenderbuffer(self, renderbuffer: int) -> int:
        ...

    def glIsSampler(self, sampler: int) -> int:
        ...

    def glIsShader(self, shader: int) -> int:
        ...

    def glIsTexture(self, texture: int) -> int:
        ...

    def glIsTransformFeedback(self, id: int) -> int:
        ...

    def glIsVertexArray(self, array: int) -> int:
        ...

    def glLineWidth(self, width: float) -> None:
        ...

    def glLinkProgram(self, program: int) -> None:
        ...

    def glLogicOp(self, opcode: int) -> None:
        ...

    def glMapBuffer(self, target: int, access: int) -> int:
        ...

    def glMapNamedBuffer(self, buffer: int, access: int) -> int:
        ...

    def glMemoryBarrier(self, barriers: int) -> None:
        ...

    def glMemoryBarrierByRegion(self, barriers: int) -> None:
        ...

    def glMinSampleShading(self, value: float) -> None:
        ...

    def glMultiDrawArrays(
        self, mode: int, first: Sequence[int], count: Sequence[int], drawcount: int
    ) -> None:
        ...

    def glMultiDrawArraysIndirect(
        self, mode: int, indirect: int, drawcount: int, stride: int
    ) -> None:
        ...

    def glNamedBufferData(self, buffer: int, size: int, data: int, usage: int) -> None:
        ...

    def glNamedBufferStorage(
        self, buffer: int, size: int, data: int, flags: int
    ) -> None:
        ...

    def glNamedFramebufferDrawBuffer(self, framebuffer: int, buf: int) -> None:
        ...

    def glNamedFramebufferDrawBuffers(
        self, framebuffer: int, n: int, bufs: Sequence[int]
    ) -> None:
        ...

    def glNamedFramebufferParameteri(
        self, framebuffer: int, pname: int, param: int
    ) -> None:
        ...

    def glNamedFramebufferReadBuffer(self, framebuffer: int, src: int) -> None:
        ...

    def glNamedFramebufferRenderbuffer(
        self,
        framebuffer: int,
        attachment: int,
        renderbuffertarget: int,
        renderbuffer: int,
    ) -> None:
        ...

    def glNamedFramebufferTexture(
        self, framebuffer: int, attachment: int, texture: int, level: int
    ) -> None:
        ...

    def glNamedFramebufferTextureLayer(
        self, framebuffer: int, attachment: int, texture: int, level: int, layer: int
    ) -> None:
        ...

    def glNamedRenderbufferStorage(
        self, renderbuffer: int, internalformat: int, width: int, height: int
    ) -> None:
        ...

    def glNamedRenderbufferStorageMultisample(
        self,
        renderbuffer: int,
        samples: int,
        internalformat: int,
        width: int,
        height: int,
    ) -> None:
        ...

    def glObjectLabel(
        self, identifier: int, name: int, length: int, label: bytes
    ) -> None:
        ...

    def glObjectPtrLabel(self, ptr: int, length: int, label: bytes) -> None:
        ...

    def glPatchParameterfv(self, pname: int, values: Sequence[float]) -> None:
        ...

    def glPatchParameteri(self, pname: int, value: int) -> None:
        ...

    def glPauseTransformFeedback(self) -> None:
        ...

    def glPixelStoref(self, pname: int, param: float) -> None:
        ...

    def glPixelStorei(self, pname: int, param: int) -> None:
        ...

    def glPointParameterf(self, pname: int, param: float) -> None:
        ...

    def glPointParameterfv(self, pname: int, params: Sequence[float]) -> None:
        ...

    def glPointParameteri(self, pname: int, param: int) -> None:
        ...

    def glPointParameteriv(self, pname: int, params: Sequence[int]) -> None:
        ...

    def glPointSize(self, size: float) -> None:
        ...

    def glPolygonMode(self, face: int, mode: int) -> None:
        ...

    def glPolygonOffset(self, factor: float, units: float) -> None:
        ...

    def glPopDebugGroup(self) -> None:
        ...

    def glPrimitiveRestartIndex(self, index: int) -> None:
        ...

    def glProgramBinary(
        self, program: int, binaryFormat: int, binary: int, length: int
    ) -> None:
        ...

    def glProgramParameteri(self, program: int, pname: int, value: int) -> None:
        ...

    def glProgramUniform1d(self, program: int, location: int, v0: float) -> None:
        ...

    def glProgramUniform1dv(
        self, program: int, location: int, count: int, value: Sequence[float]
    ) -> None:
        ...

    def glProgramUniform1f(self, program: int, location: int, v0: float) -> None:
        ...

    def glProgramUniform1fv(
        self, program: int, location: int, count: int, value: Sequence[float]
    ) -> None:
        ...

    def glProgramUniform1i(self, program: int, location: int, v0: int) -> None:
        ...

    def glProgramUniform1iv(
        self, program: int, location: int, count: int, value: Sequence[int]
    ) -> None:
        ...

    def glProgramUniform1ui(self, program: int, location: int, v0: int) -> None:
        ...

    def glProgramUniform1uiv(
        self, program: int, location: int, count: int, value: Sequence[int]
    ) -> None:
        ...

    def glProgramUniform2d(
        self, program: int, location: int, v0: float, v1: float
    ) -> None:
        ...

    def glProgramUniform2dv(
        self, program: int, location: int, count: int, value: Sequence[float]
    ) -> None:
        ...

    def glProgramUniform2f(
        self, program: int, location: int, v0: float, v1: float
    ) -> None:
        ...

    def glProgramUniform2fv(
        self, program: int, location: int, count: int, value: Sequence[float]
    ) -> None:
        ...

    def glProgramUniform2i(self, program: int, location: int, v0: int, v1: int) -> None:
        ...

    def glProgramUniform2iv(
        self, program: int, location: int, count: int, value: Sequence[int]
    ) -> None:
        ...

    def glProgramUniform2ui(
        self, program: int, location: int, v0: int, v1: int
    ) -> None:
        ...

    def glProgramUniform2uiv(
        self, program: int, location: int, count: int, value: Sequence[int]
    ) -> None:
        ...

    def glProgramUniform3d(
        self, program: int, location: int, v0: float, v1: float, v2: float
    ) -> None:
        ...

    def glProgramUniform3dv(
        self, program: int, location: int, count: int, value: Sequence[float]
    ) -> None:
        ...

    def glProgramUniform3f(
        self, program: int, location: int, v0: float, v1: float, v2: float
    ) -> None:
        ...

    def glProgramUniform3fv(
        self, program: int, location: int, count: int, value: Sequence[float]
    ) -> None:
        ...

    def glProgramUniform3i(
        self, program: int, location: int, v0: int, v1: int, v2: int
    ) -> None:
        ...

    def glProgramUniform3iv(
        self, program: int, location: int, count: int, value: Sequence[int]
    ) -> None:
        ...

    def glProgramUniform3ui(
        self, program: int, location: int, v0: int, v1: int, v2: int
    ) -> None:
        ...

    def glProgramUniform3uiv(
        self, program: int, location: int, count: int, value: Sequence[int]
    ) -> None:
        ...

    def glProgramUniform4d(
        self, program: int, location: int, v0: float, v1: float, v2: float, v3: float
    ) -> None:
        ...

    def glProgramUniform4dv(
        self, program: int, location: int, count: int, value: Sequence[float]
    ) -> None:
        ...

    def glProgramUniform4f(
        self, program: int, location: int, v0: float, v1: float, v2: float, v3: float
    ) -> None:
        ...

    def glProgramUniform4fv(
        self, program: int, location: int, count: int, value: Sequence[float]
    ) -> None:
        ...

    def glProgramUniform4i(
        self, program: int, location: int, v0: int, v1: int, v2: int, v3: int
    ) -> None:
        ...

    def glProgramUniform4iv(
        self, program: int, location: int, count: int, value: Sequence[int]
    ) -> None:
        ...

    def glProgramUniform4ui(
        self, program: int, location: int, v0: int, v1: int, v2: int, v3: int
    ) -> None:
        ...

    def glProgramUniform4uiv(
        self, program: int, location: int, count: int, value: Sequence[int]
    ) -> None:
        ...

    def glProgramUniformMatrix2dv(
        self,
        program: int,
        location: int,
        count: int,
        transpose: int,
        value: Sequence[float],
    ) -> None:
        ...

    def glProgramUniformMatrix2fv(
        self,
        program: int,
        location: int,
        count: int,
        transpose: int,
        value: Sequence[float],
    ) -> None:
        ...

    def glProgramUniformMatrix2x3dv(
        self,
        program: int,
        location: int,
        count: int,
        transpose: int,
        value: Sequence[float],
    ) -> None:
        ...

    def glProgramUniformMatrix2x3fv(
        self,
        program: int,
        location: int,
        count: int,
        transpose: int,
        value: Sequence[float],
    ) -> None:
        ...

    def glProgramUniformMatrix2x4dv(
        self,
        program: int,
        location: int,
        count: int,
        transpose: int,
        value: Sequence[float],
    ) -> None:
        ...

    def glProgramUniformMatrix2x4fv(
        self,
        program: int,
        location: int,
        count: int,
        transpose: int,
        value: Sequence[float],
    ) -> None:
        ...

    def glProgramUniformMatrix3dv(
        self,
        program: int,
        location: int,
        count: int,
        transpose: int,
        value: Sequence[float],
    ) -> None:
        ...

    def glProgramUniformMatrix3fv(
        self,
        program: int,
        location: int,
        count: int,
        transpose: int,
        value: Sequence[float],
    ) -> None:
        ...

    def glProgramUniformMatrix3x2dv(
        self,
        program: int,
        location: int,
        count: int,
        transpose: int,
        value: Sequence[float],
    ) -> None:
        ...

    def glProgramUniformMatrix3x2fv(
        self,
        program: int,
        location: int,
        count: int,
        transpose: int,
        value: Sequence[float],
    ) -> None:
        ...

    def glProgramUniformMatrix3x4dv(
        self,
        program: int,
        location: int,
        count: int,
        transpose: int,
        value: Sequence[float],
    ) -> None:
        ...

    def glProgramUniformMatrix3x4fv(
        self,
        program: int,
        location: int,
        count: int,
        transpose: int,
        value: Sequence[float],
    ) -> None:
        ...

    def glProgramUniformMatrix4dv(
        self,
        program: int,
        location: int,
        count: int,
        transpose: int,
        value: Sequence[float],
    ) -> None:
        ...

    def glProgramUniformMatrix4fv(
        self,
        program: int,
        location: int,
        count: int,
        transpose: int,
        value: Sequence[float],
    ) -> None:
        ...

    def glProgramUniformMatrix4x2dv(
        self,
        program: int,
        location: int,
        count: int,
        transpose: int,
        value: Sequence[float],
    ) -> None:
        ...

    def glProgramUniformMatrix4x2fv(
        self,
        program: int,
        location: int,
        count: int,
        transpose: int,
        value: Sequence[float],
    ) -> None:
        ...

    def glProgramUniformMatrix4x3dv(
        self,
        program: int,
        location: int,
        count: int,
        transpose: int,
        value: Sequence[float],
    ) -> None:
        ...

    def glProgramUniformMatrix4x3fv(
        self,
        program: int,
        location: int,
        count: int,
        transpose: int,
        value: Sequence[float],
    ) -> None:
        ...

    def glProvokingVertex(self, mode: int) -> None:
        ...

    def glPushDebugGroup(
        self, source: int, id: int, length: int, message: bytes
    ) -> None:
        ...

    def glQueryCounter(self, id: int, target: int) -> None:
        ...

    def glReadBuffer(self, src: int) -> None:
        ...

    def glReadPixels(
        self,
        x: int,
        y: int,
        width: int,
        height: int,
        format: int,
        type: int,
        pixels: int,
    ) -> None:
        ...

    def glReadnPixels(
        self,
        x: int,
        y: int,
        width: int,
        height: int,
        format: int,
        type: int,
        bufSize: int,
        data: int,
    ) -> None:
        ...

    def glReleaseShaderCompiler(self) -> None:
        ...

    def glRenderbufferStorage(
        self, target: int, internalformat: int, width: int, height: int
    ) -> None:
        ...

    def glRenderbufferStorageMultisample(
        self, target: int, samples: int, internalformat: int, width: int, height: int
    ) -> None:
        ...

    def glResumeTransformFeedback(self) -> None:
        ...

    def glSampleCoverage(self, value: float, invert: int) -> None:
        ...

    def glSampleMaski(self, maskNumber: int, mask: int) -> None:
        ...

    def glSamplerParameterIiv(
        self, sampler: int, pname: int, param: Sequence[int]
    ) -> None:
        ...

    def glSamplerParameterIuiv(
        self, sampler: int, pname: int, param: Sequence[int]
    ) -> None:
        ...

    def glSamplerParameterf(self, sampler: int, pname: int, param: float) -> None:
        ...

    def glSamplerParameterfv(
        self, sampler: int, pname: int, param: Sequence[float]
    ) -> None:
        ...

    def glSamplerParameteri(self, sampler: int, pname: int, param: int) -> None:
        ...

    def glSamplerParameteriv(
        self, sampler: int, pname: int, param: Sequence[int]
    ) -> None:
        ...

    def glScissor(self, x: int, y: int, width: int, height: int) -> None:
        ...

    def glScissorArrayv(self, first: int, count: int, v: Sequence[int]) -> None:
        ...

    def glScissorIndexed(
        self, index: int, left: int, bottom: int, width: int, height: int
    ) -> None:
        ...

    def glScissorIndexedv(self, index: int, v: Sequence[int]) -> None:
        ...

    def glShaderBinary(
        self,
        count: int,
        shaders: Sequence[int],
        binaryformat: int,
        binary: int,
        length: int,
    ) -> None:
        ...

    def glShaderStorageBlockBinding(
        self, program: int, storageBlockIndex: int, storageBlockBinding: int
    ) -> None:
        ...

    def glStencilFunc(self, func: int, ref: int, mask: int) -> None:
        ...

    def glStencilFuncSeparate(self, face: int, func: int, ref: int, mask: int) -> None:
        ...

    def glStencilMask(self, mask: int) -> None:
        ...

    def glStencilMaskSeparate(self, face: int, mask: int) -> None:
        ...

    def glStencilOp(self, fail: int, zfail: int, zpass: int) -> None:
        ...

    def glStencilOpSeparate(
        self, face: int, sfail: int, dpfail: int, dppass: int
    ) -> None:
        ...

    def glTexBuffer(self, target: int, internalformat: int, buffer: int) -> None:
        ...

    def glTexImage1D(
        self,
        target: int,
        level: int,
        internalformat: int,
        width: int,
        border: int,
        format: int,
        type: int,
        pixels: int,
    ) -> None:
        ...

    def glTexImage2D(
        self,
        target: int,
        level: int,
        internalformat: int,
        width: int,
        height: int,
        border: int,
        format: int,
        type: int,
        pixels: int,
    ) -> None:
        ...

    def glTexImage2DMultisample(
        self,
        target: int,
        samples: int,
        internalformat: int,
        width: int,
        height: int,
        fixedsamplelocations: int,
    ) -> None:
        ...

    def glTexImage3D(
        self,
        target: int,
        level: int,
        internalformat: int,
        width: int,
        height: int,
        depth: int,
        border: int,
        format: int,
        type: int,
        pixels: int,
    ) -> None:
        ...

    def glTexImage3DMultisample(
        self,
        target: int,
        samples: int,
        internalformat: int,
        width: int,
        height: int,
        depth: int,
        fixedsamplelocations: int,
    ) -> None:
        ...

    def glTexParameterIiv(self, target: int, pname: int, params: Sequence[int]) -> None:
        ...

    def glTexParameterIuiv(
        self, target: int, pname: int, params: Sequence[int]
    ) -> None:
        ...

    def glTexParameterf(self, target: int, pname: int, param: float) -> None:
        ...

    def glTexParameterfv(
        self, target: int, pname: int, params: Sequence[float]
    ) -> None:
        ...

    def glTexParameteri(self, target: int, pname: int, param: int) -> None:
        ...

    def glTexParameteriv(self, target: int, pname: int, params: Sequence[int]) -> None:
        ...

    def glTexStorage1D(
        self, target: int, levels: int, internalformat: int, width: int
    ) -> None:
        ...

    def glTexStorage2D(
        self, target: int, levels: int, internalformat: int, width: int, height: int
    ) -> None:
        ...

    def glTexStorage2DMultisample(
        self,
        target: int,
        samples: int,
        internalformat: int,
        width: int,
        height: int,
        fixedsamplelocations: int,
    ) -> None:
        ...

    def glTexStorage3D(
        self,
        target: int,
        levels: int,
        internalformat: int,
        width: int,
        height: int,
        depth: int,
    ) -> None:
        ...

    def glTexStorage3DMultisample(
        self,
        target: int,
        samples: int,
        internalformat: int,
        width: int,
        height: int,
        depth: int,
        fixedsamplelocations: int,
    ) -> None:
        ...

    def glTexSubImage1D(
        self,
        target: int,
        level: int,
        xoffset: int,
        width: int,
        format: int,
        type: int,
        pixels: int,
    ) -> None:
        ...

    def glTexSubImage2D(
        self,
        target: int,
        level: int,
        xoffset: int,
        yoffset: int,
        width: int,
        height: int,
        format: int,
        type: int,
        pixels: int,
    ) -> None:
        ...

    def glTexSubImage3D(
        self,
        target: int,
        level: int,
        xoffset: int,
        yoffset: int,
        zoffset: int,
        width: int,
        height: int,
        depth: int,
        format: int,
        type: int,
        pixels: int,
    ) -> None:
        ...

    def glTextureBarrier(self) -> None:
        ...

    def glTextureBuffer(self, texture: int, internalformat: int, buffer: int) -> None:
        ...

    def glTextureParameterIiv(
        self, texture: int, pname: int, params: Sequence[int]
    ) -> None:
        ...

    def glTextureParameterIuiv(
        self, texture: int, pname: int, params: Sequence[int]
    ) -> None:
        ...

    def glTextureParameterf(self, texture: int, pname: int, param: float) -> None:
        ...

    def glTextureParameterfv(
        self, texture: int, pname: int, param: Sequence[float]
    ) -> None:
        ...

    def glTextureParameteri(self, texture: int, pname: int, param: int) -> None:
        ...

    def glTextureParameteriv(
        self, texture: int, pname: int, param: Sequence[int]
    ) -> None:
        ...

    def glTextureStorage1D(
        self, texture: int, levels: int, internalformat: int, width: int
    ) -> None:
        ...

    def glTextureStorage2D(
        self, texture: int, levels: int, internalformat: int, width: int, height: int
    ) -> None:
        ...

    def glTextureStorage2DMultisample(
        self,
        texture: int,
        samples: int,
        internalformat: int,
        width: int,
        height: int,
        fixedsamplelocations: int,
    ) -> None:
        ...

    def glTextureStorage3D(
        self,
        texture: int,
        levels: int,
        internalformat: int,
        width: int,
        height: int,
        depth: int,
    ) -> None:
        ...

    def glTextureStorage3DMultisample(
        self,
        texture: int,
        samples: int,
        internalformat: int,
        width: int,
        height: int,
        depth: int,
        fixedsamplelocations: int,
    ) -> None:
        ...

    def glTextureSubImage1D(
        self,
        texture: int,
        level: int,
        xoffset: int,
        width: int,
        format: int,
        type: int,
        pixels: int,
    ) -> None:
        ...

    def glTextureSubImage2D(
        self,
        texture: int,
        level: int,
        xoffset: int,
        yoffset: int,
        width: int,
        height: int,
        format: int,
        type: int,
        pixels: int,
    ) -> None:
        ...

    def glTextureSubImage3D(
        self,
        texture: int,
        level: int,
        xoffset: int,
        yoffset: int,
        zoffset: int,
        width: int,
        height: int,
        depth: int,
        format: int,
        type: int,
        pixels: int,
    ) -> None:
        ...

    def glTextureView(
        self,
        texture: int,
        target: int,
        origtexture: int,
        internalformat: int,
        minlevel: int,
        numlevels: int,
        minlayer: int,
        numlayers: int,
    ) -> None:
        ...

    def glTransformFeedbackBufferBase(self, xfb: int, index: int, buffer: int) -> None:
        ...

    def glUniform1d(self, location: int, x: float) -> None:
        ...

    def glUniform1dv(self, location: int, count: int, value: Sequence[float]) -> None:
        ...

    def glUniform1f(self, location: int, v0: float) -> None:
        ...

    def glUniform1fv(self, location: int, count: int, value: Sequence[float]) -> None:
        ...

    def glUniform1i(self, location: int, v0: int) -> None:
        ...

    def glUniform1iv(self, location: int, count: int, value: Sequence[int]) -> None:
        ...

    def glUniform1ui(self, location: int, v0: int) -> None:
        ...

    def glUniform1uiv(self, location: int, count: int, value: Sequence[int]) -> None:
        ...

    def glUniform2d(self, location: int, x: float, y: float) -> None:
        ...

    def glUniform2dv(self, location: int, count: int, value: Sequence[float]) -> None:
        ...

    def glUniform2f(self, location: int, v0: float, v1: float) -> None:
        ...

    def glUniform2fv(self, location: int, count: int, value: Sequence[float]) -> None:
        ...

    def glUniform2i(self, location: int, v0: int, v1: int) -> None:
        ...

    def glUniform2iv(self, location: int, count: int, value: Sequence[int]) -> None:
        ...

    def glUniform2ui(self, location: int, v0: int, v1: int) -> None:
        ...

    def glUniform2uiv(self, location: int, count: int, value: Sequence[int]) -> None:
        ...

    def glUniform3d(self, location: int, x: float, y: float, z: float) -> None:
        ...

    def glUniform3dv(self, location: int, count: int, value: Sequence[float]) -> None:
        ...

    def glUniform3f(self, location: int, v0: float, v1: float, v2: float) -> None:
        ...

    def glUniform3fv(self, location: int, count: int, value: Sequence[float]) -> None:
        ...

    def glUniform3i(self, location: int, v0: int, v1: int, v2: int) -> None:
        ...

    def glUniform3iv(self, location: int, count: int, value: Sequence[int]) -> None:
        ...

    def glUniform3ui(self, location: int, v0: int, v1: int, v2: int) -> None:
        ...

    def glUniform3uiv(self, location: int, count: int, value: Sequence[int]) -> None:
        ...

    def glUniform4d(
        self, location: int, x: float, y: float, z: float, w: float
    ) -> None:
        ...

    def glUniform4dv(self, location: int, count: int, value: Sequence[float]) -> None:
        ...

    def glUniform4f(
        self, location: int, v0: float, v1: float, v2: float, v3: float
    ) -> None:
        ...

    def glUniform4fv(self, location: int, count: int, value: Sequence[float]) -> None:
        ...

    def glUniform4i(self, location: int, v0: int, v1: int, v2: int, v3: int) -> None:
        ...

    def glUniform4iv(self, location: int, count: int, value: Sequence[int]) -> None:
        ...

    def glUniform4ui(self, location: int, v0: int, v1: int, v2: int, v3: int) -> None:
        ...

    def glUniform4uiv(self, location: int, count: int, value: Sequence[int]) -> None:
        ...

    def glUniformBlockBinding(
        self, program: int, uniformBlockIndex: int, uniformBlockBinding: int
    ) -> None:
        ...

    def glUniformMatrix2dv(
        self, location: int, count: int, transpose: int, value: Sequence[float]
    ) -> None:
        ...

    def glUniformMatrix2fv(
        self, location: int, count: int, transpose: int, value: Sequence[float]
    ) -> None:
        ...

    def glUniformMatrix2x3dv(
        self, location: int, count: int, transpose: int, value: Sequence[float]
    ) -> None:
        ...

    def glUniformMatrix2x3fv(
        self, location: int, count: int, transpose: int, value: Sequence[float]
    ) -> None:
        ...

    def glUniformMatrix2x4dv(
        self, location: int, count: int, transpose: int, value: Sequence[float]
    ) -> None:
        ...

    def glUniformMatrix2x4fv(
        self, location: int, count: int, transpose: int, value: Sequence[float]
    ) -> None:
        ...

    def glUniformMatrix3dv(
        self, location: int, count: int, transpose: int, value: Sequence[float]
    ) -> None:
        ...

    def glUniformMatrix3fv(
        self, location: int, count: int, transpose: int, value: Sequence[float]
    ) -> None:
        ...

    def glUniformMatrix3x2dv(
        self, location: int, count: int, transpose: int, value: Sequence[float]
    ) -> None:
        ...

    def glUniformMatrix3x2fv(
        self, location: int, count: int, transpose: int, value: Sequence[float]
    ) -> None:
        ...

    def glUniformMatrix3x4dv(
        self, location: int, count: int, transpose: int, value: Sequence[float]
    ) -> None:
        ...

    def glUniformMatrix3x4fv(
        self, location: int, count: int, transpose: int, value: Sequence[float]
    ) -> None:
        ...

    def glUniformMatrix4dv(
        self, location: int, count: int, transpose: int, value: Sequence[float]
    ) -> None:
        ...

    def glUniformMatrix4fv(
        self, location: int, count: int, transpose: int, value: Sequence[float]
    ) -> None:
        ...

    def glUniformMatrix4x2dv(
        self, location: int, count: int, transpose: int, value: Sequence[float]
    ) -> None:
        ...

    def glUniformMatrix4x2fv(
        self, location: int, count: int, transpose: int, value: Sequence[float]
    ) -> None:
        ...

    def glUniformMatrix4x3dv(
        self, location: int, count: int, transpose: int, value: Sequence[float]
    ) -> None:
        ...

    def glUniformMatrix4x3fv(
        self, location: int, count: int, transpose: int, value: Sequence[float]
    ) -> None:
        ...

    def glUniformSubroutinesuiv(
        self, shadertype: int, count: int, indices: Sequence[int]
    ) -> None:
        ...

    def glUnmapBuffer(self, target: int) -> int:
        ...

    def glUnmapNamedBuffer(self, buffer: int) -> int:
        ...

    def glUseProgram(self, program: int) -> None:
        ...

    def glUseProgramStages(self, pipeline: int, stages: int, program: int) -> None:
        ...

    def glValidateProgram(self, program: int) -> None:
        ...

    def glValidateProgramPipeline(self, pipeline: int) -> None:
        ...

    def glVertexArrayAttribBinding(
        self, vaobj: int, attribindex: int, bindingindex: int
    ) -> None:
        ...

    def glVertexArrayAttribFormat(
        self,
        vaobj: int,
        attribindex: int,
        size: int,
        type: int,
        normalized: int,
        relativeoffset: int,
    ) -> None:
        ...

    def glVertexArrayAttribIFormat(
        self, vaobj: int, attribindex: int, size: int, type: int, relativeoffset: int
    ) -> None:
        ...

    def glVertexArrayAttribLFormat(
        self, vaobj: int, attribindex: int, size: int, type: int, relativeoffset: int
    ) -> None:
        ...

    def glVertexArrayBindingDivisor(
        self, vaobj: int, bindingindex: int, divisor: int
    ) -> None:
        ...

    def glVertexArrayElementBuffer(self, vaobj: int, buffer: int) -> None:
        ...

    def glVertexArrayVertexBuffers(
        self, vaobj: int, first: int, count: int
    ) -> Tuple[int, int, int]:
        ...

    def glVertexAttrib1d(self, index: int, x: float) -> None:
        ...

    def glVertexAttrib1dv(self, index: int, v: Sequence[float]) -> None:
        ...

    def glVertexAttrib1f(self, index: int, x: float) -> None:
        ...

    def glVertexAttrib1fv(self, index: int, v: Sequence[float]) -> None:
        ...

    def glVertexAttrib1s(self, index: int, x: int) -> None:
        ...

    def glVertexAttrib1sv(self, index: int, v: Sequence[int]) -> None:
        ...

    def glVertexAttrib2d(self, index: int, x: float, y: float) -> None:
        ...

    def glVertexAttrib2dv(self, index: int, v: Sequence[float]) -> None:
        ...

    def glVertexAttrib2f(self, index: int, x: float, y: float) -> None:
        ...

    def glVertexAttrib2fv(self, index: int, v: Sequence[float]) -> None:
        ...

    def glVertexAttrib2s(self, index: int, x: int, y: int) -> None:
        ...

    def glVertexAttrib2sv(self, index: int, v: Sequence[int]) -> None:
        ...

    def glVertexAttrib3d(self, index: int, x: float, y: float, z: float) -> None:
        ...

    def glVertexAttrib3dv(self, index: int, v: Sequence[float]) -> None:
        ...

    def glVertexAttrib3f(self, index: int, x: float, y: float, z: float) -> None:
        ...

    def glVertexAttrib3fv(self, index: int, v: Sequence[float]) -> None:
        ...

    def glVertexAttrib3s(self, index: int, x: int, y: int, z: int) -> None:
        ...

    def glVertexAttrib3sv(self, index: int, v: Sequence[int]) -> None:
        ...

    def glVertexAttrib4Nbv(self, index: int, v: bytes) -> None:
        ...

    def glVertexAttrib4Niv(self, index: int, v: Sequence[int]) -> None:
        ...

    def glVertexAttrib4Nsv(self, index: int, v: Sequence[int]) -> None:
        ...

    def glVertexAttrib4Nub(self, index: int, x: int, y: int, z: int, w: int) -> None:
        ...

    def glVertexAttrib4Nubv(self, index: int, v: bytes) -> None:
        ...

    def glVertexAttrib4Nuiv(self, index: int, v: Sequence[int]) -> None:
        ...

    def glVertexAttrib4Nusv(self, index: int, v: Sequence[int]) -> None:
        ...

    def glVertexAttrib4bv(self, index: int, v: bytes) -> None:
        ...

    def glVertexAttrib4d(
        self, index: int, x: float, y: float, z: float, w: float
    ) -> None:
        ...

    def glVertexAttrib4dv(self, index: int, v: Sequence[float]) -> None:
        ...

    def glVertexAttrib4f(
        self, index: int, x: float, y: float, z: float, w: float
    ) -> None:
        ...

    def glVertexAttrib4fv(self, index: int, v: Sequence[float]) -> None:
        ...

    def glVertexAttrib4iv(self, index: int, v: Sequence[int]) -> None:
        ...

    def glVertexAttrib4s(self, index: int, x: int, y: int, z: int, w: int) -> None:
        ...

    def glVertexAttrib4sv(self, index: int, v: Sequence[int]) -> None:
        ...

    def glVertexAttrib4ubv(self, index: int, v: bytes) -> None:
        ...

    def glVertexAttrib4uiv(self, index: int, v: Sequence[int]) -> None:
        ...

    def glVertexAttrib4usv(self, index: int, v: Sequence[int]) -> None:
        ...

    def glVertexAttribBinding(self, attribindex: int, bindingindex: int) -> None:
        ...

    def glVertexAttribDivisor(self, index: int, divisor: int) -> None:
        ...

    def glVertexAttribFormat(
        self,
        attribindex: int,
        size: int,
        type: int,
        normalized: int,
        relativeoffset: int,
    ) -> None:
        ...

    def glVertexAttribI1i(self, index: int, x: int) -> None:
        ...

    def glVertexAttribI1iv(self, index: int, v: Sequence[int]) -> None:
        ...

    def glVertexAttribI1ui(self, index: int, x: int) -> None:
        ...

    def glVertexAttribI1uiv(self, index: int, v: Sequence[int]) -> None:
        ...

    def glVertexAttribI2i(self, index: int, x: int, y: int) -> None:
        ...

    def glVertexAttribI2iv(self, index: int, v: Sequence[int]) -> None:
        ...

    def glVertexAttribI2ui(self, index: int, x: int, y: int) -> None:
        ...

    def glVertexAttribI2uiv(self, index: int, v: Sequence[int]) -> None:
        ...

    def glVertexAttribI3i(self, index: int, x: int, y: int, z: int) -> None:
        ...

    def glVertexAttribI3iv(self, index: int, v: Sequence[int]) -> None:
        ...

    def glVertexAttribI3ui(self, index: int, x: int, y: int, z: int) -> None:
        ...

    def glVertexAttribI3uiv(self, index: int, v: Sequence[int]) -> None:
        ...

    def glVertexAttribI4bv(self, index: int, v: bytes) -> None:
        ...

    def glVertexAttribI4i(self, index: int, x: int, y: int, z: int, w: int) -> None:
        ...

    def glVertexAttribI4iv(self, index: int, v: Sequence[int]) -> None:
        ...

    def glVertexAttribI4sv(self, index: int, v: Sequence[int]) -> None:
        ...

    def glVertexAttribI4ubv(self, index: int, v: bytes) -> None:
        ...

    def glVertexAttribI4ui(self, index: int, x: int, y: int, z: int, w: int) -> None:
        ...

    def glVertexAttribI4uiv(self, index: int, v: Sequence[int]) -> None:
        ...

    def glVertexAttribI4usv(self, index: int, v: Sequence[int]) -> None:
        ...

    def glVertexAttribIFormat(
        self, attribindex: int, size: int, type: int, relativeoffset: int
    ) -> None:
        ...

    def glVertexAttribIPointer(
        self, index: int, size: int, type: int, stride: int, pointer: int
    ) -> None:
        ...

    def glVertexAttribL1d(self, index: int, x: float) -> None:
        ...

    def glVertexAttribL1dv(self, index: int, v: Sequence[float]) -> None:
        ...

    def glVertexAttribL2d(self, index: int, x: float, y: float) -> None:
        ...

    def glVertexAttribL2dv(self, index: int, v: Sequence[float]) -> None:
        ...

    def glVertexAttribL3d(self, index: int, x: float, y: float, z: float) -> None:
        ...

    def glVertexAttribL3dv(self, index: int, v: Sequence[float]) -> None:
        ...

    def glVertexAttribL4d(
        self, index: int, x: float, y: float, z: float, w: float
    ) -> None:
        ...

    def glVertexAttribL4dv(self, index: int, v: Sequence[float]) -> None:
        ...

    def glVertexAttribLFormat(
        self, attribindex: int, size: int, type: int, relativeoffset: int
    ) -> None:
        ...

    def glVertexAttribLPointer(
        self, index: int, size: int, type: int, stride: int, pointer: int
    ) -> None:
        ...

    def glVertexAttribP1ui(
        self, index: int, type: int, normalized: int, value: int
    ) -> None:
        ...

    def glVertexAttribP1uiv(
        self, index: int, type: int, normalized: int, value: Sequence[int]
    ) -> None:
        ...

    def glVertexAttribP2ui(
        self, index: int, type: int, normalized: int, value: int
    ) -> None:
        ...

    def glVertexAttribP2uiv(
        self, index: int, type: int, normalized: int, value: Sequence[int]
    ) -> None:
        ...

    def glVertexAttribP3ui(
        self, index: int, type: int, normalized: int, value: int
    ) -> None:
        ...

    def glVertexAttribP3uiv(
        self, index: int, type: int, normalized: int, value: Sequence[int]
    ) -> None:
        ...

    def glVertexAttribP4ui(
        self, index: int, type: int, normalized: int, value: int
    ) -> None:
        ...

    def glVertexAttribP4uiv(
        self, index: int, type: int, normalized: int, value: Sequence[int]
    ) -> None:
        ...

    def glVertexAttribPointer(
        self,
        index: int,
        size: int,
        type: int,
        normalized: int,
        stride: int,
        pointer: int,
    ) -> None:
        ...

    def glVertexBindingDivisor(self, bindingindex: int, divisor: int) -> None:
        ...

    def glViewport(self, x: int, y: int, width: int, height: int) -> None:
        ...

    def glViewportArrayv(self, first: int, count: int, v: Sequence[float]) -> None:
        ...

    def glViewportIndexedf(
        self, index: int, x: float, y: float, w: float, h: float
    ) -> None:
        ...

    def glViewportIndexedfv(self, index: int, v: Sequence[float]) -> None:
        ...

    def initializeOpenGLFunctions(self) -> bool:
        ...
