"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtOpenGL, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import List, overload
import PySide6.QtCore
import PySide6.QtGui
import PySide6.QtOpenGL

bytes = str


class QOpenGLFramebufferObject(object):
    """
    https://doc.qt.io/qt-6/qopenglframebufferobject.html

    **Detailed Description**

    The QOpenGLFramebufferObject class encapsulates an OpenGL framebuffer
    object, defined by the `GL_EXT_framebuffer_object` extension. It provides a
    rendering surface that can be painted on with a **QPainter**  with the help
    of **QOpenGLPaintDevice** , or rendered to using native OpenGL calls. This
    surface can be bound and used as a regular texture in your own OpenGL
    drawing code. By default, the QOpenGLFramebufferObject class generates a 2D
    OpenGL texture (using the `GL_TEXTURE_2D` target), which is used as the
    internal rendering target.

    **It is important to have a current OpenGL context when creating a
    QOpenGLFramebufferObject, otherwise initialization will fail.**

    Create the QOpenGLFrameBufferObject instance with the
    **CombinedDepthStencil**  attachment if you want **QPainter**  to render
    correctly. Note that you need to create a QOpenGLFramebufferObject with more
    than one sample per pixel for primitives to be antialiased when drawing
    using a **QPainter** . To create a multisample framebuffer object you should
    use one of the constructors that take a **QOpenGLFramebufferObjectFormat**
    parameter, and set the **QOpenGLFramebufferObjectFormat::samples** ()
    property to a non-zero value.

    For multisample framebuffer objects a color render buffer is created,
    otherwise a texture with the specified texture target is created. The color
    render buffer or texture will have the specified internal format, and will
    be bound to the `GL_COLOR_ATTACHMENT0` attachment in the framebuffer object.

    Multiple render targets are also supported, in case the OpenGL
    implementation supports this. Here there will be multiple textures (or, in
    case of multisampling, renderbuffers) present and each of them will get
    attached to `GL_COLOR_ATTACHMENT0`, `1`, `2`, ...

    If you want to use a framebuffer object with multisampling enabled as a
    texture, you first need to copy from it to a regular framebuffer object
    using QOpenGLContext::blitFramebuffer().

    It is possible to draw into a QOpenGLFramebufferObject using **QPainter**
    and **QOpenGLPaintDevice**  in a separate thread.
    """

    NoAttachment: QOpenGLFramebufferObject.Attachment = ...
    CombinedDepthStencil: QOpenGLFramebufferObject.Attachment = ...
    Depth: QOpenGLFramebufferObject.Attachment = ...
    DontRestoreFramebufferBinding: QOpenGLFramebufferObject.FramebufferRestorePolicy = (
        ...
    )
    RestoreFramebufferBindingToDefault: QOpenGLFramebufferObject.FramebufferRestorePolicy = (
        ...
    )
    RestoreFrameBufferBinding: QOpenGLFramebufferObject.FramebufferRestorePolicy = ...

    class Attachment(Enum):
        NoAttachment: QOpenGLFramebufferObject.Attachment = ...
        CombinedDepthStencil: QOpenGLFramebufferObject.Attachment = ...
        Depth: QOpenGLFramebufferObject.Attachment = ...

    class FramebufferRestorePolicy(Enum):
        DontRestoreFramebufferBinding: QOpenGLFramebufferObject.FramebufferRestorePolicy = (
            ...
        )
        RestoreFramebufferBindingToDefault: QOpenGLFramebufferObject.FramebufferRestorePolicy = (
            ...
        )
        RestoreFrameBufferBinding: QOpenGLFramebufferObject.FramebufferRestorePolicy = (
            ...
        )

    @overload
    def __init__(
        self,
        size: PySide6.QtCore.QSize,
        attachment: PySide6.QtOpenGL.QOpenGLFramebufferObject.Attachment,
        target: int = ...,
        internalFormat: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#QOpenGLFramebufferO
        bject

        **QOpenGLFramebufferObject::QOpenGLFramebufferObject(const QSize & size
        , GLenum target = GL_TEXTURE_2D)**

        Constructs an OpenGL framebuffer object and binds a 2D OpenGL texture to
        the buffer of the size **size**. The texture is bound to the
        `GL_COLOR_ATTACHMENT0` target in the framebuffer object.

        The **target** parameter is used to specify the OpenGL texture target.
        The default target is `GL_TEXTURE_2D`. Keep in mind that `GL_TEXTURE_2D`
        textures must have a power of 2 width and height (e.g. 256x512), unless
        you are using OpenGL 2.0 or higher.

        By default, no depth and stencil buffers are attached. This behavior can
        be toggled using one of the overloaded constructors.

        The default internal texture format is `GL_RGBA8` for desktop OpenGL,
        and `GL_RGBA` for OpenGL/ES.

        It is important that you have a current OpenGL context set when creating
        the QOpenGLFramebufferObject, otherwise the initialization will fail.

        **See also** **size** (), **texture** (), and **attachment** ().
        """
        ...

    @overload
    def __init__(
        self,
        size: PySide6.QtCore.QSize,
        format: PySide6.QtOpenGL.QOpenGLFramebufferObjectFormat,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#QOpenGLFramebufferO
        bject-1

        **QOpenGLFramebufferObject::QOpenGLFramebufferObject(int width , int
        height , GLenum target = GL_TEXTURE_2D)**

        Constructs an OpenGL framebuffer object and binds a 2D OpenGL texture to
        the buffer of the given **width** and **height**.

        **See also** **size** () and **texture** ().
        """
        ...

    @overload
    def __init__(self, size: PySide6.QtCore.QSize, target: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#QOpenGLFramebufferO
        bject-2

        **QOpenGLFramebufferObject::QOpenGLFramebufferObject(const QSize & size
        , QOpenGLFramebufferObject::Attachment attachment , GLenum target =
        GL_TEXTURE_2D, GLenum internalFormat = 0)**

        Constructs an OpenGL framebuffer object and binds a texture to the
        buffer of the given **size**.

        The **attachment** parameter describes the depth/stencil buffer
        configuration, **target** the texture target and **internalFormat** the
        internal texture format. The default texture target is `GL_TEXTURE_2D`,
        while the default internal format is `GL_RGBA8` for desktop OpenGL and
        `GL_RGBA` for OpenGL/ES.

        **See also** **size** (), **texture** (), and **attachment** ().
        """
        ...

    @overload
    def __init__(
        self,
        width: int,
        height: int,
        attachment: PySide6.QtOpenGL.QOpenGLFramebufferObject.Attachment,
        target: int = ...,
        internalFormat: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#QOpenGLFramebufferO
        bject-3

        **QOpenGLFramebufferObject::QOpenGLFramebufferObject(int width , int
        height , QOpenGLFramebufferObject::Attachment attachment , GLenum target
        = GL_TEXTURE_2D, GLenum internalFormat = 0)**

        Constructs an OpenGL framebuffer object and binds a texture to the
        buffer of the given **width** and **height**.

        The **attachment** parameter describes the depth/stencil buffer
        configuration, **target** the texture target and **internalFormat** the
        internal texture format. The default texture target is `GL_TEXTURE_2D`,
        while the default internal format is `GL_RGBA8` for desktop OpenGL and
        `GL_RGBA` for OpenGL/ES.

        **See also** **size** (), **texture** (), and **attachment** ().
        """
        ...

    @overload
    def __init__(
        self,
        width: int,
        height: int,
        format: PySide6.QtOpenGL.QOpenGLFramebufferObjectFormat,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#QOpenGLFramebufferO
        bject-4

        **QOpenGLFramebufferObject::QOpenGLFramebufferObject(const QSize & size
        , const QOpenGLFramebufferObjectFormat & format )**

        Constructs an OpenGL framebuffer object of the given **size** based on
        the supplied **format**.
        """
        ...

    @overload
    def __init__(self, width: int, height: int, target: int = ...) -> None:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#QOpenGLFramebufferO
        bject-5

        **QOpenGLFramebufferObject::QOpenGLFramebufferObject(int width , int
        height , const QOpenGLFramebufferObjectFormat & format )**

        Constructs an OpenGL framebuffer object of the given **width** and
        **height** based on the supplied **format**.
        """
        ...

    @overload
    def addColorAttachment(
        self, size: PySide6.QtCore.QSize, internalFormat: int = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#addColorAttachment

        **[since 5.6] void QOpenGLFramebufferObject::addColorAttachment(const
        QSize & size , GLenum internalFormat = 0)**

        Creates and attaches an additional texture or renderbuffer of **size**
        width and height.

        There is always an attachment at GL_COLOR_ATTACHMENT0. Call this
        function to set up additional attachments at GL_COLOR_ATTACHMENT1,
        GL_COLOR_ATTACHMENT2, ...

        When **internalFormat** is not `0`, it specifies the internal format of
        the texture or renderbuffer. Otherwise a default of GL_RGBA or GL_RGBA8
        is used.

        **Note:** This is only functional when multiple render targets are
        supported by the OpenGL implementation. When that is not the case, the
        function will not add any additional color attachments. Call
        **QOpenGLFunctions::hasOpenGLFeature** () with
        **QOpenGLFunctions::MultipleRenderTargets**  at runtime to check if MRT
        is supported.

        **Note:** The internal format of the color attachments may differ but
        there may be limitations on the supported combinations, depending on the
        drivers.

        **Note:** The size of the color attachments may differ but rendering is
        limited to the area that fits all the attachments, according to the
        OpenGL specification. Some drivers may not be fully conformant in this
        respect, however.

        This function was introduced in Qt 5.6.
        """
        ...

    @overload
    def addColorAttachment(
        self, width: int, height: int, internalFormat: int = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#addColorAttachment-
        1

        **[since 5.6] void QOpenGLFramebufferObject::addColorAttachment(int
        width , int height , GLenum internalFormat = 0)**

        This is an overloaded function.

        Creates and attaches an additional texture or renderbuffer of size
        **width** and **height**.

        When **internalFormat** is not `0`, it specifies the internal format of
        the texture or renderbuffer. Otherwise a default of GL_RGBA or GL_RGBA8
        is used.

        This function was introduced in Qt 5.6.
        """
        ...

    def attachment(self) -> PySide6.QtOpenGL.QOpenGLFramebufferObject.Attachment:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#attachment

        **QOpenGLFramebufferObject::Attachment
        QOpenGLFramebufferObject::attachment() const**

        Returns the status of the depth and stencil buffers attached to this
        framebuffer object.

        **See also** **setAttachment** ().
        """
        ...

    def bind(self) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#bind

        **bool QOpenGLFramebufferObject::bind()**

        Switches rendering from the default, windowing system provided
        framebuffer to this framebuffer object. Returns `true` upon success,
        false otherwise.

        **Note:** If **takeTexture** () was called, a new texture is created and
        associated with the framebuffer object. This is potentially expensive
        and changes the context state (the currently bound texture).

        **See also** **release** ().
        """
        ...

    @staticmethod
    def bindDefault() -> bool:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#bindDefault

        **[static] bool QOpenGLFramebufferObject::bindDefault()**

        Switches rendering back to the default, windowing system provided
        framebuffer. Returns `true` upon success, false otherwise.

        **See also** **bind** () and **release** ().
        """
        ...

    @overload
    @staticmethod
    def blitFramebuffer(
        target: PySide6.QtOpenGL.QOpenGLFramebufferObject,
        source: PySide6.QtOpenGL.QOpenGLFramebufferObject,
        buffers: int = ...,
        filter: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#blitFramebuffer

        **[static, since 5.7] void
        QOpenGLFramebufferObject::blitFramebuffer(QOpenGLFramebufferObject *
        target , const QRect & targetRect , QOpenGLFramebufferObject * source ,
        const QRect & sourceRect , GLbitfield buffers , GLenum filter , int
        readColorAttachmentIndex , int drawColorAttachmentIndex ,
        QOpenGLFramebufferObject::FramebufferRestorePolicy restorePolicy )**

        Blits from the **sourceRect** rectangle in the **source** framebuffer
        object to the **targetRect** rectangle in the **target** framebuffer
        object.

        If **source** or **target** is 0, the default framebuffer will be used
        instead of a framebuffer object as source or target respectively.

        This function will have no effect unless **hasOpenGLFramebufferBlit** ()
        returns true.

        The **buffers** parameter should be a mask consisting of any combination
        of `GL_COLOR_BUFFER_BIT`, `GL_DEPTH_BUFFER_BIT`, and
        `GL_STENCIL_BUFFER_BIT`. Any buffer type that is not present both in the
        source and target buffers is ignored.

        The **sourceRect** and **targetRect** rectangles may have different
        sizes; in this case **buffers** should not contain `GL_DEPTH_BUFFER_BIT`
        or `GL_STENCIL_BUFFER_BIT`. The **filter** parameter should be set to
        `GL_LINEAR` or `GL_NEAREST`, and specifies whether linear or nearest
        interpolation should be used when scaling is performed.

        If **source** equals **target** a copy is performed within the same
        buffer. Results are undefined if the source and target rectangles
        overlap and have different sizes. The sizes must also be the same if any
        of the framebuffer objects are multisample framebuffers.

        **Note:** The scissor test will restrict the blit area if enabled.

        When multiple render targets are in use, **readColorAttachmentIndex**
        and **drawColorAttachmentIndex** specify the index of the color
        attachments in the source and destination framebuffers.

        The **restorePolicy** determines if the framebuffer that was bound prior
        to calling this function should be restored, or if the default
        framebuffer should be bound before returning, of if the caller is
        responsible for tracking and setting the bound framebuffer. Restoring
        the previous framebuffer can be relatively expensive due to the call to
        `glGetIntegerv` which on some OpenGL drivers may imply a pipeline stall.

        This function was introduced in Qt 5.7.

        **See also** **hasOpenGLFramebufferBlit** ().
        """
        ...

    @overload
    @staticmethod
    def blitFramebuffer(
        target: PySide6.QtOpenGL.QOpenGLFramebufferObject,
        targetRect: PySide6.QtCore.QRect,
        source: PySide6.QtOpenGL.QOpenGLFramebufferObject,
        sourceRect: PySide6.QtCore.QRect,
        buffers: int,
        filter: int,
        readColorAttachmentIndex: int,
        drawColorAttachmentIndex: int,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#blitFramebuffer-1

        **[static] void
        QOpenGLFramebufferObject::blitFramebuffer(QOpenGLFramebufferObject *
        target , const QRect & targetRect , QOpenGLFramebufferObject * source ,
        const QRect & sourceRect , GLbitfield buffers , GLenum filter , int
        readColorAttachmentIndex , int drawColorAttachmentIndex )**

        This is an overloaded function.

        Convenience overload to blit between two framebuffer objects and to
        restore the previous framebuffer binding. Equivalent to calling
        blitFramebuffer(target, targetRect, source, sourceRect, buffers, filter,
        readColorAttachmentIndex, drawColorAttachmentIndex,
        **RestoreFrameBufferBinding** ).
        """
        ...

    @overload
    @staticmethod
    def blitFramebuffer(
        target: PySide6.QtOpenGL.QOpenGLFramebufferObject,
        targetRect: PySide6.QtCore.QRect,
        source: PySide6.QtOpenGL.QOpenGLFramebufferObject,
        sourceRect: PySide6.QtCore.QRect,
        buffers: int,
        filter: int,
        readColorAttachmentIndex: int,
        drawColorAttachmentIndex: int,
        restorePolicy: PySide6.QtOpenGL.QOpenGLFramebufferObject.FramebufferRestorePolicy,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#blitFramebuffer-2

        **[static] void
        QOpenGLFramebufferObject::blitFramebuffer(QOpenGLFramebufferObject *
        target , const QRect & targetRect , QOpenGLFramebufferObject * source ,
        const QRect & sourceRect , GLbitfield buffers = GL_COLOR_BUFFER_BIT,
        GLenum filter = GL_NEAREST)**

        This is an overloaded function.

        * Convenience overload to blit between two framebuffer objects.
        """
        ...

    @overload
    @staticmethod
    def blitFramebuffer(
        target: PySide6.QtOpenGL.QOpenGLFramebufferObject,
        targetRect: PySide6.QtCore.QRect,
        source: PySide6.QtOpenGL.QOpenGLFramebufferObject,
        sourceRect: PySide6.QtCore.QRect,
        buffers: int = ...,
        filter: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#blitFramebuffer-3

        **[static] void
        QOpenGLFramebufferObject::blitFramebuffer(QOpenGLFramebufferObject *
        target , QOpenGLFramebufferObject * source , GLbitfield buffers =
        GL_COLOR_BUFFER_BIT, GLenum filter = GL_NEAREST)**

        This is an overloaded function.

        Convenience overload to blit between two framebuffer objects.
        """
        ...

    def format(self) -> PySide6.QtOpenGL.QOpenGLFramebufferObjectFormat:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#format

        **QOpenGLFramebufferObjectFormat QOpenGLFramebufferObject::format()
        const**

        Returns the format of this framebuffer object.
        """
        ...

    def handle(self) -> int:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#handle

        **GLuint QOpenGLFramebufferObject::handle() const**

        Returns the OpenGL framebuffer object handle for this framebuffer object
        (returned by the `glGenFrameBuffersEXT()` function). This handle can be
        used to attach new images or buffers to the framebuffer. The user is
        responsible for cleaning up and destroying these objects.
        """
        ...

    @staticmethod
    def hasOpenGLFramebufferBlit() -> bool:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#hasOpenGLFramebuffe
        rBlit

        **[static] bool QOpenGLFramebufferObject::hasOpenGLFramebufferBlit()**

        Returns `true` if the OpenGL `GL_EXT_framebuffer_blit` extension is
        present on this system; otherwise returns `false`.

        **See also** **blitFramebuffer** ().
        """
        ...

    @staticmethod
    def hasOpenGLFramebufferObjects() -> bool:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#hasOpenGLFramebuffe
        rObjects

        **[static] bool
        QOpenGLFramebufferObject::hasOpenGLFramebufferObjects()**

        Returns `true` if the OpenGL `GL_EXT_framebuffer_object` extension is
        present on this system; otherwise returns `false`.
        """
        ...

    def height(self) -> int:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#height

        **int QOpenGLFramebufferObject::height() const**

        Returns the height of the framebuffer object attachments.
        """
        ...

    def isBound(self) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#isBound

        **bool QOpenGLFramebufferObject::isBound() const**

        Returns `true` if the framebuffer object is currently bound to the
        current context, otherwise false is returned.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#isValid

        **bool QOpenGLFramebufferObject::isValid() const**

        Returns `true` if the framebuffer object is valid.

        The framebuffer can become invalid if the initialization process fails,
        the user attaches an invalid buffer to the framebuffer object, or a non-
        power of two width/height is specified as the texture size if the
        texture target is `GL_TEXTURE_2D`. The non-power of two limitation does
        not apply if the OpenGL version is 2.0 or higher, or if the
        GL_ARB_texture_non_power_of_two extension is present.

        The framebuffer can also become invalid if the **QOpenGLContext**  that
        the framebuffer was created within is destroyed and there are no other
        shared contexts that can take over ownership of the framebuffer.
        """
        ...

    def release(self) -> bool:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#release

        **bool QOpenGLFramebufferObject::release()**

        Switches rendering back to the default, windowing system provided
        framebuffer. Returns `true` upon success, false otherwise.

        **See also** **bind** ().
        """
        ...

    def setAttachment(
        self, attachment: PySide6.QtOpenGL.QOpenGLFramebufferObject.Attachment
    ) -> None:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#setAttachment

        **void QOpenGLFramebufferObject::setAttachment(QOpenGLFramebufferObject:
        :Attachment attachment )**

        Sets the attachments of the framebuffer object to **attachment**.

        This can be used to free or reattach the depth and stencil buffer
        attachments as needed.

        **Note:** This function alters the current framebuffer binding.

        **See also** **attachment** ().
        """
        ...

    def size(self) -> PySide6.QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#size

        **QSize QOpenGLFramebufferObject::size() const**

        Returns the size of the color and depth/stencil attachments attached to
        this framebuffer object.
        """
        ...

    def sizes(self) -> List[PySide6.QtCore.QSize]:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#sizes

        **[since 5.6] QList<QSize> QOpenGLFramebufferObject::sizes() const**

        Returns the sizes of all color attachments attached to this framebuffer
        object.

        This function was introduced in Qt 5.6.
        """
        ...

    @overload
    def takeTexture(self) -> int:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#takeTexture

        **[since 5.3] GLuint QOpenGLFramebufferObject::takeTexture()**

        Returns the texture id for the texture attached to this framebuffer
        object. The ownership of the texture is transferred to the caller.

        If the framebuffer object is currently bound, an implicit **release** ()
        will be done. During the next call to **bind** () a new texture will be
        created.

        If a multisample framebuffer object is used, then there is no texture
        and the return value from this function will be invalid. Similarly,
        incomplete framebuffer objects will also return 0.

        This function was introduced in Qt 5.3.

        **See also** **texture** (), **bind** (), and **release** ().
        """
        ...

    @overload
    def takeTexture(self, colorAttachmentIndex: int) -> int:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#takeTexture-1

        **[since 5.6] GLuint QOpenGLFramebufferObject::takeTexture(int
        colorAttachmentIndex )**

        This is an overloaded function.

        Returns the texture id for the texture attached to the color attachment
        of index **colorAttachmentIndex** of this framebuffer object. The
        ownership of the texture is transferred to the caller.

        When **colorAttachmentIndex** is `0`, the behavior is identical to the
        parameter-less variant of this function.

        If the framebuffer object is currently bound, an implicit **release** ()
        will be done. During the next call to **bind** () a new texture will be
        created.

        If a multisample framebuffer object is used, then there is no texture
        and the return value from this function will be invalid. Similarly,
        incomplete framebuffer objects will also return 0.

        This function was introduced in Qt 5.6.
        """
        ...

    def texture(self) -> int:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#texture

        **GLuint QOpenGLFramebufferObject::texture() const**

        Returns the texture id for the texture attached as the default rendering
        target in this framebuffer object. This texture id can be bound as a
        normal texture in your own OpenGL code.

        If a multisample framebuffer object is used then the value returned from
        this function will be invalid.

        When multiple textures are attached, the return value is the ID of the
        first one.

        **See also** **takeTexture** () and **textures** ().
        """
        ...

    def textures(self) -> List[int]:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#textures

        **[since 5.6] QList<GLuint> QOpenGLFramebufferObject::textures() const**

        Returns the texture id for all attached textures.

        If a multisample framebuffer object is used, then an empty vector is
        returned.

        This function was introduced in Qt 5.6.

        **See also** **takeTexture** () and **texture** ().
        """
        ...

    @overload
    def toImage(self, flipped: bool, colorAttachmentIndex: int) -> PySide6.QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#toImage

        **QImage QOpenGLFramebufferObject::toImage(bool flipped = true) const**

        Returns the contents of this framebuffer object as a **QImage** .

        If **flipped** is true the image is flipped from OpenGL coordinates to
        raster coordinates. If used together with **QOpenGLPaintDevice** ,
        **flipped** should be the opposite of the value of
        **QOpenGLPaintDevice::paintFlipped** ().

        The returned image has a format of premultiplied ARGB32 or RGB32. The
        latter is used only when internalTextureFormat() is set to `GL_RGB`.
        Since Qt 5.2 the function will fall back to premultiplied RGBA8888 or
        RGBx8888 when reading to (A)RGB32 is not supported, and this includes
        OpenGL ES. Since Qt 5.4 an A2BGR30 image is returned if the internal
        format is RGB10_A2, and since Qt 5.12 a RGBA64 image is return if the
        internal format is RGBA16.

        If the rendering in the framebuffer was not done with premultiplied
        alpha in mind, create a wrapper **QImage**  with a non-premultiplied
        format. This is necessary before performing operations like
        **QImage::save** () because otherwise the image data would get
        unpremultiplied, even though it was not premultiplied in the first
        place. To create such a wrapper without performing a copy of the pixel
        data, do the following:

        **QImage**  fboImage(fbo.toImage());
            **QImage**
        image(fboImage.constBits(), fboImage.width(), fboImage.height(),
        **QImage** ::Format_ARGB32);

        For multisampled framebuffer objects the samples are resolved using the
        `GL_EXT_framebuffer_blit` extension. If the extension is not available,
        the contents of the returned image is undefined.

        For singlesampled framebuffers the contents is retrieved via
        `glReadPixels`. This is a potentially expensive and inefficient
        operation. Therefore it is recommended that this function is used as
        seldom as possible.

        **See also** **QOpenGLPaintDevice::paintFlipped** ().
        """
        ...

    @overload
    def toImage(self, flipped: bool = ...) -> PySide6.QtGui.QImage:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#toImage-1

        **[since 5.6] QImage QOpenGLFramebufferObject::toImage(bool flipped ,
        int colorAttachmentIndex ) const**

        This is an overloaded function.

        Returns the contents of the color attachment of index
        **colorAttachmentIndex** of this framebuffer object as a **QImage** .
        This method flips the image from OpenGL coordinates to raster
        coordinates when **flipped** is set to `true`.

        **Note:** This overload is only fully functional when multiple render
        targets are supported by the OpenGL implementation. When that is not the
        case, only one color attachment will be set up.

        This function was introduced in Qt 5.6.
        """
        ...

    def width(self) -> int:
        """
        https://doc.qt.io/qt-6/qopenglframebufferobject.html#width

        **int QOpenGLFramebufferObject::width() const**

        Returns the width of the framebuffer object attachments.
        """
        ...
