"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtNetworkAuth, except for defaults which are replaced by "...".
"""
from typing import Any, Dict, Optional, Union, overload
import PySide6.QtCore
import PySide6.QtNetwork
import PySide6.QtNetworkAuth

bytes = str


class QOAuth2AuthorizationCodeFlow(PySide6.QtNetworkAuth.QAbstractOAuth2):
    """
    https://doc.qt.io/qt-6/qoauth2authorizationcodeflow.html

    **Detailed Description**

    This class implements the **Authorization Code Grant**  flow, which is used
    both to obtain and to refresh access tokens. It is a redirection-based flow
    so the user will need access to a web browser.
    """

    @overload
    def __init__(
        self,
        authorizationUrl: Union[PySide6.QtCore.QUrl, str],
        accessTokenUrl: Union[PySide6.QtCore.QUrl, str],
        manager: PySide6.QtNetwork.QNetworkAccessManager,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qoauth2authorizationcodeflow.html#QOAuth2Authoriz
        ationCodeFlow

        **QOAuth2AuthorizationCodeFlow::QOAuth2AuthorizationCodeFlow(QObject *
        parent = nullptr)**

        Constructs a QOAuth2AuthorizationCodeFlow object with parent object
        **parent**.
        """
        ...

    @overload
    def __init__(
        self,
        clientIdentifier: str,
        authorizationUrl: Union[PySide6.QtCore.QUrl, str],
        accessTokenUrl: Union[PySide6.QtCore.QUrl, str],
        manager: PySide6.QtNetwork.QNetworkAccessManager,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qoauth2authorizationcodeflow.html#QOAuth2Authoriz
        ationCodeFlow-1

        **QOAuth2AuthorizationCodeFlow::QOAuth2AuthorizationCodeFlow(QNetworkAcc
        essManager * manager , QObject * parent = nullptr)**

        Constructs a QOAuth2AuthorizationCodeFlow object using **parent** as
        parent and sets **manager** as the network access manager.
        """
        ...

    @overload
    def __init__(
        self,
        clientIdentifier: str,
        manager: PySide6.QtNetwork.QNetworkAccessManager,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qoauth2authorizationcodeflow.html#QOAuth2Authoriz
        ationCodeFlow-2

        **QOAuth2AuthorizationCodeFlow::QOAuth2AuthorizationCodeFlow(const
        QString & clientIdentifier , QNetworkAccessManager * manager , QObject *
        parent = nullptr)**

        Constructs a QOAuth2AuthorizationCodeFlow object using **parent** as
        parent and sets **manager** as the network access manager. The client
        identifier is set to **clientIdentifier**.
        """
        ...

    @overload
    def __init__(
        self,
        manager: PySide6.QtNetwork.QNetworkAccessManager,
        parent: Optional[PySide6.QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qoauth2authorizationcodeflow.html#QOAuth2Authoriz
        ationCodeFlow-3

        **QOAuth2AuthorizationCodeFlow::QOAuth2AuthorizationCodeFlow(const QUrl
        & authenticateUrl , const QUrl & accessTokenUrl , QNetworkAccessManager
        * manager , QObject * parent = nullptr)**

        Constructs a QOAuth2AuthorizationCodeFlow object using **parent** as
        parent and sets **manager** as the network access manager. The
        authenticate URL is set to **authenticateUrl** and the access token URL
        is set to **accessTokenUrl**.
        """
        ...

    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qoauth2authorizationcodeflow.html#QOAuth2Authoriz
        ationCodeFlow-4

        **QOAuth2AuthorizationCodeFlow::QOAuth2AuthorizationCodeFlow(const
        QString & clientIdentifier , const QUrl & authenticateUrl , const QUrl &
        accessTokenUrl , QNetworkAccessManager * manager , QObject * parent =
        nullptr)**

        Constructs a QOAuth2AuthorizationCodeFlow object using **parent** as
        parent and sets **manager** as the network access manager. The client
        identifier is set to **clientIdentifier** the authenticate URL is set to
        **authenticateUrl** and the access token URL is set to
        **accessTokenUrl**.
        """
        ...

    def accessTokenUrl(self) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qoauth2authorizationcodeflow.html#accessTokenUrl

        **QUrl QOAuth2AuthorizationCodeFlow::accessTokenUrl() const**

        Returns the URL used to request the access token.

        **Note:** Getter function for property accessTokenUrl.

        **See also** **setAccessTokenUrl** ().
        """
        ...

    def buildAuthenticateUrl(
        self, parameters: Dict[str, Any] = ...
    ) -> PySide6.QtCore.QUrl:
        """
        https://doc.qt.io/qt-6/qoauth2authorizationcodeflow.html#buildAuthentica
        teUrl

        **[protected] QUrl
        QOAuth2AuthorizationCodeFlow::buildAuthenticateUrl(const
        QMultiMap<QString, QVariant> & parameters = {})**

        Generates an authentication URL to be used in the **Authorization
        Request**  using **parameters**.
        """
        ...

    def grant(self) -> None:
        """
        https://doc.qt.io/qt-6/qoauth2authorizationcodeflow.html#grant

        **[override virtual slot] void QOAuth2AuthorizationCodeFlow::grant()**

        Reimplements: **QAbstractOAuth::grant** ().

        Starts the authentication flow as described in **The OAuth 2.0
        Authorization Framework**
        """
        ...

    def refreshAccessToken(self) -> None:
        """
        https://doc.qt.io/qt-6/qoauth2authorizationcodeflow.html#refreshAccessTo
        ken

        **[slot] void QOAuth2AuthorizationCodeFlow::refreshAccessToken()**

        Call this function to refresh the token. Access tokens are not
        permanent. After a time specified along with the access token when it
        was obtained, the access token will become invalid.

        **See also**  : **Refresh Token**
        """
        ...

    def requestAccessToken(self, code: str) -> None:
        """
        https://doc.qt.io/qt-6/qoauth2authorizationcodeflow.html#requestAccessTo
        ken

        **[protected] void
        QOAuth2AuthorizationCodeFlow::requestAccessToken(const QString & code
        )**

        Requests an access token from the received **code**. The **code** is
        received as a response when the user completes a successful
        authentication in the browser.
        """
        ...

    def resourceOwnerAuthorization(
        self, url: Union[PySide6.QtCore.QUrl, str], parameters: Dict[str, Any] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qoauth2authorizationcodeflow.html#resourceOwnerAu
        thorization

        **[override virtual protected] void
        QOAuth2AuthorizationCodeFlow::resourceOwnerAuthorization(const QUrl &
        url , const QMultiMap<QString, QVariant> & parameters = {})**

        Reimplements: **QAbstractOAuth::resourceOwnerAuthorization** (const QUrl
        &url, const QMultiMap<QString, QVariant> &parameters).

        Builds an authentication URL using **url** and **parameters**. This
        function emits an **authorizeWithBrowser** () signal to require user
        interaction.
        """
        ...

    def setAccessTokenUrl(
        self, accessTokenUrl: Union[PySide6.QtCore.QUrl, str]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qoauth2authorizationcodeflow.html#setAccessTokenU
        rl

        **void QOAuth2AuthorizationCodeFlow::setAccessTokenUrl(const QUrl &
        accessTokenUrl )**

        Sets the URL used to request the access token to **accessTokenUrl**.

        **Note:** Setter function for property **accessTokenUrl** .

        **See also** **accessTokenUrl** ().
        """
        ...

    @property
    def accessTokenUrlChanged(self) -> PySide6.QtCore.SignalInstance:
        ...
