"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtNetwork, except for defaults which are replaced by "...".
"""
from typing import Optional, Union, overload
import PySide6.QtCore
import PySide6.QtNetwork

bytes = str


class QTcpSocket(PySide6.QtNetwork.QAbstractSocket):
    """
    https://doc.qt.io/qt-6/qtcpsocket.html

    **Detailed Description**

    TCP (Transmission Control Protocol) is a reliable, stream-oriented,
    connection-oriented transport protocol. It is especially well suited for
    continuous transmission of data.

    QTcpSocket is a convenience subclass of **QAbstractSocket**  that allows you
    to establish a TCP connection and transfer streams of data. See the
    **QAbstractSocket**  documentation for details.

    **Note:** TCP sockets cannot be opened in QIODevice::Unbuffered mode.

    **See also** **QTcpServer** , **QUdpSocket** , **QNetworkAccessManager** ,
    **Fortune Server Example** , **Fortune Client Example** , **Threaded Fortune
    Server Example** , **Blocking Fortune Client Example** , **Loopback
    Example** , and **Torrent Example** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qtcpsocket.html#QTcpSocket

        **QTcpSocket::QTcpSocket(QObject * parent = nullptr)**

        Creates a QTcpSocket object in state `UnconnectedState`.

        **parent** is passed on to the **QObject**  constructor.

        **See also** **socketType** ().
        """
        ...

    @overload
    def bind(
        self,
        addr: PySide6.QtNetwork.QHostAddress.SpecialAddress,
        port: int = ...,
        mode: PySide6.QtNetwork.QAbstractSocket.BindMode = ...,
    ) -> bool:
        ...

    @overload
    def bind(
        self,
        address: Union[
            PySide6.QtNetwork.QHostAddress,
            PySide6.QtNetwork.QHostAddress.SpecialAddress,
        ],
        port: int = ...,
        mode: PySide6.QtNetwork.QAbstractSocket.BindMode = ...,
    ) -> bool:
        ...

    @overload
    def bind(
        self, port: int = ..., mode: PySide6.QtNetwork.QAbstractSocket.BindMode = ...
    ) -> bool:
        ...
