"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtNetwork, except for defaults which are replaced by "...".
"""
from typing import Optional, Tuple, Union
import PySide6.QtCore
import PySide6.QtNetwork

bytes = str


class QTcpServer(PySide6.QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qtcpserver.html

    **Detailed Description**

    This class makes it possible to accept incoming TCP connections. You can
    specify the port or have QTcpServer pick one automatically. You can listen
    on a specific address or on all the machine's addresses.

    Call **listen** () to have the server listen for incoming connections. The
    **newConnection** () signal is then emitted each time a client connects to
    the server.

    Call **nextPendingConnection** () to accept the pending connection as a
    connected **QTcpSocket** . The function returns a pointer to a
    **QTcpSocket**  in **QAbstractSocket::ConnectedState**  that you can use for
    communicating with the client.

    If an error occurs, **serverError** () returns the type of error, and
    **errorString** () can be called to get a human readable description of what
    happened.

    When listening for connections, the address and port on which the server is
    listening are available as **serverAddress** () and **serverPort** ().

    Calling **close** () makes QTcpServer stop listening for incoming
    connections.

    Although QTcpServer is mostly designed for use with an event loop, it's
    possible to use it without one. In that case, you must use
    **waitForNewConnection** (), which blocks until either a connection is
    available or a timeout expires.

    **See also** **QTcpSocket** , **Fortune Server Example** , **Threaded
    Fortune Server Example** , **Loopback Example** , and **Torrent Example** .
    """

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qtcpserver.html#QTcpServer

        **QTcpServer::QTcpServer(QObject * parent = nullptr)**

        Constructs a QTcpServer object.

        **parent** is passed to the **QObject**  constructor.

        **See also** **listen** () and **setSocketDescriptor** ().
        """
        ...

    def addPendingConnection(self, socket: PySide6.QtNetwork.QTcpSocket) -> None:
        """
        https://doc.qt.io/qt-6/qtcpserver.html#addPendingConnection

        **[protected] void QTcpServer::addPendingConnection(QTcpSocket * socket
        )**

        This function is called by **QTcpServer::incomingConnection** () to add
        the **socket** to the list of pending incoming connections.

        **Note:** Don't forget to call this member from reimplemented
        **incomingConnection** () if you do not want to break the Pending
        Connections mechanism.

        **See also** **incomingConnection** ().
        """
        ...

    def close(self) -> None:
        """
        https://doc.qt.io/qt-6/qtcpserver.html#close

        **void QTcpServer::close()**

        Closes the server. The server will no longer listen for incoming
        connections.

        **See also** **listen** ().
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-6/qtcpserver.html#errorString

        **QString QTcpServer::errorString() const**

        Returns a human readable description of the last error that occurred.

        **See also** **serverError** ().
        """
        ...

    def hasPendingConnections(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtcpserver.html#hasPendingConnections

        **[virtual] bool QTcpServer::hasPendingConnections() const**

        Returns `true` if the server has a pending connection; otherwise returns
        `false`.

        **See also** **nextPendingConnection** () and
        **setMaxPendingConnections** ().
        """
        ...

    def incomingConnection(self, handle: int) -> None:
        """
        https://doc.qt.io/qt-6/qtcpserver.html#incomingConnection

        **[virtual protected] void QTcpServer::incomingConnection(qintptr
        socketDescriptor )**

        This virtual function is called by **QTcpServer**  when a new connection
        is available. The **socketDescriptor** argument is the native socket
        descriptor for the accepted connection.

        The base implementation creates a **QTcpSocket** , sets the socket
        descriptor and then stores the **QTcpSocket**  in an internal list of
        pending connections. Finally **newConnection** () is emitted.

        Reimplement this function to alter the server's behavior when a
        connection is available.

        If this server is using **QNetworkProxy**  then the **socketDescriptor**
        may not be usable with native socket functions, and should only be used
        with **QTcpSocket::setSocketDescriptor** ().

        **Note:** If another socket is created in the reimplementation of this
        method, it needs to be added to the Pending Connections mechanism by
        calling **addPendingConnection** ().

        **Note:** If you want to handle an incoming connection as a new
        **QTcpSocket**  object in another thread you have to pass the
        **socketDescriptor**  to the other thread and create the **QTcpSocket**
        object there and use its **setSocketDescriptor** () method.

        **See also** **newConnection** (), **nextPendingConnection** (), and
        **addPendingConnection** ().
        """
        ...

    def isListening(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtcpserver.html#isListening

        **bool QTcpServer::isListening() const**

        Returns `true` if the server is currently listening for incoming
        connections; otherwise returns `false`.

        **See also** **listen** ().
        """
        ...

    def listen(
        self,
        address: Union[
            PySide6.QtNetwork.QHostAddress,
            PySide6.QtNetwork.QHostAddress.SpecialAddress,
        ] = ...,
        port: int = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qtcpserver.html#listen

        **bool QTcpServer::listen(const QHostAddress & address =
        QHostAddress::Any, quint16 port = 0)**

        Tells the server to listen for incoming connections on address
        **address** and port **port**. If **port** is 0, a port is chosen
        automatically. If **address** is **QHostAddress::Any** , the server will
        listen on all network interfaces.

        Returns `true` on success; otherwise returns `false`.

        **See also** **isListening** ().
        """
        ...

    def maxPendingConnections(self) -> int:
        """
        https://doc.qt.io/qt-6/qtcpserver.html#maxPendingConnections

        **int QTcpServer::maxPendingConnections() const**

        Returns the maximum number of pending accepted connections. The default
        is 30.

        **See also** **setMaxPendingConnections** () and
        **hasPendingConnections** ().
        """
        ...

    def nextPendingConnection(self) -> PySide6.QtNetwork.QTcpSocket:
        """
        https://doc.qt.io/qt-6/qtcpserver.html#nextPendingConnection

        **[virtual] QTcpSocket *QTcpServer::nextPendingConnection()**

        Returns the next pending connection as a connected **QTcpSocket**
        object.

        The socket is created as a child of the server, which means that it is
        automatically deleted when the **QTcpServer**  object is destroyed. It
        is still a good idea to delete the object explicitly when you are done
        with it, to avoid wasting memory.

        `nullptr` is returned if this function is called when there are no
        pending connections.

        **Note:** The returned **QTcpSocket**  object cannot be used from
        another thread. If you want to use an incoming connection from another
        thread, you need to override **incomingConnection** ().

        **See also** **hasPendingConnections** ().
        """
        ...

    def pauseAccepting(self) -> None:
        """
        https://doc.qt.io/qt-6/qtcpserver.html#pauseAccepting

        **[since 5.0] void QTcpServer::pauseAccepting()**

        Pauses accepting new connections. Queued connections will remain in
        queue.

        This function was introduced in Qt 5.0.

        **See also** **resumeAccepting** ().
        """
        ...

    def proxy(self) -> PySide6.QtNetwork.QNetworkProxy:
        """
        https://doc.qt.io/qt-6/qtcpserver.html#proxy

        **QNetworkProxy QTcpServer::proxy() const**

        Returns the network proxy for this socket. By default
        **QNetworkProxy::DefaultProxy**  is used.

        **See also** **setProxy** () and **QNetworkProxy** .
        """
        ...

    def resumeAccepting(self) -> None:
        """
        https://doc.qt.io/qt-6/qtcpserver.html#resumeAccepting

        **[since 5.0] void QTcpServer::resumeAccepting()**

        Resumes accepting new connections.

        This function was introduced in Qt 5.0.

        **See also** **pauseAccepting** ().
        """
        ...

    def serverAddress(self) -> PySide6.QtNetwork.QHostAddress:
        """
        https://doc.qt.io/qt-6/qtcpserver.html#serverAddress

        **QHostAddress QTcpServer::serverAddress() const**

        Returns the server's address if the server is listening for connections;
        otherwise returns **QHostAddress::Null** .

        **See also** **serverPort** () and **listen** ().
        """
        ...

    def serverError(self) -> PySide6.QtNetwork.QAbstractSocket.SocketError:
        """
        https://doc.qt.io/qt-6/qtcpserver.html#serverError

        **QAbstractSocket::SocketError QTcpServer::serverError() const**

        Returns an error code for the last error that occurred.

        **See also** **errorString** ().
        """
        ...

    def serverPort(self) -> int:
        """
        https://doc.qt.io/qt-6/qtcpserver.html#serverPort

        **quint16 QTcpServer::serverPort() const**

        Returns the server's port if the server is listening for connections;
        otherwise returns 0.

        **See also** **serverAddress** () and **listen** ().
        """
        ...

    def setMaxPendingConnections(self, numConnections: int) -> None:
        """
        https://doc.qt.io/qt-6/qtcpserver.html#setMaxPendingConnections

        **void QTcpServer::setMaxPendingConnections(int numConnections )**

        Sets the maximum number of pending accepted connections to
        **numConnections**. **QTcpServer**  will accept no more than
        **numConnections** incoming connections before **nextPendingConnection**
        () is called. By default, the limit is 30 pending connections.

        Clients may still able to connect after the server has reached its
        maximum number of pending connections (i.e., **QTcpSocket**  can still
        emit the connected() signal). **QTcpServer**  will stop accepting the
        new connections, but the operating system may still keep them in queue.

        **See also** **maxPendingConnections** () and **hasPendingConnections**
        ().
        """
        ...

    def setProxy(
        self,
        networkProxy: Union[
            PySide6.QtNetwork.QNetworkProxy, PySide6.QtNetwork.QNetworkProxy.ProxyType
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qtcpserver.html#setProxy

        **void QTcpServer::setProxy(const QNetworkProxy & networkProxy )**

        Sets the explicit network proxy for this socket to **networkProxy**.

        To disable the use of a proxy for this socket, use the
        **QNetworkProxy::NoProxy**  proxy type:

        server->setProxy(**QNetworkProxy** ::NoProxy);

        **See also** **proxy** () and **QNetworkProxy** .
        """
        ...

    def setSocketDescriptor(self, socketDescriptor: int) -> bool:
        """
        https://doc.qt.io/qt-6/qtcpserver.html#setSocketDescriptor

        **bool QTcpServer::setSocketDescriptor(qintptr socketDescriptor )**

        Sets the socket descriptor this server should use when listening for
        incoming connections to **socketDescriptor**. Returns `true` if the
        socket is set successfully; otherwise returns `false`.

        The socket is assumed to be in listening state.

        **See also** **socketDescriptor** () and **isListening** ().
        """
        ...

    def socketDescriptor(self) -> int:
        """
        https://doc.qt.io/qt-6/qtcpserver.html#socketDescriptor

        **qintptr QTcpServer::socketDescriptor() const**

        Returns the native socket descriptor the server uses to listen for
        incoming instructions, or -1 if the server is not listening.

        If the server is using **QNetworkProxy** , the returned descriptor may
        not be usable with native socket functions.

        **See also** **setSocketDescriptor** () and **isListening** ().
        """
        ...

    def waitForNewConnection(self, msec: int) -> Tuple[Tuple, bool]:
        """
        https://doc.qt.io/qt-6/qtcpserver.html#waitForNewConnection

        **bool QTcpServer::waitForNewConnection(int msec = 0, bool * timedOut =
        nullptr)**

        Waits for at most **msec** milliseconds or until an incoming connection
        is available. Returns `true` if a connection is available; otherwise
        returns `false`. If the operation timed out and **timedOut** is not
        `nullptr`, * **timedOut** will be set to true.

        This is a blocking function call. Its use is disadvised in a single-
        threaded GUI application, since the whole application will stop
        responding until the function returns. waitForNewConnection() is mostly
        useful when there is no event loop available.

        The non-blocking alternative is to connect to the **newConnection** ()
        signal.

        If msec is -1, this function will not time out.

        **See also** **hasPendingConnections** () and **nextPendingConnection**
        ().
        """
        ...

    @property
    def acceptError(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtcpserver.html#acceptError

        **[signal, since 5.0] void
        QTcpServer::acceptError(QAbstractSocket::SocketError socketError )**

        This signal is emitted when accepting a new connection results in an
        error. The **socketError** parameter describes the type of error that
        occurred.

        This function was introduced in Qt 5.0.

        **See also** **pauseAccepting** () and **resumeAccepting** ().
        """
        ...

    @property
    def newConnection(self) -> PySide6.QtCore.SignalInstance:
        """
        https://doc.qt.io/qt-6/qtcpserver.html#newConnection

        **[signal] void QTcpServer::newConnection()**

        This signal is emitted every time a new connection is available.

        **See also** **hasPendingConnections** () and **nextPendingConnection**
        ().
        """
        ...
