"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtNetwork, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Any, Dict, List, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtNetwork

bytes = str


class QSslConfiguration(object):
    """
    https://doc.qt.io/qt-6/qsslconfiguration.html

    **Detailed Description**

    QSslConfiguration is used by Qt networking classes to relay information
    about an open SSL connection and to allow the application to control certain
    features of that connection.

    The settings that QSslConfiguration currently supports are:

    * The SSL/TLS protocol to be used
      * The certificate to be presented to the
    peer during connection and its associated private key
      * The ciphers
    allowed to be used for encrypting the connection
      * The list of Certificate
    Authorities certificates that are used to validate the peer's certificate

    These settings are applied only during the connection handshake. Setting
    them after the connection has been established has no effect.

    The state that QSslConfiguration supports are:

    * The certificate the peer presented during handshake, along with the chain
    leading to a CA certificate
      * The cipher used to encrypt this session

    The state can only be obtained once the SSL connection starts, but not
    necessarily before it's done. Some settings may change during the course of
    the SSL connection without need to restart it (for instance, the cipher can
    be changed over time).

    State in QSslConfiguration objects cannot be changed.

    QSslConfiguration can be used with **QSslSocket**  and the Network Access
    API.

    Note that changing settings in QSslConfiguration is not enough to change the
    settings in the related SSL connection. You must call setSslConfiguration on
    a modified QSslConfiguration object to achieve that. The following example
    illustrates how to change the protocol to TLSv1_0 in a **QSslSocket**
    object:

    **QSslConfiguration**  config = sslSocket.sslConfiguration();
    config.setProtocol(QSsl::TlsV1_0);
    sslSocket.setSslConfiguration(config);

    **See also** **QSsl::SslProtocol** , **QSslCertificate** , **QSslCipher** ,
    **QSslKey** , **QSslSocket** , **QNetworkAccessManager** ,
    **QSslSocket::sslConfiguration** (), and **QSslSocket::setSslConfiguration**
    ().
    """

    NextProtocolNegotiationNone: QSslConfiguration.NextProtocolNegotiationStatus = ...
    NextProtocolNegotiationNegotiated: QSslConfiguration.NextProtocolNegotiationStatus = (
        ...
    )
    NextProtocolNegotiationUnsupported: QSslConfiguration.NextProtocolNegotiationStatus = (
        ...
    )

    class NextProtocolNegotiationStatus(Enum):
        NextProtocolNegotiationNone: QSslConfiguration.NextProtocolNegotiationStatus = (
            ...
        )
        NextProtocolNegotiationNegotiated: QSslConfiguration.NextProtocolNegotiationStatus = (
            ...
        )
        NextProtocolNegotiationUnsupported: QSslConfiguration.NextProtocolNegotiationStatus = (
            ...
        )

    @overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#QSslConfiguration

        **QSslConfiguration::QSslConfiguration()**

        Constructs an empty SSL configuration. This configuration contains no
        valid settings and the state will be empty. **isNull** () will return
        true after this constructor is called.

        Once any setter methods are called, **isNull** () will return false.
        """
        ...

    @overload
    def __init__(self, other: PySide6.QtNetwork.QSslConfiguration) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#QSslConfiguration-1

        **QSslConfiguration::QSslConfiguration(const QSslConfiguration & other
        )**

        Copies the configuration and state of **other**. If **other** is null,
        this object will be null too.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def addCaCertificate(
        self,
        certificate: Union[PySide6.QtNetwork.QSslCertificate, PySide6.QtCore.QIODevice],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#addCaCertificate

        **[since 5.15] void QSslConfiguration::addCaCertificate(const
        QSslCertificate & certificate )**

        Adds **certificate** to this configuration's CA certificate database.
        The certificate database must be set prior to the SSL handshake. The CA
        certificate database is used by the socket during the handshake phase to
        validate the peer's certificate.

        **Note:** The default configuration uses the system CA certificate
        database. If that is not available (as is commonly the case on iOS), the
        default database is empty.

        This function was introduced in Qt 5.15.

        **See also** **caCertificates** (), **setCaCertificates** (), and
        **addCaCertificates** ().
        """
        ...

    @overload
    def addCaCertificates(
        self, certificates: Sequence[PySide6.QtNetwork.QSslCertificate]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#addCaCertificates

        **[since 5.15] bool QSslConfiguration::addCaCertificates(const QString &
        path , QSsl::EncodingFormat format = QSsl::Pem,
        QSslCertificate::PatternSyntax syntax =
        QSslCertificate::PatternSyntax::FixedString)**

        Searches all files in the **path** for certificates encoded in the
        specified **format** and adds them to this socket's CA certificate
        database. **path** must be a file or a pattern matching one or more
        files, as specified by **syntax**. Returns `true` if one or more
        certificates are added to the socket's CA certificate database;
        otherwise returns `false`.

        The CA certificate database is used by the socket during the handshake
        phase to validate the peer's certificate.

        For more precise control, use **addCaCertificate** ().

        This function was introduced in Qt 5.15.

        **See also** **addCaCertificate** () and **QSslCertificate::fromPath**
        ().
        """
        ...

    @overload
    def addCaCertificates(
        self,
        path: str,
        format: PySide6.QtNetwork.QSsl.EncodingFormat = ...,
        syntax: PySide6.QtNetwork.QSslCertificate.PatternSyntax = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#addCaCertificates-1

        **[since 5.15] void QSslConfiguration::addCaCertificates(const
        QList<QSslCertificate> & certificates )**

        Adds **certificates** to this configuration's CA certificate database.
        The certificate database must be set prior to the SSL handshake. The CA
        certificate database is used by the socket during the handshake phase to
        validate the peer's certificate.

        **Note:** The default configuration uses the system CA certificate
        database. If that is not available (as is commonly the case on iOS), the
        default database is empty.

        This function was introduced in Qt 5.15.

        **See also** **caCertificates** (), **setCaCertificates** (), and
        **addCaCertificate** ().
        """
        ...

    def allowedNextProtocols(self) -> List[PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#allowedNextProtocols

        **[since 5.3] QList<QByteArray>
        QSslConfiguration::allowedNextProtocols() const**

        This function returns the allowed protocols to be negotiated with the
        server through the Next Protocol Negotiation (NPN) or Application-Layer
        Protocol Negotiation (ALPN) TLS extension, as set by
        **setAllowedNextProtocols** ().

        This function was introduced in Qt 5.3.

        **See also** **nextNegotiatedProtocol** (),
        **nextProtocolNegotiationStatus** (), **setAllowedNextProtocols** (),
        and **QSslConfiguration::NextProtocolHttp1_1** .
        """
        ...

    def backendConfiguration(self) -> Dict[PySide6.QtCore.QByteArray, Any]:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#backendConfiguration

        **[since 5.11] QMap<QByteArray, QVariant>
        QSslConfiguration::backendConfiguration() const**

        Returns the backend-specific configuration.

        Only options set by **setBackendConfigurationOption** () or
        **setBackendConfiguration** () will be returned. The internal standard
        configuration of the backend is not reported.

        This function was introduced in Qt 5.11.

        **See also** **setBackendConfigurationOption** () and
        **setBackendConfiguration** ().
        """
        ...

    def caCertificates(self) -> List[PySide6.QtNetwork.QSslCertificate]:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#caCertificates

        **QList<QSslCertificate> QSslConfiguration::caCertificates() const**

        Returns this connection's CA certificate database. The CA certificate
        database is used by the socket during the handshake phase to validate
        the peer's certificate. It can be modified prior to the handshake with
        **setCaCertificates** (), or with **addCaCertificate** () and
        **addCaCertificates** ().

        **See also** **setCaCertificates** (), **addCaCertificate** (), and
        **addCaCertificates** ().
        """
        ...

    def ciphers(self) -> List[PySide6.QtNetwork.QSslCipher]:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#ciphers

        **QList<QSslCipher> QSslConfiguration::ciphers() const**

        Returns this connection's current cryptographic cipher suite. This list
        is used during the handshake phase for choosing a session cipher. The
        returned list of ciphers is ordered by descending preference. (i.e., the
        first cipher in the list is the most preferred cipher). The session
        cipher will be the first one in the list that is also supported by the
        peer.

        By default, the handshake phase can choose any of the ciphers supported
        by this system's SSL libraries, which may vary from system to system.
        The list of ciphers supported by this system's SSL libraries is returned
        by **supportedCiphers** (). You can restrict the list of ciphers used
        for choosing the session cipher for this socket by calling
        **setCiphers** () with a subset of the supported ciphers. You can revert
        to using the entire set by calling **setCiphers** () with the list
        returned by **supportedCiphers** ().

        **Note:** This is not currently supported in the Schannel backend.

        **See also** **setCiphers** () and **supportedCiphers** ().
        """
        ...

    @staticmethod
    def defaultConfiguration() -> PySide6.QtNetwork.QSslConfiguration:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#defaultConfiguration

        **[static] QSslConfiguration QSslConfiguration::defaultConfiguration()**

        Returns the default SSL configuration to be used in new SSL connections.

        The default SSL configuration consists of:

        * no local certificate and no private key
          * protocol
        **SecureProtocols**
          * the system's default CA certificate list
          *
        the cipher list equal to the list of the SSL libraries' supported SSL
        ciphers that are 128 bits or more

        **See also** **supportedCiphers** () and **setDefaultConfiguration** ().
        """
        ...

    @staticmethod
    def defaultDtlsConfiguration() -> PySide6.QtNetwork.QSslConfiguration:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#defaultDtlsConfiguration

        **[static] QSslConfiguration
        QSslConfiguration::defaultDtlsConfiguration()**

        Returns the default DTLS configuration to be used in new DTLS
        connections.

        The default DTLS configuration consists of:

        * no local certificate and no private key
          * protocol DtlsV1_2OrLater
        * the system's default CA certificate list
          * the cipher list equal to
        the list of the SSL libraries' supported TLS 1.2 ciphers that use 128 or
        more secret bits for the cipher.

        **See also** **setDefaultDtlsConfiguration** ().
        """
        ...

    def diffieHellmanParameters(self) -> PySide6.QtNetwork.QSslDiffieHellmanParameters:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#diffieHellmanParameters

        **[since 5.8] QSslDiffieHellmanParameters
        QSslConfiguration::diffieHellmanParameters() const**

        Retrieves the current set of Diffie-Hellman parameters.

        If no Diffie-Hellman parameters have been set, the **QSslConfiguration**
        object defaults to using the 1024-bit MODP group from RFC 2409.

        This function was introduced in Qt 5.8.

        **See also** **setDiffieHellmanParameters** ().
        """
        ...

    def dtlsCookieVerificationEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#dtlsCookieVerificationEnab
        led

        **bool QSslConfiguration::dtlsCookieVerificationEnabled() const**

        This function returns true if DTLS cookie verification was enabled on a
        server-side socket.

        **See also** **setDtlsCookieVerificationEnabled** ().
        """
        ...

    def ellipticCurves(self) -> List[PySide6.QtNetwork.QSslEllipticCurve]:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#ellipticCurves

        **[since 5.5] QList<QSslEllipticCurve>
        QSslConfiguration::ellipticCurves() const**

        Returns this connection's current list of elliptic curves. This list is
        used during the handshake phase for choosing an elliptic curve (when
        using an elliptic curve cipher). The returned list of curves is ordered
        by descending preference (i.e., the first curve in the list is the most
        preferred one).

        By default, the handshake phase can choose any of the curves supported
        by this system's SSL libraries, which may vary from system to system.
        The list of curves supported by this system's SSL libraries is returned
        by QSslSocket::supportedEllipticCurves().

        You can restrict the list of curves used for choosing the session cipher
        for this socket by calling **setEllipticCurves** () with a subset of the
        supported ciphers. You can revert to using the entire set by calling
        **setEllipticCurves** () with the list returned by
        QSslSocket::supportedEllipticCurves().

        This function was introduced in Qt 5.5.

        **See also** **setEllipticCurves** .
        """
        ...

    def ephemeralServerKey(self) -> PySide6.QtNetwork.QSslKey:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#ephemeralServerKey

        **[since 5.7] QSslKey QSslConfiguration::ephemeralServerKey() const**

        Returns the ephemeral server key used for cipher algorithms with forward
        secrecy, e.g. DHE-RSA-AES128-SHA.

        The ephemeral key is only available when running in client mode, i.e.
        **QSslSocket::SslClientMode** . When running in server mode or using a
        cipher algorithm without forward secrecy a null key is returned. The
        ephemeral server key will be set before emitting the encrypted() signal.

        This function was introduced in Qt 5.7.
        """
        ...

    def handshakeMustInterruptOnError(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#handshakeMustInterruptOnEr
        ror

        **[since 6.0] bool QSslConfiguration::handshakeMustInterruptOnError()
        const**

        Returns true if a verification callback will emit
        **QSslSocket::handshakeInterruptedOnError** () early, before concluding
        the handshake.

        **Note:** This function always returns false for all backends but
        OpenSSL.

        This function was introduced in Qt 6.0.

        **See also** **setHandshakeMustInterruptOnError** (),
        **QSslSocket::handshakeInterruptedOnError** (), and
        **QSslSocket::continueInterruptedHandshake** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#isNull

        **bool QSslConfiguration::isNull() const**

        Returns `true` if this is a null **QSslConfiguration**  object.

        A **QSslConfiguration**  object is null if it has been default-
        constructed and no setter methods have been called.

        **See also** **setProtocol** (), **setLocalCertificate** (),
        **setPrivateKey** (), **setCiphers** (), and **setCaCertificates** ().
        """
        ...

    def localCertificate(self) -> PySide6.QtNetwork.QSslCertificate:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#localCertificate

        **QSslCertificate QSslConfiguration::localCertificate() const**

        Returns the certificate to be presented to the peer during the SSL
        handshake process.

        **See also** **setLocalCertificate** ().
        """
        ...

    def localCertificateChain(self) -> List[PySide6.QtNetwork.QSslCertificate]:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#localCertificateChain

        **[since 5.1] QList<QSslCertificate>
        QSslConfiguration::localCertificateChain() const**

        Returns the certificate chain to be presented to the peer during the SSL
        handshake process.

        This function was introduced in Qt 5.1.

        **See also** **setLocalCertificateChain** () and **localCertificate**
        ().
        """
        ...

    def missingCertificateIsFatal(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#missingCertificateIsFatal

        **[since 6.0] bool QSslConfiguration::missingCertificateIsFatal()
        const**

        Returns true if errors with code **QSslError::NoPeerCertificate**
        cannot be ignored.

        **Note:** Always returns false for all TLS backends but OpenSSL.

        This function was introduced in Qt 6.0.

        **See also** **QSslSocket::ignoreSslErrors** () and
        **setMissingCertificateIsFatal** ().
        """
        ...

    def nextNegotiatedProtocol(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#nextNegotiatedProtocol

        **[since 5.3] QByteArray QSslConfiguration::nextNegotiatedProtocol()
        const**

        This function returns the protocol negotiated with the server if the
        Next Protocol Negotiation (NPN) or Application-Layer Protocol
        Negotiation (ALPN) TLS extension was enabled. In order for the NPN/ALPN
        extension to be enabled, **setAllowedNextProtocols** () needs to be
        called explicitly before connecting to the server.

        If no protocol could be negotiated or the extension was not enabled,
        this function returns a **QByteArray**  which is null.

        This function was introduced in Qt 5.3.

        **See also** **setAllowedNextProtocols** () and
        **nextProtocolNegotiationStatus** ().
        """
        ...

    def nextProtocolNegotiationStatus(
        self,
    ) -> PySide6.QtNetwork.QSslConfiguration.NextProtocolNegotiationStatus:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#nextProtocolNegotiationSta
        tus

        **[since 5.3] QSslConfiguration::NextProtocolNegotiationStatus
        QSslConfiguration::nextProtocolNegotiationStatus() const**

        This function returns the status of the Next Protocol Negotiation (NPN)
        or Application-Layer Protocol Negotiation (ALPN). If the feature has not
        been enabled through **setAllowedNextProtocols** (), this function
        returns **NextProtocolNegotiationNone** . The status will be set before
        emitting the encrypted() signal.

        This function was introduced in Qt 5.3.

        **See also** **setAllowedNextProtocols** (), **allowedNextProtocols**
        (), **nextNegotiatedProtocol** (), and
        **QSslConfiguration::NextProtocolNegotiationStatus** .
        """
        ...

    def ocspStaplingEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#ocspStaplingEnabled

        **[since 5.13] bool QSslConfiguration::ocspStaplingEnabled() const**

        Returns true if OCSP stapling was enabled by setOCSPStaplingEnabled(),
        otherwise false (which is the default value).

        This function was introduced in Qt 5.13.

        **See also** **setOcspStaplingEnabled** ().
        """
        ...

    def peerCertificate(self) -> PySide6.QtNetwork.QSslCertificate:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#peerCertificate

        **QSslCertificate QSslConfiguration::peerCertificate() const**

        Returns the peer's digital certificate (i.e., the immediate certificate
        of the host you are connected to), or a null certificate, if the peer
        has not assigned a certificate.

        The peer certificate is checked automatically during the handshake
        phase, so this function is normally used to fetch the certificate for
        display or for connection diagnostic purposes. It contains information
        about the peer, including its host name, the certificate issuer, and the
        peer's public key.

        Because the peer certificate is set during the handshake phase, it is
        safe to access the peer certificate from a slot connected to the
        **QSslSocket::sslErrors** () signal, **QNetworkReply::sslErrors** ()
        signal, or the **QSslSocket::encrypted** () signal.

        If a null certificate is returned, it can mean the SSL handshake failed,
        or it can mean the host you are connected to doesn't have a certificate,
        or it can mean there is no connection.

        If you want to check the peer's complete chain of certificates, use
        **peerCertificateChain** () to get them all at once.

        **See also** **peerCertificateChain** (), **QSslSocket::sslErrors** (),
        **QSslSocket::ignoreSslErrors** (), **QNetworkReply::sslErrors** (), and
        **QNetworkReply::ignoreSslErrors** ().
        """
        ...

    def peerCertificateChain(self) -> List[PySide6.QtNetwork.QSslCertificate]:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#peerCertificateChain

        **QList<QSslCertificate> QSslConfiguration::peerCertificateChain()
        const**

        Returns the peer's chain of digital certificates, starting with the
        peer's immediate certificate and ending with the CA's certificate.

        Peer certificates are checked automatically during the handshake phase.
        This function is normally used to fetch certificates for display, or for
        performing connection diagnostics. Certificates contain information
        about the peer and the certificate issuers, including host name, issuer
        names, and issuer public keys.

        Because the peer certificate is set during the handshake phase, it is
        safe to access the peer certificate from a slot connected to the
        **QSslSocket::sslErrors** () signal, **QNetworkReply::sslErrors** ()
        signal, or the **QSslSocket::encrypted** () signal.

        If an empty list is returned, it can mean the SSL handshake failed, or
        it can mean the host you are connected to doesn't have a certificate, or
        it can mean there is no connection.

        If you want to get only the peer's immediate certificate, use
        **peerCertificate** ().

        **See also** **peerCertificate** (), **QSslSocket::sslErrors** (),
        **QSslSocket::ignoreSslErrors** (), **QNetworkReply::sslErrors** (), and
        **QNetworkReply::ignoreSslErrors** ().
        """
        ...

    def peerVerifyDepth(self) -> int:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#peerVerifyDepth

        **int QSslConfiguration::peerVerifyDepth() const**

        Returns the maximum number of certificates in the peer's certificate
        chain to be checked during the SSL handshake phase, or 0 (the default)
        if no maximum depth has been set, indicating that the whole certificate
        chain should be checked.

        The certificates are checked in issuing order, starting with the peer's
        own certificate, then its issuer's certificate, and so on.

        **See also** **setPeerVerifyDepth** () and **peerVerifyMode** ().
        """
        ...

    def peerVerifyMode(self) -> PySide6.QtNetwork.QSslSocket.PeerVerifyMode:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#peerVerifyMode

        **QSslSocket::PeerVerifyMode QSslConfiguration::peerVerifyMode() const**

        Returns the verify mode. This mode decides whether **QSslSocket**
        should request a certificate from the peer (i.e., the client requests a
        certificate from the server, or a server requesting a certificate from
        the client), and whether it should require that this certificate is
        valid.

        The default mode is AutoVerifyPeer, which tells **QSslSocket**  to use
        VerifyPeer for clients, QueryPeer for servers.

        **See also** **setPeerVerifyMode** ().
        """
        ...

    def preSharedKeyIdentityHint(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#preSharedKeyIdentityHint

        **[since 5.8] QByteArray QSslConfiguration::preSharedKeyIdentityHint()
        const**

        Returns the identity hint.

        This function was introduced in Qt 5.8.

        **See also** **setPreSharedKeyIdentityHint** ().
        """
        ...

    def privateKey(self) -> PySide6.QtNetwork.QSslKey:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#privateKey

        **QSslKey QSslConfiguration::privateKey() const**

        Returns the **SSL key**  assigned to this connection or a null key if
        none has been assigned yet.

        **See also** **setPrivateKey** () and **localCertificate** ().
        """
        ...

    def protocol(self) -> PySide6.QtNetwork.QSsl.SslProtocol:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#protocol

        **QSsl::SslProtocol QSslConfiguration::protocol() const**

        Returns the protocol setting for this SSL configuration.

        **See also** **setProtocol** ().
        """
        ...

    def sessionCipher(self) -> PySide6.QtNetwork.QSslCipher:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#sessionCipher

        **QSslCipher QSslConfiguration::sessionCipher() const**

        Returns the socket's cryptographic **cipher** , or a null cipher if the
        connection isn't encrypted. The socket's cipher for the session is set
        during the handshake phase. The cipher is used to encrypt and decrypt
        data transmitted through the socket.

        The SSL infrastructure also provides functions for setting the ordered
        list of ciphers from which the handshake phase will eventually select
        the session cipher. This ordered list must be in place before the
        handshake phase begins.

        **See also** **ciphers** (), **setCiphers** (), and **supportedCiphers**
        ().
        """
        ...

    def sessionProtocol(self) -> PySide6.QtNetwork.QSsl.SslProtocol:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#sessionProtocol

        **[since 5.4] QSsl::SslProtocol QSslConfiguration::sessionProtocol()
        const**

        Returns the socket's SSL/TLS protocol or UnknownProtocol if the
        connection isn't encrypted. The socket's protocol for the session is set
        during the handshake phase.

        This function was introduced in Qt 5.4.

        **See also** **protocol** () and **setProtocol** ().
        """
        ...

    def sessionTicket(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#sessionTicket

        **[since 5.2] QByteArray QSslConfiguration::sessionTicket() const**

        If **QSsl::SslOptionDisableSessionPersistence**  was turned off, this
        function returns the session ticket used in the SSL handshake in ASN.1
        format, suitable to e.g. be persisted to disk. If no session ticket was
        used or **QSsl::SslOptionDisableSessionPersistence**  was not turned
        off, this function returns an empty **QByteArray** .

        **Note:** When persisting the session ticket to disk or similar, be
        careful not to expose the session to a potential attacker, as knowledge
        of the session allows for eavesdropping on data encrypted with the
        session parameters.

        This function was introduced in Qt 5.2.

        **See also** **setSessionTicket** (),
        **QSsl::SslOptionDisableSessionPersistence** , **setSslOption** (), and
        **QSslSocket::newSessionTicketReceived** ().
        """
        ...

    def sessionTicketLifeTimeHint(self) -> int:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#sessionTicketLifeTimeHint

        **[since 5.2] int QSslConfiguration::sessionTicketLifeTimeHint() const**

        If **QSsl::SslOptionDisableSessionPersistence**  was turned off, this
        function returns the session ticket life time hint sent by the server
        (which might be 0). If the server did not send a session ticket (e.g.
        when resuming a session or when the server does not support it) or
        **QSsl::SslOptionDisableSessionPersistence**  was not turned off, this
        function returns -1.

        This function was introduced in Qt 5.2.

        **See also** **sessionTicket** (),
        **QSsl::SslOptionDisableSessionPersistence** , **setSslOption** (), and
        **QSslSocket::newSessionTicketReceived** ().
        """
        ...

    def setAllowedNextProtocols(
        self, protocols: Sequence[PySide6.QtCore.QByteArray]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#setAllowedNextProtocols

        **[since 5.3] void QSslConfiguration::setAllowedNextProtocols(const
        QList<QByteArray> & protocols )**

        This function sets the allowed **protocols** to be negotiated with the
        server through the Next Protocol Negotiation (NPN) or Application-Layer
        Protocol Negotiation (ALPN) TLS extension; each element in **protocols**
        must define one allowed protocol. The function must be called explicitly
        before connecting to send the NPN/ALPN extension in the SSL handshake.
        Whether or not the negotiation succeeded can be queried through
        **nextProtocolNegotiationStatus** ().

        This function was introduced in Qt 5.3.

        **See also** **nextNegotiatedProtocol** (),
        **nextProtocolNegotiationStatus** (), **allowedNextProtocols** (), and
        **QSslConfiguration::NextProtocolHttp1_1** .
        """
        ...

    def setBackendConfiguration(
        self, backendConfiguration: Dict[PySide6.QtCore.QByteArray, Any] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#setBackendConfiguration

        **[since 5.11] void QSslConfiguration::setBackendConfiguration(const
        QMap<QByteArray, QVariant> & backendConfiguration = QMap<QByteArray,
        QVariant>())**

        Sets or clears the backend-specific configuration.

        Without a **backendConfiguration** parameter this function will clear
        the backend-specific configuration. More information about the supported
        options is available in the documentation of
        **setBackendConfigurationOption** ().

        This function was introduced in Qt 5.11.

        **See also** **backendConfiguration** () and
        **setBackendConfigurationOption** ().
        """
        ...

    def setBackendConfigurationOption(
        self, name: Union[PySide6.QtCore.QByteArray, bytes], value: Any
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#setBackendConfigurationOpt
        ion

        **[since 5.11] void
        QSslConfiguration::setBackendConfigurationOption(const QByteArray & name
        , const QVariant & value )**

        Sets the option **name** in the backend-specific configuration to
        **value**.

        Options supported by the OpenSSL (>= 1.0.2) backend are available in the
        **supported configuration file commands**  documentation. The expected
        type for the **value** parameter is a **QByteArray**  for all options.
        The **examples**  show how to use some of the options.

        **Note:** The backend-specific configuration will be applied after the
        general configuration. Using the backend-specific configuration to set a
        general configuration option again will overwrite the general
        configuration option.

        This function was introduced in Qt 5.11.

        **See also** **backendConfiguration** () and **setBackendConfiguration**
        ().
        """
        ...

    def setCaCertificates(
        self, certificates: Sequence[PySide6.QtNetwork.QSslCertificate]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#setCaCertificates

        **void QSslConfiguration::setCaCertificates(const QList<QSslCertificate>
        & certificates )**

        Sets this socket's CA certificate database to be **certificates**. The
        certificate database must be set prior to the SSL handshake. The CA
        certificate database is used by the socket during the handshake phase to
        validate the peer's certificate.

        **Note:** The default configuration uses the system CA certificate
        database. If that is not available (as is commonly the case on iOS), the
        default database is empty.

        **See also** **caCertificates** (), **addCaCertificates** (), and
        **addCaCertificate** ().
        """
        ...

    @overload
    def setCiphers(self, ciphers: Sequence[PySide6.QtNetwork.QSslCipher]) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#setCiphers

        **void QSslConfiguration::setCiphers(const QList<QSslCipher> & ciphers
        )**

        Sets the cryptographic cipher suite for this socket to **ciphers** ,
        which must contain a subset of the ciphers in the list returned by
        **supportedCiphers** ().

        Restricting the cipher suite must be done before the handshake phase,
        where the session cipher is chosen.

        **Note:** This is not currently supported in the Schannel backend.

        **See also** **ciphers** () and **supportedCiphers** ().
        """
        ...

    @overload
    def setCiphers(self, ciphers: str) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#setCiphers-1

        **[since 6.0] void QSslConfiguration::setCiphers(const QString & ciphers
        )**

        Sets the cryptographic cipher suite for this configuration to
        **ciphers** , which is a colon-separated list of cipher suite names. The
        ciphers are listed in order of preference, starting with the most
        preferred cipher. For example:

        **QSslConfiguration**  tlsConfig = **QSslConfiguration**
        ::defaultConfiguration();
            tlsConfig.setCiphers(**QStringLiteral**
        ("DHE-RSA-AES256-SHA:DHE-DSS-AES256-SHA:AES256-SHA"));

        Each cipher name in **ciphers** must be the name of a cipher in the list
        returned by **supportedCiphers** (). Restricting the cipher suite must
        be done before the handshake phase, where the session cipher is chosen.

        **Note:** This is not currently supported in the Schannel backend.

        This function was introduced in Qt 6.0.

        **See also** **ciphers** ().
        """
        ...

    @staticmethod
    def setDefaultConfiguration(
        configuration: PySide6.QtNetwork.QSslConfiguration,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#setDefaultConfiguration

        **[static] void QSslConfiguration::setDefaultConfiguration(const
        QSslConfiguration & configuration )**

        Sets the default SSL configuration to be used in new SSL connections to
        be **configuration**. Existing connections are not affected by this
        call.

        **See also** **supportedCiphers** () and **defaultConfiguration** ().
        """
        ...

    @staticmethod
    def setDefaultDtlsConfiguration(
        configuration: PySide6.QtNetwork.QSslConfiguration,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#setDefaultDtlsConfiguratio
        n

        **[static] void QSslConfiguration::setDefaultDtlsConfiguration(const
        QSslConfiguration & configuration )**

        Sets the default DTLS configuration to be used in new DTLS connections
        to be **configuration**. Existing connections are not affected by this
        call.

        **See also** **defaultDtlsConfiguration** ().
        """
        ...

    def setDiffieHellmanParameters(
        self, dhparams: PySide6.QtNetwork.QSslDiffieHellmanParameters
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#setDiffieHellmanParameters

        **[since 5.8] void QSslConfiguration::setDiffieHellmanParameters(const
        QSslDiffieHellmanParameters & dhparams )**

        Sets a custom set of Diffie-Hellman parameters to be used by this socket
        when functioning as a server to **dhparams**.

        If no Diffie-Hellman parameters have been set, the **QSslConfiguration**
        object defaults to using the 1024-bit MODP group from RFC 2409.

        This function was introduced in Qt 5.8.

        **See also** **diffieHellmanParameters** ().
        """
        ...

    def setDtlsCookieVerificationEnabled(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#setDtlsCookieVerificationE
        nabled

        **void QSslConfiguration::setDtlsCookieVerificationEnabled(bool enable
        )**

        This function enables DTLS cookie verification when **enable** is true.

        **See also** **dtlsCookieVerificationEnabled** ().
        """
        ...

    def setEllipticCurves(
        self, curves: Sequence[PySide6.QtNetwork.QSslEllipticCurve]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#setEllipticCurves

        **[since 5.5] void QSslConfiguration::setEllipticCurves(const
        QList<QSslEllipticCurve> & curves )**

        Sets the list of elliptic curves to be used by this socket to **curves**
        , which must contain a subset of the curves in the list returned by
        **supportedEllipticCurves** ().

        Restricting the elliptic curves must be done before the handshake phase,
        where the session cipher is chosen.

        This function was introduced in Qt 5.5.

        **See also** **ellipticCurves** .
        """
        ...

    def setHandshakeMustInterruptOnError(self, interrupt: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#setHandshakeMustInterruptO
        nError

        **[since 6.0] void
        QSslConfiguration::setHandshakeMustInterruptOnError(bool interrupt )**

        If **interrupt** is true and the underlying backend supports this
        option, errors found during certificate verification are reported
        immediately by emitting **QSslSocket::handshakeInterruptedOnError** ().
        This allows to stop the unfinished handshake and send a proper alert
        message to a peer. No special action is required from the application in
        this case. **QSslSocket**  will close the connection after sending the
        alert message. If the application after inspecting the error wants to
        continue the handshake, it must call
        **QSslSocket::continueInterruptedHandshake** () from its slot function.
        The signal-slot connection must be direct.

        **Note:** When interrupting handshake is enabled, errors that would
        otherwise be reported by **QSslSocket::peerVerifyError** () are instead
        only reported by **QSslSocket::handshakeInterruptedOnError** ().

        **Note:** Even if the handshake was continued, these errors will be
        reported when emitting **QSslSocket::sslErrors** () signal (and thus
        must be ignored in the corresponding function slot).

        This function was introduced in Qt 6.0.

        **See also** **handshakeMustInterruptOnError** (),
        **QSslSocket::handshakeInterruptedOnError** (), and
        **QSslSocket::continueInterruptedHandshake** ().
        """
        ...

    def setLocalCertificate(
        self,
        certificate: Union[PySide6.QtNetwork.QSslCertificate, PySide6.QtCore.QIODevice],
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#setLocalCertificate

        **void QSslConfiguration::setLocalCertificate(const QSslCertificate &
        certificate )**

        Sets the certificate to be presented to the peer during SSL handshake to
        be **certificate**.

        Setting the certificate once the connection has been established has no
        effect.

        A certificate is the means of identification used in the SSL process.
        The local certificate is used by the remote end to verify the local
        user's identity against its list of Certification Authorities. In most
        cases, such as in HTTP web browsing, only servers identify to the
        clients, so the client does not send a certificate.

        **See also** **localCertificate** ().
        """
        ...

    def setLocalCertificateChain(
        self, localChain: Sequence[PySide6.QtNetwork.QSslCertificate]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#setLocalCertificateChain

        **[since 5.1] void QSslConfiguration::setLocalCertificateChain(const
        QList<QSslCertificate> & localChain )**

        Sets the certificate chain to be presented to the peer during the SSL
        handshake to be **localChain**.

        Setting the certificate chain once the connection has been established
        has no effect.

        A certificate is the means of identification used in the SSL process.
        The local certificate is used by the remote end to verify the local
        user's identity against its list of Certification Authorities. In most
        cases, such as in HTTP web browsing, only servers identify to the
        clients, so the client does not send a certificate.

        Unlike **QSslConfiguration::setLocalCertificate** () this method allows
        you to specify any intermediate certificates required in order to
        validate your certificate. The first item in the list must be the leaf
        certificate.

        This function was introduced in Qt 5.1.

        **See also** **localCertificateChain** ().
        """
        ...

    def setMissingCertificateIsFatal(self, cannotRecover: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#setMissingCertificateIsFat
        al

        **[since 6.0] void QSslConfiguration::setMissingCertificateIsFatal(bool
        cannotRecover )**

        If **cannotRecover** is true, and verification mode in use is
        **QSslSocket::VerifyPeer**  or **QSslSocket::AutoVerifyPeer**  (for a
        client-side socket), the missing peer's certificate would be treated as
        an unrecoverable error that cannot be ignored. A proper alert message
        will be sent to the peer before closing the connection.

        **Note:** Only available if Qt was configured and built with OpenSSL
        backend.

        This function was introduced in Qt 6.0.

        **See also** **QSslSocket::ignoreSslErrors** (),
        **QSslSocket::PeerVerifyMode** , and **missingCertificateIsFatal** ().
        """
        ...

    def setOcspStaplingEnabled(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#setOcspStaplingEnabled

        **[since 5.13] void QSslConfiguration::setOcspStaplingEnabled(bool
        enabled )**

        If **enabled** is true, client **QSslSocket**  will send a certificate
        status request to its peer when initiating a handshake. During the
        handshake **QSslSocket**  will verify the server's response. This value
        must be set before the handshake starts.

        This function was introduced in Qt 5.13.

        **See also** **ocspStaplingEnabled** ().
        """
        ...

    def setPeerVerifyDepth(self, depth: int) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#setPeerVerifyDepth

        **void QSslConfiguration::setPeerVerifyDepth(int depth )**

        Sets the maximum number of certificates in the peer's certificate chain
        to be checked during the SSL handshake phase, to **depth**. Setting a
        depth of 0 means that no maximum depth is set, indicating that the whole
        certificate chain should be checked.

        The certificates are checked in issuing order, starting with the peer's
        own certificate, then its issuer's certificate, and so on.

        **See also** **peerVerifyDepth** () and **setPeerVerifyMode** ().
        """
        ...

    def setPeerVerifyMode(
        self, mode: PySide6.QtNetwork.QSslSocket.PeerVerifyMode
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#setPeerVerifyMode

        **void QSslConfiguration::setPeerVerifyMode(QSslSocket::PeerVerifyMode
        mode )**

        Sets the verify mode to **mode**. This mode decides whether
        **QSslSocket**  should request a certificate from the peer (i.e., the
        client requests a certificate from the server, or a server requesting a
        certificate from the client), and whether it should require that this
        certificate is valid.

        The default mode is AutoVerifyPeer, which tells **QSslSocket**  to use
        VerifyPeer for clients, QueryPeer for servers.

        **See also** **peerVerifyMode** ().
        """
        ...

    def setPreSharedKeyIdentityHint(
        self, hint: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#setPreSharedKeyIdentityHin
        t

        **[since 5.8] void QSslConfiguration::setPreSharedKeyIdentityHint(const
        QByteArray & hint )**

        Sets the identity hint for a preshared key authentication to **hint**.
        This will affect the next initiated handshake; calling this function on
        an already-encrypted socket will not affect the socket's identity hint.

        The identity hint is used in **QSslSocket::SslServerMode**  only!

        This function was introduced in Qt 5.8.

        **See also** **preSharedKeyIdentityHint** ().
        """
        ...

    def setPrivateKey(self, key: Union[PySide6.QtNetwork.QSslKey, int]) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#setPrivateKey

        **void QSslConfiguration::setPrivateKey(const QSslKey & key )**

        Sets the connection's private **key**  to **key**. The private key and
        the local **certificate**  are used by clients and servers that must
        prove their identity to SSL peers.

        Both the key and the local certificate are required if you are creating
        an SSL server socket. If you are creating an SSL client socket, the key
        and local certificate are required if your client must identify itself
        to an SSL server.

        **See also** **privateKey** () and **setLocalCertificate** ().
        """
        ...

    def setProtocol(self, protocol: PySide6.QtNetwork.QSsl.SslProtocol) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#setProtocol

        **void QSslConfiguration::setProtocol(QSsl::SslProtocol protocol )**

        Sets the protocol setting for this configuration to be **protocol**.

        Setting the protocol once the connection has already been established
        has no effect.

        **See also** **protocol** ().
        """
        ...

    def setSessionTicket(
        self, sessionTicket: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#setSessionTicket

        **[since 5.2] void QSslConfiguration::setSessionTicket(const QByteArray
        & sessionTicket )**

        Sets the session ticket to be used in an SSL handshake.
        **QSsl::SslOptionDisableSessionPersistence**  must be turned off for
        this to work, and **sessionTicket** must be in ASN.1 format as returned
        by **sessionTicket** ().

        This function was introduced in Qt 5.2.

        **See also** **sessionTicket** (),
        **QSsl::SslOptionDisableSessionPersistence** , **setSslOption** (), and
        **QSslSocket::newSessionTicketReceived** ().
        """
        ...

    def setSslOption(self, option: PySide6.QtNetwork.QSsl.SslOption, on: bool) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#setSslOption

        **void QSslConfiguration::setSslOption(QSsl::SslOption option , bool on
        )**

        Enables or disables an SSL compatibility **option**. If **on** is true,
        the **option** is enabled. If **on** is false, the **option** is
        disabled.

        **See also** **testSslOption** ().
        """
        ...

    @staticmethod
    def supportedCiphers() -> List[PySide6.QtNetwork.QSslCipher]:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#supportedCiphers

        **[static, since 5.5] QList<QSslCipher>
        QSslConfiguration::supportedCiphers()**

        Returns the list of cryptographic ciphers supported by this system. This
        list is set by the system's SSL libraries and may vary from system to
        system.

        This function was introduced in Qt 5.5.

        **See also** **ciphers** () and **setCiphers** ().
        """
        ...

    @staticmethod
    def supportedEllipticCurves() -> List[PySide6.QtNetwork.QSslEllipticCurve]:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#supportedEllipticCurves

        **[static, since 5.5] QList<QSslEllipticCurve>
        QSslConfiguration::supportedEllipticCurves()**

        Returns the list of elliptic curves supported by this system. This list
        is set by the system's SSL libraries and may vary from system to system.

        This function was introduced in Qt 5.5.

        **See also** **ellipticCurves** () and **setEllipticCurves** ().
        """
        ...

    def swap(self, other: PySide6.QtNetwork.QSslConfiguration) -> None:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#swap

        **[since 5.0] void QSslConfiguration::swap(QSslConfiguration & other )**

        Swaps this SSL configuration instance with **other**. This function is
        very fast and never fails.

        This function was introduced in Qt 5.0.
        """
        ...

    @staticmethod
    def systemCaCertificates() -> List[PySide6.QtNetwork.QSslCertificate]:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#systemCaCertificates

        **[static, since 5.5] QList<QSslCertificate>
        QSslConfiguration::systemCaCertificates()**

        This function provides the CA certificate database provided by the
        operating system. The CA certificate database returned by this function
        is used to initialize the database returned by **caCertificates** () on
        the default **QSslConfiguration** .

        This function was introduced in Qt 5.5.

        **See also** **caCertificates** (), **setCaCertificates** (),
        **defaultConfiguration** (), **addCaCertificate** (), and
        **addCaCertificates** ().
        """
        ...

    def testSslOption(self, option: PySide6.QtNetwork.QSsl.SslOption) -> bool:
        """
        https://doc.qt.io/qt-6/qsslconfiguration.html#testSslOption

        **bool QSslConfiguration::testSslOption(QSsl::SslOption option ) const**

        Returns `true` if the specified SSL compatibility **option** is enabled.

        **See also** **setSslOption** ().
        """
        ...
