"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtNetwork, except for defaults which are replaced by "...".
"""
from enum import Enum
from typing import Dict, List, Optional, Sequence, Union, overload
import PySide6.QtCore
import PySide6.QtNetwork

bytes = str


class QSslCertificate(object):
    """
    https://doc.qt.io/qt-6/qsslcertificate.html

    **Detailed Description**

    QSslCertificate stores an X509 certificate, and is commonly used to verify
    the identity and store information about the local host, a remotely
    connected peer, or a trusted third party Certificate Authority.

    There are many ways to construct a QSslCertificate. The most common way is
    to call **QSslSocket::peerCertificate** (), which returns a QSslCertificate
    object, or **QSslSocket::peerCertificateChain** (), which returns a list of
    them. You can also load certificates from a DER (binary) or PEM (Base64)
    encoded bundle, typically stored as one or more local files, or in a Qt
    Resource.

    You can call **isNull** () to check if your certificate is null. By default,
    QSslCertificate constructs a null certificate. A null certificate is
    invalid, but an invalid certificate is not necessarily null. If you want to
    reset all contents in a certificate, call **clear** ().

    After loading a certificate, you can find information about the certificate,
    its subject, and its issuer, by calling one of the many accessor functions,
    including **version** (), **serialNumber** (), **issuerInfo** () and
    **subjectInfo** (). You can call **effectiveDate** () and **expiryDate** ()
    to check when the certificate starts being effective and when it expires.
    The **publicKey** () function returns the certificate subject's public key
    as a **QSslKey** . You can call **issuerInfo** () or **subjectInfo** () to
    get detailed information about the certificate issuer and its subject.

    Internally, QSslCertificate is stored as an X509 structure. You can access
    this handle by calling **handle** (), but the results are likely to not be
    portable.

    **See also** **QSslSocket** , **QSslKey** , **QSslCipher** , and
    **QSslError** .
    """

    Organization: QSslCertificate.SubjectInfo = ...
    CommonName: QSslCertificate.SubjectInfo = ...
    LocalityName: QSslCertificate.SubjectInfo = ...
    OrganizationalUnitName: QSslCertificate.SubjectInfo = ...
    CountryName: QSslCertificate.SubjectInfo = ...
    StateOrProvinceName: QSslCertificate.SubjectInfo = ...
    DistinguishedNameQualifier: QSslCertificate.SubjectInfo = ...
    SerialNumber: QSslCertificate.SubjectInfo = ...
    EmailAddress: QSslCertificate.SubjectInfo = ...

    class PatternSyntax(Enum):
        RegularExpression: QSslCertificate.PatternSyntax = ...
        Wildcard: QSslCertificate.PatternSyntax = ...
        FixedString: QSslCertificate.PatternSyntax = ...

    class SubjectInfo(Enum):
        Organization: QSslCertificate.SubjectInfo = ...
        CommonName: QSslCertificate.SubjectInfo = ...
        LocalityName: QSslCertificate.SubjectInfo = ...
        OrganizationalUnitName: QSslCertificate.SubjectInfo = ...
        CountryName: QSslCertificate.SubjectInfo = ...
        StateOrProvinceName: QSslCertificate.SubjectInfo = ...
        DistinguishedNameQualifier: QSslCertificate.SubjectInfo = ...
        SerialNumber: QSslCertificate.SubjectInfo = ...
        EmailAddress: QSslCertificate.SubjectInfo = ...

    @overload
    def __init__(
        self,
        data: Union[PySide6.QtCore.QByteArray, bytes] = ...,
        format: PySide6.QtNetwork.QSsl.EncodingFormat = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#QSslCertificate

        **QSslCertificate::QSslCertificate(QIODevice * device ,
        QSsl::EncodingFormat format = QSsl::Pem)**

        Constructs a QSslCertificate by reading **format** encoded data from
        **device** and using the first certificate found. You can later call
        **isNull** () to see if **device** contained a certificate, and if this
        certificate was loaded successfully.
        """
        ...

    @overload
    def __init__(
        self,
        device: PySide6.QtCore.QIODevice,
        format: PySide6.QtNetwork.QSsl.EncodingFormat = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#QSslCertificate-1

        **QSslCertificate::QSslCertificate(const QByteArray & data =
        QByteArray(), QSsl::EncodingFormat format = QSsl::Pem)**

        Constructs a QSslCertificate by parsing the **format** encoded **data**
        and using the first available certificate found. You can later call
        **isNull** () to see if **data** contained a certificate, and if this
        certificate was loaded successfully.
        """
        ...

    @overload
    def __init__(
        self, other: Union[PySide6.QtNetwork.QSslCertificate, PySide6.QtCore.QIODevice]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#QSslCertificate-2

        **QSslCertificate::QSslCertificate(const QSslCertificate & other )**

        Constructs an identical copy of **other**.
        """
        ...

    @staticmethod
    def __copy__() -> None:
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#clear

        **void QSslCertificate::clear()**

        Clears the contents of this certificate, making it a null certificate.

        **See also** **isNull** ().
        """
        ...

    def digest(
        self, algorithm: PySide6.QtCore.QCryptographicHash.Algorithm = ...
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#digest

        **QByteArray QSslCertificate::digest(QCryptographicHash::Algorithm
        algorithm = QCryptographicHash::Md5) const**

        Returns a cryptographic digest of this certificate. By default, an MD5
        digest will be generated, but you can also specify a custom
        **algorithm**.
        """
        ...

    def effectiveDate(self) -> PySide6.QtCore.QDateTime:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#effectiveDate

        **QDateTime QSslCertificate::effectiveDate() const**

        Returns the date-time that the certificate becomes valid, or an empty
        **QDateTime**  if this is a null certificate.

        **See also** **expiryDate** ().
        """
        ...

    def expiryDate(self) -> PySide6.QtCore.QDateTime:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#expiryDate

        **QDateTime QSslCertificate::expiryDate() const**

        Returns the date-time that the certificate expires, or an empty
        **QDateTime**  if this is a null certificate.

        **See also** **effectiveDate** ().
        """
        ...

    def extensions(self) -> List[PySide6.QtNetwork.QSslCertificateExtension]:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#extensions

        **[since 5.0] QList<QSslCertificateExtension>
        QSslCertificate::extensions() const**

        Returns a list containing the X509 extensions of this certificate.

        This function was introduced in Qt 5.0.
        """
        ...

    @staticmethod
    def fromData(
        data: Union[PySide6.QtCore.QByteArray, bytes],
        format: PySide6.QtNetwork.QSsl.EncodingFormat = ...,
    ) -> List[PySide6.QtNetwork.QSslCertificate]:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#fromData

        **[static] QList<QSslCertificate> QSslCertificate::fromData(const
        QByteArray & data , QSsl::EncodingFormat format = QSsl::Pem)**

        Searches for and parses all certificates in **data** that are encoded in
        the specified **format** and returns them in a list of certificates.

        **See also** **fromDevice** ().
        """
        ...

    @staticmethod
    def fromDevice(
        device: PySide6.QtCore.QIODevice,
        format: PySide6.QtNetwork.QSsl.EncodingFormat = ...,
    ) -> List[PySide6.QtNetwork.QSslCertificate]:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#fromDevice

        **[static] QList<QSslCertificate> QSslCertificate::fromDevice(QIODevice
        * device , QSsl::EncodingFormat format = QSsl::Pem)**

        Searches for and parses all certificates in **device** that are encoded
        in the specified **format** and returns them in a list of certificates.

        **See also** **fromData** ().
        """
        ...

    @staticmethod
    def fromPath(
        path: str,
        format: PySide6.QtNetwork.QSsl.EncodingFormat = ...,
        syntax: PySide6.QtNetwork.QSslCertificate.PatternSyntax = ...,
    ) -> List[PySide6.QtNetwork.QSslCertificate]:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#fromPath

        **[static, since 5.15] QList<QSslCertificate>
        QSslCertificate::fromPath(const QString & path , QSsl::EncodingFormat
        format = QSsl::Pem, QSslCertificate::PatternSyntax syntax =
        PatternSyntax::FixedString)**

        Searches all files in the **path** for certificates encoded in the
        specified **format** and returns them in a list. **path** must be a file
        or a pattern matching one or more files, as specified by **syntax**.

        Example:

        const auto certs = **QSslCertificate**
        ::fromPath("C:/ssl/certificate.*.pem",
        QSsl::Pem, **QSslCertificate** ::Wildcard);
            for (const
        **QSslCertificate**  &cert : certs) {
                **qDebug** () <<
        cert.issuerInfo(**QSslCertificate** ::Organization);
            }

        This function was introduced in Qt 5.15.

        **See also** **fromData** ().
        """
        ...

    def handle(self) -> int:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#handle

        **Qt::HANDLE QSslCertificate::handle() const**

        Returns a pointer to the native certificate handle, if there is one,
        else `nullptr`.

        You can use this handle, together with the native API, to access
        extended information about the certificate.

        **Warning:** Use of this function has a high probability of being non-
        portable, and its return value may vary from platform to platform or
        change from minor release to minor release.
        """
        ...

    @staticmethod
    def importPkcs12(
        device: PySide6.QtCore.QIODevice,
        key: Union[PySide6.QtNetwork.QSslKey, int],
        cert: Union[PySide6.QtNetwork.QSslCertificate, PySide6.QtCore.QIODevice],
        caCertificates: Optional[Sequence[PySide6.QtNetwork.QSslCertificate]] = ...,
        passPhrase: Union[PySide6.QtCore.QByteArray, bytes] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#importPkcs12

        **[static, since 5.4] bool QSslCertificate::importPkcs12(QIODevice *
        device , QSslKey * key , QSslCertificate * certificate ,
        QList<QSslCertificate> * caCertificates = nullptr, const QByteArray &
        passPhrase = QByteArray())**

        Imports a PKCS#12 (pfx) file from the specified **device**. A PKCS#12
        file is a bundle that can contain a number of certificates and keys.
        This method reads a single **key** , its **certificate** and any
        associated **caCertificates** from the bundle. If a **passPhrase** is
        specified then this will be used to decrypt the bundle. Returns `true`
        if the PKCS#12 file was successfully loaded.

        **Note:** The **device** must be open and ready to be read from.

        This function was introduced in Qt 5.4.
        """
        ...

    def isBlacklisted(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#isBlacklisted

        **bool QSslCertificate::isBlacklisted() const**

        Returns `true` if this certificate is blacklisted; otherwise returns
        `false`.

        **See also** **isNull** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#isNull

        **bool QSslCertificate::isNull() const**

        Returns `true` if this is a null certificate (i.e., a certificate with
        no contents); otherwise returns `false`.

        By default, **QSslCertificate**  constructs a null certificate.

        **See also** **clear** ().
        """
        ...

    def isSelfSigned(self) -> bool:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#isSelfSigned

        **[since 5.4] bool QSslCertificate::isSelfSigned() const**

        Returns `true` if this certificate is self signed; otherwise returns
        `false`.

        A certificate is considered self-signed its issuer and subject are
        identical.

        This function was introduced in Qt 5.4.
        """
        ...

    def issuerDisplayName(self) -> str:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#issuerDisplayName

        **[since 5.12] QString QSslCertificate::issuerDisplayName() const**

        Returns a name that describes the issuer. It returns the
        **QSslCertificate::CommonName**  if available, otherwise falls back to
        the first **QSslCertificate::Organization**  or the first
        **QSslCertificate::OrganizationalUnitName** .

        This function was introduced in Qt 5.12.

        **See also** **issuerInfo** ().
        """
        ...

    @overload
    def issuerInfo(
        self, attribute: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> List[str]:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#issuerInfo

        **QStringList QSslCertificate::issuerInfo(QSslCertificate::SubjectInfo
        subject ) const**

        Returns the issuer information for the **subject** from the certificate,
        or an empty list if there is no information for **subject** in the
        certificate. There can be more than one entry of each type.

        **See also** **subjectInfo** ().
        """
        ...

    @overload
    def issuerInfo(
        self, info: PySide6.QtNetwork.QSslCertificate.SubjectInfo
    ) -> List[str]:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#issuerInfo-1

        **QStringList QSslCertificate::issuerInfo(const QByteArray & attribute )
        const**

        Returns the issuer information for **attribute** from the certificate,
        or an empty list if there is no information for **attribute** in the
        certificate. There can be more than one entry for an attribute.

        **See also** **subjectInfo** ().
        """
        ...

    def issuerInfoAttributes(self) -> List[PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#issuerInfoAttributes

        **[since 5.0] QList<QByteArray> QSslCertificate::issuerInfoAttributes()
        const**

        Returns a list of the attributes that have values in the issuer
        information of this certificate. The information associated with a given
        attribute can be accessed using the **issuerInfo** () method. Note that
        this list may include the OIDs for any elements that are not known by
        the SSL backend.

        This function was introduced in Qt 5.0.

        **See also** **subjectInfo** ().
        """
        ...

    def publicKey(self) -> PySide6.QtNetwork.QSslKey:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#publicKey

        **QSslKey QSslCertificate::publicKey() const**

        Returns the certificate subject's public key.
        """
        ...

    def serialNumber(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#serialNumber

        **QByteArray QSslCertificate::serialNumber() const**

        Returns the certificate's serial number string in hexadecimal format.
        """
        ...

    def subjectAlternativeNames(
        self,
    ) -> Dict[PySide6.QtNetwork.QSsl.AlternativeNameEntryType, List[str]]:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#subjectAlternativeNames

        **QMultiMap<QSsl::AlternativeNameEntryType, QString>
        QSslCertificate::subjectAlternativeNames() const**

        Returns the list of alternative subject names for this certificate. The
        alternative names typically contain host names, optionally with
        wildcards, that are valid for this certificate.

        These names are tested against the connected peer's host name, if either
        the subject information for **CommonName**  doesn't define a valid host
        name, or the subject info name doesn't match the peer's host name.

        **See also** **subjectInfo** ().
        """
        ...

    def subjectDisplayName(self) -> str:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#subjectDisplayName

        **[since 5.12] QString QSslCertificate::subjectDisplayName() const**

        Returns a name that describes the subject. It returns the
        **QSslCertificate::CommonName**  if available, otherwise falls back to
        the first **QSslCertificate::Organization**  or the first
        **QSslCertificate::OrganizationalUnitName** .

        This function was introduced in Qt 5.12.

        **See also** **subjectInfo** ().
        """
        ...

    @overload
    def subjectInfo(
        self, attribute: Union[PySide6.QtCore.QByteArray, bytes]
    ) -> List[str]:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#subjectInfo

        **QStringList QSslCertificate::subjectInfo(QSslCertificate::SubjectInfo
        subject ) const**

        Returns the information for the **subject** , or an empty list if there
        is no information for **subject** in the certificate. There can be more
        than one entry of each type.

        **See also** **issuerInfo** ().
        """
        ...

    @overload
    def subjectInfo(
        self, info: PySide6.QtNetwork.QSslCertificate.SubjectInfo
    ) -> List[str]:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#subjectInfo-1

        **QStringList QSslCertificate::subjectInfo(const QByteArray & attribute
        ) const**

        Returns the subject information for **attribute** , or an empty list if
        there is no information for **attribute** in the certificate. There can
        be more than one entry for an attribute.

        **See also** **issuerInfo** ().
        """
        ...

    def subjectInfoAttributes(self) -> List[PySide6.QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#subjectInfoAttributes

        **[since 5.0] QList<QByteArray> QSslCertificate::subjectInfoAttributes()
        const**

        Returns a list of the attributes that have values in the subject
        information of this certificate. The information associated with a given
        attribute can be accessed using the **subjectInfo** () method. Note that
        this list may include the OIDs for any elements that are not known by
        the SSL backend.

        This function was introduced in Qt 5.0.

        **See also** **subjectInfo** ().
        """
        ...

    def swap(
        self, other: Union[PySide6.QtNetwork.QSslCertificate, PySide6.QtCore.QIODevice]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#swap

        **[since 5.0] void QSslCertificate::swap(QSslCertificate & other )**

        Swaps this certificate instance with **other**. This function is very
        fast and never fails.

        This function was introduced in Qt 5.0.
        """
        ...

    def toDer(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#toDer

        **QByteArray QSslCertificate::toDer() const**

        Returns this certificate converted to a DER (binary) encoded
        representation.
        """
        ...

    def toPem(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#toPem

        **QByteArray QSslCertificate::toPem() const**

        Returns this certificate converted to a PEM (Base64) encoded
        representation.
        """
        ...

    def toText(self) -> str:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#toText

        **[since 5.0] QString QSslCertificate::toText() const**

        Returns this certificate converted to a human-readable text
        representation.

        This function was introduced in Qt 5.0.
        """
        ...

    @staticmethod
    def verify(
        certificateChain: Sequence[PySide6.QtNetwork.QSslCertificate],
        hostName: str = ...,
    ) -> List[PySide6.QtNetwork.QSslError]:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#verify

        **[static, since 5.0] QList<QSslError> QSslCertificate::verify(const
        QList<QSslCertificate> & certificateChain , const QString & hostName =
        QString())**

        Verifies a certificate chain. The chain to be verified is passed in the
        **certificateChain** parameter. The first certificate in the list should
        be the leaf certificate of the chain to be verified. If **hostName** is
        specified then the certificate is also checked to see if it is valid for
        the specified host name.

        Note that the root (CA) certificate should not be included in the list
        to be verified, this will be looked up automatically using the CA list
        specified in the default **QSslConfiguration** , and, in addition, if
        possible, CA certificates loaded on demand on Unix and Windows.

        This function was introduced in Qt 5.0.
        """
        ...

    def version(self) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qsslcertificate.html#version

        **QByteArray QSslCertificate::version() const**

        Returns the certificate's version string.
        """
        ...
