"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
"""
This file contains the exact signatures for all functions in module
PySide6.QtNetwork, except for defaults which are replaced by "...".
"""
from typing import Union
import PySide6.QtCore
import PySide6.QtNetwork

bytes = str


class QPasswordDigestor(object):
    """
    https://doc.qt.io/qt-6/qpassworddigestor.html

    **Detailed Description**
    """

    @staticmethod
    def deriveKeyPbkdf1(
        algorithm: PySide6.QtCore.QCryptographicHash.Algorithm,
        password: Union[PySide6.QtCore.QByteArray, bytes],
        salt: Union[PySide6.QtCore.QByteArray, bytes],
        iterations: int,
        dkLen: int,
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qpassworddigestor.html#deriveKeyPbkdf1

        **[since 5.12] QByteArray
        QPasswordDigestor::deriveKeyPbkdf1(QCryptographicHash::Algorithm
        algorithm , const QByteArray & data , const QByteArray & salt , int
        iterations , quint64 dkLen )**

        Returns a hash computed using the PBKDF1-algorithm as defined in **RFC
        8018, section 5.1** .

        The function takes the **data** and **salt** , and then hashes it
        repeatedly for **iterations** iterations using the specified hash
        **algorithm**. If the resulting hash is longer than **dkLen** then it is
        truncated before it is returned.

        This function only supports SHA-1 and MD5! The max output size is 160
        bits (20 bytes) when using SHA-1, or 128 bits (16 bytes) when using MD5.
        Specifying a value for **dkLen** which is greater than this results in a
        warning and an empty **QByteArray**  is returned. To programmatically
        check this limit you can use **QCryptographicHash::hashLength** .
        Furthermore: the **salt** must always be 8 bytes long!

        **Note:** This function is provided for use with legacy applications and
        all new applications are recommended to use **PBKDF2** .

        This function was introduced in Qt 5.12.

        **See also** **deriveKeyPbkdf2** , **QCryptographicHash** , and
        **QCryptographicHash::hashLength** .
        """
        ...

    @staticmethod
    def deriveKeyPbkdf2(
        algorithm: PySide6.QtCore.QCryptographicHash.Algorithm,
        password: Union[PySide6.QtCore.QByteArray, bytes],
        salt: Union[PySide6.QtCore.QByteArray, bytes],
        iterations: int,
        dkLen: int,
    ) -> PySide6.QtCore.QByteArray:
        """
        https://doc.qt.io/qt-6/qpassworddigestor.html#deriveKeyPbkdf2

        **[since 5.12] QByteArray
        QPasswordDigestor::deriveKeyPbkdf2(QCryptographicHash::Algorithm
        algorithm , const QByteArray & data , const QByteArray & salt , int
        iterations , quint64 dkLen )**

        Derive a key using the PBKDF2-algorithm as defined in **RFC 8018,
        section 5.2** .

        This function takes the **data** and **salt** , and then applies HMAC-X,
        where the X is **algorithm** , repeatedly. It internally concatenates
        intermediate results to the final output until at least **dkLen** amount
        of bytes have been computed and it will execute HMAC-X **iterations**
        times each time a concatenation is required. The total number of times
        it will execute HMAC-X depends on **iterations** , **dkLen** and
        **algorithm** and can be calculated as `iterations * ceil(dkLen /
        QCryptographicHash::hashLength(algorithm))`.

        This function was introduced in Qt 5.12.

        **See also** **deriveKeyPbkdf1** , **QMessageAuthenticationCode** , and
        **QCryptographicHash** .
        """
        ...
